package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlansCoverageTotal invokes the bssopenapi.DescribeSavingsPlansCoverageTotal API synchronously
func (client *Client) DescribeSavingsPlansCoverageTotal(request *DescribeSavingsPlansCoverageTotalRequest) (response *DescribeSavingsPlansCoverageTotalResponse, err error) {
	response = CreateDescribeSavingsPlansCoverageTotalResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlansCoverageTotalWithChan invokes the bssopenapi.DescribeSavingsPlansCoverageTotal API asynchronously
func (client *Client) DescribeSavingsPlansCoverageTotalWithChan(request *DescribeSavingsPlansCoverageTotalRequest) (<-chan *DescribeSavingsPlansCoverageTotalResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlansCoverageTotalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlansCoverageTotal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlansCoverageTotalWithCallback invokes the bssopenapi.DescribeSavingsPlansCoverageTotal API asynchronously
func (client *Client) DescribeSavingsPlansCoverageTotalWithCallback(request *DescribeSavingsPlansCoverageTotalRequest, callback func(response *DescribeSavingsPlansCoverageTotalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlansCoverageTotalResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlansCoverageTotal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlansCoverageTotalRequest is the request struct for api DescribeSavingsPlansCoverageTotal
type DescribeSavingsPlansCoverageTotalRequest struct {
	*requests.RpcRequest
	PeriodType  string           `position:"Query" name:"PeriodType"`
	BillOwnerId requests.Integer `position:"Query" name:"BillOwnerId"`
	StartPeriod string           `position:"Query" name:"StartPeriod"`
	EndPeriod   string           `position:"Query" name:"EndPeriod"`
}

// DescribeSavingsPlansCoverageTotalResponse is the response struct for api DescribeSavingsPlansCoverageTotal
type DescribeSavingsPlansCoverageTotalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeSavingsPlansCoverageTotalRequest creates a request to invoke DescribeSavingsPlansCoverageTotal API
func CreateDescribeSavingsPlansCoverageTotalRequest() (request *DescribeSavingsPlansCoverageTotalRequest) {
	request = &DescribeSavingsPlansCoverageTotalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeSavingsPlansCoverageTotal", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlansCoverageTotalResponse creates a response to parse from DescribeSavingsPlansCoverageTotal response
func CreateDescribeSavingsPlansCoverageTotalResponse() (response *DescribeSavingsPlansCoverageTotalResponse) {
	response = &DescribeSavingsPlansCoverageTotalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
