package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceBill invokes the bssopenapi.DescribeInstanceBill API synchronously
func (client *Client) DescribeInstanceBill(request *DescribeInstanceBillRequest) (response *DescribeInstanceBillResponse, err error) {
	response = CreateDescribeInstanceBillResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceBillWithChan invokes the bssopenapi.DescribeInstanceBill API asynchronously
func (client *Client) DescribeInstanceBillWithChan(request *DescribeInstanceBillRequest) (<-chan *DescribeInstanceBillResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceBillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceBill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceBillWithCallback invokes the bssopenapi.DescribeInstanceBill API asynchronously
func (client *Client) DescribeInstanceBillWithCallback(request *DescribeInstanceBillRequest, callback func(response *DescribeInstanceBillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceBillResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceBill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceBillRequest is the request struct for api DescribeInstanceBill
type DescribeInstanceBillRequest struct {
	*requests.RpcRequest
	ProductCode      string           `position:"Query" name:"ProductCode"`
	IsHideZeroCharge requests.Boolean `position:"Query" name:"IsHideZeroCharge"`
	SubscriptionType string           `position:"Query" name:"SubscriptionType"`
	BillOwnerId      requests.Integer `position:"Query" name:"BillOwnerId"`
	ProductType      string           `position:"Query" name:"ProductType"`
	NextToken        string           `position:"Query" name:"NextToken"`
	BillingCycle     string           `position:"Query" name:"BillingCycle"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	BillingDate      string           `position:"Query" name:"BillingDate"`
	IsBillingItem    requests.Boolean `position:"Query" name:"IsBillingItem"`
	InstanceID       string           `position:"Query" name:"InstanceID"`
	Granularity      string           `position:"Query" name:"Granularity"`
	MaxResults       requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeInstanceBillResponse is the response struct for api DescribeInstanceBill
type DescribeInstanceBillResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeInstanceBillRequest creates a request to invoke DescribeInstanceBill API
func CreateDescribeInstanceBillRequest() (request *DescribeInstanceBillRequest) {
	request = &DescribeInstanceBillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeInstanceBill", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceBillResponse creates a response to parse from DescribeInstanceBill response
func CreateDescribeInstanceBillResponse() (response *DescribeInstanceBillResponse) {
	response = &DescribeInstanceBillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
