package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCostUnit invokes the bssopenapi.CreateCostUnit API synchronously
func (client *Client) CreateCostUnit(request *CreateCostUnitRequest) (response *CreateCostUnitResponse, err error) {
	response = CreateCreateCostUnitResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCostUnitWithChan invokes the bssopenapi.CreateCostUnit API asynchronously
func (client *Client) CreateCostUnitWithChan(request *CreateCostUnitRequest) (<-chan *CreateCostUnitResponse, <-chan error) {
	responseChan := make(chan *CreateCostUnitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCostUnit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCostUnitWithCallback invokes the bssopenapi.CreateCostUnit API asynchronously
func (client *Client) CreateCostUnitWithCallback(request *CreateCostUnitRequest, callback func(response *CreateCostUnitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCostUnitResponse
		var err error
		defer close(result)
		response, err = client.CreateCostUnit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCostUnitRequest is the request struct for api CreateCostUnit
type CreateCostUnitRequest struct {
	*requests.RpcRequest
	UnitEntityList *[]CreateCostUnitUnitEntityList `position:"Query" name:"UnitEntityList"  type:"Repeated"`
}

// CreateCostUnitUnitEntityList is a repeated param struct in CreateCostUnitRequest
type CreateCostUnitUnitEntityList struct {
	UnitName     string `name:"UnitName"`
	ParentUnitId string `name:"ParentUnitId"`
	OwnerUid     string `name:"OwnerUid"`
}

// CreateCostUnitResponse is the response struct for api CreateCostUnit
type CreateCostUnitResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateCostUnitRequest creates a request to invoke CreateCostUnit API
func CreateCreateCostUnitRequest() (request *CreateCostUnitRequest) {
	request = &CreateCostUnitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "CreateCostUnit", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCostUnitResponse creates a response to parse from CreateCostUnit response
func CreateCreateCostUnitResponse() (response *CreateCostUnitResponse) {
	response = &CreateCostUnitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
