// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostInfo host info
// swagger:model HostInfo
type HostInfo struct {

	// Host core information
	// Required: true
	Cores *HostResource `json:"cores"`

	// Hostname
	// Required: true
	Hostname *string `json:"hostname"`

	// IP Address
	// Required: true
	IPAddress *string `json:"ipAddress"`

	// Host memory information
	// Required: true
	Memory *HostResource `json:"memory"`

	// PVM Instances on host
	// Required: true
	PvmInstances []*HostPVMInstance `json:"pvmInstances"`
}

// Validate validates this host info
func (m *HostInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostname(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePvmInstances(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostInfo) validateCores(formats strfmt.Registry) error {

	if err := validate.Required("cores", "body", m.Cores); err != nil {
		return err
	}

	if m.Cores != nil {
		if err := m.Cores.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cores")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateHostname(formats strfmt.Registry) error {

	if err := validate.Required("hostname", "body", m.Hostname); err != nil {
		return err
	}

	return nil
}

func (m *HostInfo) validateIPAddress(formats strfmt.Registry) error {

	if err := validate.Required("ipAddress", "body", m.IPAddress); err != nil {
		return err
	}

	return nil
}

func (m *HostInfo) validateMemory(formats strfmt.Registry) error {

	if err := validate.Required("memory", "body", m.Memory); err != nil {
		return err
	}

	if m.Memory != nil {
		if err := m.Memory.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("memory")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validatePvmInstances(formats strfmt.Registry) error {

	if err := validate.Required("pvmInstances", "body", m.PvmInstances); err != nil {
		return err
	}

	for i := 0; i < len(m.PvmInstances); i++ {
		if swag.IsZero(m.PvmInstances[i]) { // not required
			continue
		}

		if m.PvmInstances[i] != nil {
			if err := m.PvmInstances[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("pvmInstances" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostInfo) UnmarshalBinary(b []byte) error {
	var res HostInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
