package machinelearningservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// NotebooksClient is the these APIs allow end users to operate on Azure Machine Learning Workspace resources.
type NotebooksClient struct {
	BaseClient
}

// NewNotebooksClient creates an instance of the NotebooksClient client.
func NewNotebooksClient(subscriptionID string) NotebooksClient {
	return NewNotebooksClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewNotebooksClientWithBaseURI creates an instance of the NotebooksClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewNotebooksClientWithBaseURI(baseURI string, subscriptionID string) NotebooksClient {
	return NotebooksClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Prepare sends the prepare request.
// Parameters:
// resourceGroupName - name of the resource group in which workspace is located.
// workspaceName - name of Azure Machine Learning workspace.
func (client NotebooksClient) Prepare(ctx context.Context, resourceGroupName string, workspaceName string) (result NotebooksPrepareFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotebooksClient.Prepare")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PreparePreparer(ctx, resourceGroupName, workspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.NotebooksClient", "Prepare", nil, "Failure preparing request")
		return
	}

	result, err = client.PrepareSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.NotebooksClient", "Prepare", nil, "Failure sending request")
		return
	}

	return
}

// PreparePreparer prepares the Prepare request.
func (client NotebooksClient) PreparePreparer(ctx context.Context, resourceGroupName string, workspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2020-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/prepareNotebook", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PrepareSender sends the Prepare request. The method will close the
// http.Response Body if it receives an error.
func (client NotebooksClient) PrepareSender(req *http.Request) (future NotebooksPrepareFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// PrepareResponder handles the response to the Prepare request. The method always
// closes the http.Response Body.
func (client NotebooksClient) PrepareResponder(resp *http.Response) (result NotebookResourceInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
