package consumption

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EventsClient is the consumption management client provides access to consumption resources for Azure Enterprise
// Subscriptions.
type EventsClient struct {
	BaseClient
}

// NewEventsClient creates an instance of the EventsClient client.
func NewEventsClient(subscriptionID string) EventsClient {
	return NewEventsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewEventsClientWithBaseURI creates an instance of the EventsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewEventsClientWithBaseURI(baseURI string, subscriptionID string) EventsClient {
	return EventsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List lists the events by billingAccountId and billingProfileId for given start and end date.
// Parameters:
// billingAccountID - billingAccount ID
// billingProfileID - azure Billing Profile ID.
// startDate - start date
// endDate - end date
func (client EventsClient) List(ctx context.Context, billingAccountID string, billingProfileID string, startDate string, endDate string) (result EventsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsClient.List")
		defer func() {
			sc := -1
			if result.e.Response.Response != nil {
				sc = result.e.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, billingAccountID, billingProfileID, startDate, endDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.EventsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.e.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "consumption.EventsClient", "List", resp, "Failure sending request")
		return
	}

	result.e, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.EventsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.e.hasNextLink() && result.e.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client EventsClient) ListPreparer(ctx context.Context, billingAccountID string, billingProfileID string, startDate string, endDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"billingProfileId": autorest.Encode("path", billingProfileID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"endDate":     autorest.Encode("query", endDate),
		"startDate":   autorest.Encode("query", startDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.Consumption/events", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client EventsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client EventsClient) ListResponder(resp *http.Response) (result Events, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client EventsClient) listNextResults(ctx context.Context, lastResults Events) (result Events, err error) {
	req, err := lastResults.eventsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "consumption.EventsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "consumption.EventsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.EventsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client EventsClient) ListComplete(ctx context.Context, billingAccountID string, billingProfileID string, startDate string, endDate string) (result EventsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, billingAccountID, billingProfileID, startDate, endDate)
	return
}
