/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	gcpfirewallv1alpha1 "k8s.io/cloud-provider-gcp/crd/apis/gcpfirewall/v1alpha1"
	versioned "k8s.io/cloud-provider-gcp/crd/client/gcpfirewall/clientset/versioned"
	internalinterfaces "k8s.io/cloud-provider-gcp/crd/client/gcpfirewall/informers/externalversions/internalinterfaces"
	v1alpha1 "k8s.io/cloud-provider-gcp/crd/client/gcpfirewall/listers/gcpfirewall/v1alpha1"
)

// GCPFirewallInformer provides access to a shared informer and lister for
// GCPFirewalls.
type GCPFirewallInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.GCPFirewallLister
}

type gCPFirewallInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewGCPFirewallInformer constructs a new informer for GCPFirewall type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewGCPFirewallInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredGCPFirewallInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredGCPFirewallInformer constructs a new informer for GCPFirewall type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredGCPFirewallInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.NetworkingV1alpha1().GCPFirewalls(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.NetworkingV1alpha1().GCPFirewalls(namespace).Watch(context.TODO(), options)
			},
		},
		&gcpfirewallv1alpha1.GCPFirewall{},
		resyncPeriod,
		indexers,
	)
}

func (f *gCPFirewallInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredGCPFirewallInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *gCPFirewallInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&gcpfirewallv1alpha1.GCPFirewall{}, f.defaultInformer)
}

func (f *gCPFirewallInformer) Lister() v1alpha1.GCPFirewallLister {
	return v1alpha1.NewGCPFirewallLister(f.Informer().GetIndexer())
}
