/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "k8s.io/cloud-provider-gcp/crd/apis/gcpfirewall/v1alpha1"
)

// FakeGCPFirewalls implements GCPFirewallInterface
type FakeGCPFirewalls struct {
	Fake *FakeNetworkingV1alpha1
	ns   string
}

var gcpfirewallsResource = schema.GroupVersionResource{Group: "networking.gke.io", Version: "v1alpha1", Resource: "gcpfirewalls"}

var gcpfirewallsKind = schema.GroupVersionKind{Group: "networking.gke.io", Version: "v1alpha1", Kind: "GCPFirewall"}

// Get takes name of the gCPFirewall, and returns the corresponding gCPFirewall object, and an error if there is any.
func (c *FakeGCPFirewalls) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.GCPFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(gcpfirewallsResource, c.ns, name), &v1alpha1.GCPFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GCPFirewall), err
}

// List takes label and field selectors, and returns the list of GCPFirewalls that match those selectors.
func (c *FakeGCPFirewalls) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.GCPFirewallList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(gcpfirewallsResource, gcpfirewallsKind, c.ns, opts), &v1alpha1.GCPFirewallList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.GCPFirewallList{ListMeta: obj.(*v1alpha1.GCPFirewallList).ListMeta}
	for _, item := range obj.(*v1alpha1.GCPFirewallList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested gCPFirewalls.
func (c *FakeGCPFirewalls) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(gcpfirewallsResource, c.ns, opts))

}

// Create takes the representation of a gCPFirewall and creates it.  Returns the server's representation of the gCPFirewall, and an error, if there is any.
func (c *FakeGCPFirewalls) Create(ctx context.Context, gCPFirewall *v1alpha1.GCPFirewall, opts v1.CreateOptions) (result *v1alpha1.GCPFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(gcpfirewallsResource, c.ns, gCPFirewall), &v1alpha1.GCPFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GCPFirewall), err
}

// Update takes the representation of a gCPFirewall and updates it. Returns the server's representation of the gCPFirewall, and an error, if there is any.
func (c *FakeGCPFirewalls) Update(ctx context.Context, gCPFirewall *v1alpha1.GCPFirewall, opts v1.UpdateOptions) (result *v1alpha1.GCPFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(gcpfirewallsResource, c.ns, gCPFirewall), &v1alpha1.GCPFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GCPFirewall), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeGCPFirewalls) UpdateStatus(ctx context.Context, gCPFirewall *v1alpha1.GCPFirewall, opts v1.UpdateOptions) (*v1alpha1.GCPFirewall, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(gcpfirewallsResource, "status", c.ns, gCPFirewall), &v1alpha1.GCPFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GCPFirewall), err
}

// Delete takes name of the gCPFirewall and deletes it. Returns an error if one occurs.
func (c *FakeGCPFirewalls) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(gcpfirewallsResource, c.ns, name), &v1alpha1.GCPFirewall{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeGCPFirewalls) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(gcpfirewallsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.GCPFirewallList{})
	return err
}

// Patch applies the patch and returns the patched gCPFirewall.
func (c *FakeGCPFirewalls) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.GCPFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(gcpfirewallsResource, c.ns, name, pt, data, subresources...), &v1alpha1.GCPFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GCPFirewall), err
}
