// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/common/matcher/v4alpha/matcher.proto

package envoy_config_common_matcher_v4alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// define the regex for a UUID once up-front
var _matcher_uuidPattern = regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")

// Validate checks the field values on MatchPredicate with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *MatchPredicate) Validate() error {
	if m == nil {
		return nil
	}

	switch m.Rule.(type) {

	case *MatchPredicate_OrMatch:

		if v, ok := interface{}(m.GetOrMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "OrMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_AndMatch:

		if v, ok := interface{}(m.GetAndMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "AndMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_NotMatch:

		if v, ok := interface{}(m.GetNotMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "NotMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_AnyMatch:

		if m.GetAnyMatch() != true {
			return MatchPredicateValidationError{
				field:  "AnyMatch",
				reason: "value must equal true",
			}
		}

	case *MatchPredicate_HttpRequestHeadersMatch:

		if v, ok := interface{}(m.GetHttpRequestHeadersMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpRequestHeadersMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_HttpRequestTrailersMatch:

		if v, ok := interface{}(m.GetHttpRequestTrailersMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpRequestTrailersMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_HttpResponseHeadersMatch:

		if v, ok := interface{}(m.GetHttpResponseHeadersMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpResponseHeadersMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_HttpResponseTrailersMatch:

		if v, ok := interface{}(m.GetHttpResponseTrailersMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpResponseTrailersMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_HttpRequestGenericBodyMatch:

		if v, ok := interface{}(m.GetHttpRequestGenericBodyMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpRequestGenericBodyMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *MatchPredicate_HttpResponseGenericBodyMatch:

		if v, ok := interface{}(m.GetHttpResponseGenericBodyMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicateValidationError{
					field:  "HttpResponseGenericBodyMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return MatchPredicateValidationError{
			field:  "Rule",
			reason: "value is required",
		}

	}

	return nil
}

// MatchPredicateValidationError is the validation error returned by
// MatchPredicate.Validate if the designated constraints aren't met.
type MatchPredicateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MatchPredicateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MatchPredicateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MatchPredicateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MatchPredicateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MatchPredicateValidationError) ErrorName() string { return "MatchPredicateValidationError" }

// Error satisfies the builtin error interface
func (e MatchPredicateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMatchPredicate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MatchPredicateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MatchPredicateValidationError{}

// Validate checks the field values on HttpHeadersMatch with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *HttpHeadersMatch) Validate() error {
	if m == nil {
		return nil
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpHeadersMatchValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// HttpHeadersMatchValidationError is the validation error returned by
// HttpHeadersMatch.Validate if the designated constraints aren't met.
type HttpHeadersMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpHeadersMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpHeadersMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpHeadersMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpHeadersMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpHeadersMatchValidationError) ErrorName() string { return "HttpHeadersMatchValidationError" }

// Error satisfies the builtin error interface
func (e HttpHeadersMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpHeadersMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpHeadersMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpHeadersMatchValidationError{}

// Validate checks the field values on HttpGenericBodyMatch with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HttpGenericBodyMatch) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for BytesLimit

	if len(m.GetPatterns()) < 1 {
		return HttpGenericBodyMatchValidationError{
			field:  "Patterns",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetPatterns() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpGenericBodyMatchValidationError{
					field:  fmt.Sprintf("Patterns[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// HttpGenericBodyMatchValidationError is the validation error returned by
// HttpGenericBodyMatch.Validate if the designated constraints aren't met.
type HttpGenericBodyMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpGenericBodyMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpGenericBodyMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpGenericBodyMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpGenericBodyMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpGenericBodyMatchValidationError) ErrorName() string {
	return "HttpGenericBodyMatchValidationError"
}

// Error satisfies the builtin error interface
func (e HttpGenericBodyMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpGenericBodyMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpGenericBodyMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpGenericBodyMatchValidationError{}

// Validate checks the field values on MatchPredicate_MatchSet with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MatchPredicate_MatchSet) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetRules()) < 2 {
		return MatchPredicate_MatchSetValidationError{
			field:  "Rules",
			reason: "value must contain at least 2 item(s)",
		}
	}

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return MatchPredicate_MatchSetValidationError{
					field:  fmt.Sprintf("Rules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// MatchPredicate_MatchSetValidationError is the validation error returned by
// MatchPredicate_MatchSet.Validate if the designated constraints aren't met.
type MatchPredicate_MatchSetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MatchPredicate_MatchSetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MatchPredicate_MatchSetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MatchPredicate_MatchSetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MatchPredicate_MatchSetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MatchPredicate_MatchSetValidationError) ErrorName() string {
	return "MatchPredicate_MatchSetValidationError"
}

// Error satisfies the builtin error interface
func (e MatchPredicate_MatchSetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMatchPredicate_MatchSet.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MatchPredicate_MatchSetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MatchPredicate_MatchSetValidationError{}

// Validate checks the field values on HttpGenericBodyMatch_GenericTextMatch
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *HttpGenericBodyMatch_GenericTextMatch) Validate() error {
	if m == nil {
		return nil
	}

	switch m.Rule.(type) {

	case *HttpGenericBodyMatch_GenericTextMatch_StringMatch:

		if utf8.RuneCountInString(m.GetStringMatch()) < 1 {
			return HttpGenericBodyMatch_GenericTextMatchValidationError{
				field:  "StringMatch",
				reason: "value length must be at least 1 runes",
			}
		}

	case *HttpGenericBodyMatch_GenericTextMatch_BinaryMatch:

		if len(m.GetBinaryMatch()) < 1 {
			return HttpGenericBodyMatch_GenericTextMatchValidationError{
				field:  "BinaryMatch",
				reason: "value length must be at least 1 bytes",
			}
		}

	default:
		return HttpGenericBodyMatch_GenericTextMatchValidationError{
			field:  "Rule",
			reason: "value is required",
		}

	}

	return nil
}

// HttpGenericBodyMatch_GenericTextMatchValidationError is the validation error
// returned by HttpGenericBodyMatch_GenericTextMatch.Validate if the
// designated constraints aren't met.
type HttpGenericBodyMatch_GenericTextMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) ErrorName() string {
	return "HttpGenericBodyMatch_GenericTextMatchValidationError"
}

// Error satisfies the builtin error interface
func (e HttpGenericBodyMatch_GenericTextMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpGenericBodyMatch_GenericTextMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpGenericBodyMatch_GenericTextMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpGenericBodyMatch_GenericTextMatchValidationError{}
