package common

const (
	// AideConfigLabelKey tells us if a specific ConfigMap is an AIDE config
	AideConfigLabelKey = "file-integrity.openshift.io/aide-conf"
	// AideConfigUpdatedAnnotationKey tells us if an aide config needs updating
	AideConfigUpdatedAnnotationKey = "file-integrity.openshift.io/updated"
	// AideDatabaseReinitAnnotationKey tells us if an aide config needs updating
	AideDatabaseReinitAnnotationKey = "file-integrity.openshift.io/re-init"
	// IntegrityLogLabelKey tells us that a log was generated by the log collector
	IntegrityLogLabelKey = "file-integrity.openshift.io/log"
	// IntegrityPodLabelKey tells us that a pod is owned by the file integrity operator
	IntegrityPodLabelKey = "file-integrity.openshift.io/pod"
	// IntegrityCMLabelKey tells us that a ConfigMap is owned by the file integrity operator
	IntegrityCMLabelKey = "file-integrity.openshift.io/cm"
	// IntegrityLogResultLabelKey tells us that the configMap represents a result log (a log we decided to keep)
	IntegrityLogResultLabelKey = "file-integrity.openshift.io/result-log"
	// IntegrityOwnerLabelKey tells us what FileIntegrity object owns a specific ConfigMap
	IntegrityOwnerLabelKey = "file-integrity.openshift.io/owner"
	// IntegrityConfigMapNodeLabelKey tells us from which node did the configmap come from
	IntegrityConfigMapNodeLabelKey = "file-integrity.openshift.io/node"
	// IntegrityLogContentKey is the key in the configmap where the logs are stored
	IntegrityLogContentKey = "integritylog"
	// IntegrityLogErrorAnnotationKey indicates that there was an error in the logcollector
	IntegrityLogErrorAnnotationKey = "file-integrity.openshift.io/log-errormsg"
	// CompressedLogsIndicatorLabelKey indicates the log has been compressed
	CompressedLogsIndicatorLabelKey    = "file-integrity.openshift.io/compressed"
	IntegrityLogFilesAddedAnnotation   = "file-integrity.openshift.io/files-added"
	IntegrityLogFilesRemovedAnnotation = "file-integrity.openshift.io/files-removed"
	IntegrityLogFilesChangedAnnotation = "file-integrity.openshift.io/files-changed"
	AideInitScriptConfigMapName        = "aide-init"
	AideReinitScriptConfigMapName      = "aide-reinit"
	AideScriptConfigMapName            = "aide-script"
	PauseConfigMapName                 = "aide-pause"
	PausePath                          = "/scripts/pause.sh"
	AideScriptConfigMapPrefix          = "aide-script"
	AideScriptPath                     = "/scripts/aide.sh"
	DaemonSetPrefix                    = "aide-ds"
	DefaultConfDataKey                 = "aide.conf"
	AideScriptKey                      = "aide.sh"
	OperatorServiceAccountName         = "file-integrity-operator"
	DaemonServiceAccountName           = "file-integrity-daemon"
	ReinitDaemonSetPrefix              = "aide-reinit-ds"
	// IntegrityCheckHoldoffFilePath specified the path to the file that tells
	// the AIDE check to hold off
	IntegrityCheckHoldoffFilePath = "/hostroot/etc/kubernetes/holdoff"
	// IntegrityHoldoffAnnotationKey indicates that there was an error in the logcollector
	IntegrityHoldoffAnnotationKey = "file-integrity.openshift.io/holdoff"
	// The default gracePeriod
	DefaultGracePeriod = 900
)
