// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object that contains one or more of the following fields:
//
//    * ListTapesInput$Limit
//
//    * ListTapesInput$Marker
//
//    * ListTapesInput$TapeARNs
type ListTapesInput struct {
	_ struct{} `type:"structure"`

	// An optional number limit for the tapes in the list returned by this call.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of tapes.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of each of the tapes you want to list. If
	// you don't specify a tape ARN, the response lists all tapes in both your VTL
	// and VTS.
	TapeARNs []string `type:"list"`
}

// String returns the string representation
func (s ListTapesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTapesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTapesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
//
//    * ListTapesOutput$Marker
//
//    * ListTapesOutput$VolumeInfos
type ListTapesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates the position at which to begin returning the next
	// list of tapes. Use the marker in your next request to continue pagination
	// of tapes. If there are no more tapes to list, this element does not appear
	// in the response body.
	Marker *string `min:"1" type:"string"`

	// An array of TapeInfo objects, where each object describes an a single tape.
	// If there not tapes in the tape library or VTS, then the TapeInfos is an empty
	// array.
	TapeInfos []TapeInfo `type:"list"`
}

// String returns the string representation
func (s ListTapesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTapes = "ListTapes"

// ListTapesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Lists virtual tapes in your virtual tape library (VTL) and your virtual tape
// shelf (VTS). You specify the tapes to list by specifying one or more tape
// Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation
// lists all virtual tapes in both your VTL and VTS.
//
// This operation supports pagination. By default, the operation returns a maximum
// of up to 100 tapes. You can optionally specify the Limit parameter in the
// body to limit the number of tapes in the response. If the number of tapes
// returned in the response is truncated, the response includes a Marker element
// that you can use in your subsequent request to retrieve the next set of tapes.
// This operation is only supported in the tape gateway type.
//
//    // Example sending a request using ListTapesRequest.
//    req := client.ListTapesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes
func (c *Client) ListTapesRequest(input *ListTapesInput) ListTapesRequest {
	op := &aws.Operation{
		Name:       opListTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTapesInput{}
	}

	req := c.newRequest(op, input, &ListTapesOutput{})
	return ListTapesRequest{Request: req, Input: input, Copy: c.ListTapesRequest}
}

// ListTapesRequest is the request type for the
// ListTapes API operation.
type ListTapesRequest struct {
	*aws.Request
	Input *ListTapesInput
	Copy  func(*ListTapesInput) ListTapesRequest
}

// Send marshals and sends the ListTapes API request.
func (r ListTapesRequest) Send(ctx context.Context) (*ListTapesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTapesResponse{
		ListTapesOutput: r.Request.Data.(*ListTapesOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTapesRequestPaginator returns a paginator for ListTapes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTapesRequest(input)
//   p := storagegateway.NewListTapesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTapesPaginator(req ListTapesRequest) ListTapesPaginator {
	return ListTapesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTapesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTapesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTapesPaginator struct {
	aws.Pager
}

func (p *ListTapesPaginator) CurrentPage() *ListTapesOutput {
	return p.Pager.CurrentPage().(*ListTapesOutput)
}

// ListTapesResponse is the response type for the
// ListTapes API operation.
type ListTapesResponse struct {
	*ListTapesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTapes request.
func (r *ListTapesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
