// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteParametersInput struct {
	_ struct{} `type:"structure"`

	// The names of the parameters to delete.
	//
	// Names is a required field
	Names []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteParametersInput"}

	if s.Names == nil {
		invalidParams.Add(aws.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteParametersOutput struct {
	_ struct{} `type:"structure"`

	// The names of the deleted parameters.
	DeletedParameters []string `min:"1" type:"list"`

	// The names of parameters that weren't deleted because the parameters are not
	// valid.
	InvalidParameters []string `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteParameters = "DeleteParameters"

// DeleteParametersRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Delete a list of parameters.
//
//    // Example sending a request using DeleteParametersRequest.
//    req := client.DeleteParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters
func (c *Client) DeleteParametersRequest(input *DeleteParametersInput) DeleteParametersRequest {
	op := &aws.Operation{
		Name:       opDeleteParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParametersInput{}
	}

	req := c.newRequest(op, input, &DeleteParametersOutput{})
	return DeleteParametersRequest{Request: req, Input: input, Copy: c.DeleteParametersRequest}
}

// DeleteParametersRequest is the request type for the
// DeleteParameters API operation.
type DeleteParametersRequest struct {
	*aws.Request
	Input *DeleteParametersInput
	Copy  func(*DeleteParametersInput) DeleteParametersRequest
}

// Send marshals and sends the DeleteParameters API request.
func (r DeleteParametersRequest) Send(ctx context.Context) (*DeleteParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteParametersResponse{
		DeleteParametersOutput: r.Request.Data.(*DeleteParametersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteParametersResponse is the response type for the
// DeleteParameters API operation.
type DeleteParametersResponse struct {
	*DeleteParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteParameters request.
func (r *DeleteParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
