// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDBProxyInput struct {
	_ struct{} `type:"structure"`

	// The authorization mechanism that the proxy uses.
	//
	// Auth is a required field
	Auth []UserAuthConfig `type:"list" required:"true"`

	// The identifier for the proxy. This name must be unique for all proxies owned
	// by your AWS account in the specified AWS Region. An identifier must begin
	// with a letter and must contain only ASCII letters, digits, and hyphens; it
	// can't end with a hyphen or contain two consecutive hyphens.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`

	// Whether the proxy includes detailed information about SQL statements in its
	// logs. This information helps you to debug issues involving SQL behavior or
	// the performance and scalability of the proxy connections. The debug information
	// includes the text of SQL statements that you submit through the proxy. Thus,
	// only enable this setting when needed for debugging, and only when you have
	// security measures in place to safeguard any sensitive information that appears
	// in the logs.
	DebugLogging *bool `type:"boolean"`

	// The kinds of databases that the proxy can connect to. This value determines
	// which database network protocol the proxy recognizes when it interprets network
	// traffic to and from the database. Currently, this value is always MYSQL.
	// The engine family applies to both RDS MySQL and Aurora MySQL.
	//
	// EngineFamily is a required field
	EngineFamily EngineFamily `type:"string" required:"true" enum:"true"`

	// The number of seconds that a connection to the proxy can be inactive before
	// the proxy disconnects it. You can set this value higher or lower than the
	// connection timeout limit for the associated database.
	IdleClientTimeout *int64 `type:"integer"`

	// A Boolean parameter that specifies whether Transport Layer Security (TLS)
	// encryption is required for connections to the proxy. By enabling this setting,
	// you can enforce encrypted TLS connections to the proxy.
	RequireTLS *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access
	// secrets in AWS Secrets Manager.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// An optional set of key-value pairs to associate arbitrary data of your choosing
	// with the proxy.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// One or more VPC security group IDs to associate with the new proxy.
	VpcSecurityGroupIds []string `type:"list"`

	// One or more VPC subnet IDs to associate with the new proxy.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateDBProxyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBProxyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDBProxyInput"}

	if s.Auth == nil {
		invalidParams.Add(aws.NewErrParamRequired("Auth"))
	}

	if s.DBProxyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBProxyName"))
	}
	if len(s.EngineFamily) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EngineFamily"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.VpcSubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcSubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDBProxyOutput struct {
	_ struct{} `type:"structure"`

	// The DBProxy structure corresponding to the new proxy.
	DBProxy *DBProxy `type:"structure"`
}

// String returns the string representation
func (s CreateDBProxyOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDBProxy = "CreateDBProxy"

// CreateDBProxyRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Creates a new DB proxy.
//
//    // Example sending a request using CreateDBProxyRequest.
//    req := client.CreateDBProxyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy
func (c *Client) CreateDBProxyRequest(input *CreateDBProxyInput) CreateDBProxyRequest {
	op := &aws.Operation{
		Name:       opCreateDBProxy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBProxyInput{}
	}

	req := c.newRequest(op, input, &CreateDBProxyOutput{})
	return CreateDBProxyRequest{Request: req, Input: input, Copy: c.CreateDBProxyRequest}
}

// CreateDBProxyRequest is the request type for the
// CreateDBProxy API operation.
type CreateDBProxyRequest struct {
	*aws.Request
	Input *CreateDBProxyInput
	Copy  func(*CreateDBProxyInput) CreateDBProxyRequest
}

// Send marshals and sends the CreateDBProxy API request.
func (r CreateDBProxyRequest) Send(ctx context.Context) (*CreateDBProxyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDBProxyResponse{
		CreateDBProxyOutput: r.Request.Data.(*CreateDBProxyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDBProxyResponse is the response type for the
// CreateDBProxy API operation.
type CreateDBProxyResponse struct {
	*CreateDBProxyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDBProxy request.
func (r *CreateDBProxyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
