// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDefaultAuthorizerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type DescribeDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The default authorizer's description.
	AuthorizerDescription *AuthorizerDescription `locationName:"authorizerDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDefaultAuthorizerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerDescription != nil {
		v := s.AuthorizerDescription

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorizerDescription", v, metadata)
	}
	return nil
}

const opDescribeDefaultAuthorizer = "DescribeDefaultAuthorizer"

// DescribeDefaultAuthorizerRequest returns a request value for making API operation for
// AWS IoT.
//
// Describes the default authorizer.
//
//    // Example sending a request using DescribeDefaultAuthorizerRequest.
//    req := client.DescribeDefaultAuthorizerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeDefaultAuthorizerRequest(input *DescribeDefaultAuthorizerInput) DescribeDefaultAuthorizerRequest {
	op := &aws.Operation{
		Name:       opDescribeDefaultAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &DescribeDefaultAuthorizerInput{}
	}

	req := c.newRequest(op, input, &DescribeDefaultAuthorizerOutput{})
	return DescribeDefaultAuthorizerRequest{Request: req, Input: input, Copy: c.DescribeDefaultAuthorizerRequest}
}

// DescribeDefaultAuthorizerRequest is the request type for the
// DescribeDefaultAuthorizer API operation.
type DescribeDefaultAuthorizerRequest struct {
	*aws.Request
	Input *DescribeDefaultAuthorizerInput
	Copy  func(*DescribeDefaultAuthorizerInput) DescribeDefaultAuthorizerRequest
}

// Send marshals and sends the DescribeDefaultAuthorizer API request.
func (r DescribeDefaultAuthorizerRequest) Send(ctx context.Context) (*DescribeDefaultAuthorizerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDefaultAuthorizerResponse{
		DescribeDefaultAuthorizerOutput: r.Request.Data.(*DescribeDefaultAuthorizerOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDefaultAuthorizerResponse is the response type for the
// DescribeDefaultAuthorizer API operation.
type DescribeDefaultAuthorizerResponse struct {
	*DescribeDefaultAuthorizerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDefaultAuthorizer request.
func (r *DescribeDefaultAuthorizerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
