// Code generated by protoc-gen-go. DO NOT EDIT.
// source: proto/v2/zipkin.proto

package zipkin_proto3

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// When present, kind clarifies timestamp, duration and remote_endpoint. When
// absent, the span is local or incomplete. Unlike client and server, there
// is no direct critical path latency relationship between producer and
// consumer spans.
type Span_Kind int32

const (
	// Default value interpreted as absent.
	Span_SPAN_KIND_UNSPECIFIED Span_Kind = 0
	// The span represents the client side of an RPC operation, implying the
	// following:
	//
	// timestamp is the moment a request was sent to the server.
	// duration is the delay until a response or an error was received.
	// remote_endpoint is the server.
	Span_CLIENT Span_Kind = 1
	// The span represents the server side of an RPC operation, implying the
	// following:
	//
	// timestamp is the moment a client request was received.
	// duration is the delay until a response was sent or an error.
	// remote_endpoint is the client.
	Span_SERVER Span_Kind = 2
	// The span represents production of a message to a remote broker, implying
	// the following:
	//
	// timestamp is the moment a message was sent to a destination.
	// duration is the delay sending the message, such as batching.
	// remote_endpoint is the broker.
	Span_PRODUCER Span_Kind = 3
	// The span represents consumption of a message from a remote broker, not
	// time spent servicing it. For example, a message processor would be an
	// in-process child span of a consumer. Consumer spans imply the following:
	//
	// timestamp is the moment a message was received from an origin.
	// duration is the delay consuming the message, such as from backlog.
	// remote_endpoint is the broker.
	Span_CONSUMER Span_Kind = 4
)

var Span_Kind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "CLIENT",
	2: "SERVER",
	3: "PRODUCER",
	4: "CONSUMER",
}
var Span_Kind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"CLIENT":                1,
	"SERVER":                2,
	"PRODUCER":              3,
	"CONSUMER":              4,
}

func (x Span_Kind) String() string {
	return proto.EnumName(Span_Kind_name, int32(x))
}
func (Span_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_zipkin_92f7b52feff0f8d2, []int{0, 0}
}

// A span is a single-host view of an operation. A trace is a series of spans
// (often RPC calls) which nest to form a latency tree. Spans are in the same
// trace when they share the same trace ID. The parent_id field establishes the
// position of one span in the tree.
//
// The root span is where parent_id is Absent and usually has the longest
// duration in the trace. However, nested asynchronous work can materialize as
// child spans whose duration exceed the root span.
//
// Spans usually represent remote activity such as RPC calls, or messaging
// producers and consumers. However, they can also represent in-process
// activity in any position of the trace. For example, a root span could
// represent a server receiving an initial client request. A root span could
// also represent a scheduled job that has no remote context.
//
// Encoding notes:
//
// Epoch timestamp are encoded fixed64 as varint would also be 8 bytes, and more
// expensive to encode and size. Duration is stored uint64, as often the numbers
// are quite small.
//
// Default values are ok, as only natural numbers are used. For example, zero is
// an invalid timestamp and an invalid duration, false values for debug or shared
// are ignorable, and zero-length strings also coerce to null.
//
// The next id is 14.
//
// Note fields up to 15 take 1 byte to encode. Take care when adding new fields
// https://developers.google.com/protocol-buffers/docs/proto3#assigning-tags
type Span struct {
	// Randomly generated, unique identifier for a trace, set on all spans within
	// it.
	//
	// This field is required and encoded as 8 or 16 opaque bytes.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// The parent span ID or absent if this the root span in a trace.
	ParentId []byte `protobuf:"bytes,2,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	// Unique identifier for this operation within the trace.
	//
	// This field is required and encoded as 8 opaque bytes.
	Id []byte `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// When present, used to interpret remote_endpoint
	Kind Span_Kind `protobuf:"varint,4,opt,name=kind,proto3,enum=zipkin.proto3.Span_Kind" json:"kind,omitempty"`
	// The logical operation this span represents in lowercase (e.g. rpc method).
	// Leave absent if unknown.
	//
	// As these are lookup labels, take care to ensure names are low cardinality.
	// For example, do not embed variables into the name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Epoch microseconds of the start of this span, possibly absent if
	// incomplete.
	//
	// For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
	//
	// This value should be set directly by instrumentation, using the most
	// precise value possible. For example, gettimeofday or multiplying epoch
	// millis by 1000.
	//
	// There are three known edge-cases where this could be reported absent.
	// - A span was allocated but never started (ex not yet received a timestamp)
	// - The span's start event was lost
	// - Data about a completed span (ex tags) were sent after the fact
	Timestamp uint64 `protobuf:"fixed64,6,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Duration in microseconds of the critical path, if known. Durations of less
	// than one are rounded up. Duration of children can be longer than their
	// parents due to asynchronous operations.
	//
	// For example 150 milliseconds is 150000 microseconds.
	Duration uint64 `protobuf:"varint,7,opt,name=duration,proto3" json:"duration,omitempty"`
	// The host that recorded this span, primarily for query by service name.
	//
	// Instrumentation should always record this. Usually, absent implies late
	// data. The IP address corresponding to this is usually the site local or
	// advertised service address. When present, the port indicates the listen
	// port.
	LocalEndpoint *Endpoint `protobuf:"bytes,8,opt,name=local_endpoint,json=localEndpoint,proto3" json:"local_endpoint,omitempty"`
	// When an RPC (or messaging) span, indicates the other side of the
	// connection.
	//
	// By recording the remote endpoint, your trace will contain network context
	// even if the peer is not tracing. For example, you can record the IP from
	// the "X-Forwarded-For" header or the service name and socket of a remote
	// peer.
	RemoteEndpoint *Endpoint `protobuf:"bytes,9,opt,name=remote_endpoint,json=remoteEndpoint,proto3" json:"remote_endpoint,omitempty"`
	// Associates events that explain latency with the time they happened.
	Annotations []*Annotation `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Tags give your span context for search, viewing and analysis.
	//
	// For example, a key "your_app.version" would let you lookup traces by
	// version. A tag "sql.query" isn't searchable, but it can help in debugging
	// when viewing a trace.
	Tags map[string]string `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// True is a request to store this span even if it overrides sampling policy.
	//
	// This is true when the "X-B3-Flags" header has a value of 1.
	Debug bool `protobuf:"varint,12,opt,name=debug,proto3" json:"debug,omitempty"`
	// True if we are contributing to a span started by another tracer (ex on a
	// different host).
	Shared               bool     `protobuf:"varint,13,opt,name=shared,proto3" json:"shared,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span) Reset()         { *m = Span{} }
func (m *Span) String() string { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()    {}
func (*Span) Descriptor() ([]byte, []int) {
	return fileDescriptor_zipkin_92f7b52feff0f8d2, []int{0}
}
func (m *Span) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span.Unmarshal(m, b)
}
func (m *Span) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span.Marshal(b, m, deterministic)
}
func (dst *Span) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span.Merge(dst, src)
}
func (m *Span) XXX_Size() int {
	return xxx_messageInfo_Span.Size(m)
}
func (m *Span) XXX_DiscardUnknown() {
	xxx_messageInfo_Span.DiscardUnknown(m)
}

var xxx_messageInfo_Span proto.InternalMessageInfo

func (m *Span) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span) GetParentId() []byte {
	if m != nil {
		return m.ParentId
	}
	return nil
}

func (m *Span) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Span) GetKind() Span_Kind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span) GetTimestamp() uint64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Span) GetDuration() uint64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *Span) GetLocalEndpoint() *Endpoint {
	if m != nil {
		return m.LocalEndpoint
	}
	return nil
}

func (m *Span) GetRemoteEndpoint() *Endpoint {
	if m != nil {
		return m.RemoteEndpoint
	}
	return nil
}

func (m *Span) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Span) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Span) GetDebug() bool {
	if m != nil {
		return m.Debug
	}
	return false
}

func (m *Span) GetShared() bool {
	if m != nil {
		return m.Shared
	}
	return false
}

// The network context of a node in the service graph.
//
// The next id is 5.
type Endpoint struct {
	// Lower-case label of this node in the service graph, such as "favstar".
	// Leave absent if unknown.
	//
	// This is a primary label for trace lookup and aggregation, so it should be
	// intuitive and consistent. Many use a name from service discovery.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// 4 byte representation of the primary IPv4 address associated with this
	// connection. Absent if unknown.
	Ipv4 []byte `protobuf:"bytes,2,opt,name=ipv4,proto3" json:"ipv4,omitempty"`
	// 16 byte representation of the primary IPv6 address associated with this
	// connection. Absent if unknown.
	//
	// Prefer using the ipv4 field for mapped addresses.
	Ipv6 []byte `protobuf:"bytes,3,opt,name=ipv6,proto3" json:"ipv6,omitempty"`
	// Depending on context, this could be a listen port or the client-side of a
	// socket. Absent if unknown.
	Port                 int32    `protobuf:"varint,4,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Endpoint) Reset()         { *m = Endpoint{} }
func (m *Endpoint) String() string { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()    {}
func (*Endpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_zipkin_92f7b52feff0f8d2, []int{1}
}
func (m *Endpoint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Endpoint.Unmarshal(m, b)
}
func (m *Endpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Endpoint.Marshal(b, m, deterministic)
}
func (dst *Endpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Endpoint.Merge(dst, src)
}
func (m *Endpoint) XXX_Size() int {
	return xxx_messageInfo_Endpoint.Size(m)
}
func (m *Endpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_Endpoint.DiscardUnknown(m)
}

var xxx_messageInfo_Endpoint proto.InternalMessageInfo

func (m *Endpoint) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *Endpoint) GetIpv4() []byte {
	if m != nil {
		return m.Ipv4
	}
	return nil
}

func (m *Endpoint) GetIpv6() []byte {
	if m != nil {
		return m.Ipv6
	}
	return nil
}

func (m *Endpoint) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Associates an event that explains latency with a timestamp.
// Unlike log statements, annotations are often codes. Ex. "ws" for WireSend
//
// The next id is 3.
type Annotation struct {
	// Epoch microseconds of this event.
	//
	// For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
	//
	// This value should be set directly by instrumentation, using the most
	// precise value possible. For example, gettimeofday or multiplying epoch
	// millis by 1000.
	Timestamp uint64 `protobuf:"fixed64,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Usually a short tag indicating an event, like "error"
	//
	// While possible to add larger data, such as garbage collection details, low
	// cardinality event names both keep the size of spans down and also are easy
	// to search against.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Annotation) Reset()         { *m = Annotation{} }
func (m *Annotation) String() string { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()    {}
func (*Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_zipkin_92f7b52feff0f8d2, []int{2}
}
func (m *Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Annotation.Unmarshal(m, b)
}
func (m *Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Annotation.Marshal(b, m, deterministic)
}
func (dst *Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Annotation.Merge(dst, src)
}
func (m *Annotation) XXX_Size() int {
	return xxx_messageInfo_Annotation.Size(m)
}
func (m *Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Annotation proto.InternalMessageInfo

func (m *Annotation) GetTimestamp() uint64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Annotation) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A list of spans with possibly different trace ids, in no particular order.
//
// This is used for all transports: POST, Kafka messages etc. No other fields
// are expected, This message facilitates the mechanics of encoding a list, as
// a field number is required. The name of this type is the same in the OpenApi
// aka Swagger specification. https://zipkin.io/zipkin-api/#/default/post_spans
type ListOfSpans struct {
	Spans                []*Span  `protobuf:"bytes,1,rep,name=spans,proto3" json:"spans,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOfSpans) Reset()         { *m = ListOfSpans{} }
func (m *ListOfSpans) String() string { return proto.CompactTextString(m) }
func (*ListOfSpans) ProtoMessage()    {}
func (*ListOfSpans) Descriptor() ([]byte, []int) {
	return fileDescriptor_zipkin_92f7b52feff0f8d2, []int{3}
}
func (m *ListOfSpans) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOfSpans.Unmarshal(m, b)
}
func (m *ListOfSpans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOfSpans.Marshal(b, m, deterministic)
}
func (dst *ListOfSpans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOfSpans.Merge(dst, src)
}
func (m *ListOfSpans) XXX_Size() int {
	return xxx_messageInfo_ListOfSpans.Size(m)
}
func (m *ListOfSpans) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOfSpans.DiscardUnknown(m)
}

var xxx_messageInfo_ListOfSpans proto.InternalMessageInfo

func (m *ListOfSpans) GetSpans() []*Span {
	if m != nil {
		return m.Spans
	}
	return nil
}

func init() {
	proto.RegisterType((*Span)(nil), "zipkin.proto3.Span")
	proto.RegisterMapType((map[string]string)(nil), "zipkin.proto3.Span.TagsEntry")
	proto.RegisterType((*Endpoint)(nil), "zipkin.proto3.Endpoint")
	proto.RegisterType((*Annotation)(nil), "zipkin.proto3.Annotation")
	proto.RegisterType((*ListOfSpans)(nil), "zipkin.proto3.ListOfSpans")
	proto.RegisterEnum("zipkin.proto3.Span_Kind", Span_Kind_name, Span_Kind_value)
}

func init() { proto.RegisterFile("proto/v2/zipkin.proto", fileDescriptor_zipkin_92f7b52feff0f8d2) }

var fileDescriptor_zipkin_92f7b52feff0f8d2 = []byte{
	// 529 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x52, 0x61, 0x8f, 0xd2, 0x40,
	0x10, 0x75, 0xa1, 0x70, 0xed, 0x14, 0xb0, 0x59, 0x3d, 0x5d, 0x4e, 0x4d, 0x2a, 0x9f, 0x6a, 0x62,
	0xb8, 0x88, 0x46, 0x2f, 0x9a, 0x98, 0x3b, 0xa1, 0x26, 0xcd, 0x9d, 0x85, 0x2c, 0x87, 0x5f, 0xc9,
	0x1e, 0x5d, 0x71, 0x03, 0x6c, 0x9b, 0x76, 0x21, 0x39, 0x7f, 0xba, 0x9f, 0x4c, 0xb7, 0x15, 0xee,
	0x08, 0xb9, 0x6f, 0xef, 0xbd, 0x79, 0x3b, 0x3b, 0x99, 0x79, 0x70, 0x9c, 0xa4, 0xb1, 0x8a, 0x4f,
	0x37, 0xbd, 0xd3, 0x3f, 0x22, 0x59, 0x08, 0xd9, 0xd5, 0x1c, 0x37, 0xef, 0xb2, 0xf7, 0x9d, 0xbf,
	0x06, 0x18, 0xe3, 0x84, 0x49, 0xdc, 0x06, 0x53, 0xa5, 0x6c, 0xc6, 0xa7, 0x22, 0x22, 0xc8, 0x45,
	0x5e, 0x83, 0x1e, 0x69, 0x1e, 0x44, 0xf8, 0x05, 0x58, 0x09, 0x4b, 0xb9, 0x54, 0x79, 0xad, 0xa2,
	0x6b, 0x66, 0x21, 0x04, 0x11, 0x6e, 0x41, 0x45, 0x44, 0xa4, 0xaa, 0xd5, 0x8a, 0x88, 0xf0, 0x5b,
	0x30, 0x16, 0x42, 0x46, 0xc4, 0x70, 0x91, 0xd7, 0xea, 0x91, 0xee, 0xbd, 0xef, 0xba, 0xf9, 0x57,
	0xdd, 0x4b, 0x21, 0x23, 0xaa, 0x5d, 0x18, 0x83, 0x21, 0xd9, 0x8a, 0x93, 0x9a, 0x8b, 0x3c, 0x8b,
	0x6a, 0x8c, 0x5f, 0x82, 0xa5, 0xc4, 0x8a, 0x67, 0x8a, 0xad, 0x12, 0x52, 0x77, 0x91, 0x57, 0xa7,
	0x3b, 0x01, 0x9f, 0x80, 0x19, 0xad, 0x53, 0xa6, 0x44, 0x2c, 0xc9, 0x91, 0x8b, 0x3c, 0x83, 0x6e,
	0x39, 0xfe, 0x0a, 0xad, 0x65, 0x3c, 0x63, 0xcb, 0x29, 0x97, 0x51, 0x12, 0x0b, 0xa9, 0x88, 0xe9,
	0x22, 0xcf, 0xee, 0x3d, 0xdf, 0x9b, 0xc2, 0x2f, 0xcb, 0xb4, 0xa9, 0xed, 0xff, 0x29, 0x3e, 0x87,
	0xc7, 0x29, 0x5f, 0xc5, 0x8a, 0xef, 0x1a, 0x58, 0x0f, 0x37, 0x68, 0x15, 0xfe, 0x6d, 0x87, 0x2f,
	0x60, 0x33, 0x29, 0x63, 0xa5, 0xe7, 0xc9, 0x08, 0xb8, 0x55, 0xcf, 0xee, 0xb5, 0xf7, 0x5e, 0x5f,
	0x6c, 0x1d, 0xf4, 0xae, 0x1b, 0xbf, 0x03, 0x43, 0xb1, 0x79, 0x46, 0x6c, 0xfd, 0xea, 0xd5, 0xa1,
	0xd5, 0x5d, 0xb3, 0x79, 0xe6, 0x4b, 0x95, 0xde, 0x52, 0x6d, 0xc5, 0x4f, 0xa1, 0x16, 0xf1, 0x9b,
	0xf5, 0x9c, 0x34, 0x5c, 0xe4, 0x99, 0xb4, 0x20, 0xf8, 0x19, 0xd4, 0xb3, 0xdf, 0x2c, 0xe5, 0x11,
	0x69, 0x6a, 0xb9, 0x64, 0x27, 0x9f, 0xc0, 0xda, 0x36, 0xc0, 0x0e, 0x54, 0x17, 0xfc, 0x56, 0xdf,
	0xda, 0xa2, 0x39, 0xcc, 0x9b, 0x6d, 0xd8, 0x72, 0xcd, 0xf5, 0x8d, 0x2d, 0x5a, 0x90, 0xcf, 0x95,
	0x33, 0xd4, 0x99, 0x80, 0x91, 0x1f, 0x0d, 0xb7, 0xe1, 0x78, 0x3c, 0xba, 0x08, 0xa7, 0x97, 0x41,
	0x38, 0x98, 0x4e, 0xc2, 0xf1, 0xc8, 0xef, 0x07, 0xdf, 0x03, 0x7f, 0xe0, 0x3c, 0xc2, 0x00, 0xf5,
	0xfe, 0x55, 0xe0, 0x87, 0xd7, 0x0e, 0xca, 0xf1, 0xd8, 0xa7, 0x3f, 0x7d, 0xea, 0x54, 0x70, 0x03,
	0xcc, 0x11, 0x1d, 0x0e, 0x26, 0x7d, 0x9f, 0x3a, 0xd5, 0x9c, 0xf5, 0x87, 0xe1, 0x78, 0xf2, 0xc3,
	0xa7, 0x8e, 0xd1, 0x11, 0x60, 0x6e, 0x37, 0xf7, 0x1a, 0x1a, 0x19, 0x4f, 0x37, 0x62, 0xc6, 0xa7,
	0x3a, 0x11, 0xc5, 0x5c, 0x76, 0xa9, 0x85, 0x79, 0x30, 0x30, 0x18, 0x22, 0xd9, 0x7c, 0x28, 0x23,
	0xa8, 0x71, 0xa9, 0x7d, 0x2c, 0x03, 0xa8, 0x71, 0xae, 0x25, 0x71, 0xaa, 0x74, 0x04, 0x6b, 0x54,
	0xe3, 0xce, 0x39, 0xc0, 0x6e, 0xed, 0xf7, 0x23, 0x86, 0xf6, 0x23, 0x76, 0x70, 0x0f, 0x9d, 0x33,
	0xb0, 0xaf, 0x44, 0xa6, 0x86, 0xbf, 0xf2, 0x43, 0x64, 0xf8, 0x0d, 0xd4, 0xb2, 0x1c, 0x10, 0xa4,
	0xaf, 0xf5, 0xe4, 0xc0, 0xb5, 0x68, 0xe1, 0xf8, 0x86, 0xa1, 0x55, 0x14, 0x7b, 0x65, 0x75, 0x84,
	0x6e, 0xea, 0x05, 0xfa, 0x17, 0x00, 0x00, 0xff, 0xff, 0x9f, 0x6d, 0xae, 0x22, 0xa6, 0x03, 0x00,
	0x00,
}
