// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/api/servicecertsigner/v1alpha1"
	scheme "github.com/openshift/client-go/servicecertsigner/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceCertSignerOperatorConfigsGetter has a method to return a ServiceCertSignerOperatorConfigInterface.
// A group's client should implement this interface.
type ServiceCertSignerOperatorConfigsGetter interface {
	ServiceCertSignerOperatorConfigs() ServiceCertSignerOperatorConfigInterface
}

// ServiceCertSignerOperatorConfigInterface has methods to work with ServiceCertSignerOperatorConfig resources.
type ServiceCertSignerOperatorConfigInterface interface {
	Create(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.CreateOptions) (*v1alpha1.ServiceCertSignerOperatorConfig, error)
	Update(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.UpdateOptions) (*v1alpha1.ServiceCertSignerOperatorConfig, error)
	UpdateStatus(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.UpdateOptions) (*v1alpha1.ServiceCertSignerOperatorConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ServiceCertSignerOperatorConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ServiceCertSignerOperatorConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error)
	ServiceCertSignerOperatorConfigExpansion
}

// serviceCertSignerOperatorConfigs implements ServiceCertSignerOperatorConfigInterface
type serviceCertSignerOperatorConfigs struct {
	client rest.Interface
}

// newServiceCertSignerOperatorConfigs returns a ServiceCertSignerOperatorConfigs
func newServiceCertSignerOperatorConfigs(c *ServicecertsignerV1alpha1Client) *serviceCertSignerOperatorConfigs {
	return &serviceCertSignerOperatorConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the serviceCertSignerOperatorConfig, and returns the corresponding serviceCertSignerOperatorConfig object, and an error if there is any.
func (c *serviceCertSignerOperatorConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error) {
	result = &v1alpha1.ServiceCertSignerOperatorConfig{}
	err = c.client.Get().
		Resource("servicecertsigneroperatorconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceCertSignerOperatorConfigs that match those selectors.
func (c *serviceCertSignerOperatorConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ServiceCertSignerOperatorConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ServiceCertSignerOperatorConfigList{}
	err = c.client.Get().
		Resource("servicecertsigneroperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceCertSignerOperatorConfigs.
func (c *serviceCertSignerOperatorConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("servicecertsigneroperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a serviceCertSignerOperatorConfig and creates it.  Returns the server's representation of the serviceCertSignerOperatorConfig, and an error, if there is any.
func (c *serviceCertSignerOperatorConfigs) Create(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.CreateOptions) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error) {
	result = &v1alpha1.ServiceCertSignerOperatorConfig{}
	err = c.client.Post().
		Resource("servicecertsigneroperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCertSignerOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a serviceCertSignerOperatorConfig and updates it. Returns the server's representation of the serviceCertSignerOperatorConfig, and an error, if there is any.
func (c *serviceCertSignerOperatorConfigs) Update(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.UpdateOptions) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error) {
	result = &v1alpha1.ServiceCertSignerOperatorConfig{}
	err = c.client.Put().
		Resource("servicecertsigneroperatorconfigs").
		Name(serviceCertSignerOperatorConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCertSignerOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *serviceCertSignerOperatorConfigs) UpdateStatus(ctx context.Context, serviceCertSignerOperatorConfig *v1alpha1.ServiceCertSignerOperatorConfig, opts v1.UpdateOptions) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error) {
	result = &v1alpha1.ServiceCertSignerOperatorConfig{}
	err = c.client.Put().
		Resource("servicecertsigneroperatorconfigs").
		Name(serviceCertSignerOperatorConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCertSignerOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the serviceCertSignerOperatorConfig and deletes it. Returns an error if one occurs.
func (c *serviceCertSignerOperatorConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("servicecertsigneroperatorconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceCertSignerOperatorConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("servicecertsigneroperatorconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched serviceCertSignerOperatorConfig.
func (c *serviceCertSignerOperatorConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ServiceCertSignerOperatorConfig, err error) {
	result = &v1alpha1.ServiceCertSignerOperatorConfig{}
	err = c.client.Patch(pt).
		Resource("servicecertsigneroperatorconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
