// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grafeas/v1/provenance.proto

package grafeas

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of an alias.
type AliasContext_Kind int32

const (
	// Unknown.
	AliasContext_KIND_UNSPECIFIED AliasContext_Kind = 0
	// Git tag.
	AliasContext_FIXED AliasContext_Kind = 1
	// Git branch.
	AliasContext_MOVABLE AliasContext_Kind = 2
	// Used to specify non-standard aliases. For example, if a Git repo has a
	// ref named "refs/foo/bar".
	AliasContext_OTHER AliasContext_Kind = 4
)

var AliasContext_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "FIXED",
	2: "MOVABLE",
	4: "OTHER",
}

var AliasContext_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"FIXED":            1,
	"MOVABLE":          2,
	"OTHER":            4,
}

func (x AliasContext_Kind) String() string {
	return proto.EnumName(AliasContext_Kind_name, int32(x))
}

func (AliasContext_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{7, 0}
}

// Provenance of a build. Contains all information needed to verify the full
// details about the build from source to completion.
type BuildProvenance struct {
	// Required. Unique identifier of the build.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the project.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Commands requested by the build.
	Commands []*Command `protobuf:"bytes,3,rep,name=commands,proto3" json:"commands,omitempty"`
	// Output of the build.
	BuiltArtifacts []*Artifact `protobuf:"bytes,4,rep,name=built_artifacts,json=builtArtifacts,proto3" json:"built_artifacts,omitempty"`
	// Time at which the build was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time at which execution of the build was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time at which execution of the build was finished.
	EndTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// E-mail address of the user who initiated this build. Note that this was the
	// user's e-mail address at the time the build was initiated; this address may
	// not represent the same end-user for all time.
	Creator string `protobuf:"bytes,8,opt,name=creator,proto3" json:"creator,omitempty"`
	// URI where any logs for this provenance were written.
	LogsUri string `protobuf:"bytes,9,opt,name=logs_uri,json=logsUri,proto3" json:"logs_uri,omitempty"`
	// Details of the Source input to the build.
	SourceProvenance *Source `protobuf:"bytes,10,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Trigger identifier if the build was triggered automatically; empty if not.
	TriggerId string `protobuf:"bytes,11,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Special options applied to this build. This is a catch-all field where
	// build providers can enter any desired additional details.
	BuildOptions map[string]string `protobuf:"bytes,12,rep,name=build_options,json=buildOptions,proto3" json:"build_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Version string of the builder at the time this build was executed.
	BuilderVersion       string   `protobuf:"bytes,13,opt,name=builder_version,json=builderVersion,proto3" json:"builder_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildProvenance) Reset()         { *m = BuildProvenance{} }
func (m *BuildProvenance) String() string { return proto.CompactTextString(m) }
func (*BuildProvenance) ProtoMessage()    {}
func (*BuildProvenance) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{0}
}

func (m *BuildProvenance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildProvenance.Unmarshal(m, b)
}
func (m *BuildProvenance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildProvenance.Marshal(b, m, deterministic)
}
func (m *BuildProvenance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildProvenance.Merge(m, src)
}
func (m *BuildProvenance) XXX_Size() int {
	return xxx_messageInfo_BuildProvenance.Size(m)
}
func (m *BuildProvenance) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildProvenance.DiscardUnknown(m)
}

var xxx_messageInfo_BuildProvenance proto.InternalMessageInfo

func (m *BuildProvenance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildProvenance) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BuildProvenance) GetCommands() []*Command {
	if m != nil {
		return m.Commands
	}
	return nil
}

func (m *BuildProvenance) GetBuiltArtifacts() []*Artifact {
	if m != nil {
		return m.BuiltArtifacts
	}
	return nil
}

func (m *BuildProvenance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BuildProvenance) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *BuildProvenance) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *BuildProvenance) GetCreator() string {
	if m != nil {
		return m.Creator
	}
	return ""
}

func (m *BuildProvenance) GetLogsUri() string {
	if m != nil {
		return m.LogsUri
	}
	return ""
}

func (m *BuildProvenance) GetSourceProvenance() *Source {
	if m != nil {
		return m.SourceProvenance
	}
	return nil
}

func (m *BuildProvenance) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *BuildProvenance) GetBuildOptions() map[string]string {
	if m != nil {
		return m.BuildOptions
	}
	return nil
}

func (m *BuildProvenance) GetBuilderVersion() string {
	if m != nil {
		return m.BuilderVersion
	}
	return ""
}

// Source describes the location of the source used for the build.
type Source struct {
	// If provided, the input binary artifacts for the build came from this
	// location.
	ArtifactStorageSourceUri string `protobuf:"bytes,1,opt,name=artifact_storage_source_uri,json=artifactStorageSourceUri,proto3" json:"artifact_storage_source_uri,omitempty"`
	// Hash(es) of the build source, which can be used to verify that the original
	// source integrity was maintained in the build.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (.tar.gz), the FileHash will be for the single path to that file.
	FileHashes map[string]*FileHashes `protobuf:"bytes,2,rep,name=file_hashes,json=fileHashes,proto3" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If provided, the source code used for the build came from this location.
	Context *SourceContext `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
	// If provided, some of the source code used for the build may be found in
	// these locations, in the case where the source repository had multiple
	// remotes or submodules. This list will not include the context specified in
	// the context field.
	AdditionalContexts   []*SourceContext `protobuf:"bytes,4,rep,name=additional_contexts,json=additionalContexts,proto3" json:"additional_contexts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{1}
}

func (m *Source) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Source.Unmarshal(m, b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Source.Marshal(b, m, deterministic)
}
func (m *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(m, src)
}
func (m *Source) XXX_Size() int {
	return xxx_messageInfo_Source.Size(m)
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

func (m *Source) GetArtifactStorageSourceUri() string {
	if m != nil {
		return m.ArtifactStorageSourceUri
	}
	return ""
}

func (m *Source) GetFileHashes() map[string]*FileHashes {
	if m != nil {
		return m.FileHashes
	}
	return nil
}

func (m *Source) GetContext() *SourceContext {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Source) GetAdditionalContexts() []*SourceContext {
	if m != nil {
		return m.AdditionalContexts
	}
	return nil
}

// Container message for hashes of byte content of files, used in source
// messages to verify integrity of source input to the build.
type FileHashes struct {
	// Required. Collection of file hashes.
	FileHash             []*Hash  `protobuf:"bytes,1,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileHashes) Reset()         { *m = FileHashes{} }
func (m *FileHashes) String() string { return proto.CompactTextString(m) }
func (*FileHashes) ProtoMessage()    {}
func (*FileHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{2}
}

func (m *FileHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileHashes.Unmarshal(m, b)
}
func (m *FileHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileHashes.Marshal(b, m, deterministic)
}
func (m *FileHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileHashes.Merge(m, src)
}
func (m *FileHashes) XXX_Size() int {
	return xxx_messageInfo_FileHashes.Size(m)
}
func (m *FileHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_FileHashes.DiscardUnknown(m)
}

var xxx_messageInfo_FileHashes proto.InternalMessageInfo

func (m *FileHashes) GetFileHash() []*Hash {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	// Required. The type of hash that was performed, e.g. "SHA-256".
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Required. The hash value.
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hash) Reset()         { *m = Hash{} }
func (m *Hash) String() string { return proto.CompactTextString(m) }
func (*Hash) ProtoMessage()    {}
func (*Hash) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{3}
}

func (m *Hash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hash.Unmarshal(m, b)
}
func (m *Hash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hash.Marshal(b, m, deterministic)
}
func (m *Hash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hash.Merge(m, src)
}
func (m *Hash) XXX_Size() int {
	return xxx_messageInfo_Hash.Size(m)
}
func (m *Hash) XXX_DiscardUnknown() {
	xxx_messageInfo_Hash.DiscardUnknown(m)
}

var xxx_messageInfo_Hash proto.InternalMessageInfo

func (m *Hash) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Hash) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Command describes a step performed as part of the build pipeline.
type Command struct {
	// Required. Name of the command, as presented on the command line, or if the
	// command is packaged as a Docker container, as presented to `docker pull`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Environment variables set before running this command.
	Env []string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// Command-line arguments used when executing this command.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Working directory (relative to project source root) used when running this
	// command.
	Dir string `protobuf:"bytes,4,opt,name=dir,proto3" json:"dir,omitempty"`
	// Optional unique identifier for this command, used in wait_for to reference
	// this command as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The ID(s) of the command(s) that this command depends on.
	WaitFor              []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor,proto3" json:"wait_for,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Command) Reset()         { *m = Command{} }
func (m *Command) String() string { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()    {}
func (*Command) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{4}
}

func (m *Command) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Command.Unmarshal(m, b)
}
func (m *Command) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Command.Marshal(b, m, deterministic)
}
func (m *Command) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Command.Merge(m, src)
}
func (m *Command) XXX_Size() int {
	return xxx_messageInfo_Command.Size(m)
}
func (m *Command) XXX_DiscardUnknown() {
	xxx_messageInfo_Command.DiscardUnknown(m)
}

var xxx_messageInfo_Command proto.InternalMessageInfo

func (m *Command) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Command) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *Command) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Command) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *Command) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Command) GetWaitFor() []string {
	if m != nil {
		return m.WaitFor
	}
	return nil
}

// Artifact describes a build product.
type Artifact struct {
	// Hash or checksum value of a binary, or Docker Registry 2.0 digest of a
	// container.
	Checksum string `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Artifact ID, if any; for container images, this will be a URL by digest
	// like `gcr.io/projectID/imagename@sha256:123456`.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Related artifact names. This may be the path to a binary or jar file, or in
	// the case of a container build, the name used to push the container image to
	// Google Container Registry, as presented to `docker push`. Note that a
	// single Artifact ID can have multiple names, for example if two tags are
	// applied to one image.
	Names                []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Artifact) Reset()         { *m = Artifact{} }
func (m *Artifact) String() string { return proto.CompactTextString(m) }
func (*Artifact) ProtoMessage()    {}
func (*Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{5}
}

func (m *Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifact.Unmarshal(m, b)
}
func (m *Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifact.Marshal(b, m, deterministic)
}
func (m *Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifact.Merge(m, src)
}
func (m *Artifact) XXX_Size() int {
	return xxx_messageInfo_Artifact.Size(m)
}
func (m *Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_Artifact proto.InternalMessageInfo

func (m *Artifact) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

func (m *Artifact) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Artifact) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

// A SourceContext is a reference to a tree of files. A SourceContext together
// with a path point to a unique revision of a single file or directory.
type SourceContext struct {
	// A SourceContext can refer any one of the following types of repositories.
	//
	// Types that are valid to be assigned to Context:
	//	*SourceContext_CloudRepo
	//	*SourceContext_Gerrit
	//	*SourceContext_Git
	Context isSourceContext_Context `protobuf_oneof:"context"`
	// Labels with user defined metadata.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SourceContext) Reset()         { *m = SourceContext{} }
func (m *SourceContext) String() string { return proto.CompactTextString(m) }
func (*SourceContext) ProtoMessage()    {}
func (*SourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{6}
}

func (m *SourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceContext.Unmarshal(m, b)
}
func (m *SourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceContext.Marshal(b, m, deterministic)
}
func (m *SourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceContext.Merge(m, src)
}
func (m *SourceContext) XXX_Size() int {
	return xxx_messageInfo_SourceContext.Size(m)
}
func (m *SourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_SourceContext proto.InternalMessageInfo

type isSourceContext_Context interface {
	isSourceContext_Context()
}

type SourceContext_CloudRepo struct {
	CloudRepo *CloudRepoSourceContext `protobuf:"bytes,1,opt,name=cloud_repo,json=cloudRepo,proto3,oneof"`
}

type SourceContext_Gerrit struct {
	Gerrit *GerritSourceContext `protobuf:"bytes,2,opt,name=gerrit,proto3,oneof"`
}

type SourceContext_Git struct {
	Git *GitSourceContext `protobuf:"bytes,3,opt,name=git,proto3,oneof"`
}

func (*SourceContext_CloudRepo) isSourceContext_Context() {}

func (*SourceContext_Gerrit) isSourceContext_Context() {}

func (*SourceContext_Git) isSourceContext_Context() {}

func (m *SourceContext) GetContext() isSourceContext_Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *SourceContext) GetCloudRepo() *CloudRepoSourceContext {
	if x, ok := m.GetContext().(*SourceContext_CloudRepo); ok {
		return x.CloudRepo
	}
	return nil
}

func (m *SourceContext) GetGerrit() *GerritSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Gerrit); ok {
		return x.Gerrit
	}
	return nil
}

func (m *SourceContext) GetGit() *GitSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Git); ok {
		return x.Git
	}
	return nil
}

func (m *SourceContext) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SourceContext_CloudRepo)(nil),
		(*SourceContext_Gerrit)(nil),
		(*SourceContext_Git)(nil),
	}
}

// An alias to a repo revision.
type AliasContext struct {
	// The alias kind.
	Kind AliasContext_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=grafeas.v1.AliasContext_Kind" json:"kind,omitempty"`
	// The alias name.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AliasContext) Reset()         { *m = AliasContext{} }
func (m *AliasContext) String() string { return proto.CompactTextString(m) }
func (*AliasContext) ProtoMessage()    {}
func (*AliasContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{7}
}

func (m *AliasContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AliasContext.Unmarshal(m, b)
}
func (m *AliasContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AliasContext.Marshal(b, m, deterministic)
}
func (m *AliasContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AliasContext.Merge(m, src)
}
func (m *AliasContext) XXX_Size() int {
	return xxx_messageInfo_AliasContext.Size(m)
}
func (m *AliasContext) XXX_DiscardUnknown() {
	xxx_messageInfo_AliasContext.DiscardUnknown(m)
}

var xxx_messageInfo_AliasContext proto.InternalMessageInfo

func (m *AliasContext) GetKind() AliasContext_Kind {
	if m != nil {
		return m.Kind
	}
	return AliasContext_KIND_UNSPECIFIED
}

func (m *AliasContext) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A CloudRepoSourceContext denotes a particular revision in a Google Cloud
// Source Repo.
type CloudRepoSourceContext struct {
	// The ID of the repo.
	RepoId *RepoId `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	// A revision in a Cloud Repo can be identified by either its revision ID or
	// its alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*CloudRepoSourceContext_RevisionId
	//	*CloudRepoSourceContext_AliasContext
	Revision             isCloudRepoSourceContext_Revision `protobuf_oneof:"revision"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CloudRepoSourceContext) Reset()         { *m = CloudRepoSourceContext{} }
func (m *CloudRepoSourceContext) String() string { return proto.CompactTextString(m) }
func (*CloudRepoSourceContext) ProtoMessage()    {}
func (*CloudRepoSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{8}
}

func (m *CloudRepoSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudRepoSourceContext.Unmarshal(m, b)
}
func (m *CloudRepoSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudRepoSourceContext.Marshal(b, m, deterministic)
}
func (m *CloudRepoSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudRepoSourceContext.Merge(m, src)
}
func (m *CloudRepoSourceContext) XXX_Size() int {
	return xxx_messageInfo_CloudRepoSourceContext.Size(m)
}
func (m *CloudRepoSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudRepoSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_CloudRepoSourceContext proto.InternalMessageInfo

func (m *CloudRepoSourceContext) GetRepoId() *RepoId {
	if m != nil {
		return m.RepoId
	}
	return nil
}

type isCloudRepoSourceContext_Revision interface {
	isCloudRepoSourceContext_Revision()
}

type CloudRepoSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3,oneof"`
}

type CloudRepoSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,3,opt,name=alias_context,json=aliasContext,proto3,oneof"`
}

func (*CloudRepoSourceContext_RevisionId) isCloudRepoSourceContext_Revision() {}

func (*CloudRepoSourceContext_AliasContext) isCloudRepoSourceContext_Revision() {}

func (m *CloudRepoSourceContext) GetRevision() isCloudRepoSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CloudRepoSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *CloudRepoSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CloudRepoSourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CloudRepoSourceContext_RevisionId)(nil),
		(*CloudRepoSourceContext_AliasContext)(nil),
	}
}

// A SourceContext referring to a Gerrit project.
type GerritSourceContext struct {
	// The URI of a running Gerrit instance.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// The full project name within the host. Projects may be nested, so
	// "project/subproject" is a valid project name. The "repo name" is the
	// hostURI/project.
	GerritProject string `protobuf:"bytes,2,opt,name=gerrit_project,json=gerritProject,proto3" json:"gerrit_project,omitempty"`
	// A revision in a Gerrit project can be identified by either its revision ID
	// or its alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*GerritSourceContext_RevisionId
	//	*GerritSourceContext_AliasContext
	Revision             isGerritSourceContext_Revision `protobuf_oneof:"revision"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GerritSourceContext) Reset()         { *m = GerritSourceContext{} }
func (m *GerritSourceContext) String() string { return proto.CompactTextString(m) }
func (*GerritSourceContext) ProtoMessage()    {}
func (*GerritSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{9}
}

func (m *GerritSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GerritSourceContext.Unmarshal(m, b)
}
func (m *GerritSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GerritSourceContext.Marshal(b, m, deterministic)
}
func (m *GerritSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GerritSourceContext.Merge(m, src)
}
func (m *GerritSourceContext) XXX_Size() int {
	return xxx_messageInfo_GerritSourceContext.Size(m)
}
func (m *GerritSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_GerritSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_GerritSourceContext proto.InternalMessageInfo

func (m *GerritSourceContext) GetHostUri() string {
	if m != nil {
		return m.HostUri
	}
	return ""
}

func (m *GerritSourceContext) GetGerritProject() string {
	if m != nil {
		return m.GerritProject
	}
	return ""
}

type isGerritSourceContext_Revision interface {
	isGerritSourceContext_Revision()
}

type GerritSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3,oneof"`
}

type GerritSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,4,opt,name=alias_context,json=aliasContext,proto3,oneof"`
}

func (*GerritSourceContext_RevisionId) isGerritSourceContext_Revision() {}

func (*GerritSourceContext_AliasContext) isGerritSourceContext_Revision() {}

func (m *GerritSourceContext) GetRevision() isGerritSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GerritSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*GerritSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *GerritSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*GerritSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GerritSourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GerritSourceContext_RevisionId)(nil),
		(*GerritSourceContext_AliasContext)(nil),
	}
}

// A GitSourceContext denotes a particular revision in a third party Git
// repository (e.g., GitHub).
type GitSourceContext struct {
	// Git repository URL.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Git commit hash.
	RevisionId           string   `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GitSourceContext) Reset()         { *m = GitSourceContext{} }
func (m *GitSourceContext) String() string { return proto.CompactTextString(m) }
func (*GitSourceContext) ProtoMessage()    {}
func (*GitSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{10}
}

func (m *GitSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GitSourceContext.Unmarshal(m, b)
}
func (m *GitSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GitSourceContext.Marshal(b, m, deterministic)
}
func (m *GitSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitSourceContext.Merge(m, src)
}
func (m *GitSourceContext) XXX_Size() int {
	return xxx_messageInfo_GitSourceContext.Size(m)
}
func (m *GitSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_GitSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_GitSourceContext proto.InternalMessageInfo

func (m *GitSourceContext) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *GitSourceContext) GetRevisionId() string {
	if m != nil {
		return m.RevisionId
	}
	return ""
}

// A unique identifier for a Cloud Repo.
type RepoId struct {
	// A cloud repo can be identified by either its project ID and repository name
	// combination, or its globally unique identifier.
	//
	// Types that are valid to be assigned to Id:
	//	*RepoId_ProjectRepoId
	//	*RepoId_Uid
	Id                   isRepoId_Id `protobuf_oneof:"id"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RepoId) Reset()         { *m = RepoId{} }
func (m *RepoId) String() string { return proto.CompactTextString(m) }
func (*RepoId) ProtoMessage()    {}
func (*RepoId) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{11}
}

func (m *RepoId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RepoId.Unmarshal(m, b)
}
func (m *RepoId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RepoId.Marshal(b, m, deterministic)
}
func (m *RepoId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepoId.Merge(m, src)
}
func (m *RepoId) XXX_Size() int {
	return xxx_messageInfo_RepoId.Size(m)
}
func (m *RepoId) XXX_DiscardUnknown() {
	xxx_messageInfo_RepoId.DiscardUnknown(m)
}

var xxx_messageInfo_RepoId proto.InternalMessageInfo

type isRepoId_Id interface {
	isRepoId_Id()
}

type RepoId_ProjectRepoId struct {
	ProjectRepoId *ProjectRepoId `protobuf:"bytes,1,opt,name=project_repo_id,json=projectRepoId,proto3,oneof"`
}

type RepoId_Uid struct {
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3,oneof"`
}

func (*RepoId_ProjectRepoId) isRepoId_Id() {}

func (*RepoId_Uid) isRepoId_Id() {}

func (m *RepoId) GetId() isRepoId_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *RepoId) GetProjectRepoId() *ProjectRepoId {
	if x, ok := m.GetId().(*RepoId_ProjectRepoId); ok {
		return x.ProjectRepoId
	}
	return nil
}

func (m *RepoId) GetUid() string {
	if x, ok := m.GetId().(*RepoId_Uid); ok {
		return x.Uid
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RepoId) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RepoId_ProjectRepoId)(nil),
		(*RepoId_Uid)(nil),
	}
}

// Selects a repo using a Google Cloud Platform project ID (e.g.,
// winged-cargo-31) and a repo name within that project.
type ProjectRepoId struct {
	// The ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The name of the repo. Leave empty for the default repo.
	RepoName             string   `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProjectRepoId) Reset()         { *m = ProjectRepoId{} }
func (m *ProjectRepoId) String() string { return proto.CompactTextString(m) }
func (*ProjectRepoId) ProtoMessage()    {}
func (*ProjectRepoId) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{12}
}

func (m *ProjectRepoId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProjectRepoId.Unmarshal(m, b)
}
func (m *ProjectRepoId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProjectRepoId.Marshal(b, m, deterministic)
}
func (m *ProjectRepoId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectRepoId.Merge(m, src)
}
func (m *ProjectRepoId) XXX_Size() int {
	return xxx_messageInfo_ProjectRepoId.Size(m)
}
func (m *ProjectRepoId) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectRepoId.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectRepoId proto.InternalMessageInfo

func (m *ProjectRepoId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ProjectRepoId) GetRepoName() string {
	if m != nil {
		return m.RepoName
	}
	return ""
}

func init() {
	proto.RegisterEnum("grafeas.v1.AliasContext_Kind", AliasContext_Kind_name, AliasContext_Kind_value)
	proto.RegisterType((*BuildProvenance)(nil), "grafeas.v1.BuildProvenance")
	proto.RegisterMapType((map[string]string)(nil), "grafeas.v1.BuildProvenance.BuildOptionsEntry")
	proto.RegisterType((*Source)(nil), "grafeas.v1.Source")
	proto.RegisterMapType((map[string]*FileHashes)(nil), "grafeas.v1.Source.FileHashesEntry")
	proto.RegisterType((*FileHashes)(nil), "grafeas.v1.FileHashes")
	proto.RegisterType((*Hash)(nil), "grafeas.v1.Hash")
	proto.RegisterType((*Command)(nil), "grafeas.v1.Command")
	proto.RegisterType((*Artifact)(nil), "grafeas.v1.Artifact")
	proto.RegisterType((*SourceContext)(nil), "grafeas.v1.SourceContext")
	proto.RegisterMapType((map[string]string)(nil), "grafeas.v1.SourceContext.LabelsEntry")
	proto.RegisterType((*AliasContext)(nil), "grafeas.v1.AliasContext")
	proto.RegisterType((*CloudRepoSourceContext)(nil), "grafeas.v1.CloudRepoSourceContext")
	proto.RegisterType((*GerritSourceContext)(nil), "grafeas.v1.GerritSourceContext")
	proto.RegisterType((*GitSourceContext)(nil), "grafeas.v1.GitSourceContext")
	proto.RegisterType((*RepoId)(nil), "grafeas.v1.RepoId")
	proto.RegisterType((*ProjectRepoId)(nil), "grafeas.v1.ProjectRepoId")
}

func init() { proto.RegisterFile("grafeas/v1/provenance.proto", fileDescriptor_f3e893c2155395b5) }

var fileDescriptor_f3e893c2155395b5 = []byte{
	// 1135 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x4e, 0xe3, 0x46,
	0x14, 0xc6, 0xf9, 0xcf, 0x09, 0x81, 0xec, 0x2c, 0x5a, 0x79, 0x43, 0x11, 0xd4, 0xd2, 0xaa, 0x48,
	0xed, 0x26, 0x0b, 0xab, 0x4a, 0x4b, 0x11, 0x42, 0x24, 0x84, 0x4d, 0x0a, 0x05, 0x6a, 0x96, 0x55,
	0xd5, 0x1b, 0x6b, 0x88, 0x27, 0x66, 0x8a, 0xe3, 0x89, 0xc6, 0x76, 0x5a, 0xee, 0xfa, 0x14, 0x7d,
	0x80, 0x3e, 0x42, 0xa5, 0xbe, 0x42, 0xfb, 0x22, 0x7d, 0x90, 0x6a, 0x7e, 0xec, 0x38, 0x81, 0xed,
	0xb6, 0xea, 0x95, 0xe7, 0x9c, 0xf3, 0x7d, 0xc7, 0xe7, 0xcf, 0xc7, 0x03, 0xeb, 0x1e, 0xc7, 0x23,
	0x82, 0xc3, 0xf6, 0x74, 0xa7, 0x3d, 0xe1, 0x6c, 0x4a, 0x02, 0x1c, 0x0c, 0x49, 0x6b, 0xc2, 0x59,
	0xc4, 0x10, 0x68, 0x63, 0x6b, 0xba, 0xd3, 0xdc, 0xf4, 0x18, 0xf3, 0x7c, 0xd2, 0x96, 0x96, 0x9b,
	0x78, 0xd4, 0x8e, 0xe8, 0x98, 0x84, 0x11, 0x1e, 0x4f, 0x14, 0xd8, 0xfa, 0xad, 0x08, 0xab, 0x9d,
	0x98, 0xfa, 0xee, 0x65, 0xea, 0x06, 0xad, 0x40, 0x8e, 0xba, 0xa6, 0xb1, 0x65, 0x6c, 0x57, 0xed,
	0x1c, 0x75, 0xd1, 0x06, 0xc0, 0x84, 0xb3, 0x1f, 0xc8, 0x30, 0x72, 0xa8, 0x6b, 0xe6, 0xa4, 0xbe,
	0xaa, 0x35, 0x03, 0x17, 0xb5, 0xa1, 0x32, 0x64, 0xe3, 0x31, 0x0e, 0xdc, 0xd0, 0xcc, 0x6f, 0xe5,
	0xb7, 0x6b, 0xbb, 0x4f, 0x5b, 0xb3, 0x10, 0x5a, 0x5d, 0x65, 0xb3, 0x53, 0x10, 0x3a, 0x80, 0xd5,
	0x9b, 0x98, 0xfa, 0x91, 0x83, 0x79, 0x44, 0x47, 0x78, 0x18, 0x85, 0x66, 0x41, 0xf2, 0xd6, 0xb2,
	0xbc, 0x23, 0x6d, 0xb4, 0x57, 0x24, 0x38, 0x11, 0x43, 0xb4, 0x0f, 0xb5, 0x21, 0x27, 0x38, 0x22,
	0x8e, 0x48, 0xc6, 0x2c, 0x6e, 0x19, 0xdb, 0xb5, 0xdd, 0x66, 0x4b, 0x65, 0xda, 0x4a, 0x32, 0x6d,
	0xbd, 0x4b, 0x32, 0xb5, 0x41, 0xc1, 0x85, 0x02, 0xed, 0x01, 0x84, 0x11, 0xe6, 0x91, 0xe2, 0x96,
	0x3e, 0xca, 0xad, 0x4a, 0xb4, 0xa4, 0x7e, 0x09, 0x15, 0x12, 0xb8, 0x8a, 0x58, 0xfe, 0x28, 0xb1,
	0x4c, 0x02, 0x57, 0xd2, 0x4c, 0x28, 0xcb, 0xf7, 0x33, 0x6e, 0x56, 0x64, 0xe9, 0x12, 0x11, 0x3d,
	0x87, 0x8a, 0xcf, 0xbc, 0xd0, 0x89, 0x39, 0x35, 0xab, 0xca, 0x24, 0xe4, 0x6b, 0x4e, 0xd1, 0x21,
	0x3c, 0x09, 0x59, 0xcc, 0x87, 0xc4, 0x99, 0xb5, 0xd7, 0x04, 0xf9, 0x52, 0x94, 0x2d, 0xd2, 0x95,
	0x04, 0xd9, 0x0d, 0x05, 0xce, 0xf4, 0x70, 0x03, 0x20, 0xe2, 0xd4, 0xf3, 0x08, 0x17, 0x3d, 0xab,
	0xa9, 0x9e, 0x69, 0xcd, 0xc0, 0x45, 0x36, 0xd4, 0x45, 0x55, 0x5d, 0x87, 0x4d, 0x22, 0xca, 0x82,
	0xd0, 0x5c, 0x96, 0x0d, 0x78, 0x99, 0xf5, 0xbd, 0x30, 0x16, 0x4a, 0xbe, 0x50, 0xf8, 0x5e, 0x10,
	0xf1, 0x7b, 0x7b, 0xf9, 0x26, 0xa3, 0x42, 0x9f, 0xa9, 0xb6, 0xba, 0x84, 0x3b, 0x53, 0xc2, 0x43,
	0xca, 0x02, 0xb3, 0x2e, 0xdf, 0xbb, 0xa2, 0xd5, 0xef, 0x95, 0xb6, 0x79, 0x08, 0x4f, 0x1e, 0xf8,
	0x42, 0x0d, 0xc8, 0xdf, 0x91, 0x7b, 0x3d, 0x75, 0xe2, 0x88, 0xd6, 0xa0, 0x38, 0xc5, 0x7e, 0x4c,
	0xf4, 0xc4, 0x29, 0xe1, 0xab, 0xdc, 0x1b, 0xc3, 0xfa, 0x2b, 0x07, 0x25, 0x95, 0x39, 0x3a, 0x80,
	0xf5, 0x64, 0x8a, 0x9c, 0x30, 0x62, 0x1c, 0x7b, 0xc4, 0xd1, 0x95, 0x13, 0x65, 0x55, 0xee, 0xcc,
	0x04, 0x72, 0xa5, 0x10, 0x8a, 0x2b, 0xea, 0xdc, 0x85, 0xda, 0x88, 0xfa, 0xc4, 0xb9, 0xc5, 0xe1,
	0x2d, 0x09, 0xcd, 0x9c, 0xac, 0x82, 0xf5, 0xb0, 0xc2, 0xad, 0x13, 0xea, 0x93, 0xbe, 0x04, 0xa9,
	0xd4, 0x61, 0x94, 0x2a, 0xd0, 0x6b, 0x28, 0x0f, 0x59, 0x10, 0x91, 0x9f, 0x22, 0x33, 0x2f, 0x5b,
	0xf4, 0xfc, 0xa1, 0x83, 0xae, 0x02, 0xd8, 0x09, 0x12, 0x7d, 0x0d, 0x4f, 0xb1, 0xeb, 0x52, 0x51,
	0x01, 0xec, 0x3b, 0x5a, 0x9b, 0x7c, 0x08, 0xff, 0xe0, 0x00, 0xcd, 0x58, 0x5a, 0x15, 0x36, 0xaf,
	0x61, 0x75, 0x21, 0xbe, 0x47, 0xca, 0xf9, 0x45, 0xb6, 0x9c, 0xb5, 0xdd, 0x67, 0xd9, 0x57, 0xcc,
	0xd8, 0xd9, 0x32, 0xef, 0x03, 0xcc, 0x0c, 0xe8, 0x25, 0x54, 0xd3, 0x52, 0x99, 0x86, 0x0c, 0xb3,
	0x91, 0xf5, 0x21, 0x60, 0x76, 0x25, 0x29, 0x8b, 0xf5, 0x0a, 0x0a, 0xe2, 0x89, 0x10, 0x14, 0xa2,
	0xfb, 0x09, 0xd1, 0x91, 0xc8, 0xf3, 0x7c, 0x67, 0x97, 0xf5, 0x2b, 0xad, 0x9f, 0x0d, 0x28, 0xeb,
	0x65, 0x21, 0x58, 0x01, 0x1e, 0xa7, 0x2c, 0x71, 0x16, 0x29, 0x91, 0x60, 0x2a, 0x7b, 0x54, 0xb5,
	0xc5, 0x51, 0xa0, 0x30, 0xf7, 0xd4, 0xd6, 0xa9, 0xda, 0xf2, 0x2c, 0x50, 0x2e, 0xe5, 0x66, 0x41,
	0x25, 0xee, 0x52, 0xae, 0xd7, 0x59, 0x31, 0x5d, 0x67, 0xcf, 0xa1, 0xf2, 0x23, 0xa6, 0x91, 0x33,
	0x62, 0xdc, 0x2c, 0x49, 0x66, 0x59, 0xc8, 0x27, 0x8c, 0x5b, 0x67, 0x50, 0x49, 0xf6, 0x0c, 0x6a,
	0x42, 0x65, 0x78, 0x4b, 0x86, 0x77, 0x61, 0x3c, 0xd6, 0x61, 0xa4, 0xb2, 0x76, 0x99, 0x4b, 0x5d,
	0xae, 0x41, 0x51, 0x84, 0x98, 0x44, 0xa2, 0x04, 0xeb, 0x8f, 0x1c, 0xd4, 0xe7, 0x9a, 0x87, 0xba,
	0x00, 0x43, 0x9f, 0xc5, 0xae, 0xc3, 0xc9, 0x84, 0x49, 0xaf, 0x0b, 0xd3, 0xd6, 0x15, 0x56, 0x9b,
	0x4c, 0xd8, 0x1c, 0xaf, 0xbf, 0x64, 0x57, 0x87, 0x89, 0x05, 0xed, 0x41, 0xc9, 0x23, 0x9c, 0xd3,
	0x48, 0x77, 0x72, 0x33, 0xeb, 0xe0, 0xad, 0xb4, 0x2c, 0xb2, 0x35, 0x01, 0xbd, 0x82, 0xbc, 0x47,
	0x93, 0x29, 0xfd, 0x64, 0x8e, 0xf7, 0x90, 0x24, 0xa0, 0xe8, 0x00, 0x4a, 0x3e, 0xbe, 0x21, 0x7e,
	0x32, 0x99, 0x2f, 0x3e, 0x38, 0x99, 0xad, 0x33, 0x89, 0x53, 0x9f, 0x87, 0x26, 0x35, 0xf7, 0xa0,
	0x96, 0x51, 0xff, 0x97, 0x8f, 0xbc, 0x53, 0x4d, 0xbf, 0x2a, 0xeb, 0x17, 0x03, 0x96, 0x8f, 0x7c,
	0x8a, 0xc3, 0xa4, 0x8e, 0x3b, 0x50, 0xb8, 0xa3, 0x81, 0xfa, 0x47, 0xad, 0xec, 0x6e, 0xcc, 0xfd,
	0x36, 0x32, 0xb8, 0xd6, 0x29, 0x0d, 0x5c, 0x5b, 0x42, 0xd3, 0x89, 0xca, 0xcd, 0x26, 0xca, 0x3a,
	0x84, 0x82, 0x40, 0xa0, 0x35, 0x68, 0x9c, 0x0e, 0xce, 0x8f, 0x9d, 0xeb, 0xf3, 0xab, 0xcb, 0x5e,
	0x77, 0x70, 0x32, 0xe8, 0x1d, 0x37, 0x96, 0x50, 0x15, 0x8a, 0x27, 0x83, 0xef, 0x7a, 0xc7, 0x0d,
	0x03, 0xd5, 0xa0, 0xfc, 0xcd, 0xc5, 0xfb, 0xa3, 0xce, 0x59, 0xaf, 0x91, 0x13, 0xfa, 0x8b, 0x77,
	0xfd, 0x9e, 0xdd, 0x28, 0x58, 0xbf, 0x1b, 0xf0, 0xec, 0xf1, 0x96, 0xa1, 0xcf, 0xa1, 0x2c, 0x9a,
	0xec, 0xe8, 0x3f, 0xe9, 0xc2, 0xde, 0x16, 0xf8, 0x81, 0x6b, 0x97, 0xb8, 0x7c, 0xa2, 0x4f, 0xa1,
	0xc6, 0xc9, 0x94, 0x8a, 0xed, 0x98, 0xfe, 0x62, 0xfb, 0x4b, 0x36, 0x24, 0xca, 0x81, 0x8b, 0x0e,
	0xa1, 0x8e, 0x45, 0x6a, 0xce, 0xfc, 0xaa, 0x31, 0x3f, 0x94, 0x7b, 0x7f, 0xc9, 0x5e, 0xc6, 0x19,
	0xb9, 0x03, 0x50, 0x49, 0xdc, 0x59, 0x7f, 0x1a, 0xf0, 0xf4, 0x91, 0x49, 0x11, 0x9f, 0xc6, 0x2d,
	0x0b, 0xa3, 0xcc, 0xea, 0x2c, 0x0b, 0x59, 0x6c, 0xca, 0x17, 0xb0, 0xa2, 0x86, 0xc8, 0xd1, 0x7f,
	0x7e, 0x5d, 0xc9, 0xba, 0xd2, 0x5e, 0x2a, 0xe5, 0x62, 0x26, 0xf9, 0x7f, 0x93, 0x49, 0xe1, 0x7f,
	0x64, 0xd2, 0x83, 0xc6, 0xe2, 0xe8, 0x8a, 0x29, 0x8b, 0xb9, 0x9f, 0x4c, 0x59, 0xcc, 0x7d, 0xb4,
	0xf9, 0x48, 0x7d, 0xb3, 0x31, 0x59, 0x1e, 0x94, 0x54, 0x4b, 0x50, 0x17, 0x56, 0x93, 0xcb, 0xce,
	0x7c, 0xff, 0xe6, 0x76, 0xb2, 0x4e, 0x57, 0x71, 0xfa, 0x4b, 0x76, 0x7d, 0x92, 0x55, 0x20, 0x04,
	0xf9, 0x38, 0xd3, 0x47, 0x21, 0x74, 0x0a, 0x62, 0x67, 0x58, 0xa7, 0x50, 0x9f, 0xe3, 0x2e, 0x5c,
	0xae, 0x8c, 0xc5, 0xcb, 0xd5, 0x3a, 0x54, 0x65, 0x18, 0x99, 0xd9, 0xad, 0x08, 0xc5, 0x39, 0x1e,
	0x93, 0xce, 0xb7, 0x50, 0xa7, 0x2c, 0x13, 0xd6, 0xa5, 0xf1, 0xfd, 0x1b, 0x7d, 0x23, 0xf1, 0x98,
	0x8f, 0x03, 0xaf, 0xc5, 0xb8, 0xd7, 0xf6, 0x48, 0x20, 0xef, 0x27, 0x6d, 0x65, 0xc2, 0x13, 0x1a,
	0xb6, 0x67, 0xf7, 0xc7, 0x7d, 0x7d, 0xfc, 0x35, 0x97, 0x7f, 0x6b, 0x1f, 0xdd, 0x94, 0x24, 0xf4,
	0xf5, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x6c, 0x9f, 0x7c, 0xce, 0x62, 0x0a, 0x00, 0x00,
}
