// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/devtools/resultstore/v2/resultstore_download.proto

package resultstore

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request passed into GetInvocation
type GetInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}
	// where INVOCATION_ID must be an RFC 4122-compliant random UUID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInvocationRequest) Reset() {
	*x = GetInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInvocationRequest) ProtoMessage() {}

func (x *GetInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInvocationRequest.ProtoReflect.Descriptor instead.
func (*GetInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{0}
}

func (x *GetInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into SearchInvocations
type SearchInvocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return. Zero means all, but may be capped by
	// the server.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*SearchInvocationsRequest_PageToken
	//	*SearchInvocationsRequest_Offset
	PageStart isSearchInvocationsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filtering query string.
	//
	// Only a limited number of fields and operators are supported. Not every
	// field supports every operator.
	//
	// Fields that support equals ("=") restrictions:
	//
	// name
	// status_attributes.status
	// workspace_info.hostname
	//
	// Fields that support contains (":") restrictions:
	//
	// invocation_attributes.users
	// invocation_attributes.labels
	//
	// Fields that support comparison ("<", "<=", ">", ">=") restrictions;
	//
	// timing.start_time
	//
	// Supported custom function global restrictions:
	//
	// propertyEquals("key", "value")
	Query string `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	// The project id to search under.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If true, all equals or contains restrictions on string fields in query will
	// require exact match. Otherwise, a string field restriction may ignore case
	// and punctuation.
	ExactMatch bool `protobuf:"varint,7,opt,name=exact_match,json=exactMatch,proto3" json:"exact_match,omitempty"`
}

func (x *SearchInvocationsRequest) Reset() {
	*x = SearchInvocationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchInvocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchInvocationsRequest) ProtoMessage() {}

func (x *SearchInvocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchInvocationsRequest.ProtoReflect.Descriptor instead.
func (*SearchInvocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{1}
}

func (x *SearchInvocationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *SearchInvocationsRequest) GetPageStart() isSearchInvocationsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *SearchInvocationsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*SearchInvocationsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *SearchInvocationsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*SearchInvocationsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *SearchInvocationsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchInvocationsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SearchInvocationsRequest) GetExactMatch() bool {
	if x != nil {
		return x.ExactMatch
	}
	return false
}

type isSearchInvocationsRequest_PageStart interface {
	isSearchInvocationsRequest_PageStart()
}

type SearchInvocationsRequest_PageToken struct {
	// The next_page_token value returned from a previous Search request, if
	// any.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type SearchInvocationsRequest_Offset struct {
	// Absolute number of results to skip. May be rejected if too high.
	Offset int64 `protobuf:"varint,3,opt,name=offset,proto3,oneof"`
}

func (*SearchInvocationsRequest_PageToken) isSearchInvocationsRequest_PageStart() {}

func (*SearchInvocationsRequest_Offset) isSearchInvocationsRequest_PageStart() {}

// Response from calling SearchInvocations
type SearchInvocationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Invocations matching the search, possibly capped at request.page_size or a
	// server limit.
	Invocations []*Invocation `protobuf:"bytes,1,rep,name=invocations,proto3" json:"invocations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchInvocationsResponse) Reset() {
	*x = SearchInvocationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchInvocationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchInvocationsResponse) ProtoMessage() {}

func (x *SearchInvocationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchInvocationsResponse.ProtoReflect.Descriptor instead.
func (*SearchInvocationsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{2}
}

func (x *SearchInvocationsResponse) GetInvocations() []*Invocation {
	if x != nil {
		return x.Invocations
	}
	return nil
}

func (x *SearchInvocationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into GetInvocationDownloadMetadata
type GetInvocationDownloadMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the download metadata to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/downloadMetadata
	// where INVOCATION_ID must be an RFC 4122-compliant random UUID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInvocationDownloadMetadataRequest) Reset() {
	*x = GetInvocationDownloadMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInvocationDownloadMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInvocationDownloadMetadataRequest) ProtoMessage() {}

func (x *GetInvocationDownloadMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInvocationDownloadMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetInvocationDownloadMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{3}
}

func (x *GetInvocationDownloadMetadataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into GetConfiguration
type GetConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the configuration to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/configs/${url_encode(CONFIGURATION_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfigurationRequest) Reset() {
	*x = GetConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfigurationRequest) ProtoMessage() {}

func (x *GetConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfigurationRequest.ProtoReflect.Descriptor instead.
func (*GetConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{4}
}

func (x *GetConfigurationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into ListConfigurations
type ListConfigurationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The invocation name of the configurations to retrieve.
	// It must match this format: invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*ListConfigurationsRequest_PageToken
	//	*ListConfigurationsRequest_Offset
	PageStart isListConfigurationsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filter to return only resources that match it.
	// Any fields used in the filter must be also specified in the field mask.
	// May cause pages with 0 results and a next_page_token to be returned.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListConfigurationsRequest) Reset() {
	*x = ListConfigurationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfigurationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfigurationsRequest) ProtoMessage() {}

func (x *ListConfigurationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfigurationsRequest.ProtoReflect.Descriptor instead.
func (*ListConfigurationsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{5}
}

func (x *ListConfigurationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConfigurationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *ListConfigurationsRequest) GetPageStart() isListConfigurationsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *ListConfigurationsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*ListConfigurationsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *ListConfigurationsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*ListConfigurationsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *ListConfigurationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isListConfigurationsRequest_PageStart interface {
	isListConfigurationsRequest_PageStart()
}

type ListConfigurationsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type ListConfigurationsRequest_Offset struct {
	// Absolute number of results to skip.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*ListConfigurationsRequest_PageToken) isListConfigurationsRequest_PageStart() {}

func (*ListConfigurationsRequest_Offset) isListConfigurationsRequest_PageStart() {}

// Response from calling ListConfigurations
type ListConfigurationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configurations matching the request invocation,
	// possibly capped at request.page_size or a server limit.
	Configurations []*Configuration `protobuf:"bytes,1,rep,name=configurations,proto3" json:"configurations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConfigurationsResponse) Reset() {
	*x = ListConfigurationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfigurationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfigurationsResponse) ProtoMessage() {}

func (x *ListConfigurationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfigurationsResponse.ProtoReflect.Descriptor instead.
func (*ListConfigurationsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{6}
}

func (x *ListConfigurationsResponse) GetConfigurations() []*Configuration {
	if x != nil {
		return x.Configurations
	}
	return nil
}

func (x *ListConfigurationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into GetTarget
type GetTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the target to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetRequest) Reset() {
	*x = GetTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetRequest) ProtoMessage() {}

func (x *GetTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetRequest.ProtoReflect.Descriptor instead.
func (*GetTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{7}
}

func (x *GetTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into ListTargets
type ListTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The invocation name of the targets to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*ListTargetsRequest_PageToken
	//	*ListTargetsRequest_Offset
	PageStart isListTargetsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filter to return only resources that match it.
	// Any fields used in the filter must be also specified in the field mask.
	// May cause pages with 0 results and a next_page_token to be returned.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListTargetsRequest) Reset() {
	*x = ListTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsRequest) ProtoMessage() {}

func (x *ListTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{8}
}

func (x *ListTargetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *ListTargetsRequest) GetPageStart() isListTargetsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *ListTargetsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*ListTargetsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *ListTargetsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*ListTargetsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *ListTargetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isListTargetsRequest_PageStart interface {
	isListTargetsRequest_PageStart()
}

type ListTargetsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type ListTargetsRequest_Offset struct {
	// Absolute number of results to skip.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*ListTargetsRequest_PageToken) isListTargetsRequest_PageStart() {}

func (*ListTargetsRequest_Offset) isListTargetsRequest_PageStart() {}

// Response from calling ListTargetsResponse
type ListTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Targets matching the request invocation,
	// possibly capped at request.page_size or a server limit.
	Targets []*Target `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTargetsResponse) Reset() {
	*x = ListTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsResponse) ProtoMessage() {}

func (x *ListTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{9}
}

func (x *ListTargetsResponse) GetTargets() []*Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *ListTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into GetConfiguredTarget
type GetConfiguredTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the configured target to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIGURATION_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfiguredTargetRequest) Reset() {
	*x = GetConfiguredTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConfiguredTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfiguredTargetRequest) ProtoMessage() {}

func (x *GetConfiguredTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfiguredTargetRequest.ProtoReflect.Descriptor instead.
func (*GetConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{10}
}

func (x *GetConfiguredTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into ListConfiguredTargets
type ListConfiguredTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The invocation and target name of the configured targets to retrieve.
	// It must match this format:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	// Supports '-' for ${TARGET_ID} meaning all targets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*ListConfiguredTargetsRequest_PageToken
	//	*ListConfiguredTargetsRequest_Offset
	PageStart isListConfiguredTargetsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filter to return only resources that match it.
	// Any fields used in the filter must be also specified in the field mask.
	// May cause pages with 0 results and a next_page_token to be returned.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListConfiguredTargetsRequest) Reset() {
	*x = ListConfiguredTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfiguredTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfiguredTargetsRequest) ProtoMessage() {}

func (x *ListConfiguredTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfiguredTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListConfiguredTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{11}
}

func (x *ListConfiguredTargetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConfiguredTargetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *ListConfiguredTargetsRequest) GetPageStart() isListConfiguredTargetsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *ListConfiguredTargetsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*ListConfiguredTargetsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *ListConfiguredTargetsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*ListConfiguredTargetsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *ListConfiguredTargetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isListConfiguredTargetsRequest_PageStart interface {
	isListConfiguredTargetsRequest_PageStart()
}

type ListConfiguredTargetsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type ListConfiguredTargetsRequest_Offset struct {
	// Absolute number of results to skip.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*ListConfiguredTargetsRequest_PageToken) isListConfiguredTargetsRequest_PageStart() {}

func (*ListConfiguredTargetsRequest_Offset) isListConfiguredTargetsRequest_PageStart() {}

// Response from calling ListConfiguredTargets
type ListConfiguredTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ConfiguredTargets matching the request,
	// possibly capped at request.page_size or a server limit.
	ConfiguredTargets []*ConfiguredTarget `protobuf:"bytes,1,rep,name=configured_targets,json=configuredTargets,proto3" json:"configured_targets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConfiguredTargetsResponse) Reset() {
	*x = ListConfiguredTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfiguredTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfiguredTargetsResponse) ProtoMessage() {}

func (x *ListConfiguredTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfiguredTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListConfiguredTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{12}
}

func (x *ListConfiguredTargetsResponse) GetConfiguredTargets() []*ConfiguredTarget {
	if x != nil {
		return x.ConfiguredTargets
	}
	return nil
}

func (x *ListConfiguredTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into GetAction
type GetActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the action to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIGURATION_ID)}/actions/${url_encode(ACTION_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetActionRequest) Reset() {
	*x = GetActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetActionRequest) ProtoMessage() {}

func (x *GetActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetActionRequest.ProtoReflect.Descriptor instead.
func (*GetActionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{13}
}

func (x *GetActionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into ListActions
type ListActionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The invocation, target, and configuration name of the action to retrieve.
	// It must match this format:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIGURATION_ID)}
	// Supports '-' for ${CONFIGURATION_ID} to mean all Actions for all
	// Configurations for a Target, or '-' for ${TARGET_ID} and
	// ${CONFIGURATION_ID} to mean all Actions for all Configurations and all
	// Targets. Does not support ${TARGET_ID} '-' with a specified configuration.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*ListActionsRequest_PageToken
	//	*ListActionsRequest_Offset
	PageStart isListActionsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filter to return only resources that match it.
	// Any fields used in the filter must be also specified in the field mask.
	// May cause pages with 0 results and a next_page_token to be returned.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListActionsRequest) Reset() {
	*x = ListActionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListActionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListActionsRequest) ProtoMessage() {}

func (x *ListActionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListActionsRequest.ProtoReflect.Descriptor instead.
func (*ListActionsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{14}
}

func (x *ListActionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListActionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *ListActionsRequest) GetPageStart() isListActionsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *ListActionsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*ListActionsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *ListActionsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*ListActionsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *ListActionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isListActionsRequest_PageStart interface {
	isListActionsRequest_PageStart()
}

type ListActionsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type ListActionsRequest_Offset struct {
	// Absolute number of results to skip.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*ListActionsRequest_PageToken) isListActionsRequest_PageStart() {}

func (*ListActionsRequest_Offset) isListActionsRequest_PageStart() {}

// Response from calling ListActions
type ListActionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Actions matching the request,
	// possibly capped at request.page_size or a server limit.
	Actions []*Action `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListActionsResponse) Reset() {
	*x = ListActionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListActionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListActionsResponse) ProtoMessage() {}

func (x *ListActionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListActionsResponse.ProtoReflect.Descriptor instead.
func (*ListActionsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{15}
}

func (x *ListActionsResponse) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *ListActionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into GetFileSet
type GetFileSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the file set to retrieve. It must match this format:
	// invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFileSetRequest) Reset() {
	*x = GetFileSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFileSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileSetRequest) ProtoMessage() {}

func (x *GetFileSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFileSetRequest.ProtoReflect.Descriptor instead.
func (*GetFileSetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{16}
}

func (x *GetFileSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into ListFileSets
type ListFileSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The invocation name of the file sets to retrieve.
	// It must match this format: invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*ListFileSetsRequest_PageToken
	//	*ListFileSetsRequest_Offset
	PageStart isListFileSetsRequest_PageStart `protobuf_oneof:"page_start"`
	// A filter to return only resources that match it.
	// Any fields used in the filter must be also specified in the field mask.
	// May cause pages with 0 results and a next_page_token to be returned.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListFileSetsRequest) Reset() {
	*x = ListFileSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFileSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFileSetsRequest) ProtoMessage() {}

func (x *ListFileSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFileSetsRequest.ProtoReflect.Descriptor instead.
func (*ListFileSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{17}
}

func (x *ListFileSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFileSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *ListFileSetsRequest) GetPageStart() isListFileSetsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *ListFileSetsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*ListFileSetsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *ListFileSetsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*ListFileSetsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *ListFileSetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isListFileSetsRequest_PageStart interface {
	isListFileSetsRequest_PageStart()
}

type ListFileSetsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type ListFileSetsRequest_Offset struct {
	// Absolute number of results to skip.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*ListFileSetsRequest_PageToken) isListFileSetsRequest_PageStart() {}

func (*ListFileSetsRequest_Offset) isListFileSetsRequest_PageStart() {}

// Response from calling ListFileSets
type ListFileSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File sets matching the request,
	// possibly capped at request.page_size or a server limit.
	FileSets []*FileSet `protobuf:"bytes,1,rep,name=file_sets,json=fileSets,proto3" json:"file_sets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFileSetsResponse) Reset() {
	*x = ListFileSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFileSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFileSetsResponse) ProtoMessage() {}

func (x *ListFileSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFileSetsResponse.ProtoReflect.Descriptor instead.
func (*ListFileSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{18}
}

func (x *ListFileSetsResponse) GetFileSets() []*FileSet {
	if x != nil {
		return x.FileSets
	}
	return nil
}

func (x *ListFileSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed into TraverseFileSets
type TraverseFileSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the resource to traverse.
	// It must match one of the following formats:
	//
	// invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	// This returns the transitive closure of FileSets referenced by the given
	// FileSet, including itself.
	//
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIGURATION_ID)}/actions/${url_encode(ACTION_ID)}
	// This returns the transitive closure of FileSets referenced by the given
	// Action. If ${ACTION_ID} is "-", this returns the transitive closure of
	// FileSets referenced by all Actions under the given ConfiguredTarget.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of items to return.
	// Zero means all, but may be capped by the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Options for pagination.
	//
	// Types that are assignable to PageStart:
	//	*TraverseFileSetsRequest_PageToken
	//	*TraverseFileSetsRequest_Offset
	PageStart isTraverseFileSetsRequest_PageStart `protobuf_oneof:"page_start"`
}

func (x *TraverseFileSetsRequest) Reset() {
	*x = TraverseFileSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TraverseFileSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TraverseFileSetsRequest) ProtoMessage() {}

func (x *TraverseFileSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TraverseFileSetsRequest.ProtoReflect.Descriptor instead.
func (*TraverseFileSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{19}
}

func (x *TraverseFileSetsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TraverseFileSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (m *TraverseFileSetsRequest) GetPageStart() isTraverseFileSetsRequest_PageStart {
	if m != nil {
		return m.PageStart
	}
	return nil
}

func (x *TraverseFileSetsRequest) GetPageToken() string {
	if x, ok := x.GetPageStart().(*TraverseFileSetsRequest_PageToken); ok {
		return x.PageToken
	}
	return ""
}

func (x *TraverseFileSetsRequest) GetOffset() int64 {
	if x, ok := x.GetPageStart().(*TraverseFileSetsRequest_Offset); ok {
		return x.Offset
	}
	return 0
}

type isTraverseFileSetsRequest_PageStart interface {
	isTraverseFileSetsRequest_PageStart()
}

type TraverseFileSetsRequest_PageToken struct {
	// The next_page_token value returned from a previous List request, if any.
	// Page tokens will become larger with every page returned, and if a page
	// token becomes too large, it will no longer be possible to continue to
	// calculate the transitive dependencies. The API will return a 400
	// Bad request (HTTPS), or a INVALID_ARGUMENT (gRPC ) when
	// this happens.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof"`
}

type TraverseFileSetsRequest_Offset struct {
	// Absolute number of results to skip.
	// Not yet implemented. 0 for default.
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

func (*TraverseFileSetsRequest_PageToken) isTraverseFileSetsRequest_PageStart() {}

func (*TraverseFileSetsRequest_Offset) isTraverseFileSetsRequest_PageStart() {}

// Response from calling TraverseFileSets
type TraverseFileSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File sets matching the request.
	// The order in which results are returned is undefined, but stable.
	FileSets []*FileSet `protobuf:"bytes,1,rep,name=file_sets,json=fileSets,proto3" json:"file_sets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *TraverseFileSetsResponse) Reset() {
	*x = TraverseFileSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TraverseFileSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TraverseFileSetsResponse) ProtoMessage() {}

func (x *TraverseFileSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TraverseFileSetsResponse.ProtoReflect.Descriptor instead.
func (*TraverseFileSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP(), []int{20}
}

func (x *TraverseFileSetsResponse) GetFileSets() []*FileSet {
	if x != nil {
		return x.FileSets
	}
	return nil
}

func (x *TraverseFileSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_devtools_resultstore_v2_resultstore_download_proto protoreflect.FileDescriptor

var file_google_devtools_resultstore_v2_resultstore_download_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f,
	0x76, 0x32, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x2a, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd6, 0x01, 0x0a,
	0x18, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x78, 0x61,
	0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x91, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3a, 0x0a, 0x24, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2d, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x9b, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x26, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x7f, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x07, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x30, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0xa8, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x26, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x07,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x27, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xab, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42,
	0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x84, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53,
	0x65, 0x74, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x17, 0x54, 0x72, 0x61, 0x76, 0x65, 0x72, 0x73,
	0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x0c, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x22, 0x88, 0x01, 0x0a, 0x18, 0x54,
	0x72, 0x61, 0x76, 0x65, 0x72, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xff, 0x14, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x93, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x20, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x12, 0x18, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0xca,
	0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x12, 0x29, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d, 0x12, 0xa6, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24,
	0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x91,
	0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xa2, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x3e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x95, 0x01, 0x0a, 0x0a, 0x47, 0x65,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xa6, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x9a, 0x02, 0x0a, 0x10, 0x54,
	0x72, 0x61, 0x76, 0x65, 0x72, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x72, 0x61, 0x76, 0x65, 0x72, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x92, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8b, 0x01, 0x12, 0x34, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x72, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x5a, 0x53, 0x12, 0x51, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x72, 0x73, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x71, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x50, 0x01, 0x5a,
	0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x3b, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescOnce sync.Once
	file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescData = file_google_devtools_resultstore_v2_resultstore_download_proto_rawDesc
)

func file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescGZIP() []byte {
	file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescOnce.Do(func() {
		file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescData)
	})
	return file_google_devtools_resultstore_v2_resultstore_download_proto_rawDescData
}

var file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_devtools_resultstore_v2_resultstore_download_proto_goTypes = []interface{}{
	(*GetInvocationRequest)(nil),                 // 0: google.devtools.resultstore.v2.GetInvocationRequest
	(*SearchInvocationsRequest)(nil),             // 1: google.devtools.resultstore.v2.SearchInvocationsRequest
	(*SearchInvocationsResponse)(nil),            // 2: google.devtools.resultstore.v2.SearchInvocationsResponse
	(*GetInvocationDownloadMetadataRequest)(nil), // 3: google.devtools.resultstore.v2.GetInvocationDownloadMetadataRequest
	(*GetConfigurationRequest)(nil),              // 4: google.devtools.resultstore.v2.GetConfigurationRequest
	(*ListConfigurationsRequest)(nil),            // 5: google.devtools.resultstore.v2.ListConfigurationsRequest
	(*ListConfigurationsResponse)(nil),           // 6: google.devtools.resultstore.v2.ListConfigurationsResponse
	(*GetTargetRequest)(nil),                     // 7: google.devtools.resultstore.v2.GetTargetRequest
	(*ListTargetsRequest)(nil),                   // 8: google.devtools.resultstore.v2.ListTargetsRequest
	(*ListTargetsResponse)(nil),                  // 9: google.devtools.resultstore.v2.ListTargetsResponse
	(*GetConfiguredTargetRequest)(nil),           // 10: google.devtools.resultstore.v2.GetConfiguredTargetRequest
	(*ListConfiguredTargetsRequest)(nil),         // 11: google.devtools.resultstore.v2.ListConfiguredTargetsRequest
	(*ListConfiguredTargetsResponse)(nil),        // 12: google.devtools.resultstore.v2.ListConfiguredTargetsResponse
	(*GetActionRequest)(nil),                     // 13: google.devtools.resultstore.v2.GetActionRequest
	(*ListActionsRequest)(nil),                   // 14: google.devtools.resultstore.v2.ListActionsRequest
	(*ListActionsResponse)(nil),                  // 15: google.devtools.resultstore.v2.ListActionsResponse
	(*GetFileSetRequest)(nil),                    // 16: google.devtools.resultstore.v2.GetFileSetRequest
	(*ListFileSetsRequest)(nil),                  // 17: google.devtools.resultstore.v2.ListFileSetsRequest
	(*ListFileSetsResponse)(nil),                 // 18: google.devtools.resultstore.v2.ListFileSetsResponse
	(*TraverseFileSetsRequest)(nil),              // 19: google.devtools.resultstore.v2.TraverseFileSetsRequest
	(*TraverseFileSetsResponse)(nil),             // 20: google.devtools.resultstore.v2.TraverseFileSetsResponse
	(*Invocation)(nil),                           // 21: google.devtools.resultstore.v2.Invocation
	(*Configuration)(nil),                        // 22: google.devtools.resultstore.v2.Configuration
	(*Target)(nil),                               // 23: google.devtools.resultstore.v2.Target
	(*ConfiguredTarget)(nil),                     // 24: google.devtools.resultstore.v2.ConfiguredTarget
	(*Action)(nil),                               // 25: google.devtools.resultstore.v2.Action
	(*FileSet)(nil),                              // 26: google.devtools.resultstore.v2.FileSet
	(*DownloadMetadata)(nil),                     // 27: google.devtools.resultstore.v2.DownloadMetadata
}
var file_google_devtools_resultstore_v2_resultstore_download_proto_depIdxs = []int32{
	21, // 0: google.devtools.resultstore.v2.SearchInvocationsResponse.invocations:type_name -> google.devtools.resultstore.v2.Invocation
	22, // 1: google.devtools.resultstore.v2.ListConfigurationsResponse.configurations:type_name -> google.devtools.resultstore.v2.Configuration
	23, // 2: google.devtools.resultstore.v2.ListTargetsResponse.targets:type_name -> google.devtools.resultstore.v2.Target
	24, // 3: google.devtools.resultstore.v2.ListConfiguredTargetsResponse.configured_targets:type_name -> google.devtools.resultstore.v2.ConfiguredTarget
	25, // 4: google.devtools.resultstore.v2.ListActionsResponse.actions:type_name -> google.devtools.resultstore.v2.Action
	26, // 5: google.devtools.resultstore.v2.ListFileSetsResponse.file_sets:type_name -> google.devtools.resultstore.v2.FileSet
	26, // 6: google.devtools.resultstore.v2.TraverseFileSetsResponse.file_sets:type_name -> google.devtools.resultstore.v2.FileSet
	0,  // 7: google.devtools.resultstore.v2.ResultStoreDownload.GetInvocation:input_type -> google.devtools.resultstore.v2.GetInvocationRequest
	1,  // 8: google.devtools.resultstore.v2.ResultStoreDownload.SearchInvocations:input_type -> google.devtools.resultstore.v2.SearchInvocationsRequest
	3,  // 9: google.devtools.resultstore.v2.ResultStoreDownload.GetInvocationDownloadMetadata:input_type -> google.devtools.resultstore.v2.GetInvocationDownloadMetadataRequest
	4,  // 10: google.devtools.resultstore.v2.ResultStoreDownload.GetConfiguration:input_type -> google.devtools.resultstore.v2.GetConfigurationRequest
	5,  // 11: google.devtools.resultstore.v2.ResultStoreDownload.ListConfigurations:input_type -> google.devtools.resultstore.v2.ListConfigurationsRequest
	7,  // 12: google.devtools.resultstore.v2.ResultStoreDownload.GetTarget:input_type -> google.devtools.resultstore.v2.GetTargetRequest
	8,  // 13: google.devtools.resultstore.v2.ResultStoreDownload.ListTargets:input_type -> google.devtools.resultstore.v2.ListTargetsRequest
	10, // 14: google.devtools.resultstore.v2.ResultStoreDownload.GetConfiguredTarget:input_type -> google.devtools.resultstore.v2.GetConfiguredTargetRequest
	11, // 15: google.devtools.resultstore.v2.ResultStoreDownload.ListConfiguredTargets:input_type -> google.devtools.resultstore.v2.ListConfiguredTargetsRequest
	13, // 16: google.devtools.resultstore.v2.ResultStoreDownload.GetAction:input_type -> google.devtools.resultstore.v2.GetActionRequest
	14, // 17: google.devtools.resultstore.v2.ResultStoreDownload.ListActions:input_type -> google.devtools.resultstore.v2.ListActionsRequest
	16, // 18: google.devtools.resultstore.v2.ResultStoreDownload.GetFileSet:input_type -> google.devtools.resultstore.v2.GetFileSetRequest
	17, // 19: google.devtools.resultstore.v2.ResultStoreDownload.ListFileSets:input_type -> google.devtools.resultstore.v2.ListFileSetsRequest
	19, // 20: google.devtools.resultstore.v2.ResultStoreDownload.TraverseFileSets:input_type -> google.devtools.resultstore.v2.TraverseFileSetsRequest
	21, // 21: google.devtools.resultstore.v2.ResultStoreDownload.GetInvocation:output_type -> google.devtools.resultstore.v2.Invocation
	2,  // 22: google.devtools.resultstore.v2.ResultStoreDownload.SearchInvocations:output_type -> google.devtools.resultstore.v2.SearchInvocationsResponse
	27, // 23: google.devtools.resultstore.v2.ResultStoreDownload.GetInvocationDownloadMetadata:output_type -> google.devtools.resultstore.v2.DownloadMetadata
	22, // 24: google.devtools.resultstore.v2.ResultStoreDownload.GetConfiguration:output_type -> google.devtools.resultstore.v2.Configuration
	6,  // 25: google.devtools.resultstore.v2.ResultStoreDownload.ListConfigurations:output_type -> google.devtools.resultstore.v2.ListConfigurationsResponse
	23, // 26: google.devtools.resultstore.v2.ResultStoreDownload.GetTarget:output_type -> google.devtools.resultstore.v2.Target
	9,  // 27: google.devtools.resultstore.v2.ResultStoreDownload.ListTargets:output_type -> google.devtools.resultstore.v2.ListTargetsResponse
	24, // 28: google.devtools.resultstore.v2.ResultStoreDownload.GetConfiguredTarget:output_type -> google.devtools.resultstore.v2.ConfiguredTarget
	12, // 29: google.devtools.resultstore.v2.ResultStoreDownload.ListConfiguredTargets:output_type -> google.devtools.resultstore.v2.ListConfiguredTargetsResponse
	25, // 30: google.devtools.resultstore.v2.ResultStoreDownload.GetAction:output_type -> google.devtools.resultstore.v2.Action
	15, // 31: google.devtools.resultstore.v2.ResultStoreDownload.ListActions:output_type -> google.devtools.resultstore.v2.ListActionsResponse
	26, // 32: google.devtools.resultstore.v2.ResultStoreDownload.GetFileSet:output_type -> google.devtools.resultstore.v2.FileSet
	18, // 33: google.devtools.resultstore.v2.ResultStoreDownload.ListFileSets:output_type -> google.devtools.resultstore.v2.ListFileSetsResponse
	20, // 34: google.devtools.resultstore.v2.ResultStoreDownload.TraverseFileSets:output_type -> google.devtools.resultstore.v2.TraverseFileSetsResponse
	21, // [21:35] is the sub-list for method output_type
	7,  // [7:21] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_devtools_resultstore_v2_resultstore_download_proto_init() }
func file_google_devtools_resultstore_v2_resultstore_download_proto_init() {
	if File_google_devtools_resultstore_v2_resultstore_download_proto != nil {
		return
	}
	file_google_devtools_resultstore_v2_action_proto_init()
	file_google_devtools_resultstore_v2_configuration_proto_init()
	file_google_devtools_resultstore_v2_configured_target_proto_init()
	file_google_devtools_resultstore_v2_download_metadata_proto_init()
	file_google_devtools_resultstore_v2_file_set_proto_init()
	file_google_devtools_resultstore_v2_invocation_proto_init()
	file_google_devtools_resultstore_v2_target_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchInvocationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchInvocationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInvocationDownloadMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfigurationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfigurationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConfiguredTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfiguredTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfiguredTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListActionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListActionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFileSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFileSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFileSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TraverseFileSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TraverseFileSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*SearchInvocationsRequest_PageToken)(nil),
		(*SearchInvocationsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ListConfigurationsRequest_PageToken)(nil),
		(*ListConfigurationsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ListTargetsRequest_PageToken)(nil),
		(*ListTargetsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*ListConfiguredTargetsRequest_PageToken)(nil),
		(*ListConfiguredTargetsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*ListActionsRequest_PageToken)(nil),
		(*ListActionsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*ListFileSetsRequest_PageToken)(nil),
		(*ListFileSetsRequest_Offset)(nil),
	}
	file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*TraverseFileSetsRequest_PageToken)(nil),
		(*TraverseFileSetsRequest_Offset)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_resultstore_v2_resultstore_download_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_resultstore_v2_resultstore_download_proto_goTypes,
		DependencyIndexes: file_google_devtools_resultstore_v2_resultstore_download_proto_depIdxs,
		MessageInfos:      file_google_devtools_resultstore_v2_resultstore_download_proto_msgTypes,
	}.Build()
	File_google_devtools_resultstore_v2_resultstore_download_proto = out.File
	file_google_devtools_resultstore_v2_resultstore_download_proto_rawDesc = nil
	file_google_devtools_resultstore_v2_resultstore_download_proto_goTypes = nil
	file_google_devtools_resultstore_v2_resultstore_download_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResultStoreDownloadClient is the client API for ResultStoreDownload service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResultStoreDownloadClient interface {
	// Retrieves the invocation with the given name.
	//
	// An error will be reported in the following cases:
	// - If the invocation is not found.
	// - If the given invocation name is badly formatted.
	// - If no field mask was given.
	GetInvocation(ctx context.Context, in *GetInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Searches for invocations matching the given query parameters. Results will
	// be ordered by timing.start_time with most recent first, but total ordering
	// of results is not guaranteed when difference in timestamps is very small.
	// Results may be stale.
	//
	//
	// An error will be reported in the following cases:
	// - If a query string is not provided
	// - If no field mask was given.
	SearchInvocations(ctx context.Context, in *SearchInvocationsRequest, opts ...grpc.CallOption) (*SearchInvocationsResponse, error)
	// Retrieves the metadata for an invocation with the given name.
	//
	// An error will be reported in the following cases:
	// - If the invocation is not found.
	// - If the given invocation name is badly formatted.
	GetInvocationDownloadMetadata(ctx context.Context, in *GetInvocationDownloadMetadataRequest, opts ...grpc.CallOption) (*DownloadMetadata, error)
	// Retrieves the configuration with the given name.
	//
	// An error will be reported in the following cases:
	// - If the configuration or its parent invocation is not found.
	// - If the given configuration name is badly formatted.
	// - If no field mask was given.
	GetConfiguration(ctx context.Context, in *GetConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Retrieves all configurations for a parent invocation.
	// This might be limited by user or server,
	// in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent invocation is not found.
	// - If the given parent invocation name is badly formatted.
	// - If no field mask was given.
	ListConfigurations(ctx context.Context, in *ListConfigurationsRequest, opts ...grpc.CallOption) (*ListConfigurationsResponse, error)
	// Retrieves the target with the given name.
	//
	// An error will be reported in the following cases:
	// - If the target or its parent invocation is not found.
	// - If the given target name is badly formatted.
	// - If no field mask was given.
	GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Retrieves all targets for a parent invocation.  This might be limited by
	// user or server, in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error)
	// Retrieves the configured target with the given name.
	//
	// An error will be reported in the following cases:
	// - If the configured target is not found.
	// - If the given name is badly formatted.
	// - If no field mask was given.
	GetConfiguredTarget(ctx context.Context, in *GetConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Retrieves all configured targets for a parent invocation/target.
	// This might be limited by user or server, in which case a continuation
	// token is provided.  Supports '-' for targetId meaning all targets.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListConfiguredTargets(ctx context.Context, in *ListConfiguredTargetsRequest, opts ...grpc.CallOption) (*ListConfiguredTargetsResponse, error)
	// Retrieves the action with the given name.
	//
	// An error will be reported in the following cases:
	// - If the action is not found.
	// - If the given name is badly formatted.
	// - If no field mask was given.
	GetAction(ctx context.Context, in *GetActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Retrieves all actions for a parent invocation/target/configuration.
	// This might be limited by user or server, in which case a continuation
	// token is provided.  Supports '-' for configurationId to mean all
	// actions for all configurations for a target, or '-' for targetId and
	// configurationId to mean all actions for all configurations and all targets.
	// Does not support targetId '-' with a specified configuration.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListActions(ctx context.Context, in *ListActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error)
	// Retrieves the file set with the given name.
	//
	// An error will be reported in the following cases:
	// - If the file set or its parent invocation is not found.
	// - If the given file set name is badly formatted.
	// - If no field mask was given.
	GetFileSet(ctx context.Context, in *GetFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Retrieves all file sets for a parent invocation.
	// This might be limited by user or server,
	// in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent invocation is not found.
	// - If the given parent invocation name is badly formatted.
	// - If no field mask was given.
	ListFileSets(ctx context.Context, in *ListFileSetsRequest, opts ...grpc.CallOption) (*ListFileSetsResponse, error)
	// Returns the transitive closure of FileSets. This might be limited by user
	// or server, in which case a continuation token is provided.
	// The order in which results are returned is undefined, and unstable.
	//
	// An error will be reported in the following cases:
	// - If page_token is too large to continue the calculation.
	// - If the resource is not found.
	// - If the given resource name is badly formatted.
	// - If no field mask was given.
	TraverseFileSets(ctx context.Context, in *TraverseFileSetsRequest, opts ...grpc.CallOption) (*TraverseFileSetsResponse, error)
}

type resultStoreDownloadClient struct {
	cc grpc.ClientConnInterface
}

func NewResultStoreDownloadClient(cc grpc.ClientConnInterface) ResultStoreDownloadClient {
	return &resultStoreDownloadClient{cc}
}

func (c *resultStoreDownloadClient) GetInvocation(ctx context.Context, in *GetInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) SearchInvocations(ctx context.Context, in *SearchInvocationsRequest, opts ...grpc.CallOption) (*SearchInvocationsResponse, error) {
	out := new(SearchInvocationsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/SearchInvocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetInvocationDownloadMetadata(ctx context.Context, in *GetInvocationDownloadMetadataRequest, opts ...grpc.CallOption) (*DownloadMetadata, error) {
	out := new(DownloadMetadata)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetInvocationDownloadMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetConfiguration(ctx context.Context, in *GetConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) ListConfigurations(ctx context.Context, in *ListConfigurationsRequest, opts ...grpc.CallOption) (*ListConfigurationsResponse, error) {
	out := new(ListConfigurationsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/ListConfigurations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error) {
	out := new(ListTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/ListTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetConfiguredTarget(ctx context.Context, in *GetConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) ListConfiguredTargets(ctx context.Context, in *ListConfiguredTargetsRequest, opts ...grpc.CallOption) (*ListConfiguredTargetsResponse, error) {
	out := new(ListConfiguredTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/ListConfiguredTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetAction(ctx context.Context, in *GetActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) ListActions(ctx context.Context, in *ListActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error) {
	out := new(ListActionsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/ListActions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) GetFileSet(ctx context.Context, in *GetFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/GetFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) ListFileSets(ctx context.Context, in *ListFileSetsRequest, opts ...grpc.CallOption) (*ListFileSetsResponse, error) {
	out := new(ListFileSetsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/ListFileSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreDownloadClient) TraverseFileSets(ctx context.Context, in *TraverseFileSetsRequest, opts ...grpc.CallOption) (*TraverseFileSetsResponse, error) {
	out := new(TraverseFileSetsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreDownload/TraverseFileSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResultStoreDownloadServer is the server API for ResultStoreDownload service.
type ResultStoreDownloadServer interface {
	// Retrieves the invocation with the given name.
	//
	// An error will be reported in the following cases:
	// - If the invocation is not found.
	// - If the given invocation name is badly formatted.
	// - If no field mask was given.
	GetInvocation(context.Context, *GetInvocationRequest) (*Invocation, error)
	// Searches for invocations matching the given query parameters. Results will
	// be ordered by timing.start_time with most recent first, but total ordering
	// of results is not guaranteed when difference in timestamps is very small.
	// Results may be stale.
	//
	//
	// An error will be reported in the following cases:
	// - If a query string is not provided
	// - If no field mask was given.
	SearchInvocations(context.Context, *SearchInvocationsRequest) (*SearchInvocationsResponse, error)
	// Retrieves the metadata for an invocation with the given name.
	//
	// An error will be reported in the following cases:
	// - If the invocation is not found.
	// - If the given invocation name is badly formatted.
	GetInvocationDownloadMetadata(context.Context, *GetInvocationDownloadMetadataRequest) (*DownloadMetadata, error)
	// Retrieves the configuration with the given name.
	//
	// An error will be reported in the following cases:
	// - If the configuration or its parent invocation is not found.
	// - If the given configuration name is badly formatted.
	// - If no field mask was given.
	GetConfiguration(context.Context, *GetConfigurationRequest) (*Configuration, error)
	// Retrieves all configurations for a parent invocation.
	// This might be limited by user or server,
	// in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent invocation is not found.
	// - If the given parent invocation name is badly formatted.
	// - If no field mask was given.
	ListConfigurations(context.Context, *ListConfigurationsRequest) (*ListConfigurationsResponse, error)
	// Retrieves the target with the given name.
	//
	// An error will be reported in the following cases:
	// - If the target or its parent invocation is not found.
	// - If the given target name is badly formatted.
	// - If no field mask was given.
	GetTarget(context.Context, *GetTargetRequest) (*Target, error)
	// Retrieves all targets for a parent invocation.  This might be limited by
	// user or server, in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error)
	// Retrieves the configured target with the given name.
	//
	// An error will be reported in the following cases:
	// - If the configured target is not found.
	// - If the given name is badly formatted.
	// - If no field mask was given.
	GetConfiguredTarget(context.Context, *GetConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Retrieves all configured targets for a parent invocation/target.
	// This might be limited by user or server, in which case a continuation
	// token is provided.  Supports '-' for targetId meaning all targets.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListConfiguredTargets(context.Context, *ListConfiguredTargetsRequest) (*ListConfiguredTargetsResponse, error)
	// Retrieves the action with the given name.
	//
	// An error will be reported in the following cases:
	// - If the action is not found.
	// - If the given name is badly formatted.
	// - If no field mask was given.
	GetAction(context.Context, *GetActionRequest) (*Action, error)
	// Retrieves all actions for a parent invocation/target/configuration.
	// This might be limited by user or server, in which case a continuation
	// token is provided.  Supports '-' for configurationId to mean all
	// actions for all configurations for a target, or '-' for targetId and
	// configurationId to mean all actions for all configurations and all targets.
	// Does not support targetId '-' with a specified configuration.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent is not found.
	// - If the given parent name is badly formatted.
	// - If no field mask was given.
	ListActions(context.Context, *ListActionsRequest) (*ListActionsResponse, error)
	// Retrieves the file set with the given name.
	//
	// An error will be reported in the following cases:
	// - If the file set or its parent invocation is not found.
	// - If the given file set name is badly formatted.
	// - If no field mask was given.
	GetFileSet(context.Context, *GetFileSetRequest) (*FileSet, error)
	// Retrieves all file sets for a parent invocation.
	// This might be limited by user or server,
	// in which case a continuation token is provided.
	// The order in which results are returned is undefined, but stable.
	//
	// An error will be reported in the following cases:
	// - If the parent invocation is not found.
	// - If the given parent invocation name is badly formatted.
	// - If no field mask was given.
	ListFileSets(context.Context, *ListFileSetsRequest) (*ListFileSetsResponse, error)
	// Returns the transitive closure of FileSets. This might be limited by user
	// or server, in which case a continuation token is provided.
	// The order in which results are returned is undefined, and unstable.
	//
	// An error will be reported in the following cases:
	// - If page_token is too large to continue the calculation.
	// - If the resource is not found.
	// - If the given resource name is badly formatted.
	// - If no field mask was given.
	TraverseFileSets(context.Context, *TraverseFileSetsRequest) (*TraverseFileSetsResponse, error)
}

// UnimplementedResultStoreDownloadServer can be embedded to have forward compatible implementations.
type UnimplementedResultStoreDownloadServer struct {
}

func (*UnimplementedResultStoreDownloadServer) GetInvocation(context.Context, *GetInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInvocation not implemented")
}
func (*UnimplementedResultStoreDownloadServer) SearchInvocations(context.Context, *SearchInvocationsRequest) (*SearchInvocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchInvocations not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetInvocationDownloadMetadata(context.Context, *GetInvocationDownloadMetadataRequest) (*DownloadMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInvocationDownloadMetadata not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetConfiguration(context.Context, *GetConfigurationRequest) (*Configuration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfiguration not implemented")
}
func (*UnimplementedResultStoreDownloadServer) ListConfigurations(context.Context, *ListConfigurationsRequest) (*ListConfigurationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConfigurations not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetTarget(context.Context, *GetTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTarget not implemented")
}
func (*UnimplementedResultStoreDownloadServer) ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargets not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetConfiguredTarget(context.Context, *GetConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreDownloadServer) ListConfiguredTargets(context.Context, *ListConfiguredTargetsRequest) (*ListConfiguredTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConfiguredTargets not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetAction(context.Context, *GetActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAction not implemented")
}
func (*UnimplementedResultStoreDownloadServer) ListActions(context.Context, *ListActionsRequest) (*ListActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListActions not implemented")
}
func (*UnimplementedResultStoreDownloadServer) GetFileSet(context.Context, *GetFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFileSet not implemented")
}
func (*UnimplementedResultStoreDownloadServer) ListFileSets(context.Context, *ListFileSetsRequest) (*ListFileSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFileSets not implemented")
}
func (*UnimplementedResultStoreDownloadServer) TraverseFileSets(context.Context, *TraverseFileSetsRequest) (*TraverseFileSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TraverseFileSets not implemented")
}

func RegisterResultStoreDownloadServer(s *grpc.Server, srv ResultStoreDownloadServer) {
	s.RegisterService(&_ResultStoreDownload_serviceDesc, srv)
}

func _ResultStoreDownload_GetInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetInvocation(ctx, req.(*GetInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_SearchInvocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchInvocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).SearchInvocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/SearchInvocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).SearchInvocations(ctx, req.(*SearchInvocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetInvocationDownloadMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInvocationDownloadMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetInvocationDownloadMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetInvocationDownloadMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetInvocationDownloadMetadata(ctx, req.(*GetInvocationDownloadMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetConfiguration(ctx, req.(*GetConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_ListConfigurations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfigurationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).ListConfigurations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/ListConfigurations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).ListConfigurations(ctx, req.(*ListConfigurationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetTarget(ctx, req.(*GetTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_ListTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).ListTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/ListTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).ListTargets(ctx, req.(*ListTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetConfiguredTarget(ctx, req.(*GetConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_ListConfiguredTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfiguredTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).ListConfiguredTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/ListConfiguredTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).ListConfiguredTargets(ctx, req.(*ListConfiguredTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetAction(ctx, req.(*GetActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_ListActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).ListActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/ListActions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).ListActions(ctx, req.(*ListActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_GetFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).GetFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/GetFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).GetFileSet(ctx, req.(*GetFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_ListFileSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFileSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).ListFileSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/ListFileSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).ListFileSets(ctx, req.(*ListFileSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreDownload_TraverseFileSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TraverseFileSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreDownloadServer).TraverseFileSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreDownload/TraverseFileSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreDownloadServer).TraverseFileSets(ctx, req.(*TraverseFileSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResultStoreDownload_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.resultstore.v2.ResultStoreDownload",
	HandlerType: (*ResultStoreDownloadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetInvocation",
			Handler:    _ResultStoreDownload_GetInvocation_Handler,
		},
		{
			MethodName: "SearchInvocations",
			Handler:    _ResultStoreDownload_SearchInvocations_Handler,
		},
		{
			MethodName: "GetInvocationDownloadMetadata",
			Handler:    _ResultStoreDownload_GetInvocationDownloadMetadata_Handler,
		},
		{
			MethodName: "GetConfiguration",
			Handler:    _ResultStoreDownload_GetConfiguration_Handler,
		},
		{
			MethodName: "ListConfigurations",
			Handler:    _ResultStoreDownload_ListConfigurations_Handler,
		},
		{
			MethodName: "GetTarget",
			Handler:    _ResultStoreDownload_GetTarget_Handler,
		},
		{
			MethodName: "ListTargets",
			Handler:    _ResultStoreDownload_ListTargets_Handler,
		},
		{
			MethodName: "GetConfiguredTarget",
			Handler:    _ResultStoreDownload_GetConfiguredTarget_Handler,
		},
		{
			MethodName: "ListConfiguredTargets",
			Handler:    _ResultStoreDownload_ListConfiguredTargets_Handler,
		},
		{
			MethodName: "GetAction",
			Handler:    _ResultStoreDownload_GetAction_Handler,
		},
		{
			MethodName: "ListActions",
			Handler:    _ResultStoreDownload_ListActions_Handler,
		},
		{
			MethodName: "GetFileSet",
			Handler:    _ResultStoreDownload_GetFileSet_Handler,
		},
		{
			MethodName: "ListFileSets",
			Handler:    _ResultStoreDownload_ListFileSets_Handler,
		},
		{
			MethodName: "TraverseFileSets",
			Handler:    _ResultStoreDownload_TraverseFileSets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/resultstore/v2/resultstore_download.proto",
}
