package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRequestGraph invokes the pvtz.DescribeRequestGraph API synchronously
func (client *Client) DescribeRequestGraph(request *DescribeRequestGraphRequest) (response *DescribeRequestGraphResponse, err error) {
	response = CreateDescribeRequestGraphResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRequestGraphWithChan invokes the pvtz.DescribeRequestGraph API asynchronously
func (client *Client) DescribeRequestGraphWithChan(request *DescribeRequestGraphRequest) (<-chan *DescribeRequestGraphResponse, <-chan error) {
	responseChan := make(chan *DescribeRequestGraphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRequestGraph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRequestGraphWithCallback invokes the pvtz.DescribeRequestGraph API asynchronously
func (client *Client) DescribeRequestGraphWithCallback(request *DescribeRequestGraphRequest, callback func(response *DescribeRequestGraphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRequestGraphResponse
		var err error
		defer close(result)
		response, err = client.DescribeRequestGraph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRequestGraphRequest is the request struct for api DescribeRequestGraph
type DescribeRequestGraphRequest struct {
	*requests.RpcRequest
	StartTimestamp requests.Integer `position:"Query" name:"StartTimestamp"`
	EndTimestamp   requests.Integer `position:"Query" name:"EndTimestamp"`
	BizType        string           `position:"Query" name:"BizType"`
	VpcId          string           `position:"Query" name:"VpcId"`
	UserClientIp   string           `position:"Query" name:"UserClientIp"`
	BizId          string           `position:"Query" name:"BizId"`
	ZoneId         string           `position:"Query" name:"ZoneId"`
	Lang           string           `position:"Query" name:"Lang"`
}

// DescribeRequestGraphResponse is the response struct for api DescribeRequestGraph
type DescribeRequestGraphResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	RequestDetails RequestDetails `json:"RequestDetails" xml:"RequestDetails"`
}

// CreateDescribeRequestGraphRequest creates a request to invoke DescribeRequestGraph API
func CreateDescribeRequestGraphRequest() (request *DescribeRequestGraphRequest) {
	request = &DescribeRequestGraphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeRequestGraph", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRequestGraphResponse creates a response to parse from DescribeRequestGraph response
func CreateDescribeRequestGraphResponse() (response *DescribeRequestGraphResponse) {
	response = &DescribeRequestGraphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
