// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (397B)
// assets/dns/daemonset.yaml (6.403kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (520B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x90\xb1\x4e\xc4\x30\x10\x44\x7b\x7f\x85\x75\xfd\x05\xd1\xa1\xb4\x14\xf4\x14\xf4\x1b\x67\x50\x96\xe4\x76\xad\xdd\x75\x4e\xe2\xeb\x51\x2e\x57\xa0\x8b\xa0\x9b\x19\xd9\xf3\x3c\x9e\x59\xc6\x3e\xbf\x2e\xcd\x03\xf6\xae\x0b\x12\x55\xfe\x80\x39\xab\xf4\xd9\x06\x2a\x1d\xb5\x98\xd4\xf8\x9b\x82\x55\xba\xf9\xc5\x3b\xd6\xa7\xf5\x39\x5d\x10\x34\x52\x50\x9f\x72\x16\xba\xa0\xcf\x5a\x21\x3e\xf1\x67\x9c\x47\xf1\x64\x6d\x81\xf7\xe9\x9c\xa9\xf2\x9b\x69\xab\xbe\x9d\x3c\xe7\xd3\x29\xe5\x6c\x70\x6d\x56\x70\xcf\x20\x63\x55\x96\xf0\x9b\x73\xd8\xca\x05\xbb\xa9\x3a\xee\x62\x63\x78\xa5\x3d\x5f\x61\xc3\xfd\xee\xc2\x1e\x37\x71\xa5\x28\x53\x3a\x02\xb7\x01\x90\xe0\xf2\x7b\xc1\xf1\x0d\xa1\x33\xc4\xb0\x32\xae\x0f\x84\x62\xa0\xc0\x1f\xcd\x8f\x5f\x73\x2c\xf6\x36\x7c\xa1\x04\x95\x02\xf7\xff\x00\x3f\x01\x00\x00\xff\xff\x76\x1b\x55\x2e\x8d\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 397, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x84, 0xae, 0xd1, 0xba, 0xfa, 0x6b, 0xf8, 0x6e, 0x8d, 0x28, 0xc2, 0xa7, 0xaf, 0xc9, 0x3b, 0xc7, 0xcd, 0x80, 0xbe, 0xec, 0x98, 0xb4, 0x61, 0xa0, 0x9, 0xae, 0xa, 0xd8, 0xb2, 0x2e, 0x16, 0xf2}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x59\xff\x57\xe3\x36\x12\xff\x9d\xbf\x62\x6a\xb8\xb2\xdb\x62\x48\x76\x97\xed\x9e\xb7\xf4\x9a\x42\x28\xbc\x2e\x90\x47\xb2\xed\x0f\x3c\x8e\xa7\xc8\x93\x58\x17\x59\x52\x25\xd9\xe0\x07\xfc\xef\xf7\x24\xc7\x89\x1d\x87\xb4\x7b\xdf\xde\xf5\x07\x0a\x9a\x99\x8f\x66\x46\xf3\xd5\x3b\x63\x22\x8e\xe0\x84\x60\x2a\xc5\x10\xed\x16\x51\xec\x57\xd4\x86\x49\x11\x01\x51\xca\x1c\xe4\xdd\xad\x6d\x10\x24\xc5\x3d\xff\xd3\x28\x42\x11\x88\x88\x81\x93\x31\x72\x03\x44\x23\x18\xb4\x40\x2c\xe8\x4c\x58\x96\xe2\x96\x51\x48\xa3\x2d\x00\x8b\xa9\xe2\xc4\xa2\xfb\x1d\xa0\x3a\xf5\xbf\xa3\xce\x19\xc5\x1e\xa5\x32\x13\xf6\x92\xa4\x18\x41\x2c\xcc\x9c\xaa\x34\x93\x9a\xd9\xe2\x98\x13\x63\x4a\xa2\x29\x8c\xc5\x34\x14\x32\xc6\x90\x6a\x66\x19\x25\x7c\xce\x4d\xa5\xb0\x84\x09\xd4\xa6\x42\x0f\xbd\xa6\x75\x44\x80\x6d\x60\x29\x99\x22\x30\xb3\xaa\x6d\xc5\xe1\xe9\x83\x8c\xf3\x81\xe4\x8c\x16\x11\x9c\x4f\x2e\xa5\x1d\x68\x34\x28\xec\x82\xcb\xa2\x4e\x99\x20\x96\x49\x71\x81\xc6\x38\x91\x39\xfb\x29\xe1\x7c\x4c\xe8\x6c\x24\x3f\xc9\xa9\xb9\x12\x7d\xad\xa5\x5e\xc8\x51\x99\xa6\xc4\xb9\xfa\x06\x02\x2a\x35\xc6\xc2\x04\x70\xbb\x20\x13\x3d\x35\x9e\x16\x52\x29\x26\xc1\x1e\x04\x07\x68\xe9\xc1\x9c\xf3\xe0\x58\x6a\x9c\x30\x8e\x75\x91\x5c\xf2\x2c\xc5\x0b\xe7\xc0\x85\xe5\x4b\xdb\x1d\x0c\x9b\x86\x25\xd3\x82\x0a\x90\x3a\xfe\x01\xb1\x49\x04\xf5\x1b\x6a\x1c\x1a\x49\x7c\x25\x78\x11\x81\xd5\xd9\x52\x54\x49\xdd\xbc\x67\xe1\xf7\x81\xd4\x36\x82\xc3\xb7\x87\x6f\x6b\x28\xed\x17\x70\xef\x2a\xad\xa4\x92\x47\xf0\xf9\x64\xf0\xe5\x48\xa1\xa5\x6a\x2d\xda\xe8\x78\x89\xe6\xb4\x67\x02\x8d\x19\x68\x39\xc6\xa8\xc6\x9f\x58\xab\x7e\x46\x5b\x3f\x02\x50\xa5\x27\x9c\x54\xd1\x24\x78\x55\x3e\x74\x3f\x74\x1b\xc7\x86\x26\xe8\xd4\x39\x1b\x8d\x06\x35\x02\x13\xcc\x32\xc2\x4f\x90\x93\x62\x88\x54\x8a\xd8\x44\xd0\xed\xd4\xb5\x45\xcd\x64\xbc\xa0\xd5\x0d\x34\x19\xa5\x68\xcc\x28\xd1\x68\x12\xc9\xe3\x08\xea\x77\x4e\x08\xe3\x99\xc6\x1a\xb5\x2e\xeb\x22\x58\x66\x76\x0d\x2e\x67\x39\x7e\xb1\x1f\x12\x24\xdc\x26\xeb\x1c\xd1\xf9\xd0\xf9\x97\x1d\xf1\xbe\xb3\x41\xe3\xc3\x7f\xc3\x13\x87\xb5\x67\x37\x32\xd3\x14\x4d\xdd\x2c\xce\x52\x66\x4d\xd3\xd0\x14\x53\xa9\x8b\x08\x0e\xbb\x6f\x2e\x58\x23\xea\x7f\xcf\xd0\xac\x72\x53\x95\x45\x70\xd8\x49\xd7\x42\x7c\xd7\x59\x20\x54\x59\x37\xcb\xc6\x18\xea\x31\xa1\xa1\xd2\xf2\xa1\xf8\x82\xea\xe3\x0b\x40\x2d\x27\xc2\x90\xcb\xa9\x95\xc6\xc6\xa8\x75\xe3\xdc\x20\xcd\x34\x86\x9c\x19\x8b\x22\x24\x71\xac\xd1\x98\xa3\xe8\xaf\xdd\xc3\x77\x0d\x3e\xcb\x4d\x48\x99\x4a\x50\x87\x26\x63\x16\xcd\xd1\xe8\xd3\xf0\xae\x7f\x7c\x72\xd6\xbf\xbb\x1e\xf6\xee\x7e\x3b\x1f\x9d\xdd\xf5\xfa\xc3\xbb\xee\x9b\x0f\x77\x3f\x1f\x5f\xdc\x0d\xcf\x7a\x6f\x0e\xdf\xef\x2d\xb9\xfa\xc7\x27\x7f\xc0\xd7\xc2\x39\xfe\xe9\xf8\x4f\xe1\xac\xe5\xdb\x80\xd6\xb0\x2c\x53\xc6\x6a\x24\xe9\x91\x0b\xe5\xe8\xe0\xa0\xfb\xe6\xbb\xfd\xce\x7e\x67\xbf\xeb\x9c\xf0\xf6\xa0\xed\x05\xd4\x36\x74\xe5\xf3\xc8\x97\x3c\xcb\xcd\x81\xd2\x2c\x27\x16\xdd\xef\xfb\x54\xdb\x96\xc8\x9c\x1e\xce\xb0\xd8\x20\x39\xc3\xe2\x4f\xd7\xc7\xc6\xfb\x54\x55\x2d\x45\xab\x19\x35\x9b\xc3\x78\x43\x68\x76\x5f\x08\xcd\x77\x9d\x5a\x70\xbf\xd4\x28\x56\x5b\x41\xcd\xba\x97\x14\x75\xbe\xf9\xa3\x56\x51\xeb\xbe\x65\xbf\x76\x46\xf1\x1c\xf5\xff\x4d\x2f\xf6\x19\xe4\xe6\x0b\x29\x2c\x3e\x34\x2a\xa1\xb3\x9f\x71\x9c\x62\xbc\xd2\xfe\x36\x77\xdb\x44\x1a\x6b\x7c\xa0\x6c\x68\xb5\x9e\xa9\xe6\x04\x14\x39\x5c\xf6\x2e\xfa\xc3\xfe\xf5\xaf\xfd\x6b\x3f\x53\x1d\x7f\xfa\x3c\x1c\xf5\xaf\xef\x4e\xae\x2e\x7a\xe7\x97\xeb\x66\xab\x4a\x1c\x45\xde\x56\xc3\x21\x9d\x1f\xf7\x87\x35\x25\xb6\xe1\xd8\x4d\x1e\x20\x35\x94\xa3\x9b\x41\x45\x34\xb1\x18\x83\xab\x20\x20\x27\xd5\x30\x66\x1a\x52\x97\x57\xa3\x7e\x04\xa7\x52\x83\x90\xf7\x7b\x80\xc2\x64\x1a\xc1\x26\x68\xd0\xab\xa5\x91\x13\xcb\x72\x2c\x87\xc2\x8f\x30\x91\x1a\x90\xd0\xa4\x49\xd8\x6b\x60\x12\x01\x84\x33\x62\xe0\x9e\xd9\xc4\x61\xad\xda\x6b\xb2\xc9\x84\x3d\xc0\x3d\xe3\x1c\x08\x37\x12\xc6\x08\x24\x8e\x31\xde\xaf\xe1\xe4\x84\x67\x18\x41\xe0\x63\x24\xd4\x38\x65\xc6\xea\x62\x5f\x2a\x14\x26\x61\x13\x1b\xae\x10\x4c\x4e\x83\xd6\x18\x56\x73\xdd\xc1\x98\x89\x83\x31\x31\x49\xbd\x08\xd0\xda\x1f\x4f\x75\x23\xbe\x6a\xb3\x83\x7f\xa3\x30\x93\xa0\x98\x42\xd7\xa5\xb6\xea\xfd\x4e\x13\x05\xbb\xff\x90\x63\x03\xa1\x82\x27\x78\x70\x95\x1e\x66\xce\xc4\xa7\x27\x1f\x63\x1f\xe1\x9e\x30\xfb\x11\xf0\x81\x59\xe8\xec\xc2\xa8\x7f\x7d\x51\x47\xb8\x1a\xf4\x2f\x87\x67\xe7\xa7\xa3\xbb\x8b\xde\xf5\x2f\xfd\xeb\xa3\x60\x69\xeb\x14\x05\xfa\xd7\x6c\xa6\x5a\x50\x13\x3f\xbb\x1a\x8e\x86\x77\xa7\xe7\x9f\xfa\x47\xc1\x32\x0e\xeb\x1c\xa3\xfe\xc5\xa0\xc5\xb0\x6f\x53\x15\xd4\xd5\x38\x3f\x1d\x1e\xed\xee\xc1\xae\xcf\x7a\x08\x35\x84\x64\x11\x3a\xf0\xfd\xf7\xdf\x43\xb0\xf3\x58\x05\xe0\x73\x43\x72\x1b\x2e\xc8\x0c\x81\xf8\x85\x40\x6a\xa2\x0b\x70\xa9\xb2\x0c\x03\xc9\xe3\x32\x85\xfc\xf9\xae\x01\x62\xad\x66\xe3\xcc\xa2\xa9\xbf\x3c\x55\x10\x4e\x20\x0c\x97\xd4\x50\x0a\x5e\xb8\x8b\x97\x46\x3e\x07\xee\xef\x85\x49\x4d\x4d\xee\x13\x77\x6f\xe9\xf4\x58\x36\x4a\x67\x8c\x94\xbb\xc0\x0e\x7b\x60\x72\x7a\xc7\x94\x69\x90\x5d\x7c\x9b\x9c\x02\x13\x0e\xbe\xb2\xfb\xe6\xc7\xdb\xe7\xa0\x05\xe5\x2c\x3e\x45\x4b\x93\xca\x3f\x70\x3e\x80\x89\x96\x29\x50\x9e\x19\x8b\xda\xd5\x46\x60\x13\x50\x65\x41\xdb\x87\xdf\x10\x52\xe7\x22\x83\x39\x6a\xc2\xc1\x6a\x86\xa6\x85\x69\x25\xc4\x12\x98\x8d\xe0\x7c\x90\xbf\xdb\x73\x3f\xdf\xfb\x9f\xef\x40\xe6\xa8\xdd\x1c\xec\xab\x88\x3b\x5f\x9c\xec\xc3\x28\x41\xb0\xf7\x12\x38\x71\xf9\x2e\xd6\x00\x3b\xbb\x9d\x81\x31\x2a\x2e\x8b\x14\x85\x9d\xe7\xe8\x2f\x99\x2e\x34\x48\xe1\x5e\x08\x35\x5c\x29\x14\x43\x4b\xe8\x0c\x5e\x5d\x0d\x07\xdd\xb7\xaf\x21\x04\x9b\x48\x83\x4e\x2f\x21\x6d\x0b\xd8\x64\xca\xf5\x45\x37\xef\x03\x97\x24\x1e\x13\x4e\x04\x45\x6d\xbc\x9e\xae\xb1\x31\x5f\x4b\x08\x4d\x98\x98\xc2\xc9\xe5\x10\x6c\xa2\x65\x36\x4d\xbc\xea\x2b\x78\x34\x8d\xcd\xd1\xab\xdd\x98\x4d\x21\xb4\xd0\x83\x1f\x83\x9d\xc7\x65\x01\x7d\x0e\xe0\x5b\x93\xb8\xdb\xdc\x03\xe5\xf4\x79\x7f\xe7\xb1\x59\x5f\x9e\x83\xa7\xa9\x46\x05\x61\x0e\xc1\xdf\x3f\x06\xbb\x2b\xf0\xe5\x7f\x0b\xf8\x5e\xef\xbf\x7d\x03\x7c\x6b\xa9\x82\x6f\x35\x5a\x5d\x1c\x75\xfe\x07\xe6\xfc\x67\xef\x7b\xbd\x72\xa1\x8b\x20\xe6\x12\x64\xe7\xf1\x2b\xf7\x54\x37\xdf\xdc\x3e\xaf\xb0\xb4\x12\x05\x80\x29\x73\xf4\x6a\xe7\x15\xe6\x84\xbb\x9b\xbd\x20\xbb\x7d\x0e\x5e\xaf\xc2\x83\xcb\x98\x9b\x1b\x08\x76\xfe\x16\x40\x88\xbf\x43\x07\xbe\xfe\xda\x89\x6c\x33\x55\x26\x22\x84\x02\xa1\x03\xb7\xb7\x1f\x5d\x55\x11\x6b\xfc\x31\xcf\xec\x9b\xb9\x89\xc1\xed\x51\xb0\xf3\x58\x89\xaf\xe1\x1f\x6b\x24\xb3\xd6\xf9\x84\xb5\xcc\x12\xb8\xd5\x3a\x68\x9c\x6c\xc3\x67\x15\x13\x8b\xb5\x51\x00\x7c\xf1\x62\x13\xb8\x47\x98\xa2\x75\x8d\x8d\xc5\xb5\x92\x61\x56\x00\x7e\xc3\xb2\x33\x0a\x69\x21\x6b\x81\xdd\x27\x28\x9c\xd9\xda\xcf\x55\xf3\xb5\x7e\x81\x26\x33\xeb\x26\x2e\xa9\x81\x28\x06\x99\x20\x39\x61\x9c\x8c\x19\x67\xb6\x58\xb9\x66\x68\x09\x47\x40\xe1\x6b\x10\x50\x99\xf1\xd8\xb5\x26\x63\xdd\xd3\xd6\x2e\x64\x13\x5f\xbb\xab\x1b\x98\x81\x18\x39\x5a\x8c\xb7\xda\x6f\x16\x8a\x79\x54\x79\xef\x7f\x73\x1b\x3e\x07\x2f\x3d\xd3\x36\xfc\x94\x31\x1e\x03\x01\x81\xf7\xb5\xae\x50\x16\xd0\xba\xc1\xae\x40\xc9\x4c\x03\xcd\x8c\x95\xe9\x42\xe3\x09\xe3\x16\x35\xc6\xce\xe6\x15\xec\x45\xf8\x6e\xc3\xce\xe3\x6a\x5b\x2d\x1b\x47\xa3\x91\xfc\xb0\xa1\x95\x94\xba\xf6\x94\x42\x5f\xc9\xca\xbe\xbb\x54\xc2\xb5\x8b\xf6\x5c\x05\xad\x4e\xf2\x55\xe5\x94\x17\x3a\xc9\x3c\xad\x54\x99\x57\x15\x73\x19\xbe\xb7\xcf\x6b\x05\x00\x90\x26\x12\x7c\x64\x3f\x97\x42\xd5\xff\xda\x39\x0d\x2f\xb8\xe2\x87\x96\xed\xab\x97\xb4\x82\x7e\x5d\xd8\x3b\x1f\x8d\xae\x4e\xae\xa2\x35\xe1\x4f\xac\x4c\x19\x25\x9c\x17\xae\xb3\x91\x5c\xb2\x18\x88\x28\x80\x09\x2a\x85\xf1\xeb\xad\x85\x31\x26\x24\x67\xb5\xe1\xbd\x42\xbd\x46\xc5\xdd\x3c\xbb\x2e\x22\x52\x19\xb3\x09\xc3\x18\xf2\xf2\x53\xa6\x8b\x42\x81\x18\xaf\xc4\xa6\xeb\x28\x6a\xc5\xcc\x56\x0c\x3c\x3d\xcd\xe7\x8e\xcd\x7c\x6d\xab\x2b\x5e\x97\x19\x2e\x65\x35\xa6\x32\xc7\x78\x69\xab\x8f\x6a\xaa\xd1\x6d\x93\x65\xea\xf8\xae\xb8\x9c\x6e\x80\x4a\x55\x00\x4d\x32\xdd\x4c\x92\x95\xfa\x63\x38\xa2\x82\xf7\x1d\xf8\xda\x0f\x92\x0d\x5a\x26\xdc\x6c\xda\x1e\x68\x1a\x8f\xf7\xa5\x5b\xe7\x61\xb5\x74\xc6\xc2\x54\x1b\xd7\x09\x4e\x48\xc6\xab\xcb\xdd\x30\x3a\x44\x8e\xd4\x4a\xbd\x04\x98\x65\x63\xd4\x02\xdd\x54\xc7\xe4\x81\x34\x11\x70\x26\xb2\x87\x92\x38\xe7\x2a\xf7\xac\xd6\xa7\xdc\xf5\x9f\x33\xcb\xd3\x0b\xa2\xa2\xda\x5a\x75\x49\xd2\x4d\xab\x25\x00\xb3\x98\x36\xcc\x0a\x61\x86\x45\x04\xd5\x47\xd6\x35\x1f\xc6\x56\x48\x1b\xd6\x3e\x77\xe4\x77\xbe\xad\x55\x8c\x35\x3b\x20\x80\x2d\x14\x46\x70\xda\x86\x5e\xb7\x70\x6f\xbb\xcd\x55\xa3\xdd\x68\xa1\x95\xdc\x6d\x04\x4c\x8a\x85\x8d\xdb\x7e\xb0\x72\x09\x60\x5c\xf4\xe9\x4c\x80\x9b\x33\x8b\x7b\xd7\x2d\xf6\x61\x54\x4a\x20\x10\xce\xc1\x12\x26\x16\x1a\x86\x20\x95\x23\x49\x1d\x41\xdf\xb5\x00\x47\x28\x5b\xcf\xd0\x3a\x91\x69\x51\xde\x51\x9a\x71\x2d\x39\x67\x62\x5a\x66\xba\x3f\xd7\xf5\x93\xa5\x3a\x97\xd2\x62\xe4\xe7\xd2\xd8\xff\xc3\x83\xff\x56\xe2\x78\x51\x83\x96\x99\x70\x7a\x26\x08\x0a\x35\x45\xe1\x1b\x57\xa6\x16\xc2\xaf\x32\xc1\xd9\xcc\xef\xa2\xb5\x81\xb5\x06\xb1\xe7\xc6\x7c\xb7\x89\x96\x48\xb1\xbc\x17\xaf\xab\x51\x32\x25\x0f\x9f\xab\xe6\xc7\x31\x82\x6e\xe7\x2f\x5b\xff\x0c\x00\x00\xff\xff\x9a\xc0\xe1\xd2\x03\x19\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 6403, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x5c, 0x87, 0x6f, 0x52, 0x95, 0x83, 0xce, 0xc0, 0x85, 0xb4, 0x62, 0x99, 0x62, 0x96, 0x6a, 0x5b, 0x4e, 0x9e, 0x3f, 0x9d, 0x0, 0x53, 0xcf, 0xd7, 0xad, 0x80, 0x9f, 0x6d, 0xc7, 0xd3, 0x49, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x91\x31\x6f\xe2\x40\x10\x85\x7b\xff\x8a\x27\xe8\x4e\xc0\x09\xdd\x51\x9c\xdb\xa3\x89\x52\x80\x14\x48\x3f\x5e\x4f\xcc\x8a\xf5\x8c\xb5\x33\x06\xf1\xef\x23\x4c\x42\x80\x14\x69\x56\xda\x7d\x9f\x3e\x3d\xbd\xdd\x47\xa9\x4b\xbc\x70\x3e\xc4\xc0\x05\x75\xf1\x95\xb3\x45\x95\x12\x87\x79\x31\x86\x50\xcb\x93\xe1\xb4\x8e\x02\x4f\x12\x55\x9c\x0c\x24\x35\x48\x44\x9d\x3c\xaa\x18\x28\x33\x8c\x1d\xe4\xc8\xbd\x78\x6c\xb9\xb0\x8e\x43\x59\x00\x63\x84\xd4\x9b\x73\x7e\x5a\xe3\x18\x53\x42\xc5\xa0\xde\xb5\x25\x8f\x81\x52\x3a\xa1\x25\xa1\x86\xeb\xd9\x00\x1b\x27\x0e\xae\x19\xd1\x1e\x8d\x40\xa7\xd9\xed\x2c\x9d\x0e\x95\x4a\xd4\x62\x05\x70\x09\x4a\x2c\xfe\x0c\x17\xa7\xdc\xb0\xaf\x87\xa7\x2b\x90\xd5\x35\x68\x2a\xb1\x5d\xae\xef\x05\x53\x0f\xdd\x8f\x92\x2f\xe8\x2a\xda\xfc\xbf\x15\xb5\xec\x39\x86\xdb\x36\xff\xe6\x8b\xbf\xdf\x54\x77\xd8\x83\x6a\x8c\xcd\x6a\xb9\x2a\xb1\x95\xa0\x6d\xcb\xe2\x38\xee\x58\x60\x97\xbf\x81\x6b\xa7\x49\x9b\x13\xde\x98\xbc\xcf\x8c\x86\x9c\xcf\x33\xb1\x50\x95\x3e\xf6\xfb\x84\x9e\xf9\x64\x97\xf5\x31\xc5\x68\xdf\x57\x9c\x85\x9d\x6d\x16\xf5\xf7\x4e\xcd\xcf\xa5\x47\xd7\xfc\xd7\xa8\x78\x0f\x00\x00\xff\xff\x82\x42\x75\xa4\x08\x02\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 520, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x18, 0x69, 0xc5, 0xf1, 0xe, 0xc, 0x77, 0xe5, 0x78, 0xce, 0xfc, 0xc2, 0x41, 0xf8, 0x21, 0x87, 0x8a, 0xb7, 0x67, 0xdd, 0x48, 0x94, 0x63, 0x79, 0x69, 0x4e, 0x38, 0x53, 0x3c, 0xdb, 0xc7, 0x13}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
