// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterCSIDriversGetter has a method to return a ClusterCSIDriverInterface.
// A group's client should implement this interface.
type ClusterCSIDriversGetter interface {
	ClusterCSIDrivers() ClusterCSIDriverInterface
}

// ClusterCSIDriverInterface has methods to work with ClusterCSIDriver resources.
type ClusterCSIDriverInterface interface {
	Create(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.CreateOptions) (*v1.ClusterCSIDriver, error)
	Update(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.UpdateOptions) (*v1.ClusterCSIDriver, error)
	UpdateStatus(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.UpdateOptions) (*v1.ClusterCSIDriver, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ClusterCSIDriver, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ClusterCSIDriverList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterCSIDriver, err error)
	ClusterCSIDriverExpansion
}

// clusterCSIDrivers implements ClusterCSIDriverInterface
type clusterCSIDrivers struct {
	client rest.Interface
}

// newClusterCSIDrivers returns a ClusterCSIDrivers
func newClusterCSIDrivers(c *OperatorV1Client) *clusterCSIDrivers {
	return &clusterCSIDrivers{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterCSIDriver, and returns the corresponding clusterCSIDriver object, and an error if there is any.
func (c *clusterCSIDrivers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ClusterCSIDriver, err error) {
	result = &v1.ClusterCSIDriver{}
	err = c.client.Get().
		Resource("clustercsidrivers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterCSIDrivers that match those selectors.
func (c *clusterCSIDrivers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ClusterCSIDriverList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ClusterCSIDriverList{}
	err = c.client.Get().
		Resource("clustercsidrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterCSIDrivers.
func (c *clusterCSIDrivers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clustercsidrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterCSIDriver and creates it.  Returns the server's representation of the clusterCSIDriver, and an error, if there is any.
func (c *clusterCSIDrivers) Create(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.CreateOptions) (result *v1.ClusterCSIDriver, err error) {
	result = &v1.ClusterCSIDriver{}
	err = c.client.Post().
		Resource("clustercsidrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterCSIDriver).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterCSIDriver and updates it. Returns the server's representation of the clusterCSIDriver, and an error, if there is any.
func (c *clusterCSIDrivers) Update(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.UpdateOptions) (result *v1.ClusterCSIDriver, err error) {
	result = &v1.ClusterCSIDriver{}
	err = c.client.Put().
		Resource("clustercsidrivers").
		Name(clusterCSIDriver.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterCSIDriver).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterCSIDrivers) UpdateStatus(ctx context.Context, clusterCSIDriver *v1.ClusterCSIDriver, opts metav1.UpdateOptions) (result *v1.ClusterCSIDriver, err error) {
	result = &v1.ClusterCSIDriver{}
	err = c.client.Put().
		Resource("clustercsidrivers").
		Name(clusterCSIDriver.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterCSIDriver).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterCSIDriver and deletes it. Returns an error if one occurs.
func (c *clusterCSIDrivers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clustercsidrivers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterCSIDrivers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clustercsidrivers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterCSIDriver.
func (c *clusterCSIDrivers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterCSIDriver, err error) {
	result = &v1.ClusterCSIDriver{}
	err = c.client.Patch(pt).
		Resource("clustercsidrivers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
