package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	kubeSystemConfigmapEtcdServingCAFileName = "kube-system-configmap-etcd-serving-ca.yaml.template"
)

var _ asset.WritableAsset = (*KubeSystemConfigmapEtcdServingCA)(nil)

// KubeSystemConfigmapEtcdServingCA is the constant to represent contents of kube-system-configmap-etcd-serving-ca.yaml.template file.
type KubeSystemConfigmapEtcdServingCA struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *KubeSystemConfigmapEtcdServingCA) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *KubeSystemConfigmapEtcdServingCA) Name() string {
	return "KubeSystemConfigmapEtcdServingCA"
}

// Generate generates the actual files by this asset
func (t *KubeSystemConfigmapEtcdServingCA) Generate(parents asset.Parents) error {
	fileName := kubeSystemConfigmapEtcdServingCAFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *KubeSystemConfigmapEtcdServingCA) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *KubeSystemConfigmapEtcdServingCA) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, kubeSystemConfigmapEtcdServingCAFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
