// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VolumesCloneDetail volumes clone detail
// swagger:model VolumesCloneDetail
type VolumesCloneDetail struct {

	// Current action performed for the volumes-clone request
	Action string `json:"action,omitempty"`

	// List of cloned volumes created from the volumes-clone request
	ClonedVolumes []*ClonedVolumeDetail `json:"clonedVolumes"`

	// Creation Date
	// Format: date-time
	CreationDate strfmt.DateTime `json:"creationDate,omitempty"`

	// Failure reason for a failed volumes-clone request
	FailureMessage string `json:"failureMessage,omitempty"`

	// Last Update Date
	// Format: date-time
	LastUpdateDate strfmt.DateTime `json:"lastUpdateDate,omitempty"`

	// Name assigned to a volumes-clone request
	Name string `json:"name,omitempty"`

	// The percent completion for the current action
	// Required: true
	PercentComplete *int64 `json:"percentComplete"`

	// Current status of the volumes-clone request
	Status string `json:"status,omitempty"`

	// ID assigned to a volumes-clone request
	VolumesCloneID string `json:"volumesCloneID,omitempty"`
}

// Validate validates this volumes clone detail
func (m *VolumesCloneDetail) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClonedVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreationDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VolumesCloneDetail) validateClonedVolumes(formats strfmt.Registry) error {

	if swag.IsZero(m.ClonedVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.ClonedVolumes); i++ {
		if swag.IsZero(m.ClonedVolumes[i]) { // not required
			continue
		}

		if m.ClonedVolumes[i] != nil {
			if err := m.ClonedVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("clonedVolumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *VolumesCloneDetail) validateCreationDate(formats strfmt.Registry) error {

	if swag.IsZero(m.CreationDate) { // not required
		return nil
	}

	if err := validate.FormatOf("creationDate", "body", "date-time", m.CreationDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumesCloneDetail) validateLastUpdateDate(formats strfmt.Registry) error {

	if swag.IsZero(m.LastUpdateDate) { // not required
		return nil
	}

	if err := validate.FormatOf("lastUpdateDate", "body", "date-time", m.LastUpdateDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *VolumesCloneDetail) validatePercentComplete(formats strfmt.Registry) error {

	if err := validate.Required("percentComplete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VolumesCloneDetail) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VolumesCloneDetail) UnmarshalBinary(b []byte) error {
	var res VolumesCloneDetail
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
