// Code generated by go-swagger; DO NOT EDIT.

package service_bindings

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewServiceBindingLastOperationGetParams creates a new ServiceBindingLastOperationGetParams object
// with the default values initialized.
func NewServiceBindingLastOperationGetParams() *ServiceBindingLastOperationGetParams {
	var ()
	return &ServiceBindingLastOperationGetParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceBindingLastOperationGetParamsWithTimeout creates a new ServiceBindingLastOperationGetParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceBindingLastOperationGetParamsWithTimeout(timeout time.Duration) *ServiceBindingLastOperationGetParams {
	var ()
	return &ServiceBindingLastOperationGetParams{

		timeout: timeout,
	}
}

// NewServiceBindingLastOperationGetParamsWithContext creates a new ServiceBindingLastOperationGetParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceBindingLastOperationGetParamsWithContext(ctx context.Context) *ServiceBindingLastOperationGetParams {
	var ()
	return &ServiceBindingLastOperationGetParams{

		Context: ctx,
	}
}

// NewServiceBindingLastOperationGetParamsWithHTTPClient creates a new ServiceBindingLastOperationGetParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceBindingLastOperationGetParamsWithHTTPClient(client *http.Client) *ServiceBindingLastOperationGetParams {
	var ()
	return &ServiceBindingLastOperationGetParams{
		HTTPClient: client,
	}
}

/*ServiceBindingLastOperationGetParams contains all the parameters to send to the API endpoint
for the service binding last operation get operation typically these are written to a http.Request
*/
type ServiceBindingLastOperationGetParams struct {

	/*XBrokerAPIVersion
	  version number of the Service Broker API that the Platform will use

	*/
	XBrokerAPIVersion string
	/*BindingID
	  binding id of binding to create

	*/
	BindingID string
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string
	/*Operation
	  a provided identifier for the operation

	*/
	Operation *string
	/*PlanID
	  id of the plan associated with the instance

	*/
	PlanID *string
	/*ServiceID
	  id of the service associated with the instance

	*/
	ServiceID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithTimeout(timeout time.Duration) *ServiceBindingLastOperationGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithContext(ctx context.Context) *ServiceBindingLastOperationGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithHTTPClient(client *http.Client) *ServiceBindingLastOperationGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXBrokerAPIVersion adds the xBrokerAPIVersion to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithXBrokerAPIVersion(xBrokerAPIVersion string) *ServiceBindingLastOperationGetParams {
	o.SetXBrokerAPIVersion(xBrokerAPIVersion)
	return o
}

// SetXBrokerAPIVersion adds the xBrokerApiVersion to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetXBrokerAPIVersion(xBrokerAPIVersion string) {
	o.XBrokerAPIVersion = xBrokerAPIVersion
}

// WithBindingID adds the bindingID to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithBindingID(bindingID string) *ServiceBindingLastOperationGetParams {
	o.SetBindingID(bindingID)
	return o
}

// SetBindingID adds the bindingId to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetBindingID(bindingID string) {
	o.BindingID = bindingID
}

// WithInstanceID adds the instanceID to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithInstanceID(instanceID string) *ServiceBindingLastOperationGetParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WithOperation adds the operation to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithOperation(operation *string) *ServiceBindingLastOperationGetParams {
	o.SetOperation(operation)
	return o
}

// SetOperation adds the operation to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetOperation(operation *string) {
	o.Operation = operation
}

// WithPlanID adds the planID to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithPlanID(planID *string) *ServiceBindingLastOperationGetParams {
	o.SetPlanID(planID)
	return o
}

// SetPlanID adds the planId to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetPlanID(planID *string) {
	o.PlanID = planID
}

// WithServiceID adds the serviceID to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) WithServiceID(serviceID *string) *ServiceBindingLastOperationGetParams {
	o.SetServiceID(serviceID)
	return o
}

// SetServiceID adds the serviceId to the service binding last operation get params
func (o *ServiceBindingLastOperationGetParams) SetServiceID(serviceID *string) {
	o.ServiceID = serviceID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceBindingLastOperationGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// header param X-Broker-API-Version
	if err := r.SetHeaderParam("X-Broker-API-Version", o.XBrokerAPIVersion); err != nil {
		return err
	}

	// path param binding_id
	if err := r.SetPathParam("binding_id", o.BindingID); err != nil {
		return err
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if o.Operation != nil {

		// query param operation
		var qrOperation string
		if o.Operation != nil {
			qrOperation = *o.Operation
		}
		qOperation := qrOperation
		if qOperation != "" {
			if err := r.SetQueryParam("operation", qOperation); err != nil {
				return err
			}
		}

	}

	if o.PlanID != nil {

		// query param plan_id
		var qrPlanID string
		if o.PlanID != nil {
			qrPlanID = *o.PlanID
		}
		qPlanID := qrPlanID
		if qPlanID != "" {
			if err := r.SetQueryParam("plan_id", qPlanID); err != nil {
				return err
			}
		}

	}

	if o.ServiceID != nil {

		// query param service_id
		var qrServiceID string
		if o.ServiceID != nil {
			qrServiceID = *o.ServiceID
		}
		qServiceID := qrServiceID
		if qServiceID != "" {
			if err := r.SetQueryParam("service_id", qServiceID); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
