// Code generated by go-swagger; DO NOT EDIT.

package authentication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewServiceBrokerAuthRegistrationParams creates a new ServiceBrokerAuthRegistrationParams object
// with the default values initialized.
func NewServiceBrokerAuthRegistrationParams() *ServiceBrokerAuthRegistrationParams {
	var ()
	return &ServiceBrokerAuthRegistrationParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceBrokerAuthRegistrationParamsWithTimeout creates a new ServiceBrokerAuthRegistrationParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceBrokerAuthRegistrationParamsWithTimeout(timeout time.Duration) *ServiceBrokerAuthRegistrationParams {
	var ()
	return &ServiceBrokerAuthRegistrationParams{

		timeout: timeout,
	}
}

// NewServiceBrokerAuthRegistrationParamsWithContext creates a new ServiceBrokerAuthRegistrationParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceBrokerAuthRegistrationParamsWithContext(ctx context.Context) *ServiceBrokerAuthRegistrationParams {
	var ()
	return &ServiceBrokerAuthRegistrationParams{

		Context: ctx,
	}
}

// NewServiceBrokerAuthRegistrationParamsWithHTTPClient creates a new ServiceBrokerAuthRegistrationParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceBrokerAuthRegistrationParamsWithHTTPClient(client *http.Client) *ServiceBrokerAuthRegistrationParams {
	var ()
	return &ServiceBrokerAuthRegistrationParams{
		HTTPClient: client,
	}
}

/*ServiceBrokerAuthRegistrationParams contains all the parameters to send to the API endpoint
for the service broker auth registration operation typically these are written to a http.Request
*/
type ServiceBrokerAuthRegistrationParams struct {

	/*EntitlementID
	  Entitlement ID of for this tenant

	*/
	EntitlementID string
	/*Icn
	  IBM Customer Number (ICN) for this tenant

	*/
	Icn string
	/*Plan
	  Plan for this tenant and entitlement

	*/
	Plan string
	/*RedirectURL
	  The URL to redirect to after login/registration

	*/
	RedirectURL *string
	/*Regions
	  An array of regions matching the number of cloud-instances in the plan

	*/
	Regions []string
	/*TenantID
	  Tenant ID of a pcloud tenant

	*/
	TenantID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithTimeout(timeout time.Duration) *ServiceBrokerAuthRegistrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithContext(ctx context.Context) *ServiceBrokerAuthRegistrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithHTTPClient(client *http.Client) *ServiceBrokerAuthRegistrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEntitlementID adds the entitlementID to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithEntitlementID(entitlementID string) *ServiceBrokerAuthRegistrationParams {
	o.SetEntitlementID(entitlementID)
	return o
}

// SetEntitlementID adds the entitlementId to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetEntitlementID(entitlementID string) {
	o.EntitlementID = entitlementID
}

// WithIcn adds the icn to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithIcn(icn string) *ServiceBrokerAuthRegistrationParams {
	o.SetIcn(icn)
	return o
}

// SetIcn adds the icn to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetIcn(icn string) {
	o.Icn = icn
}

// WithPlan adds the plan to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithPlan(plan string) *ServiceBrokerAuthRegistrationParams {
	o.SetPlan(plan)
	return o
}

// SetPlan adds the plan to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetPlan(plan string) {
	o.Plan = plan
}

// WithRedirectURL adds the redirectURL to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithRedirectURL(redirectURL *string) *ServiceBrokerAuthRegistrationParams {
	o.SetRedirectURL(redirectURL)
	return o
}

// SetRedirectURL adds the redirectUrl to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetRedirectURL(redirectURL *string) {
	o.RedirectURL = redirectURL
}

// WithRegions adds the regions to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithRegions(regions []string) *ServiceBrokerAuthRegistrationParams {
	o.SetRegions(regions)
	return o
}

// SetRegions adds the regions to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetRegions(regions []string) {
	o.Regions = regions
}

// WithTenantID adds the tenantID to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) WithTenantID(tenantID string) *ServiceBrokerAuthRegistrationParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the service broker auth registration params
func (o *ServiceBrokerAuthRegistrationParams) SetTenantID(tenantID string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceBrokerAuthRegistrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param entitlement_id
	qrEntitlementID := o.EntitlementID
	qEntitlementID := qrEntitlementID
	if qEntitlementID != "" {
		if err := r.SetQueryParam("entitlement_id", qEntitlementID); err != nil {
			return err
		}
	}

	// query param icn
	qrIcn := o.Icn
	qIcn := qrIcn
	if qIcn != "" {
		if err := r.SetQueryParam("icn", qIcn); err != nil {
			return err
		}
	}

	// query param plan
	qrPlan := o.Plan
	qPlan := qrPlan
	if qPlan != "" {
		if err := r.SetQueryParam("plan", qPlan); err != nil {
			return err
		}
	}

	if o.RedirectURL != nil {

		// query param redirect_url
		var qrRedirectURL string
		if o.RedirectURL != nil {
			qrRedirectURL = *o.RedirectURL
		}
		qRedirectURL := qrRedirectURL
		if qRedirectURL != "" {
			if err := r.SetQueryParam("redirect_url", qRedirectURL); err != nil {
				return err
			}
		}

	}

	valuesRegions := o.Regions

	joinedRegions := swag.JoinByFormat(valuesRegions, "")
	// query array param regions
	if err := r.SetQueryParam("regions", joinedRegions...); err != nil {
		return err
	}

	// query param tenant_id
	qrTenantID := o.TenantID
	qTenantID := qrTenantID
	if qTenantID != "" {
		if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
