// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceCode device code
// swagger:model DeviceCode
type DeviceCode struct {

	// This code lets the device running the app securely determine whether the user has granted or denied access
	// Required: true
	DeviceCode *string `json:"deviceCode"`

	// The length of time, in seconds, that the device_code and user_code are valid
	// Required: true
	ExpiresIn *float64 `json:"expiresIn"`

	// The length of time, in seconds, that your device should wait between polling requests
	// Required: true
	Interval *float64 `json:"interval"`

	// The value given to the user to enter on device authentication page
	// Required: true
	UserCode *string `json:"userCode"`

	// A URL that the user must navigate to, on a separate device, to enter the user_code and grant or deny access to your application. Your user interface will also display this value
	// Required: true
	VerificationURL *string `json:"verificationURL"`
}

// Validate validates this device code
func (m *DeviceCode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDeviceCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiresIn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerificationURL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceCode) validateDeviceCode(formats strfmt.Registry) error {

	if err := validate.Required("deviceCode", "body", m.DeviceCode); err != nil {
		return err
	}

	return nil
}

func (m *DeviceCode) validateExpiresIn(formats strfmt.Registry) error {

	if err := validate.Required("expiresIn", "body", m.ExpiresIn); err != nil {
		return err
	}

	return nil
}

func (m *DeviceCode) validateInterval(formats strfmt.Registry) error {

	if err := validate.Required("interval", "body", m.Interval); err != nil {
		return err
	}

	return nil
}

func (m *DeviceCode) validateUserCode(formats strfmt.Registry) error {

	if err := validate.Required("userCode", "body", m.UserCode); err != nil {
		return err
	}

	return nil
}

func (m *DeviceCode) validateVerificationURL(formats strfmt.Registry) error {

	if err := validate.Required("verificationURL", "body", m.VerificationURL); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceCode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceCode) UnmarshalBinary(b []byte) error {
	var res DeviceCode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
