package synapse

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLPoolVulnerabilityAssessmentScansClient is the azure Synapse Analytics Management Client
type SQLPoolVulnerabilityAssessmentScansClient struct {
	BaseClient
}

// NewSQLPoolVulnerabilityAssessmentScansClient creates an instance of the SQLPoolVulnerabilityAssessmentScansClient
// client.
func NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI creates an instance of the
// SQLPoolVulnerabilityAssessmentScansClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return SQLPoolVulnerabilityAssessmentScansClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Export convert an existing scan result to a human readable format. If already exists nothing happens
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace
// SQLPoolName - SQL pool name
// scanID - the vulnerability assessment scan Id of the scan to retrieve.
func (client SQLPoolVulnerabilityAssessmentScansClient) Export(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (result SQLPoolVulnerabilityAssessmentScansExport, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentScansClient.Export")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.SQLPoolVulnerabilityAssessmentScansClient", "Export", err.Error())
	}

	req, err := client.ExportPreparer(ctx, resourceGroupName, workspaceName, SQLPoolName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Export", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExportSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Export", resp, "Failure sending request")
		return
	}

	result, err = client.ExportResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Export", resp, "Failure responding to request")
		return
	}

	return
}

// ExportPreparer prepares the Export request.
func (client SQLPoolVulnerabilityAssessmentScansClient) ExportPreparer(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"sqlPoolName":                 autorest.Encode("path", SQLPoolName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
		"workspaceName":               autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExportSender sends the Export request. The method will close the
// http.Response Body if it receives an error.
func (client SQLPoolVulnerabilityAssessmentScansClient) ExportSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ExportResponder handles the response to the Export request. The method always
// closes the http.Response Body.
func (client SQLPoolVulnerabilityAssessmentScansClient) ExportResponder(resp *http.Response) (result SQLPoolVulnerabilityAssessmentScansExport, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets a vulnerability assessment scan record of a Sql pool.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace
// SQLPoolName - SQL pool name
// scanID - the vulnerability assessment scan Id of the scan to retrieve.
func (client SQLPoolVulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (result VulnerabilityAssessmentScanRecord, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentScansClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.SQLPoolVulnerabilityAssessmentScansClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, workspaceName, SQLPoolName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SQLPoolVulnerabilityAssessmentScansClient) GetPreparer(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"sqlPoolName":                 autorest.Encode("path", SQLPoolName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
		"workspaceName":               autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SQLPoolVulnerabilityAssessmentScansClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SQLPoolVulnerabilityAssessmentScansClient) GetResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecord, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InitiateScan executes a Vulnerability Assessment database scan.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace
// SQLPoolName - SQL pool name
// scanID - the vulnerability assessment scan Id of the scan to retrieve.
func (client SQLPoolVulnerabilityAssessmentScansClient) InitiateScan(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (result SQLPoolVulnerabilityAssessmentScansInitiateScanFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentScansClient.InitiateScan")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.SQLPoolVulnerabilityAssessmentScansClient", "InitiateScan", err.Error())
	}

	req, err := client.InitiateScanPreparer(ctx, resourceGroupName, workspaceName, SQLPoolName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "InitiateScan", nil, "Failure preparing request")
		return
	}

	result, err = client.InitiateScanSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "InitiateScan", nil, "Failure sending request")
		return
	}

	return
}

// InitiateScanPreparer prepares the InitiateScan request.
func (client SQLPoolVulnerabilityAssessmentScansClient) InitiateScanPreparer(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"sqlPoolName":                 autorest.Encode("path", SQLPoolName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
		"workspaceName":               autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InitiateScanSender sends the InitiateScan request. The method will close the
// http.Response Body if it receives an error.
func (client SQLPoolVulnerabilityAssessmentScansClient) InitiateScanSender(req *http.Request) (future SQLPoolVulnerabilityAssessmentScansInitiateScanFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SQLPoolVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// InitiateScanResponder handles the response to the InitiateScan request. The method always
// closes the http.Response Body.
func (client SQLPoolVulnerabilityAssessmentScansClient) InitiateScanResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// List lists the vulnerability assessment scans of a SQL pool.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace
// SQLPoolName - SQL pool name
func (client SQLPoolVulnerabilityAssessmentScansClient) List(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string) (result VulnerabilityAssessmentScanRecordListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentScansClient.List")
		defer func() {
			sc := -1
			if result.vasrlr.Response.Response != nil {
				sc = result.vasrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.SQLPoolVulnerabilityAssessmentScansClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, workspaceName, SQLPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vasrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "List", resp, "Failure sending request")
		return
	}

	result.vasrlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "List", resp, "Failure responding to request")
		return
	}
	if result.vasrlr.hasNextLink() && result.vasrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client SQLPoolVulnerabilityAssessmentScansClient) ListPreparer(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"sqlPoolName":                 autorest.Encode("path", SQLPoolName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
		"workspaceName":               autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SQLPoolVulnerabilityAssessmentScansClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SQLPoolVulnerabilityAssessmentScansClient) ListResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecordListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client SQLPoolVulnerabilityAssessmentScansClient) listNextResults(ctx context.Context, lastResults VulnerabilityAssessmentScanRecordListResult) (result VulnerabilityAssessmentScanRecordListResult, err error) {
	req, err := lastResults.vulnerabilityAssessmentScanRecordListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client SQLPoolVulnerabilityAssessmentScansClient) ListComplete(ctx context.Context, resourceGroupName string, workspaceName string, SQLPoolName string) (result VulnerabilityAssessmentScanRecordListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentScansClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, workspaceName, SQLPoolName)
	return
}
