package azfile

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/base64"
	"encoding/xml"
	"errors"
	"io"
	"net/http"
	"reflect"
	"strconv"
	"strings"
	"time"
	"unsafe"
)

// ETag is an entity tag.
type ETag string

const (
	// ETagNone represents an empty entity tag.
	ETagNone ETag = ""

	// ETagAny matches any entity tag.
	ETagAny ETag = "*"
)

// Metadata contains metadata key/value pairs.
type Metadata map[string]string

const mdPrefix = "x-ms-meta-"

const mdPrefixLen = len(mdPrefix)

// UnmarshalXML implements the xml.Unmarshaler interface for Metadata.
func (md *Metadata) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	tokName := ""
	for t, err := d.Token(); err == nil; t, err = d.Token() {
		switch tt := t.(type) {
		case xml.StartElement:
			tokName = strings.ToLower(tt.Name.Local)
			break
		case xml.CharData:
			if *md == nil {
				*md = Metadata{}
			}
			(*md)[tokName] = string(tt)
			break
		}
	}
	return nil
}

// Marker represents an opaque value used in paged responses.
type Marker struct {
	Val *string
}

// NotDone returns true if the list enumeration should be started or is not yet complete. Specifically, NotDone returns true
// for a just-initialized (zero value) Marker indicating that you should make an initial request to get a result portion from
// the service. NotDone also returns true whenever the service returns an interim result portion. NotDone returns false only
// after the service has returned the final result portion.
func (m Marker) NotDone() bool {
	return m.Val == nil || *m.Val != ""
}

// UnmarshalXML implements the xml.Unmarshaler interface for Marker.
func (m *Marker) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	var out string
	err := d.DecodeElement(&out, &start)
	m.Val = &out
	return err
}

// concatenates a slice of const values with the specified separator between each item
func joinConst(s interface{}, sep string) string {
	v := reflect.ValueOf(s)
	if v.Kind() != reflect.Slice && v.Kind() != reflect.Array {
		panic("s wasn't a slice or array")
	}
	ss := make([]string, 0, v.Len())
	for i := 0; i < v.Len(); i++ {
		ss = append(ss, v.Index(i).String())
	}
	return strings.Join(ss, sep)
}

func validateError(err error) {
	if err != nil {
		panic(err)
	}
}

// CopyStatusType enumerates the values for copy status type.
type CopyStatusType string

const (
	// CopyStatusAborted ...
	CopyStatusAborted CopyStatusType = "aborted"
	// CopyStatusFailed ...
	CopyStatusFailed CopyStatusType = "failed"
	// CopyStatusNone represents an empty CopyStatusType.
	CopyStatusNone CopyStatusType = ""
	// CopyStatusPending ...
	CopyStatusPending CopyStatusType = "pending"
	// CopyStatusSuccess ...
	CopyStatusSuccess CopyStatusType = "success"
)

// PossibleCopyStatusTypeValues returns an array of possible values for the CopyStatusType const type.
func PossibleCopyStatusTypeValues() []CopyStatusType {
	return []CopyStatusType{CopyStatusAborted, CopyStatusFailed, CopyStatusNone, CopyStatusPending, CopyStatusSuccess}
}

// DeleteSnapshotsOptionType enumerates the values for delete snapshots option type.
type DeleteSnapshotsOptionType string

const (
	// DeleteSnapshotsOptionInclude ...
	DeleteSnapshotsOptionInclude DeleteSnapshotsOptionType = "include"
	// DeleteSnapshotsOptionNone represents an empty DeleteSnapshotsOptionType.
	DeleteSnapshotsOptionNone DeleteSnapshotsOptionType = ""
)

// PossibleDeleteSnapshotsOptionTypeValues returns an array of possible values for the DeleteSnapshotsOptionType const type.
func PossibleDeleteSnapshotsOptionTypeValues() []DeleteSnapshotsOptionType {
	return []DeleteSnapshotsOptionType{DeleteSnapshotsOptionInclude, DeleteSnapshotsOptionNone}
}

// FileRangeWriteType enumerates the values for file range write type.
type FileRangeWriteType string

const (
	// FileRangeWriteClear ...
	FileRangeWriteClear FileRangeWriteType = "clear"
	// FileRangeWriteNone represents an empty FileRangeWriteType.
	FileRangeWriteNone FileRangeWriteType = ""
	// FileRangeWriteUpdate ...
	FileRangeWriteUpdate FileRangeWriteType = "update"
)

// PossibleFileRangeWriteTypeValues returns an array of possible values for the FileRangeWriteType const type.
func PossibleFileRangeWriteTypeValues() []FileRangeWriteType {
	return []FileRangeWriteType{FileRangeWriteClear, FileRangeWriteNone, FileRangeWriteUpdate}
}

// ListSharesIncludeType enumerates the values for list shares include type.
type ListSharesIncludeType string

const (
	// ListSharesIncludeMetadata ...
	ListSharesIncludeMetadata ListSharesIncludeType = "metadata"
	// ListSharesIncludeNone represents an empty ListSharesIncludeType.
	ListSharesIncludeNone ListSharesIncludeType = ""
	// ListSharesIncludeSnapshots ...
	ListSharesIncludeSnapshots ListSharesIncludeType = "snapshots"
)

// PossibleListSharesIncludeTypeValues returns an array of possible values for the ListSharesIncludeType const type.
func PossibleListSharesIncludeTypeValues() []ListSharesIncludeType {
	return []ListSharesIncludeType{ListSharesIncludeMetadata, ListSharesIncludeNone, ListSharesIncludeSnapshots}
}

// StorageErrorCodeType enumerates the values for storage error code type.
type StorageErrorCodeType string

const (
	// StorageErrorCodeAccountAlreadyExists ...
	StorageErrorCodeAccountAlreadyExists StorageErrorCodeType = "AccountAlreadyExists"
	// StorageErrorCodeAccountBeingCreated ...
	StorageErrorCodeAccountBeingCreated StorageErrorCodeType = "AccountBeingCreated"
	// StorageErrorCodeAccountIsDisabled ...
	StorageErrorCodeAccountIsDisabled StorageErrorCodeType = "AccountIsDisabled"
	// StorageErrorCodeAuthenticationFailed ...
	StorageErrorCodeAuthenticationFailed StorageErrorCodeType = "AuthenticationFailed"
	// StorageErrorCodeAuthorizationFailure ...
	StorageErrorCodeAuthorizationFailure StorageErrorCodeType = "AuthorizationFailure"
	// StorageErrorCodeAuthorizationPermissionMismatch ...
	StorageErrorCodeAuthorizationPermissionMismatch StorageErrorCodeType = "AuthorizationPermissionMismatch"
	// StorageErrorCodeAuthorizationProtocolMismatch ...
	StorageErrorCodeAuthorizationProtocolMismatch StorageErrorCodeType = "AuthorizationProtocolMismatch"
	// StorageErrorCodeAuthorizationResourceTypeMismatch ...
	StorageErrorCodeAuthorizationResourceTypeMismatch StorageErrorCodeType = "AuthorizationResourceTypeMismatch"
	// StorageErrorCodeAuthorizationServiceMismatch ...
	StorageErrorCodeAuthorizationServiceMismatch StorageErrorCodeType = "AuthorizationServiceMismatch"
	// StorageErrorCodeAuthorizationSourceIPMismatch ...
	StorageErrorCodeAuthorizationSourceIPMismatch StorageErrorCodeType = "AuthorizationSourceIPMismatch"
	// StorageErrorCodeCannotDeleteFileOrDirectory ...
	StorageErrorCodeCannotDeleteFileOrDirectory StorageErrorCodeType = "CannotDeleteFileOrDirectory"
	// StorageErrorCodeClientCacheFlushDelay ...
	StorageErrorCodeClientCacheFlushDelay StorageErrorCodeType = "ClientCacheFlushDelay"
	// StorageErrorCodeConditionHeadersNotSupported ...
	StorageErrorCodeConditionHeadersNotSupported StorageErrorCodeType = "ConditionHeadersNotSupported"
	// StorageErrorCodeConditionNotMet ...
	StorageErrorCodeConditionNotMet StorageErrorCodeType = "ConditionNotMet"
	// StorageErrorCodeContainerQuotaDowngradeNotAllowed ...
	StorageErrorCodeContainerQuotaDowngradeNotAllowed StorageErrorCodeType = "ContainerQuotaDowngradeNotAllowed"
	// StorageErrorCodeDeletePending ...
	StorageErrorCodeDeletePending StorageErrorCodeType = "DeletePending"
	// StorageErrorCodeDirectoryNotEmpty ...
	StorageErrorCodeDirectoryNotEmpty StorageErrorCodeType = "DirectoryNotEmpty"
	// StorageErrorCodeEmptyMetadataKey ...
	StorageErrorCodeEmptyMetadataKey StorageErrorCodeType = "EmptyMetadataKey"
	// StorageErrorCodeFeatureVersionMismatch ...
	StorageErrorCodeFeatureVersionMismatch StorageErrorCodeType = "FeatureVersionMismatch"
	// StorageErrorCodeFileLockConflict ...
	StorageErrorCodeFileLockConflict StorageErrorCodeType = "FileLockConflict"
	// StorageErrorCodeInsufficientAccountPermissions ...
	StorageErrorCodeInsufficientAccountPermissions StorageErrorCodeType = "InsufficientAccountPermissions"
	// StorageErrorCodeInternalError ...
	StorageErrorCodeInternalError StorageErrorCodeType = "InternalError"
	// StorageErrorCodeInvalidAuthenticationInfo ...
	StorageErrorCodeInvalidAuthenticationInfo StorageErrorCodeType = "InvalidAuthenticationInfo"
	// StorageErrorCodeInvalidFileOrDirectoryPathName ...
	StorageErrorCodeInvalidFileOrDirectoryPathName StorageErrorCodeType = "InvalidFileOrDirectoryPathName"
	// StorageErrorCodeInvalidHeaderValue ...
	StorageErrorCodeInvalidHeaderValue StorageErrorCodeType = "InvalidHeaderValue"
	// StorageErrorCodeInvalidHTTPVerb ...
	StorageErrorCodeInvalidHTTPVerb StorageErrorCodeType = "InvalidHttpVerb"
	// StorageErrorCodeInvalidInput ...
	StorageErrorCodeInvalidInput StorageErrorCodeType = "InvalidInput"
	// StorageErrorCodeInvalidMd5 ...
	StorageErrorCodeInvalidMd5 StorageErrorCodeType = "InvalidMd5"
	// StorageErrorCodeInvalidMetadata ...
	StorageErrorCodeInvalidMetadata StorageErrorCodeType = "InvalidMetadata"
	// StorageErrorCodeInvalidQueryParameterValue ...
	StorageErrorCodeInvalidQueryParameterValue StorageErrorCodeType = "InvalidQueryParameterValue"
	// StorageErrorCodeInvalidRange ...
	StorageErrorCodeInvalidRange StorageErrorCodeType = "InvalidRange"
	// StorageErrorCodeInvalidResourceName ...
	StorageErrorCodeInvalidResourceName StorageErrorCodeType = "InvalidResourceName"
	// StorageErrorCodeInvalidURI ...
	StorageErrorCodeInvalidURI StorageErrorCodeType = "InvalidUri"
	// StorageErrorCodeInvalidXMLDocument ...
	StorageErrorCodeInvalidXMLDocument StorageErrorCodeType = "InvalidXmlDocument"
	// StorageErrorCodeInvalidXMLNodeValue ...
	StorageErrorCodeInvalidXMLNodeValue StorageErrorCodeType = "InvalidXmlNodeValue"
	// StorageErrorCodeMd5Mismatch ...
	StorageErrorCodeMd5Mismatch StorageErrorCodeType = "Md5Mismatch"
	// StorageErrorCodeMetadataTooLarge ...
	StorageErrorCodeMetadataTooLarge StorageErrorCodeType = "MetadataTooLarge"
	// StorageErrorCodeMissingContentLengthHeader ...
	StorageErrorCodeMissingContentLengthHeader StorageErrorCodeType = "MissingContentLengthHeader"
	// StorageErrorCodeMissingRequiredHeader ...
	StorageErrorCodeMissingRequiredHeader StorageErrorCodeType = "MissingRequiredHeader"
	// StorageErrorCodeMissingRequiredQueryParameter ...
	StorageErrorCodeMissingRequiredQueryParameter StorageErrorCodeType = "MissingRequiredQueryParameter"
	// StorageErrorCodeMissingRequiredXMLNode ...
	StorageErrorCodeMissingRequiredXMLNode StorageErrorCodeType = "MissingRequiredXmlNode"
	// StorageErrorCodeMultipleConditionHeadersNotSupported ...
	StorageErrorCodeMultipleConditionHeadersNotSupported StorageErrorCodeType = "MultipleConditionHeadersNotSupported"
	// StorageErrorCodeNone represents an empty StorageErrorCodeType.
	StorageErrorCodeNone StorageErrorCodeType = ""
	// StorageErrorCodeOperationTimedOut ...
	StorageErrorCodeOperationTimedOut StorageErrorCodeType = "OperationTimedOut"
	// StorageErrorCodeOutOfRangeInput ...
	StorageErrorCodeOutOfRangeInput StorageErrorCodeType = "OutOfRangeInput"
	// StorageErrorCodeOutOfRangeQueryParameterValue ...
	StorageErrorCodeOutOfRangeQueryParameterValue StorageErrorCodeType = "OutOfRangeQueryParameterValue"
	// StorageErrorCodeParentNotFound ...
	StorageErrorCodeParentNotFound StorageErrorCodeType = "ParentNotFound"
	// StorageErrorCodeReadOnlyAttribute ...
	StorageErrorCodeReadOnlyAttribute StorageErrorCodeType = "ReadOnlyAttribute"
	// StorageErrorCodeRequestBodyTooLarge ...
	StorageErrorCodeRequestBodyTooLarge StorageErrorCodeType = "RequestBodyTooLarge"
	// StorageErrorCodeRequestURLFailedToParse ...
	StorageErrorCodeRequestURLFailedToParse StorageErrorCodeType = "RequestUrlFailedToParse"
	// StorageErrorCodeResourceAlreadyExists ...
	StorageErrorCodeResourceAlreadyExists StorageErrorCodeType = "ResourceAlreadyExists"
	// StorageErrorCodeResourceNotFound ...
	StorageErrorCodeResourceNotFound StorageErrorCodeType = "ResourceNotFound"
	// StorageErrorCodeResourceTypeMismatch ...
	StorageErrorCodeResourceTypeMismatch StorageErrorCodeType = "ResourceTypeMismatch"
	// StorageErrorCodeServerBusy ...
	StorageErrorCodeServerBusy StorageErrorCodeType = "ServerBusy"
	// StorageErrorCodeShareAlreadyExists ...
	StorageErrorCodeShareAlreadyExists StorageErrorCodeType = "ShareAlreadyExists"
	// StorageErrorCodeShareBeingDeleted ...
	StorageErrorCodeShareBeingDeleted StorageErrorCodeType = "ShareBeingDeleted"
	// StorageErrorCodeShareDisabled ...
	StorageErrorCodeShareDisabled StorageErrorCodeType = "ShareDisabled"
	// StorageErrorCodeShareHasSnapshots ...
	StorageErrorCodeShareHasSnapshots StorageErrorCodeType = "ShareHasSnapshots"
	// StorageErrorCodeShareNotFound ...
	StorageErrorCodeShareNotFound StorageErrorCodeType = "ShareNotFound"
	// StorageErrorCodeShareSnapshotCountExceeded ...
	StorageErrorCodeShareSnapshotCountExceeded StorageErrorCodeType = "ShareSnapshotCountExceeded"
	// StorageErrorCodeShareSnapshotInProgress ...
	StorageErrorCodeShareSnapshotInProgress StorageErrorCodeType = "ShareSnapshotInProgress"
	// StorageErrorCodeShareSnapshotOperationNotSupported ...
	StorageErrorCodeShareSnapshotOperationNotSupported StorageErrorCodeType = "ShareSnapshotOperationNotSupported"
	// StorageErrorCodeSharingViolation ...
	StorageErrorCodeSharingViolation StorageErrorCodeType = "SharingViolation"
	// StorageErrorCodeUnsupportedHeader ...
	StorageErrorCodeUnsupportedHeader StorageErrorCodeType = "UnsupportedHeader"
	// StorageErrorCodeUnsupportedHTTPVerb ...
	StorageErrorCodeUnsupportedHTTPVerb StorageErrorCodeType = "UnsupportedHttpVerb"
	// StorageErrorCodeUnsupportedQueryParameter ...
	StorageErrorCodeUnsupportedQueryParameter StorageErrorCodeType = "UnsupportedQueryParameter"
	// StorageErrorCodeUnsupportedXMLNode ...
	StorageErrorCodeUnsupportedXMLNode StorageErrorCodeType = "UnsupportedXmlNode"
)

// PossibleStorageErrorCodeTypeValues returns an array of possible values for the StorageErrorCodeType const type.
func PossibleStorageErrorCodeTypeValues() []StorageErrorCodeType {
	return []StorageErrorCodeType{StorageErrorCodeAccountAlreadyExists, StorageErrorCodeAccountBeingCreated, StorageErrorCodeAccountIsDisabled, StorageErrorCodeAuthenticationFailed, StorageErrorCodeAuthorizationFailure, StorageErrorCodeAuthorizationPermissionMismatch, StorageErrorCodeAuthorizationProtocolMismatch, StorageErrorCodeAuthorizationResourceTypeMismatch, StorageErrorCodeAuthorizationServiceMismatch, StorageErrorCodeAuthorizationSourceIPMismatch, StorageErrorCodeCannotDeleteFileOrDirectory, StorageErrorCodeClientCacheFlushDelay, StorageErrorCodeConditionHeadersNotSupported, StorageErrorCodeConditionNotMet, StorageErrorCodeContainerQuotaDowngradeNotAllowed, StorageErrorCodeDeletePending, StorageErrorCodeDirectoryNotEmpty, StorageErrorCodeEmptyMetadataKey, StorageErrorCodeFeatureVersionMismatch, StorageErrorCodeFileLockConflict, StorageErrorCodeInsufficientAccountPermissions, StorageErrorCodeInternalError, StorageErrorCodeInvalidAuthenticationInfo, StorageErrorCodeInvalidFileOrDirectoryPathName, StorageErrorCodeInvalidHeaderValue, StorageErrorCodeInvalidHTTPVerb, StorageErrorCodeInvalidInput, StorageErrorCodeInvalidMd5, StorageErrorCodeInvalidMetadata, StorageErrorCodeInvalidQueryParameterValue, StorageErrorCodeInvalidRange, StorageErrorCodeInvalidResourceName, StorageErrorCodeInvalidURI, StorageErrorCodeInvalidXMLDocument, StorageErrorCodeInvalidXMLNodeValue, StorageErrorCodeMd5Mismatch, StorageErrorCodeMetadataTooLarge, StorageErrorCodeMissingContentLengthHeader, StorageErrorCodeMissingRequiredHeader, StorageErrorCodeMissingRequiredQueryParameter, StorageErrorCodeMissingRequiredXMLNode, StorageErrorCodeMultipleConditionHeadersNotSupported, StorageErrorCodeNone, StorageErrorCodeOperationTimedOut, StorageErrorCodeOutOfRangeInput, StorageErrorCodeOutOfRangeQueryParameterValue, StorageErrorCodeParentNotFound, StorageErrorCodeReadOnlyAttribute, StorageErrorCodeRequestBodyTooLarge, StorageErrorCodeRequestURLFailedToParse, StorageErrorCodeResourceAlreadyExists, StorageErrorCodeResourceNotFound, StorageErrorCodeResourceTypeMismatch, StorageErrorCodeServerBusy, StorageErrorCodeShareAlreadyExists, StorageErrorCodeShareBeingDeleted, StorageErrorCodeShareDisabled, StorageErrorCodeShareHasSnapshots, StorageErrorCodeShareNotFound, StorageErrorCodeShareSnapshotCountExceeded, StorageErrorCodeShareSnapshotInProgress, StorageErrorCodeShareSnapshotOperationNotSupported, StorageErrorCodeSharingViolation, StorageErrorCodeUnsupportedHeader, StorageErrorCodeUnsupportedHTTPVerb, StorageErrorCodeUnsupportedQueryParameter, StorageErrorCodeUnsupportedXMLNode}
}

// AccessPolicy - An Access policy.
type AccessPolicy struct {
	// Start - The date-time the policy is active.
	Start *time.Time `xml:"Start"`
	// Expiry - The date-time the policy expires.
	Expiry *time.Time `xml:"Expiry"`
	// Permission - The permissions for the ACL policy.
	Permission *string `xml:"Permission"`
}

// MarshalXML implements the xml.Marshaler interface for AccessPolicy.
func (ap AccessPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	ap2 := (*accessPolicy)(unsafe.Pointer(&ap))
	return e.EncodeElement(*ap2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for AccessPolicy.
func (ap *AccessPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	ap2 := (*accessPolicy)(unsafe.Pointer(ap))
	return d.DecodeElement(ap2, &start)
}

// CorsRule - CORS is an HTTP feature that enables a web application running under one domain to access
// resources in another domain. Web browsers implement a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain
// (the origin domain) to call APIs in another domain.
type CorsRule struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the storage service via CORS. The origin domain is the domain from which the request originates. Note that the origin must be an exact case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains to make requests via CORS.
	AllowedOrigins string `xml:"AllowedOrigins"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods string `xml:"AllowedMethods"`
	// AllowedHeaders - The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders string `xml:"AllowedHeaders"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
	ExposedHeaders string `xml:"ExposedHeaders"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds int32 `xml:"MaxAgeInSeconds"`
}

// DirectoryCreateResponse ...
type DirectoryCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (dcr DirectoryCreateResponse) Response() *http.Response {
	return dcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dcr DirectoryCreateResponse) StatusCode() int {
	return dcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dcr DirectoryCreateResponse) Status() string {
	return dcr.rawResponse.Status
}

// Date returns the value for header Date.
func (dcr DirectoryCreateResponse) Date() time.Time {
	s := dcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dcr DirectoryCreateResponse) ErrorCode() string {
	return dcr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (dcr DirectoryCreateResponse) ETag() ETag {
	return ETag(dcr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (dcr DirectoryCreateResponse) FileAttributes() string {
	return dcr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (dcr DirectoryCreateResponse) FileChangeTime() string {
	return dcr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (dcr DirectoryCreateResponse) FileCreationTime() string {
	return dcr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (dcr DirectoryCreateResponse) FileID() string {
	return dcr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (dcr DirectoryCreateResponse) FileLastWriteTime() string {
	return dcr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (dcr DirectoryCreateResponse) FileParentID() string {
	return dcr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (dcr DirectoryCreateResponse) FilePermissionKey() string {
	return dcr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (dcr DirectoryCreateResponse) IsServerEncrypted() string {
	return dcr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (dcr DirectoryCreateResponse) LastModified() time.Time {
	s := dcr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (dcr DirectoryCreateResponse) RequestID() string {
	return dcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dcr DirectoryCreateResponse) Version() string {
	return dcr.rawResponse.Header.Get("x-ms-version")
}

// DirectoryDeleteResponse ...
type DirectoryDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ddr DirectoryDeleteResponse) Response() *http.Response {
	return ddr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ddr DirectoryDeleteResponse) StatusCode() int {
	return ddr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ddr DirectoryDeleteResponse) Status() string {
	return ddr.rawResponse.Status
}

// Date returns the value for header Date.
func (ddr DirectoryDeleteResponse) Date() time.Time {
	s := ddr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ddr DirectoryDeleteResponse) ErrorCode() string {
	return ddr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (ddr DirectoryDeleteResponse) RequestID() string {
	return ddr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ddr DirectoryDeleteResponse) Version() string {
	return ddr.rawResponse.Header.Get("x-ms-version")
}

// DirectoryForceCloseHandlesResponse ...
type DirectoryForceCloseHandlesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (dfchr DirectoryForceCloseHandlesResponse) Response() *http.Response {
	return dfchr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dfchr DirectoryForceCloseHandlesResponse) StatusCode() int {
	return dfchr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dfchr DirectoryForceCloseHandlesResponse) Status() string {
	return dfchr.rawResponse.Status
}

// Date returns the value for header Date.
func (dfchr DirectoryForceCloseHandlesResponse) Date() time.Time {
	s := dfchr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dfchr DirectoryForceCloseHandlesResponse) ErrorCode() string {
	return dfchr.rawResponse.Header.Get("x-ms-error-code")
}

// Marker returns the value for header x-ms-marker.
func (dfchr DirectoryForceCloseHandlesResponse) Marker() string {
	return dfchr.rawResponse.Header.Get("x-ms-marker")
}

// NumberOfHandlesClosed returns the value for header x-ms-number-of-handles-closed.
func (dfchr DirectoryForceCloseHandlesResponse) NumberOfHandlesClosed() int32 {
	s := dfchr.rawResponse.Header.Get("x-ms-number-of-handles-closed")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		i = 0
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (dfchr DirectoryForceCloseHandlesResponse) RequestID() string {
	return dfchr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dfchr DirectoryForceCloseHandlesResponse) Version() string {
	return dfchr.rawResponse.Header.Get("x-ms-version")
}

// DirectoryGetPropertiesResponse ...
type DirectoryGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (dgpr DirectoryGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range dgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (dgpr DirectoryGetPropertiesResponse) Response() *http.Response {
	return dgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dgpr DirectoryGetPropertiesResponse) StatusCode() int {
	return dgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dgpr DirectoryGetPropertiesResponse) Status() string {
	return dgpr.rawResponse.Status
}

// Date returns the value for header Date.
func (dgpr DirectoryGetPropertiesResponse) Date() time.Time {
	s := dgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dgpr DirectoryGetPropertiesResponse) ErrorCode() string {
	return dgpr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (dgpr DirectoryGetPropertiesResponse) ETag() ETag {
	return ETag(dgpr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (dgpr DirectoryGetPropertiesResponse) FileAttributes() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (dgpr DirectoryGetPropertiesResponse) FileChangeTime() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (dgpr DirectoryGetPropertiesResponse) FileCreationTime() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (dgpr DirectoryGetPropertiesResponse) FileID() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (dgpr DirectoryGetPropertiesResponse) FileLastWriteTime() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (dgpr DirectoryGetPropertiesResponse) FileParentID() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (dgpr DirectoryGetPropertiesResponse) FilePermissionKey() string {
	return dgpr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (dgpr DirectoryGetPropertiesResponse) IsServerEncrypted() string {
	return dgpr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (dgpr DirectoryGetPropertiesResponse) LastModified() time.Time {
	s := dgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (dgpr DirectoryGetPropertiesResponse) RequestID() string {
	return dgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dgpr DirectoryGetPropertiesResponse) Version() string {
	return dgpr.rawResponse.Header.Get("x-ms-version")
}

// DirectoryItem - A listed directory item.
//type DirectoryItem struct {
//	// XMLName is used for marshalling and is subject to removal in a future release.
//	XMLName xml.Name `xml:"Directory"`
//	Name    string   `xml:"Name"`
//}

// DirectorySetMetadataResponse ...
type DirectorySetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (dsmr DirectorySetMetadataResponse) Response() *http.Response {
	return dsmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dsmr DirectorySetMetadataResponse) StatusCode() int {
	return dsmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dsmr DirectorySetMetadataResponse) Status() string {
	return dsmr.rawResponse.Status
}

// Date returns the value for header Date.
func (dsmr DirectorySetMetadataResponse) Date() time.Time {
	s := dsmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dsmr DirectorySetMetadataResponse) ErrorCode() string {
	return dsmr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (dsmr DirectorySetMetadataResponse) ETag() ETag {
	return ETag(dsmr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (dsmr DirectorySetMetadataResponse) IsServerEncrypted() string {
	return dsmr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// RequestID returns the value for header x-ms-request-id.
func (dsmr DirectorySetMetadataResponse) RequestID() string {
	return dsmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dsmr DirectorySetMetadataResponse) Version() string {
	return dsmr.rawResponse.Header.Get("x-ms-version")
}

// DirectorySetPropertiesResponse ...
type DirectorySetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (dspr DirectorySetPropertiesResponse) Response() *http.Response {
	return dspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dspr DirectorySetPropertiesResponse) StatusCode() int {
	return dspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dspr DirectorySetPropertiesResponse) Status() string {
	return dspr.rawResponse.Status
}

// Date returns the value for header Date.
func (dspr DirectorySetPropertiesResponse) Date() time.Time {
	s := dspr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dspr DirectorySetPropertiesResponse) ErrorCode() string {
	return dspr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (dspr DirectorySetPropertiesResponse) ETag() ETag {
	return ETag(dspr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (dspr DirectorySetPropertiesResponse) FileAttributes() string {
	return dspr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (dspr DirectorySetPropertiesResponse) FileChangeTime() string {
	return dspr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (dspr DirectorySetPropertiesResponse) FileCreationTime() string {
	return dspr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (dspr DirectorySetPropertiesResponse) FileID() string {
	return dspr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (dspr DirectorySetPropertiesResponse) FileLastWriteTime() string {
	return dspr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (dspr DirectorySetPropertiesResponse) FileParentID() string {
	return dspr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (dspr DirectorySetPropertiesResponse) FilePermissionKey() string {
	return dspr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (dspr DirectorySetPropertiesResponse) IsServerEncrypted() string {
	return dspr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (dspr DirectorySetPropertiesResponse) LastModified() time.Time {
	s := dspr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (dspr DirectorySetPropertiesResponse) RequestID() string {
	return dspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dspr DirectorySetPropertiesResponse) Version() string {
	return dspr.rawResponse.Header.Get("x-ms-version")
}

// DownloadResponse - Wraps the response from the fileClient.Download method.
type DownloadResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (dr DownloadResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range dr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (dr DownloadResponse) Response() *http.Response {
	return dr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dr DownloadResponse) StatusCode() int {
	return dr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dr DownloadResponse) Status() string {
	return dr.rawResponse.Status
}

// Body returns the raw HTTP response object's Body.
func (dr DownloadResponse) Body() io.ReadCloser {
	return dr.rawResponse.Body
}

// AcceptRanges returns the value for header Accept-Ranges.
func (dr DownloadResponse) AcceptRanges() string {
	return dr.rawResponse.Header.Get("Accept-Ranges")
}

// CacheControl returns the value for header Cache-Control.
func (dr DownloadResponse) CacheControl() string {
	return dr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (dr DownloadResponse) ContentDisposition() string {
	return dr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (dr DownloadResponse) ContentEncoding() string {
	return dr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (dr DownloadResponse) ContentLanguage() string {
	return dr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (dr DownloadResponse) ContentLength() int64 {
	s := dr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		i = 0
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (dr DownloadResponse) ContentMD5() []byte {
	s := dr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		b = nil
	}
	return b
}

// ContentRange returns the value for header Content-Range.
func (dr DownloadResponse) ContentRange() string {
	return dr.rawResponse.Header.Get("Content-Range")
}

// ContentType returns the value for header Content-Type.
func (dr DownloadResponse) ContentType() string {
	return dr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (dr DownloadResponse) CopyCompletionTime() time.Time {
	s := dr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (dr DownloadResponse) CopyID() string {
	return dr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (dr DownloadResponse) CopyProgress() string {
	return dr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (dr DownloadResponse) CopySource() string {
	return dr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (dr DownloadResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(dr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (dr DownloadResponse) CopyStatusDescription() string {
	return dr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (dr DownloadResponse) Date() time.Time {
	s := dr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (dr DownloadResponse) ErrorCode() string {
	return dr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (dr DownloadResponse) ETag() ETag {
	return ETag(dr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (dr DownloadResponse) FileAttributes() string {
	return dr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (dr DownloadResponse) FileChangeTime() string {
	return dr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileContentMD5 returns the value for header x-ms-content-md5.
func (dr DownloadResponse) FileContentMD5() []byte {
	s := dr.rawResponse.Header.Get("x-ms-content-md5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		b = nil
	}
	return b
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (dr DownloadResponse) FileCreationTime() string {
	return dr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (dr DownloadResponse) FileID() string {
	return dr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (dr DownloadResponse) FileLastWriteTime() string {
	return dr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (dr DownloadResponse) FileParentID() string {
	return dr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (dr DownloadResponse) FilePermissionKey() string {
	return dr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (dr DownloadResponse) IsServerEncrypted() string {
	return dr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (dr DownloadResponse) LastModified() time.Time {
	s := dr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (dr DownloadResponse) RequestID() string {
	return dr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dr DownloadResponse) Version() string {
	return dr.rawResponse.Header.Get("x-ms-version")
}

// FileAbortCopyResponse ...
type FileAbortCopyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (facr FileAbortCopyResponse) Response() *http.Response {
	return facr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (facr FileAbortCopyResponse) StatusCode() int {
	return facr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (facr FileAbortCopyResponse) Status() string {
	return facr.rawResponse.Status
}

// Date returns the value for header Date.
func (facr FileAbortCopyResponse) Date() time.Time {
	s := facr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (facr FileAbortCopyResponse) ErrorCode() string {
	return facr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (facr FileAbortCopyResponse) RequestID() string {
	return facr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (facr FileAbortCopyResponse) Version() string {
	return facr.rawResponse.Header.Get("x-ms-version")
}

// FileCreateResponse ...
type FileCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (fcr FileCreateResponse) Response() *http.Response {
	return fcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fcr FileCreateResponse) StatusCode() int {
	return fcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fcr FileCreateResponse) Status() string {
	return fcr.rawResponse.Status
}

// Date returns the value for header Date.
func (fcr FileCreateResponse) Date() time.Time {
	s := fcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fcr FileCreateResponse) ErrorCode() string {
	return fcr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (fcr FileCreateResponse) ETag() ETag {
	return ETag(fcr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (fcr FileCreateResponse) FileAttributes() string {
	return fcr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (fcr FileCreateResponse) FileChangeTime() string {
	return fcr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (fcr FileCreateResponse) FileCreationTime() string {
	return fcr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (fcr FileCreateResponse) FileID() string {
	return fcr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (fcr FileCreateResponse) FileLastWriteTime() string {
	return fcr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (fcr FileCreateResponse) FileParentID() string {
	return fcr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (fcr FileCreateResponse) FilePermissionKey() string {
	return fcr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (fcr FileCreateResponse) IsServerEncrypted() string {
	return fcr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (fcr FileCreateResponse) LastModified() time.Time {
	s := fcr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (fcr FileCreateResponse) RequestID() string {
	return fcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fcr FileCreateResponse) Version() string {
	return fcr.rawResponse.Header.Get("x-ms-version")
}

// FileDeleteResponse ...
type FileDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (fdr FileDeleteResponse) Response() *http.Response {
	return fdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fdr FileDeleteResponse) StatusCode() int {
	return fdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fdr FileDeleteResponse) Status() string {
	return fdr.rawResponse.Status
}

// Date returns the value for header Date.
func (fdr FileDeleteResponse) Date() time.Time {
	s := fdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fdr FileDeleteResponse) ErrorCode() string {
	return fdr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (fdr FileDeleteResponse) RequestID() string {
	return fdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fdr FileDeleteResponse) Version() string {
	return fdr.rawResponse.Header.Get("x-ms-version")
}

// FileForceCloseHandlesResponse ...
type FileForceCloseHandlesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ffchr FileForceCloseHandlesResponse) Response() *http.Response {
	return ffchr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ffchr FileForceCloseHandlesResponse) StatusCode() int {
	return ffchr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ffchr FileForceCloseHandlesResponse) Status() string {
	return ffchr.rawResponse.Status
}

// Date returns the value for header Date.
func (ffchr FileForceCloseHandlesResponse) Date() time.Time {
	s := ffchr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ffchr FileForceCloseHandlesResponse) ErrorCode() string {
	return ffchr.rawResponse.Header.Get("x-ms-error-code")
}

// Marker returns the value for header x-ms-marker.
func (ffchr FileForceCloseHandlesResponse) Marker() string {
	return ffchr.rawResponse.Header.Get("x-ms-marker")
}

// NumberOfHandlesClosed returns the value for header x-ms-number-of-handles-closed.
func (ffchr FileForceCloseHandlesResponse) NumberOfHandlesClosed() int32 {
	s := ffchr.rawResponse.Header.Get("x-ms-number-of-handles-closed")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		i = 0
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (ffchr FileForceCloseHandlesResponse) RequestID() string {
	return ffchr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ffchr FileForceCloseHandlesResponse) Version() string {
	return ffchr.rawResponse.Header.Get("x-ms-version")
}

// FileGetPropertiesResponse ...
type FileGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (fgpr FileGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range fgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (fgpr FileGetPropertiesResponse) Response() *http.Response {
	return fgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fgpr FileGetPropertiesResponse) StatusCode() int {
	return fgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fgpr FileGetPropertiesResponse) Status() string {
	return fgpr.rawResponse.Status
}

// CacheControl returns the value for header Cache-Control.
func (fgpr FileGetPropertiesResponse) CacheControl() string {
	return fgpr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (fgpr FileGetPropertiesResponse) ContentDisposition() string {
	return fgpr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (fgpr FileGetPropertiesResponse) ContentEncoding() string {
	return fgpr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (fgpr FileGetPropertiesResponse) ContentLanguage() string {
	return fgpr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (fgpr FileGetPropertiesResponse) ContentLength() int64 {
	s := fgpr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		i = 0
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (fgpr FileGetPropertiesResponse) ContentMD5() []byte {
	s := fgpr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		b = nil
	}
	return b
}

// ContentType returns the value for header Content-Type.
func (fgpr FileGetPropertiesResponse) ContentType() string {
	return fgpr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (fgpr FileGetPropertiesResponse) CopyCompletionTime() time.Time {
	s := fgpr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (fgpr FileGetPropertiesResponse) CopyID() string {
	return fgpr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (fgpr FileGetPropertiesResponse) CopyProgress() string {
	return fgpr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (fgpr FileGetPropertiesResponse) CopySource() string {
	return fgpr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (fgpr FileGetPropertiesResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(fgpr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (fgpr FileGetPropertiesResponse) CopyStatusDescription() string {
	return fgpr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (fgpr FileGetPropertiesResponse) Date() time.Time {
	s := fgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fgpr FileGetPropertiesResponse) ErrorCode() string {
	return fgpr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (fgpr FileGetPropertiesResponse) ETag() ETag {
	return ETag(fgpr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (fgpr FileGetPropertiesResponse) FileAttributes() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (fgpr FileGetPropertiesResponse) FileChangeTime() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (fgpr FileGetPropertiesResponse) FileCreationTime() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (fgpr FileGetPropertiesResponse) FileID() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (fgpr FileGetPropertiesResponse) FileLastWriteTime() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (fgpr FileGetPropertiesResponse) FileParentID() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (fgpr FileGetPropertiesResponse) FilePermissionKey() string {
	return fgpr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// FileType returns the value for header x-ms-type.
func (fgpr FileGetPropertiesResponse) FileType() string {
	return string(fgpr.rawResponse.Header.Get("x-ms-type"))
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (fgpr FileGetPropertiesResponse) IsServerEncrypted() string {
	return fgpr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (fgpr FileGetPropertiesResponse) LastModified() time.Time {
	s := fgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (fgpr FileGetPropertiesResponse) RequestID() string {
	return fgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fgpr FileGetPropertiesResponse) Version() string {
	return fgpr.rawResponse.Header.Get("x-ms-version")
}

// FileItem - A listed file item.
//type FileItem struct {
//	// XMLName is used for marshalling and is subject to removal in a future release.
//	XMLName    xml.Name     `xml:"File"`
//	Name       string       `xml:"Name"`
//	Properties FileProperty `xml:"Properties"`
//}

// FileProperty - File properties.
type FileProperty struct {
	// ContentLength - Content length of the file. This value may not be up-to-date since an SMB client may have modified the file locally. The value of Content-Length may not reflect that fact until the handle is closed or the op-lock is broken. To retrieve current property values, call Get File Properties.
	ContentLength int64 `xml:"Content-Length"`
}

// FilesAndDirectoriesListSegment - Abstract for entries that can be listed from Directory.
type FilesAndDirectoriesListSegment struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName        xml.Name        `xml:"Entries"`
	DirectoryItems []DirectoryItem `xml:"Directory"`
	FileItems      []FileItem      `xml:"File"`
}

// FileSetHTTPHeadersResponse ...
type FileSetHTTPHeadersResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (fshhr FileSetHTTPHeadersResponse) Response() *http.Response {
	return fshhr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fshhr FileSetHTTPHeadersResponse) StatusCode() int {
	return fshhr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fshhr FileSetHTTPHeadersResponse) Status() string {
	return fshhr.rawResponse.Status
}

// Date returns the value for header Date.
func (fshhr FileSetHTTPHeadersResponse) Date() time.Time {
	s := fshhr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fshhr FileSetHTTPHeadersResponse) ErrorCode() string {
	return fshhr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (fshhr FileSetHTTPHeadersResponse) ETag() ETag {
	return ETag(fshhr.rawResponse.Header.Get("ETag"))
}

// FileAttributes returns the value for header x-ms-file-attributes.
func (fshhr FileSetHTTPHeadersResponse) FileAttributes() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-attributes")
}

// FileChangeTime returns the value for header x-ms-file-change-time.
func (fshhr FileSetHTTPHeadersResponse) FileChangeTime() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-change-time")
}

// FileCreationTime returns the value for header x-ms-file-creation-time.
func (fshhr FileSetHTTPHeadersResponse) FileCreationTime() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-creation-time")
}

// FileID returns the value for header x-ms-file-id.
func (fshhr FileSetHTTPHeadersResponse) FileID() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-id")
}

// FileLastWriteTime returns the value for header x-ms-file-last-write-time.
func (fshhr FileSetHTTPHeadersResponse) FileLastWriteTime() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-last-write-time")
}

// FileParentID returns the value for header x-ms-file-parent-id.
func (fshhr FileSetHTTPHeadersResponse) FileParentID() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-parent-id")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (fshhr FileSetHTTPHeadersResponse) FilePermissionKey() string {
	return fshhr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (fshhr FileSetHTTPHeadersResponse) IsServerEncrypted() string {
	return fshhr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (fshhr FileSetHTTPHeadersResponse) LastModified() time.Time {
	s := fshhr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (fshhr FileSetHTTPHeadersResponse) RequestID() string {
	return fshhr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fshhr FileSetHTTPHeadersResponse) Version() string {
	return fshhr.rawResponse.Header.Get("x-ms-version")
}

// FileSetMetadataResponse ...
type FileSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (fsmr FileSetMetadataResponse) Response() *http.Response {
	return fsmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fsmr FileSetMetadataResponse) StatusCode() int {
	return fsmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fsmr FileSetMetadataResponse) Status() string {
	return fsmr.rawResponse.Status
}

// Date returns the value for header Date.
func (fsmr FileSetMetadataResponse) Date() time.Time {
	s := fsmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fsmr FileSetMetadataResponse) ErrorCode() string {
	return fsmr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (fsmr FileSetMetadataResponse) ETag() ETag {
	return ETag(fsmr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (fsmr FileSetMetadataResponse) IsServerEncrypted() string {
	return fsmr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// RequestID returns the value for header x-ms-request-id.
func (fsmr FileSetMetadataResponse) RequestID() string {
	return fsmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fsmr FileSetMetadataResponse) Version() string {
	return fsmr.rawResponse.Header.Get("x-ms-version")
}

// FileStartCopyResponse ...
type FileStartCopyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (fscr FileStartCopyResponse) Response() *http.Response {
	return fscr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (fscr FileStartCopyResponse) StatusCode() int {
	return fscr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (fscr FileStartCopyResponse) Status() string {
	return fscr.rawResponse.Status
}

// CopyID returns the value for header x-ms-copy-id.
func (fscr FileStartCopyResponse) CopyID() string {
	return fscr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (fscr FileStartCopyResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(fscr.rawResponse.Header.Get("x-ms-copy-status"))
}

// Date returns the value for header Date.
func (fscr FileStartCopyResponse) Date() time.Time {
	s := fscr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (fscr FileStartCopyResponse) ErrorCode() string {
	return fscr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (fscr FileStartCopyResponse) ETag() ETag {
	return ETag(fscr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (fscr FileStartCopyResponse) LastModified() time.Time {
	s := fscr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (fscr FileStartCopyResponse) RequestID() string {
	return fscr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (fscr FileStartCopyResponse) Version() string {
	return fscr.rawResponse.Header.Get("x-ms-version")
}

// FileUploadRangeFromURLResponse ...
type FileUploadRangeFromURLResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (furfur FileUploadRangeFromURLResponse) Response() *http.Response {
	return furfur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (furfur FileUploadRangeFromURLResponse) StatusCode() int {
	return furfur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (furfur FileUploadRangeFromURLResponse) Status() string {
	return furfur.rawResponse.Status
}

// Date returns the value for header Date.
func (furfur FileUploadRangeFromURLResponse) Date() time.Time {
	s := furfur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (furfur FileUploadRangeFromURLResponse) ErrorCode() string {
	return furfur.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (furfur FileUploadRangeFromURLResponse) ETag() ETag {
	return ETag(furfur.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (furfur FileUploadRangeFromURLResponse) IsServerEncrypted() string {
	return furfur.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (furfur FileUploadRangeFromURLResponse) LastModified() time.Time {
	s := furfur.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (furfur FileUploadRangeFromURLResponse) RequestID() string {
	return furfur.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (furfur FileUploadRangeFromURLResponse) Version() string {
	return furfur.rawResponse.Header.Get("x-ms-version")
}

// XMsContentCrc64 returns the value for header x-ms-content-crc64.
func (furfur FileUploadRangeFromURLResponse) XMsContentCrc64() []byte {
	s := furfur.rawResponse.Header.Get("x-ms-content-crc64")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		b = nil
	}
	return b
}

// FileUploadRangeResponse ...
type FileUploadRangeResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (furr FileUploadRangeResponse) Response() *http.Response {
	return furr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (furr FileUploadRangeResponse) StatusCode() int {
	return furr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (furr FileUploadRangeResponse) Status() string {
	return furr.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (furr FileUploadRangeResponse) ContentMD5() []byte {
	s := furr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		b = nil
	}
	return b
}

// Date returns the value for header Date.
func (furr FileUploadRangeResponse) Date() time.Time {
	s := furr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (furr FileUploadRangeResponse) ErrorCode() string {
	return furr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (furr FileUploadRangeResponse) ETag() ETag {
	return ETag(furr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (furr FileUploadRangeResponse) IsServerEncrypted() string {
	return furr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (furr FileUploadRangeResponse) LastModified() time.Time {
	s := furr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (furr FileUploadRangeResponse) RequestID() string {
	return furr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (furr FileUploadRangeResponse) Version() string {
	return furr.rawResponse.Header.Get("x-ms-version")
}

// HandleItem - A listed Azure Storage handle item.
type HandleItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name `xml:"Handle"`
	// HandleID - XSMB service handle ID
	HandleID string `xml:"HandleId"`
	// Path - File or directory name including full path starting from share root
	Path string `xml:"Path"`
	// FileID - FileId uniquely identifies the file or directory.
	FileID string `xml:"FileId"`
	// ParentID - ParentId uniquely identifies the parent directory of the object.
	ParentID *string `xml:"ParentId"`
	// SessionID - SMB session ID in context of which the file handle was opened
	SessionID string `xml:"SessionId"`
	// ClientIP - Client IP that opened the handle
	ClientIP string `xml:"ClientIp"`
	// OpenTime - Time when the session that previously opened the handle has last been reconnected. (UTC)
	OpenTime time.Time `xml:"OpenTime"`
	// LastReconnectTime - Time handle was last connected to (UTC)
	LastReconnectTime *time.Time `xml:"LastReconnectTime"`
}

// MarshalXML implements the xml.Marshaler interface for HandleItem.
func (hi HandleItem) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	hi2 := (*handleItem)(unsafe.Pointer(&hi))
	return e.EncodeElement(*hi2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for HandleItem.
func (hi *HandleItem) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	hi2 := (*handleItem)(unsafe.Pointer(hi))
	return d.DecodeElement(hi2, &start)
}

//// ListFilesAndDirectoriesSegmentResponse - An enumeration of directories and files.
//type ListFilesAndDirectoriesSegmentResponse struct {
//	rawResponse *http.Response
//	// XMLName is used for marshalling and is subject to removal in a future release.
//	XMLName         xml.Name                       `xml:"EnumerationResults"`
//	ServiceEndpoint string                         `xml:"ServiceEndpoint,attr"`
//	ShareName       string                         `xml:"ShareName,attr"`
//	ShareSnapshot   *string                        `xml:"ShareSnapshot,attr"`
//	DirectoryPath   string                         `xml:"DirectoryPath,attr"`
//	Prefix          string                         `xml:"Prefix"`
//	Marker          *string                        `xml:"Marker"`
//	MaxResults      *int32                         `xml:"MaxResults"`
//	Segment         FilesAndDirectoriesListSegment `xml:"Entries"`
//	NextMarker      Marker                         `xml:"NextMarker"`
//}
//
//// Response returns the raw HTTP response object.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) Response() *http.Response {
//	return lfadsr.rawResponse
//}
//
//// StatusCode returns the HTTP status code of the response, e.g. 200.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) StatusCode() int {
//	return lfadsr.rawResponse.StatusCode
//}
//
//// Status returns the HTTP status message of the response, e.g. "200 OK".
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) Status() string {
//	return lfadsr.rawResponse.Status
//}
//
//// ContentType returns the value for header Content-Type.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) ContentType() string {
//	return lfadsr.rawResponse.Header.Get("Content-Type")
//}
//
//// Date returns the value for header Date.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) Date() time.Time {
//	s := lfadsr.rawResponse.Header.Get("Date")
//	if s == "" {
//		return time.Time{}
//	}
//	t, err := time.Parse(time.RFC1123, s)
//	if err != nil {
//		t = time.Time{}
//	}
//	return t
//}
//
//// ErrorCode returns the value for header x-ms-error-code.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) ErrorCode() string {
//	return lfadsr.rawResponse.Header.Get("x-ms-error-code")
//}
//
//// RequestID returns the value for header x-ms-request-id.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) RequestID() string {
//	return lfadsr.rawResponse.Header.Get("x-ms-request-id")
//}
//
//// Version returns the value for header x-ms-version.
//func (lfadsr ListFilesAndDirectoriesSegmentResponse) Version() string {
//	return lfadsr.rawResponse.Header.Get("x-ms-version")
//}

// ListHandlesResponse - An enumeration of handles.
type ListHandlesResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName    xml.Name     `xml:"EnumerationResults"`
	HandleList []HandleItem `xml:"Entries>Handle"`
	NextMarker string       `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lhr ListHandlesResponse) Response() *http.Response {
	return lhr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lhr ListHandlesResponse) StatusCode() int {
	return lhr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lhr ListHandlesResponse) Status() string {
	return lhr.rawResponse.Status
}

// ContentType returns the value for header Content-Type.
func (lhr ListHandlesResponse) ContentType() string {
	return lhr.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (lhr ListHandlesResponse) Date() time.Time {
	s := lhr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (lhr ListHandlesResponse) ErrorCode() string {
	return lhr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (lhr ListHandlesResponse) RequestID() string {
	return lhr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lhr ListHandlesResponse) Version() string {
	return lhr.rawResponse.Header.Get("x-ms-version")
}

// ListSharesResponse - An enumeration of shares.
type ListSharesResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"EnumerationResults"`
	ServiceEndpoint string      `xml:"ServiceEndpoint,attr"`
	Prefix          *string     `xml:"Prefix"`
	Marker          *string     `xml:"Marker"`
	MaxResults      *int32      `xml:"MaxResults"`
	ShareItems      []ShareItem `xml:"Shares>Share"`
	NextMarker      Marker      `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lsr ListSharesResponse) Response() *http.Response {
	return lsr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lsr ListSharesResponse) StatusCode() int {
	return lsr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lsr ListSharesResponse) Status() string {
	return lsr.rawResponse.Status
}

// ErrorCode returns the value for header x-ms-error-code.
func (lsr ListSharesResponse) ErrorCode() string {
	return lsr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (lsr ListSharesResponse) RequestID() string {
	return lsr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lsr ListSharesResponse) Version() string {
	return lsr.rawResponse.Header.Get("x-ms-version")
}

// Metrics - Storage Analytics metrics for file service.
type Metrics struct {
	// Version - The version of Storage Analytics to configure.
	Version string `xml:"Version"`
	// Enabled - Indicates whether metrics are enabled for the File service.
	Enabled bool `xml:"Enabled"`
	// IncludeAPIs - Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs     *bool            `xml:"IncludeAPIs"`
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`
}

// Range - An Azure Storage file range.
type Range struct {
	// Start - Start of the range.
	Start int64 `xml:"Start"`
	// End - End of the range.
	End int64 `xml:"End"`
}

// Ranges - Wraps the response from the fileClient.GetRangeList method.
type Ranges struct {
	rawResponse *http.Response
	Items       []Range `xml:"Range"`
}

// Response returns the raw HTTP response object.
func (r Ranges) Response() *http.Response {
	return r.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (r Ranges) StatusCode() int {
	return r.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (r Ranges) Status() string {
	return r.rawResponse.Status
}

// Date returns the value for header Date.
func (r Ranges) Date() time.Time {
	s := r.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (r Ranges) ErrorCode() string {
	return r.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (r Ranges) ETag() ETag {
	return ETag(r.rawResponse.Header.Get("ETag"))
}

// FileContentLength returns the value for header x-ms-content-length.
func (r Ranges) FileContentLength() int64 {
	s := r.rawResponse.Header.Get("x-ms-content-length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		i = 0
	}
	return i
}

// LastModified returns the value for header Last-Modified.
func (r Ranges) LastModified() time.Time {
	s := r.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (r Ranges) RequestID() string {
	return r.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (r Ranges) Version() string {
	return r.rawResponse.Header.Get("x-ms-version")
}

// RetentionPolicy - The retention policy.
type RetentionPolicy struct {
	// Enabled - Indicates whether a retention policy is enabled for the File service. If false, metrics data is retained, and the user is responsible for deleting it.
	Enabled bool `xml:"Enabled"`
	// Days - Indicates the number of days that metrics data should be retained. All data older than this value will be deleted. Metrics data is deleted on a best-effort basis after the retention period expires.
	Days *int32 `xml:"Days"`
}

// ServiceSetPropertiesResponse ...
type ServiceSetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (sspr ServiceSetPropertiesResponse) Response() *http.Response {
	return sspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sspr ServiceSetPropertiesResponse) StatusCode() int {
	return sspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sspr ServiceSetPropertiesResponse) Status() string {
	return sspr.rawResponse.Status
}

// ErrorCode returns the value for header x-ms-error-code.
func (sspr ServiceSetPropertiesResponse) ErrorCode() string {
	return sspr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (sspr ServiceSetPropertiesResponse) RequestID() string {
	return sspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sspr ServiceSetPropertiesResponse) Version() string {
	return sspr.rawResponse.Header.Get("x-ms-version")
}

// ShareCreatePermissionResponse ...
type ShareCreatePermissionResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (scpr ShareCreatePermissionResponse) Response() *http.Response {
	return scpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (scpr ShareCreatePermissionResponse) StatusCode() int {
	return scpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (scpr ShareCreatePermissionResponse) Status() string {
	return scpr.rawResponse.Status
}

// Date returns the value for header Date.
func (scpr ShareCreatePermissionResponse) Date() time.Time {
	s := scpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (scpr ShareCreatePermissionResponse) ErrorCode() string {
	return scpr.rawResponse.Header.Get("x-ms-error-code")
}

// FilePermissionKey returns the value for header x-ms-file-permission-key.
func (scpr ShareCreatePermissionResponse) FilePermissionKey() string {
	return scpr.rawResponse.Header.Get("x-ms-file-permission-key")
}

// RequestID returns the value for header x-ms-request-id.
func (scpr ShareCreatePermissionResponse) RequestID() string {
	return scpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (scpr ShareCreatePermissionResponse) Version() string {
	return scpr.rawResponse.Header.Get("x-ms-version")
}

// ShareCreateResponse ...
type ShareCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (scr ShareCreateResponse) Response() *http.Response {
	return scr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (scr ShareCreateResponse) StatusCode() int {
	return scr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (scr ShareCreateResponse) Status() string {
	return scr.rawResponse.Status
}

// Date returns the value for header Date.
func (scr ShareCreateResponse) Date() time.Time {
	s := scr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (scr ShareCreateResponse) ErrorCode() string {
	return scr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (scr ShareCreateResponse) ETag() ETag {
	return ETag(scr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (scr ShareCreateResponse) LastModified() time.Time {
	s := scr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (scr ShareCreateResponse) RequestID() string {
	return scr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (scr ShareCreateResponse) Version() string {
	return scr.rawResponse.Header.Get("x-ms-version")
}

// ShareCreateSnapshotResponse ...
type ShareCreateSnapshotResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (scsr ShareCreateSnapshotResponse) Response() *http.Response {
	return scsr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (scsr ShareCreateSnapshotResponse) StatusCode() int {
	return scsr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (scsr ShareCreateSnapshotResponse) Status() string {
	return scsr.rawResponse.Status
}

// Date returns the value for header Date.
func (scsr ShareCreateSnapshotResponse) Date() time.Time {
	s := scsr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (scsr ShareCreateSnapshotResponse) ErrorCode() string {
	return scsr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (scsr ShareCreateSnapshotResponse) ETag() ETag {
	return ETag(scsr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (scsr ShareCreateSnapshotResponse) LastModified() time.Time {
	s := scsr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (scsr ShareCreateSnapshotResponse) RequestID() string {
	return scsr.rawResponse.Header.Get("x-ms-request-id")
}

// Snapshot returns the value for header x-ms-snapshot.
func (scsr ShareCreateSnapshotResponse) Snapshot() string {
	return scsr.rawResponse.Header.Get("x-ms-snapshot")
}

// Version returns the value for header x-ms-version.
func (scsr ShareCreateSnapshotResponse) Version() string {
	return scsr.rawResponse.Header.Get("x-ms-version")
}

// ShareDeleteResponse ...
type ShareDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (sdr ShareDeleteResponse) Response() *http.Response {
	return sdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sdr ShareDeleteResponse) StatusCode() int {
	return sdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sdr ShareDeleteResponse) Status() string {
	return sdr.rawResponse.Status
}

// Date returns the value for header Date.
func (sdr ShareDeleteResponse) Date() time.Time {
	s := sdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (sdr ShareDeleteResponse) ErrorCode() string {
	return sdr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (sdr ShareDeleteResponse) RequestID() string {
	return sdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sdr ShareDeleteResponse) Version() string {
	return sdr.rawResponse.Header.Get("x-ms-version")
}

// ShareGetPropertiesResponse ...
type ShareGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (sgpr ShareGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range sgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (sgpr ShareGetPropertiesResponse) Response() *http.Response {
	return sgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sgpr ShareGetPropertiesResponse) StatusCode() int {
	return sgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sgpr ShareGetPropertiesResponse) Status() string {
	return sgpr.rawResponse.Status
}

// Date returns the value for header Date.
func (sgpr ShareGetPropertiesResponse) Date() time.Time {
	s := sgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (sgpr ShareGetPropertiesResponse) ErrorCode() string {
	return sgpr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (sgpr ShareGetPropertiesResponse) ETag() ETag {
	return ETag(sgpr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (sgpr ShareGetPropertiesResponse) LastModified() time.Time {
	s := sgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// Quota returns the value for header x-ms-share-quota.
func (sgpr ShareGetPropertiesResponse) Quota() int32 {
	s := sgpr.rawResponse.Header.Get("x-ms-share-quota")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		i = 0
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (sgpr ShareGetPropertiesResponse) RequestID() string {
	return sgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sgpr ShareGetPropertiesResponse) Version() string {
	return sgpr.rawResponse.Header.Get("x-ms-version")
}

// ShareItem - A listed Azure Storage share item.
type ShareItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName    xml.Name        `xml:"Share"`
	Name       string          `xml:"Name"`
	Snapshot   *string         `xml:"Snapshot"`
	Properties ShareProperties `xml:"Properties"`
	Metadata   Metadata        `xml:"Metadata"`
}

// SharePermission - A permission (a security descriptor) at the share level.
type SharePermission struct {
	rawResponse *http.Response
	// Permission - The permission in the Security Descriptor Definition Language (SDDL).
	Permission string
}

// Response returns the raw HTTP response object.
func (sp SharePermission) Response() *http.Response {
	return sp.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sp SharePermission) StatusCode() int {
	return sp.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sp SharePermission) Status() string {
	return sp.rawResponse.Status
}

// Date returns the value for header Date.
func (sp SharePermission) Date() time.Time {
	s := sp.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (sp SharePermission) ErrorCode() string {
	return sp.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (sp SharePermission) RequestID() string {
	return sp.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sp SharePermission) Version() string {
	return sp.rawResponse.Header.Get("x-ms-version")
}

// ShareProperties - Properties of a share.
type ShareProperties struct {
	LastModified time.Time `xml:"Last-Modified"`
	Etag         ETag      `xml:"Etag"`
	Quota        int32     `xml:"Quota"`
}

// MarshalXML implements the xml.Marshaler interface for ShareProperties.
func (sp ShareProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	sp2 := (*shareProperties)(unsafe.Pointer(&sp))
	return e.EncodeElement(*sp2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for ShareProperties.
func (sp *ShareProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	sp2 := (*shareProperties)(unsafe.Pointer(sp))
	return d.DecodeElement(sp2, &start)
}

// ShareSetAccessPolicyResponse ...
type ShareSetAccessPolicyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ssapr ShareSetAccessPolicyResponse) Response() *http.Response {
	return ssapr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssapr ShareSetAccessPolicyResponse) StatusCode() int {
	return ssapr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssapr ShareSetAccessPolicyResponse) Status() string {
	return ssapr.rawResponse.Status
}

// Date returns the value for header Date.
func (ssapr ShareSetAccessPolicyResponse) Date() time.Time {
	s := ssapr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ssapr ShareSetAccessPolicyResponse) ErrorCode() string {
	return ssapr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (ssapr ShareSetAccessPolicyResponse) ETag() ETag {
	return ETag(ssapr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ssapr ShareSetAccessPolicyResponse) LastModified() time.Time {
	s := ssapr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ssapr ShareSetAccessPolicyResponse) RequestID() string {
	return ssapr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssapr ShareSetAccessPolicyResponse) Version() string {
	return ssapr.rawResponse.Header.Get("x-ms-version")
}

// ShareSetMetadataResponse ...
type ShareSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ssmr ShareSetMetadataResponse) Response() *http.Response {
	return ssmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssmr ShareSetMetadataResponse) StatusCode() int {
	return ssmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssmr ShareSetMetadataResponse) Status() string {
	return ssmr.rawResponse.Status
}

// Date returns the value for header Date.
func (ssmr ShareSetMetadataResponse) Date() time.Time {
	s := ssmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ssmr ShareSetMetadataResponse) ErrorCode() string {
	return ssmr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (ssmr ShareSetMetadataResponse) ETag() ETag {
	return ETag(ssmr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ssmr ShareSetMetadataResponse) LastModified() time.Time {
	s := ssmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ssmr ShareSetMetadataResponse) RequestID() string {
	return ssmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssmr ShareSetMetadataResponse) Version() string {
	return ssmr.rawResponse.Header.Get("x-ms-version")
}

// ShareSetQuotaResponse ...
type ShareSetQuotaResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ssqr ShareSetQuotaResponse) Response() *http.Response {
	return ssqr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssqr ShareSetQuotaResponse) StatusCode() int {
	return ssqr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssqr ShareSetQuotaResponse) Status() string {
	return ssqr.rawResponse.Status
}

// Date returns the value for header Date.
func (ssqr ShareSetQuotaResponse) Date() time.Time {
	s := ssqr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ssqr ShareSetQuotaResponse) ErrorCode() string {
	return ssqr.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (ssqr ShareSetQuotaResponse) ETag() ETag {
	return ETag(ssqr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ssqr ShareSetQuotaResponse) LastModified() time.Time {
	s := ssqr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ssqr ShareSetQuotaResponse) RequestID() string {
	return ssqr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssqr ShareSetQuotaResponse) Version() string {
	return ssqr.rawResponse.Header.Get("x-ms-version")
}

// ShareStats - Stats for the share.
type ShareStats struct {
	rawResponse *http.Response
	// ShareUsageBytes - The approximate size of the data stored in bytes. Note that this value may not include all recently created or recently resized files.
	ShareUsageBytes int32 `xml:"ShareUsageBytes"`
}

// Response returns the raw HTTP response object.
func (ss ShareStats) Response() *http.Response {
	return ss.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ss ShareStats) StatusCode() int {
	return ss.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ss ShareStats) Status() string {
	return ss.rawResponse.Status
}

// Date returns the value for header Date.
func (ss ShareStats) Date() time.Time {
	s := ss.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (ss ShareStats) ErrorCode() string {
	return ss.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (ss ShareStats) ETag() ETag {
	return ETag(ss.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ss ShareStats) LastModified() time.Time {
	s := ss.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ss ShareStats) RequestID() string {
	return ss.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ss ShareStats) Version() string {
	return ss.rawResponse.Header.Get("x-ms-version")
}

// SignedIdentifier - Signed identifier.
type SignedIdentifier struct {
	// ID - A unique id.
	ID string `xml:"Id"`
	// AccessPolicy - The access policy.
	AccessPolicy *AccessPolicy `xml:"AccessPolicy"`
}

// SignedIdentifiers - Wraps the response from the shareClient.GetAccessPolicy method.
type SignedIdentifiers struct {
	rawResponse *http.Response
	Items       []SignedIdentifier `xml:"SignedIdentifier"`
}

// Response returns the raw HTTP response object.
func (si SignedIdentifiers) Response() *http.Response {
	return si.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (si SignedIdentifiers) StatusCode() int {
	return si.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (si SignedIdentifiers) Status() string {
	return si.rawResponse.Status
}

// Date returns the value for header Date.
func (si SignedIdentifiers) Date() time.Time {
	s := si.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (si SignedIdentifiers) ErrorCode() string {
	return si.rawResponse.Header.Get("x-ms-error-code")
}

// ETag returns the value for header ETag.
func (si SignedIdentifiers) ETag() ETag {
	return ETag(si.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (si SignedIdentifiers) LastModified() time.Time {
	s := si.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (si SignedIdentifiers) RequestID() string {
	return si.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (si SignedIdentifiers) Version() string {
	return si.rawResponse.Header.Get("x-ms-version")
}

// StorageError ...
// type StorageError struct {
// 	Message *string `xml:"Message"`
// }

// StorageServiceProperties - Storage service properties.
type StorageServiceProperties struct {
	rawResponse *http.Response
	// HourMetrics - A summary of request statistics grouped by API in hourly aggregates for files.
	HourMetrics *Metrics `xml:"HourMetrics"`
	// MinuteMetrics - A summary of request statistics grouped by API in minute aggregates for files.
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`
	// Cors - The set of CORS rules.
	Cors []CorsRule `xml:"Cors>CorsRule"`
}

// Response returns the raw HTTP response object.
func (ssp StorageServiceProperties) Response() *http.Response {
	return ssp.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssp StorageServiceProperties) StatusCode() int {
	return ssp.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssp StorageServiceProperties) Status() string {
	return ssp.rawResponse.Status
}

// ErrorCode returns the value for header x-ms-error-code.
func (ssp StorageServiceProperties) ErrorCode() string {
	return ssp.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (ssp StorageServiceProperties) RequestID() string {
	return ssp.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssp StorageServiceProperties) Version() string {
	return ssp.rawResponse.Header.Get("x-ms-version")
}

func init() {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between AccessPolicy and accessPolicy"))
	}
	if reflect.TypeOf((*HandleItem)(nil)).Elem().Size() != reflect.TypeOf((*handleItem)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between HandleItem and handleItem"))
	}
	if reflect.TypeOf((*ShareProperties)(nil)).Elem().Size() != reflect.TypeOf((*shareProperties)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between ShareProperties and shareProperties"))
	}
}

const (
	rfc3339Format = "2006-01-02T15:04:05.0000000Z07:00"
)

// used to convert times from UTC to GMT before sending across the wire
var gmt = time.FixedZone("GMT", 0)

// internal type used for marshalling time in RFC1123 format
type timeRFC1123 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC1123.
func (t timeRFC1123) MarshalText() ([]byte, error) {
	return []byte(t.Format(time.RFC1123)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC1123.
func (t *timeRFC1123) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(time.RFC1123, string(data))
	return
}

// internal type used for marshalling time in RFC3339 format
type timeRFC3339 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC3339.
func (t timeRFC3339) MarshalText() ([]byte, error) {
	return []byte(t.Format(rfc3339Format)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC3339.
func (t *timeRFC3339) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(rfc3339Format, string(data))
	return
}

// internal type used for marshalling
type accessPolicy struct {
	Start      *timeRFC3339 `xml:"Start"`
	Expiry     *timeRFC3339 `xml:"Expiry"`
	Permission *string      `xml:"Permission"`
}

// internal type used for marshalling
type handleItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName           xml.Name     `xml:"Handle"`
	HandleID          string       `xml:"HandleId"`
	Path              string       `xml:"Path"`
	FileID            string       `xml:"FileId"`
	ParentID          *string      `xml:"ParentId"`
	SessionID         string       `xml:"SessionId"`
	ClientIP          string       `xml:"ClientIp"`
	OpenTime          timeRFC1123  `xml:"OpenTime"`
	LastReconnectTime *timeRFC1123 `xml:"LastReconnectTime"`
}

// internal type used for marshalling
type shareProperties struct {
	LastModified timeRFC1123 `xml:"Last-Modified"`
	Etag         ETag        `xml:"Etag"`
	Quota        int32       `xml:"Quota"`
}
