// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/azure-disk-csi-driver-operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/openshift/azure-disk-csi-driver-operator/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AzureDiskDriversGetter has a method to return a AzureDiskDriverInterface.
// A group's client should implement this interface.
type AzureDiskDriversGetter interface {
	AzureDiskDrivers() AzureDiskDriverInterface
}

// AzureDiskDriverInterface has methods to work with AzureDiskDriver resources.
type AzureDiskDriverInterface interface {
	Create(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.CreateOptions) (*v1alpha1.AzureDiskDriver, error)
	Update(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.UpdateOptions) (*v1alpha1.AzureDiskDriver, error)
	UpdateStatus(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.UpdateOptions) (*v1alpha1.AzureDiskDriver, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.AzureDiskDriver, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AzureDiskDriverList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AzureDiskDriver, err error)
	AzureDiskDriverExpansion
}

// azureDiskDrivers implements AzureDiskDriverInterface
type azureDiskDrivers struct {
	client rest.Interface
}

// newAzureDiskDrivers returns a AzureDiskDrivers
func newAzureDiskDrivers(c *CsiV1alpha1Client) *azureDiskDrivers {
	return &azureDiskDrivers{
		client: c.RESTClient(),
	}
}

// Get takes name of the azureDiskDriver, and returns the corresponding azureDiskDriver object, and an error if there is any.
func (c *azureDiskDrivers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AzureDiskDriver, err error) {
	result = &v1alpha1.AzureDiskDriver{}
	err = c.client.Get().
		Resource("azurediskdrivers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AzureDiskDrivers that match those selectors.
func (c *azureDiskDrivers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AzureDiskDriverList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AzureDiskDriverList{}
	err = c.client.Get().
		Resource("azurediskdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested azureDiskDrivers.
func (c *azureDiskDrivers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("azurediskdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a azureDiskDriver and creates it.  Returns the server's representation of the azureDiskDriver, and an error, if there is any.
func (c *azureDiskDrivers) Create(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.CreateOptions) (result *v1alpha1.AzureDiskDriver, err error) {
	result = &v1alpha1.AzureDiskDriver{}
	err = c.client.Post().
		Resource("azurediskdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(azureDiskDriver).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a azureDiskDriver and updates it. Returns the server's representation of the azureDiskDriver, and an error, if there is any.
func (c *azureDiskDrivers) Update(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.UpdateOptions) (result *v1alpha1.AzureDiskDriver, err error) {
	result = &v1alpha1.AzureDiskDriver{}
	err = c.client.Put().
		Resource("azurediskdrivers").
		Name(azureDiskDriver.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(azureDiskDriver).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *azureDiskDrivers) UpdateStatus(ctx context.Context, azureDiskDriver *v1alpha1.AzureDiskDriver, opts v1.UpdateOptions) (result *v1alpha1.AzureDiskDriver, err error) {
	result = &v1alpha1.AzureDiskDriver{}
	err = c.client.Put().
		Resource("azurediskdrivers").
		Name(azureDiskDriver.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(azureDiskDriver).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the azureDiskDriver and deletes it. Returns an error if one occurs.
func (c *azureDiskDrivers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("azurediskdrivers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *azureDiskDrivers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("azurediskdrivers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched azureDiskDriver.
func (c *azureDiskDrivers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AzureDiskDriver, err error) {
	result = &v1alpha1.AzureDiskDriver{}
	err = c.client.Patch(pt).
		Resource("azurediskdrivers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
