// Code generated by csi-proxy-api-gen. DO NOT EDIT.

package v1beta2

import (
	"context"
	"net"

	"github.com/Microsoft/go-winio"
	"github.com/kubernetes-csi/csi-proxy/client"
	"github.com/kubernetes-csi/csi-proxy/client/api/volume/v1beta2"
	"github.com/kubernetes-csi/csi-proxy/client/apiversion"
	"google.golang.org/grpc"
)

const groupName = "volume"

var version = apiversion.NewVersionOrPanic("v1beta2")

type Client struct {
	client     v1beta2.VolumeClient
	connection *grpc.ClientConn
}

// NewClient returns a client to make calls to the volume API group version v1beta2.
// It's the caller's responsibility to Close the client when done.
func NewClient() (*Client, error) {
	pipePath := client.PipePath(groupName, version)

	connection, err := grpc.Dial(pipePath,
		grpc.WithContextDialer(func(context context.Context, s string) (net.Conn, error) {
			return winio.DialPipeContext(context, s)
		}),
		grpc.WithInsecure())
	if err != nil {
		return nil, err
	}

	client := v1beta2.NewVolumeClient(connection)
	return &Client{
		client:     client,
		connection: connection,
	}, nil
}

// Close closes the client. It must be called before the client gets GC-ed.
func (w *Client) Close() error {
	return w.connection.Close()
}

// ensures we implement all the required methods
var _ v1beta2.VolumeClient = &Client{}

func (w *Client) DismountVolume(context context.Context, request *v1beta2.DismountVolumeRequest, opts ...grpc.CallOption) (*v1beta2.DismountVolumeResponse, error) {
	return w.client.DismountVolume(context, request, opts...)
}

func (w *Client) FormatVolume(context context.Context, request *v1beta2.FormatVolumeRequest, opts ...grpc.CallOption) (*v1beta2.FormatVolumeResponse, error) {
	return w.client.FormatVolume(context, request, opts...)
}

func (w *Client) GetVolumeDiskNumber(context context.Context, request *v1beta2.VolumeDiskNumberRequest, opts ...grpc.CallOption) (*v1beta2.VolumeDiskNumberResponse, error) {
	return w.client.GetVolumeDiskNumber(context, request, opts...)
}

func (w *Client) GetVolumeIDFromMount(context context.Context, request *v1beta2.VolumeIDFromMountRequest, opts ...grpc.CallOption) (*v1beta2.VolumeIDFromMountResponse, error) {
	return w.client.GetVolumeIDFromMount(context, request, opts...)
}

func (w *Client) IsVolumeFormatted(context context.Context, request *v1beta2.IsVolumeFormattedRequest, opts ...grpc.CallOption) (*v1beta2.IsVolumeFormattedResponse, error) {
	return w.client.IsVolumeFormatted(context, request, opts...)
}

func (w *Client) ListVolumesOnDisk(context context.Context, request *v1beta2.ListVolumesOnDiskRequest, opts ...grpc.CallOption) (*v1beta2.ListVolumesOnDiskResponse, error) {
	return w.client.ListVolumesOnDisk(context, request, opts...)
}

func (w *Client) MountVolume(context context.Context, request *v1beta2.MountVolumeRequest, opts ...grpc.CallOption) (*v1beta2.MountVolumeResponse, error) {
	return w.client.MountVolume(context, request, opts...)
}

func (w *Client) ResizeVolume(context context.Context, request *v1beta2.ResizeVolumeRequest, opts ...grpc.CallOption) (*v1beta2.ResizeVolumeResponse, error) {
	return w.client.ResizeVolume(context, request, opts...)
}

func (w *Client) VolumeStats(context context.Context, request *v1beta2.VolumeStatsRequest, opts ...grpc.CallOption) (*v1beta2.VolumeStatsResponse, error) {
	return w.client.VolumeStats(context, request, opts...)
}

func (w *Client) WriteVolumeCache(context context.Context, request *v1beta2.WriteVolumeCacheRequest, opts ...grpc.CallOption) (*v1beta2.WriteVolumeCacheResponse, error) {
	return w.client.WriteVolumeCache(context, request, opts...)
}
