---
title: "v0.7.3"
linkTitle: "v0.7.3"
date: 2021-04-19
description: >
  Cloud Provider Azure v0.7.3
--- 

# Major changes since v0.7.2

Cloud Provider Azure v0.7.3 supports out-of-tree node ipam controller, sharing the primary SLB with multiple vmSets, and a bunch of other features/bug fixes. The images are available at:

- `mcr.microsoft.com/oss/kubernetes/azure-cloud-node-manager:v0.7.3`
- `mcr.microsoft.com/oss/kubernetes/azure-cloud-controller-manager:v0.7.3`

## Changes by Kind

### Feature

- Chore: remove get file in CreateFileShare ([#534](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/534), [@andyzhangx](https://github.com/andyzhangx))
- Feat: add ARM node provider ([#580](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/580), [@JesusAlvarezTorres](https://github.com/JesusAlvarezTorres))
- Feat: add disable RetentionPolicy parameter ([#545](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/545), [@andyzhangx](https://github.com/andyzhangx))
- Feat: add update vm interface ([#592](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/592), [@andyzhangx](https://github.com/andyzhangx))
- Feat: implement cloud allocator for vmas ([#555](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/555), [@nilo19](https://github.com/nilo19))
- Feat: implement cloud cidr allocator for VMSS ([#539](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/539), [@nilo19](https://github.com/nilo19))
- Feat: support sharing the primary slb with multiple vmSets ([#578](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/578), [@nilo19](https://github.com/nilo19))
- Feat: support system tag ([#558](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/558), [@nilo19](https://github.com/nilo19))
- Feat: upgrade azure sdk to v53.1.0 ([#589](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/589), [@andyzhangx](https://github.com/andyzhangx))

### Documentation

- Doc: add doc for out-of-tree node ipam controller ([#553](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/553), [@nilo19](https://github.com/nilo19))

### Bug or Regression

- Allow disabling AzureStackCloud API versions when using AzureStackCloud config on public cloud ([#525](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/525), [@feiskyer](https://github.com/feiskyer))
- Avoid caching the VMSS instances whose network profile is nil ([#583](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/583), [@feiskyer](https://github.com/feiskyer))
- Azure_storageaccount.go:99] found skip-matching tag for account %!s(*string=0xc000cbd7b0), skip matching ([#529](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/529), [@andyzhangx](https://github.com/andyzhangx))
- Ensure only LoadBalancer rule is created when HA mode is enabled ([#536](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/536), [@feiskyer](https://github.com/feiskyer))
- Ensure service deleted when the Azure resource group has been deleted ([#584](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/584), [@feiskyer](https://github.com/feiskyer))
- Fix node public IP fetching from instance metadata service when the node is part of standard load balancer backend pool. ([#540](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/540), [@feiskyer](https://github.com/feiskyer))
- Fix: avoid panic when RouteTablePropertiesFormat is nil ([#568](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/568), [@feiskyer](https://github.com/feiskyer))
- Fix: not delete existing pip when service is deleted ([#574](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/574), [@nilo19](https://github.com/nilo19))
- Fix: support sharing the primary slb when there are both external and internal load balancers in the cluster ([#588](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/588), [@nilo19](https://github.com/nilo19))
- Fixed routes not created issues before Pod scheduling. When using kubenet, 1) cloud-node-manager supports "--wait-routes=true" to indicate a node would wait for route updates before accepting Pod scheduling and  2) route controller would wait a while for new routes to take effect (default is 30s). ([#528](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/528), [@feiskyer](https://github.com/feiskyer))
- Ignore not a VMSS error for VMAS nodes in reconcileBackendPools ([#551](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/551), [@CecileRobertMichon](https://github.com/CecileRobertMichon))

### Other (Cleanup or Flake)

- Chore: move consts in azure_vmss.go to consts.go ([#554](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/554), [@nilo19](https://github.com/nilo19))
- Chore: remove bazel support ([#585](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/585), [@nilo19](https://github.com/nilo19))
- Chore: switch to network api 2020-08-01 ([#569](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/569), [@nilo19](https://github.com/nilo19))
- Enable docker BuildKit and update Go to 1.15.8 ([#548](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/548), [@CecileRobertMichon](https://github.com/CecileRobertMichon))
- Update Azure compute API version to 2020-12-01 ([#579](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/579), [@feiskyer](https://github.com/feiskyer))

### Uncategorized

- Fix availability set cache in vmss cache ([#537](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/537), [@CecileRobertMichon](https://github.com/CecileRobertMichon))
- Fix: check disk state before attach disk ([#564](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/564), [@andyzhangx](https://github.com/andyzhangx))
- Fix: convert backend pool id to lower case before using it ([#561](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/561), [@nilo19](https://github.com/nilo19))

## Dependencies

### Added
- github.com/gofrs/uuid: [v4.0.0+incompatible](https://github.com/gofrs/uuid/tree/v4.0.0)

### Changed
- github.com/Azure/azure-sdk-for-go: [v51.2.0+incompatible → v53.1.0+incompatible](https://github.com/Azure/azure-sdk-for-go/compare/v51.2.0...v53.1.0)
