package trafficmanager

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EndpointMonitorStatus enumerates the values for endpoint monitor status.
type EndpointMonitorStatus string

const (
	// CheckingEndpoint ...
	CheckingEndpoint EndpointMonitorStatus = "CheckingEndpoint"
	// Degraded ...
	Degraded EndpointMonitorStatus = "Degraded"
	// Disabled ...
	Disabled EndpointMonitorStatus = "Disabled"
	// Inactive ...
	Inactive EndpointMonitorStatus = "Inactive"
	// Online ...
	Online EndpointMonitorStatus = "Online"
	// Stopped ...
	Stopped EndpointMonitorStatus = "Stopped"
)

// PossibleEndpointMonitorStatusValues returns an array of possible values for the EndpointMonitorStatus const type.
func PossibleEndpointMonitorStatusValues() []EndpointMonitorStatus {
	return []EndpointMonitorStatus{CheckingEndpoint, Degraded, Disabled, Inactive, Online, Stopped}
}

// EndpointStatus enumerates the values for endpoint status.
type EndpointStatus string

const (
	// EndpointStatusDisabled ...
	EndpointStatusDisabled EndpointStatus = "Disabled"
	// EndpointStatusEnabled ...
	EndpointStatusEnabled EndpointStatus = "Enabled"
)

// PossibleEndpointStatusValues returns an array of possible values for the EndpointStatus const type.
func PossibleEndpointStatusValues() []EndpointStatus {
	return []EndpointStatus{EndpointStatusDisabled, EndpointStatusEnabled}
}

// MonitorProtocol enumerates the values for monitor protocol.
type MonitorProtocol string

const (
	// HTTP ...
	HTTP MonitorProtocol = "HTTP"
	// HTTPS ...
	HTTPS MonitorProtocol = "HTTPS"
	// TCP ...
	TCP MonitorProtocol = "TCP"
)

// PossibleMonitorProtocolValues returns an array of possible values for the MonitorProtocol const type.
func PossibleMonitorProtocolValues() []MonitorProtocol {
	return []MonitorProtocol{HTTP, HTTPS, TCP}
}

// ProfileMonitorStatus enumerates the values for profile monitor status.
type ProfileMonitorStatus string

const (
	// ProfileMonitorStatusCheckingEndpoints ...
	ProfileMonitorStatusCheckingEndpoints ProfileMonitorStatus = "CheckingEndpoints"
	// ProfileMonitorStatusDegraded ...
	ProfileMonitorStatusDegraded ProfileMonitorStatus = "Degraded"
	// ProfileMonitorStatusDisabled ...
	ProfileMonitorStatusDisabled ProfileMonitorStatus = "Disabled"
	// ProfileMonitorStatusInactive ...
	ProfileMonitorStatusInactive ProfileMonitorStatus = "Inactive"
	// ProfileMonitorStatusOnline ...
	ProfileMonitorStatusOnline ProfileMonitorStatus = "Online"
)

// PossibleProfileMonitorStatusValues returns an array of possible values for the ProfileMonitorStatus const type.
func PossibleProfileMonitorStatusValues() []ProfileMonitorStatus {
	return []ProfileMonitorStatus{ProfileMonitorStatusCheckingEndpoints, ProfileMonitorStatusDegraded, ProfileMonitorStatusDisabled, ProfileMonitorStatusInactive, ProfileMonitorStatusOnline}
}

// ProfileStatus enumerates the values for profile status.
type ProfileStatus string

const (
	// ProfileStatusDisabled ...
	ProfileStatusDisabled ProfileStatus = "Disabled"
	// ProfileStatusEnabled ...
	ProfileStatusEnabled ProfileStatus = "Enabled"
)

// PossibleProfileStatusValues returns an array of possible values for the ProfileStatus const type.
func PossibleProfileStatusValues() []ProfileStatus {
	return []ProfileStatus{ProfileStatusDisabled, ProfileStatusEnabled}
}

// TrafficRoutingMethod enumerates the values for traffic routing method.
type TrafficRoutingMethod string

const (
	// Geographic ...
	Geographic TrafficRoutingMethod = "Geographic"
	// Performance ...
	Performance TrafficRoutingMethod = "Performance"
	// Priority ...
	Priority TrafficRoutingMethod = "Priority"
	// Weighted ...
	Weighted TrafficRoutingMethod = "Weighted"
)

// PossibleTrafficRoutingMethodValues returns an array of possible values for the TrafficRoutingMethod const type.
func PossibleTrafficRoutingMethodValues() []TrafficRoutingMethod {
	return []TrafficRoutingMethod{Geographic, Performance, Priority, Weighted}
}

// TrafficViewEnrollmentStatus enumerates the values for traffic view enrollment status.
type TrafficViewEnrollmentStatus string

const (
	// TrafficViewEnrollmentStatusDisabled ...
	TrafficViewEnrollmentStatusDisabled TrafficViewEnrollmentStatus = "Disabled"
	// TrafficViewEnrollmentStatusEnabled ...
	TrafficViewEnrollmentStatusEnabled TrafficViewEnrollmentStatus = "Enabled"
)

// PossibleTrafficViewEnrollmentStatusValues returns an array of possible values for the TrafficViewEnrollmentStatus const type.
func PossibleTrafficViewEnrollmentStatusValues() []TrafficViewEnrollmentStatus {
	return []TrafficViewEnrollmentStatus{TrafficViewEnrollmentStatusDisabled, TrafficViewEnrollmentStatusEnabled}
}
