package featuresapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2021-07-01/features"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	ListOperations(ctx context.Context, APIVersion string) (result features.OperationListResultPage, err error)
	ListOperationsComplete(ctx context.Context, APIVersion string) (result features.OperationListResultIterator, err error)
}

var _ BaseClientAPI = (*features.BaseClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Get(ctx context.Context, resourceProviderNamespace string, featureName string, APIVersion string) (result features.Result, err error)
	List(ctx context.Context, resourceProviderNamespace string, APIVersion string) (result features.OperationsListResultPage, err error)
	ListComplete(ctx context.Context, resourceProviderNamespace string, APIVersion string) (result features.OperationsListResultIterator, err error)
	ListAll(ctx context.Context, APIVersion string) (result features.OperationsListResultPage, err error)
	ListAllComplete(ctx context.Context, APIVersion string) (result features.OperationsListResultIterator, err error)
	Register(ctx context.Context, resourceProviderNamespace string, featureName string, APIVersion string) (result features.Result, err error)
	Unregister(ctx context.Context, resourceProviderNamespace string, featureName string, APIVersion string) (result features.Result, err error)
}

var _ ClientAPI = (*features.Client)(nil)

// SubscriptionFeatureRegistrationsClientAPI contains the set of methods on the SubscriptionFeatureRegistrationsClient type.
type SubscriptionFeatureRegistrationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, APIVersion string, featureName string, subscriptionFeatureRegistrationType *features.SubscriptionFeatureRegistration) (result features.SubscriptionFeatureRegistration, err error)
	Delete(ctx context.Context, APIVersion string, featureName string) (result autorest.Response, err error)
	Get(ctx context.Context, APIVersion string, featureName string) (result features.SubscriptionFeatureRegistration, err error)
	ListAllBySubscription(ctx context.Context, APIVersion string) (result features.SubscriptionFeatureRegistrationListPage, err error)
	ListAllBySubscriptionComplete(ctx context.Context, APIVersion string) (result features.SubscriptionFeatureRegistrationListIterator, err error)
	ListBySubscription(ctx context.Context, APIVersion string) (result features.SubscriptionFeatureRegistrationListPage, err error)
	ListBySubscriptionComplete(ctx context.Context, APIVersion string) (result features.SubscriptionFeatureRegistrationListIterator, err error)
}

var _ SubscriptionFeatureRegistrationsClientAPI = (*features.SubscriptionFeatureRegistrationsClient)(nil)
