package datamigration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ActiveDirectoryIntegrated ...
	ActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	// ActiveDirectoryPassword ...
	ActiveDirectoryPassword AuthenticationType = "ActiveDirectoryPassword"
	// None ...
	None AuthenticationType = "None"
	// SQLAuthentication ...
	SQLAuthentication AuthenticationType = "SqlAuthentication"
	// WindowsAuthentication ...
	WindowsAuthentication AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ActiveDirectoryIntegrated, ActiveDirectoryPassword, None, SQLAuthentication, WindowsAuthentication}
}

// DatabaseCompatLevel enumerates the values for database compat level.
type DatabaseCompatLevel string

const (
	// CompatLevel100 ...
	CompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	// CompatLevel110 ...
	CompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	// CompatLevel120 ...
	CompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	// CompatLevel130 ...
	CompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	// CompatLevel140 ...
	CompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	// CompatLevel80 ...
	CompatLevel80 DatabaseCompatLevel = "CompatLevel80"
	// CompatLevel90 ...
	CompatLevel90 DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns an array of possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{CompatLevel100, CompatLevel110, CompatLevel120, CompatLevel130, CompatLevel140, CompatLevel80, CompatLevel90}
}

// DatabaseFileType enumerates the values for database file type.
type DatabaseFileType string

const (
	// Filestream ...
	Filestream DatabaseFileType = "Filestream"
	// Fulltext ...
	Fulltext DatabaseFileType = "Fulltext"
	// Log ...
	Log DatabaseFileType = "Log"
	// NotSupported ...
	NotSupported DatabaseFileType = "NotSupported"
	// Rows ...
	Rows DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns an array of possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{Filestream, Fulltext, Log, NotSupported, Rows}
}

// DatabaseMigrationStage enumerates the values for database migration stage.
type DatabaseMigrationStage string

const (
	// DatabaseMigrationStageBackup ...
	DatabaseMigrationStageBackup DatabaseMigrationStage = "Backup"
	// DatabaseMigrationStageCompleted ...
	DatabaseMigrationStageCompleted DatabaseMigrationStage = "Completed"
	// DatabaseMigrationStageFileCopy ...
	DatabaseMigrationStageFileCopy DatabaseMigrationStage = "FileCopy"
	// DatabaseMigrationStageInitialize ...
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	// DatabaseMigrationStageNone ...
	DatabaseMigrationStageNone DatabaseMigrationStage = "None"
	// DatabaseMigrationStageRestore ...
	DatabaseMigrationStageRestore DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns an array of possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{DatabaseMigrationStageBackup, DatabaseMigrationStageCompleted, DatabaseMigrationStageFileCopy, DatabaseMigrationStageInitialize, DatabaseMigrationStageNone, DatabaseMigrationStageRestore}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// Copying ...
	Copying DatabaseState = "Copying"
	// Emergency ...
	Emergency DatabaseState = "Emergency"
	// Offline ...
	Offline DatabaseState = "Offline"
	// OfflineSecondary ...
	OfflineSecondary DatabaseState = "OfflineSecondary"
	// Online ...
	Online DatabaseState = "Online"
	// Recovering ...
	Recovering DatabaseState = "Recovering"
	// RecoveryPending ...
	RecoveryPending DatabaseState = "RecoveryPending"
	// Restoring ...
	Restoring DatabaseState = "Restoring"
	// Suspect ...
	Suspect DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{Copying, Emergency, Offline, OfflineSecondary, Online, Recovering, RecoveryPending, Restoring, Suspect}
}

// ErrorType enumerates the values for error type.
type ErrorType string

const (
	// ErrorTypeDefault ...
	ErrorTypeDefault ErrorType = "Default"
	// ErrorTypeError ...
	ErrorTypeError ErrorType = "Error"
	// ErrorTypeWarning ...
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns an array of possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{ErrorTypeDefault, ErrorTypeError, ErrorTypeWarning}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateFailed ...
	MigrationStateFailed MigrationState = "Failed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
	// MigrationStateNone ...
	MigrationStateNone MigrationState = "None"
	// MigrationStateSkipped ...
	MigrationStateSkipped MigrationState = "Skipped"
	// MigrationStateStopped ...
	MigrationStateStopped MigrationState = "Stopped"
	// MigrationStateWarning ...
	MigrationStateWarning MigrationState = "Warning"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateFailed, MigrationStateInProgress, MigrationStateNone, MigrationStateSkipped, MigrationStateStopped, MigrationStateWarning}
}

// MigrationStatus enumerates the values for migration status.
type MigrationStatus string

const (
	// MigrationStatusCompleted ...
	MigrationStatusCompleted MigrationStatus = "Completed"
	// MigrationStatusCompletedWithWarnings ...
	MigrationStatusCompletedWithWarnings MigrationStatus = "CompletedWithWarnings"
	// MigrationStatusConfigured ...
	MigrationStatusConfigured MigrationStatus = "Configured"
	// MigrationStatusConnecting ...
	MigrationStatusConnecting MigrationStatus = "Connecting"
	// MigrationStatusDefault ...
	MigrationStatusDefault MigrationStatus = "Default"
	// MigrationStatusError ...
	MigrationStatusError MigrationStatus = "Error"
	// MigrationStatusRunning ...
	MigrationStatusRunning MigrationStatus = "Running"
	// MigrationStatusSelectLogins ...
	MigrationStatusSelectLogins MigrationStatus = "SelectLogins"
	// MigrationStatusSourceAndTargetSelected ...
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	// MigrationStatusStopped ...
	MigrationStatusStopped MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns an array of possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{MigrationStatusCompleted, MigrationStatusCompletedWithWarnings, MigrationStatusConfigured, MigrationStatusConnecting, MigrationStatusDefault, MigrationStatusError, MigrationStatusRunning, MigrationStatusSelectLogins, MigrationStatusSourceAndTargetSelected, MigrationStatusStopped}
}

// NameCheckFailureReason enumerates the values for name check failure reason.
type NameCheckFailureReason string

const (
	// AlreadyExists ...
	AlreadyExists NameCheckFailureReason = "AlreadyExists"
	// Invalid ...
	Invalid NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns an array of possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{AlreadyExists, Invalid}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// Function ...
	Function ObjectType = "Function"
	// StoredProcedures ...
	StoredProcedures ObjectType = "StoredProcedures"
	// Table ...
	Table ObjectType = "Table"
	// User ...
	User ObjectType = "User"
	// View ...
	View ObjectType = "View"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{Function, StoredProcedures, Table, User, View}
}

// ProjectProvisioningState enumerates the values for project provisioning state.
type ProjectProvisioningState string

const (
	// Deleting ...
	Deleting ProjectProvisioningState = "Deleting"
	// Succeeded ...
	Succeeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns an array of possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{Deleting, Succeeded}
}

// ProjectSourcePlatform enumerates the values for project source platform.
type ProjectSourcePlatform string

const (
	// SQL ...
	SQL ProjectSourcePlatform = "SQL"
	// Unknown ...
	Unknown ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns an array of possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{SQL, Unknown}
}

// ProjectTargetPlatform enumerates the values for project target platform.
type ProjectTargetPlatform string

const (
	// ProjectTargetPlatformSQLDB ...
	ProjectTargetPlatformSQLDB ProjectTargetPlatform = "SQLDB"
	// ProjectTargetPlatformUnknown ...
	ProjectTargetPlatformUnknown ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns an array of possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{ProjectTargetPlatformSQLDB, ProjectTargetPlatformUnknown}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "location"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeDatabaseLevelOutput ...
	ResultTypeDatabaseLevelOutput ResultType = "DatabaseLevelOutput"
	// ResultTypeErrorOutput ...
	ResultTypeErrorOutput ResultType = "ErrorOutput"
	// ResultTypeMigrateSQLServerSQLDbTaskOutput ...
	ResultTypeMigrateSQLServerSQLDbTaskOutput ResultType = "MigrateSqlServerSqlDbTaskOutput"
	// ResultTypeMigrationLevelOutput ...
	ResultTypeMigrationLevelOutput ResultType = "MigrationLevelOutput"
	// ResultTypeTableLevelOutput ...
	ResultTypeTableLevelOutput ResultType = "TableLevelOutput"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeDatabaseLevelOutput, ResultTypeErrorOutput, ResultTypeMigrateSQLServerSQLDbTaskOutput, ResultTypeMigrationLevelOutput, ResultTypeTableLevelOutput}
}

// ResultTypeBasicConnectToSourceSQLServerTaskOutput enumerates the values for result type basic connect to
// source sql server task output.
type ResultTypeBasicConnectToSourceSQLServerTaskOutput string

const (
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "ConnectToSourceSqlServerTaskOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "TaskLevelOutput"
)

// PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues returns an array of possible values for the ResultTypeBasicConnectToSourceSQLServerTaskOutput const type.
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return []ResultTypeBasicConnectToSourceSQLServerTaskOutput{ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput}
}

// ServerLevelPermissionsGroup enumerates the values for server level permissions group.
type ServerLevelPermissionsGroup string

const (
	// Default ...
	Default ServerLevelPermissionsGroup = "Default"
	// MigrationFromSQLServerToAzureDB ...
	MigrationFromSQLServerToAzureDB ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
)

// PossibleServerLevelPermissionsGroupValues returns an array of possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{Default, MigrationFromSQLServerToAzureDB}
}

// ServiceProvisioningState enumerates the values for service provisioning state.
type ServiceProvisioningState string

const (
	// ServiceProvisioningStateAccepted ...
	ServiceProvisioningStateAccepted ServiceProvisioningState = "Accepted"
	// ServiceProvisioningStateDeleting ...
	ServiceProvisioningStateDeleting ServiceProvisioningState = "Deleting"
	// ServiceProvisioningStateDeploying ...
	ServiceProvisioningStateDeploying ServiceProvisioningState = "Deploying"
	// ServiceProvisioningStateFailed ...
	ServiceProvisioningStateFailed ServiceProvisioningState = "Failed"
	// ServiceProvisioningStateFailedToStart ...
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	// ServiceProvisioningStateFailedToStop ...
	ServiceProvisioningStateFailedToStop ServiceProvisioningState = "FailedToStop"
	// ServiceProvisioningStateStarting ...
	ServiceProvisioningStateStarting ServiceProvisioningState = "Starting"
	// ServiceProvisioningStateStopped ...
	ServiceProvisioningStateStopped ServiceProvisioningState = "Stopped"
	// ServiceProvisioningStateStopping ...
	ServiceProvisioningStateStopping ServiceProvisioningState = "Stopping"
	// ServiceProvisioningStateSucceeded ...
	ServiceProvisioningStateSucceeded ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns an array of possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{ServiceProvisioningStateAccepted, ServiceProvisioningStateDeleting, ServiceProvisioningStateDeploying, ServiceProvisioningStateFailed, ServiceProvisioningStateFailedToStart, ServiceProvisioningStateFailedToStop, ServiceProvisioningStateStarting, ServiceProvisioningStateStopped, ServiceProvisioningStateStopping, ServiceProvisioningStateSucceeded}
}

// ServiceScalability enumerates the values for service scalability.
type ServiceScalability string

const (
	// ServiceScalabilityAutomatic ...
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	// ServiceScalabilityManual ...
	ServiceScalabilityManual ServiceScalability = "manual"
	// ServiceScalabilityNone ...
	ServiceScalabilityNone ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns an array of possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{ServiceScalabilityAutomatic, ServiceScalabilityManual, ServiceScalabilityNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityMessage ...
	SeverityMessage Severity = "Message"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityMessage, SeverityWarning}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateCanceled ...
	TaskStateCanceled TaskState = "Canceled"
	// TaskStateFailed ...
	TaskStateFailed TaskState = "Failed"
	// TaskStateFailedInputValidation ...
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	// TaskStateFaulted ...
	TaskStateFaulted TaskState = "Faulted"
	// TaskStateQueued ...
	TaskStateQueued TaskState = "Queued"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "Running"
	// TaskStateSucceeded ...
	TaskStateSucceeded TaskState = "Succeeded"
	// TaskStateUnknown ...
	TaskStateUnknown TaskState = "Unknown"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateCanceled, TaskStateFailed, TaskStateFailedInputValidation, TaskStateFaulted, TaskStateQueued, TaskStateRunning, TaskStateSucceeded, TaskStateUnknown}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// TaskTypeConnectToSourceSQLServer ...
	TaskTypeConnectToSourceSQLServer TaskType = "ConnectToSource.SqlServer"
	// TaskTypeConnectToTargetSQLDb ...
	TaskTypeConnectToTargetSQLDb TaskType = "ConnectToTarget.SqlDb"
	// TaskTypeGetUserTablesSQL ...
	TaskTypeGetUserTablesSQL TaskType = "GetUserTables.Sql"
	// TaskTypeMigrateSQLServerSQLDb ...
	TaskTypeMigrateSQLServerSQLDb TaskType = "Migrate.SqlServer.SqlDb"
	// TaskTypeProjectTaskProperties ...
	TaskTypeProjectTaskProperties TaskType = "ProjectTaskProperties"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{TaskTypeConnectToSourceSQLServer, TaskTypeConnectToTargetSQLDb, TaskTypeGetUserTablesSQL, TaskTypeMigrateSQLServerSQLDb, TaskTypeProjectTaskProperties}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeConnectionInfo ...
	TypeConnectionInfo Type = "ConnectionInfo"
	// TypeSQLConnectionInfo ...
	TypeSQLConnectionInfo Type = "SqlConnectionInfo"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeConnectionInfo, TypeSQLConnectionInfo}
}

// UpdateActionType enumerates the values for update action type.
type UpdateActionType string

const (
	// AddedOnTarget ...
	AddedOnTarget UpdateActionType = "AddedOnTarget"
	// ChangedOnTarget ...
	ChangedOnTarget UpdateActionType = "ChangedOnTarget"
	// DeletedOnTarget ...
	DeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns an array of possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{AddedOnTarget, ChangedOnTarget, DeletedOnTarget}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusCompleted ...
	ValidationStatusCompleted ValidationStatus = "Completed"
	// ValidationStatusCompletedWithIssues ...
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	// ValidationStatusDefault ...
	ValidationStatusDefault ValidationStatus = "Default"
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInitialized ...
	ValidationStatusInitialized ValidationStatus = "Initialized"
	// ValidationStatusInProgress ...
	ValidationStatusInProgress ValidationStatus = "InProgress"
	// ValidationStatusNotStarted ...
	ValidationStatusNotStarted ValidationStatus = "NotStarted"
	// ValidationStatusStopped ...
	ValidationStatusStopped ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusCompleted, ValidationStatusCompletedWithIssues, ValidationStatusDefault, ValidationStatusFailed, ValidationStatusInitialized, ValidationStatusInProgress, ValidationStatusNotStarted, ValidationStatusStopped}
}
