package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// WorkloadNetworksClient is the azure VMware Solution API
type WorkloadNetworksClient struct {
	BaseClient
}

// NewWorkloadNetworksClient creates an instance of the WorkloadNetworksClient client.
func NewWorkloadNetworksClient(subscriptionID string) WorkloadNetworksClient {
	return NewWorkloadNetworksClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWorkloadNetworksClientWithBaseURI creates an instance of the WorkloadNetworksClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewWorkloadNetworksClientWithBaseURI(baseURI string, subscriptionID string) WorkloadNetworksClient {
	return WorkloadNetworksClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateDhcp sends the create dhcp request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// dhcpID - NSX DHCP identifier. Generally the same as the DHCP display name
// workloadNetworkDhcp - NSX DHCP
func (client WorkloadNetworksClient) CreateDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp WorkloadNetworkDhcp) (result WorkloadNetworksCreateDhcpFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreateDhcp")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreateDhcp", err.Error())
	}

	req, err := client.CreateDhcpPreparer(ctx, resourceGroupName, privateCloudName, dhcpID, workloadNetworkDhcp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDhcp", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateDhcpSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDhcp", nil, "Failure sending request")
		return
	}

	return
}

// CreateDhcpPreparer prepares the CreateDhcp request.
func (client WorkloadNetworksClient) CreateDhcpPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp WorkloadNetworkDhcp) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dhcpId":            autorest.Encode("path", dhcpID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}", pathParameters),
		autorest.WithJSON(workloadNetworkDhcp),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDhcpSender sends the CreateDhcp request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreateDhcpSender(req *http.Request) (future WorkloadNetworksCreateDhcpFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateDhcpResponder handles the response to the CreateDhcp request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreateDhcpResponder(resp *http.Response) (result WorkloadNetworkDhcp, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDNSService sends the create dns service request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSServiceID - NSX DNS Service identifier. Generally the same as the DNS Service's display name
// workloadNetworkDNSService - NSX DNS Service
func (client WorkloadNetworksClient) CreateDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService WorkloadNetworkDNSService) (result WorkloadNetworksCreateDNSServiceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreateDNSService")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreateDNSService", err.Error())
	}

	req, err := client.CreateDNSServicePreparer(ctx, resourceGroupName, privateCloudName, DNSServiceID, workloadNetworkDNSService)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDNSService", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateDNSServiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDNSService", nil, "Failure sending request")
		return
	}

	return
}

// CreateDNSServicePreparer prepares the CreateDNSService request.
func (client WorkloadNetworksClient) CreateDNSServicePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService WorkloadNetworkDNSService) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsServiceId":      autorest.Encode("path", DNSServiceID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}", pathParameters),
		autorest.WithJSON(workloadNetworkDNSService),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDNSServiceSender sends the CreateDNSService request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreateDNSServiceSender(req *http.Request) (future WorkloadNetworksCreateDNSServiceFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateDNSServiceResponder handles the response to the CreateDNSService request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreateDNSServiceResponder(resp *http.Response) (result WorkloadNetworkDNSService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDNSZone sends the create dns zone request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSZoneID - NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
// workloadNetworkDNSZone - NSX DNS Zone
func (client WorkloadNetworksClient) CreateDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone WorkloadNetworkDNSZone) (result WorkloadNetworksCreateDNSZoneFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreateDNSZone")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreateDNSZone", err.Error())
	}

	req, err := client.CreateDNSZonePreparer(ctx, resourceGroupName, privateCloudName, DNSZoneID, workloadNetworkDNSZone)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDNSZone", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateDNSZoneSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateDNSZone", nil, "Failure sending request")
		return
	}

	return
}

// CreateDNSZonePreparer prepares the CreateDNSZone request.
func (client WorkloadNetworksClient) CreateDNSZonePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone WorkloadNetworkDNSZone) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsZoneId":         autorest.Encode("path", DNSZoneID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}", pathParameters),
		autorest.WithJSON(workloadNetworkDNSZone),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDNSZoneSender sends the CreateDNSZone request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreateDNSZoneSender(req *http.Request) (future WorkloadNetworksCreateDNSZoneFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateDNSZoneResponder handles the response to the CreateDNSZone request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreateDNSZoneResponder(resp *http.Response) (result WorkloadNetworkDNSZone, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePortMirroring sends the create port mirroring request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// portMirroringID - NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
// workloadNetworkPortMirroring - NSX port mirroring
func (client WorkloadNetworksClient) CreatePortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring WorkloadNetworkPortMirroring) (result WorkloadNetworksCreatePortMirroringFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreatePortMirroring")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreatePortMirroring", err.Error())
	}

	req, err := client.CreatePortMirroringPreparer(ctx, resourceGroupName, privateCloudName, portMirroringID, workloadNetworkPortMirroring)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreatePortMirroring", nil, "Failure preparing request")
		return
	}

	result, err = client.CreatePortMirroringSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreatePortMirroring", nil, "Failure sending request")
		return
	}

	return
}

// CreatePortMirroringPreparer prepares the CreatePortMirroring request.
func (client WorkloadNetworksClient) CreatePortMirroringPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring WorkloadNetworkPortMirroring) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"portMirroringId":   autorest.Encode("path", portMirroringID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}", pathParameters),
		autorest.WithJSON(workloadNetworkPortMirroring),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePortMirroringSender sends the CreatePortMirroring request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreatePortMirroringSender(req *http.Request) (future WorkloadNetworksCreatePortMirroringFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreatePortMirroringResponder handles the response to the CreatePortMirroring request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreatePortMirroringResponder(resp *http.Response) (result WorkloadNetworkPortMirroring, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePublicIP sends the create public ip request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// publicIPID - NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
// workloadNetworkPublicIP - NSX Public IP Block
func (client WorkloadNetworksClient) CreatePublicIP(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string, workloadNetworkPublicIP WorkloadNetworkPublicIP) (result WorkloadNetworksCreatePublicIPFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreatePublicIP")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreatePublicIP", err.Error())
	}

	req, err := client.CreatePublicIPPreparer(ctx, resourceGroupName, privateCloudName, publicIPID, workloadNetworkPublicIP)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreatePublicIP", nil, "Failure preparing request")
		return
	}

	result, err = client.CreatePublicIPSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreatePublicIP", nil, "Failure sending request")
		return
	}

	return
}

// CreatePublicIPPreparer prepares the CreatePublicIP request.
func (client WorkloadNetworksClient) CreatePublicIPPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string, workloadNetworkPublicIP WorkloadNetworkPublicIP) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"publicIPId":        autorest.Encode("path", publicIPID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs/{publicIPId}", pathParameters),
		autorest.WithJSON(workloadNetworkPublicIP),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePublicIPSender sends the CreatePublicIP request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreatePublicIPSender(req *http.Request) (future WorkloadNetworksCreatePublicIPFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreatePublicIPResponder handles the response to the CreatePublicIP request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreatePublicIPResponder(resp *http.Response) (result WorkloadNetworkPublicIP, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateSegments sends the create segments request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// segmentID - NSX Segment identifier. Generally the same as the Segment's display name
// workloadNetworkSegment - NSX Segment
func (client WorkloadNetworksClient) CreateSegments(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment WorkloadNetworkSegment) (result WorkloadNetworksCreateSegmentsFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreateSegments")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreateSegments", err.Error())
	}

	req, err := client.CreateSegmentsPreparer(ctx, resourceGroupName, privateCloudName, segmentID, workloadNetworkSegment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateSegments", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSegmentsSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateSegments", nil, "Failure sending request")
		return
	}

	return
}

// CreateSegmentsPreparer prepares the CreateSegments request.
func (client WorkloadNetworksClient) CreateSegmentsPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment WorkloadNetworkSegment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"segmentId":         autorest.Encode("path", segmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}", pathParameters),
		autorest.WithJSON(workloadNetworkSegment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSegmentsSender sends the CreateSegments request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreateSegmentsSender(req *http.Request) (future WorkloadNetworksCreateSegmentsFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateSegmentsResponder handles the response to the CreateSegments request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreateSegmentsResponder(resp *http.Response) (result WorkloadNetworkSegment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateVMGroup sends the create vm group request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// VMGroupID - NSX VM Group identifier. Generally the same as the VM Group's display name
// workloadNetworkVMGroup - NSX VM Group
func (client WorkloadNetworksClient) CreateVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup WorkloadNetworkVMGroup) (result WorkloadNetworksCreateVMGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.CreateVMGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "CreateVMGroup", err.Error())
	}

	req, err := client.CreateVMGroupPreparer(ctx, resourceGroupName, privateCloudName, VMGroupID, workloadNetworkVMGroup)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateVMGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateVMGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "CreateVMGroup", nil, "Failure sending request")
		return
	}

	return
}

// CreateVMGroupPreparer prepares the CreateVMGroup request.
func (client WorkloadNetworksClient) CreateVMGroupPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup WorkloadNetworkVMGroup) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vmGroupId":         autorest.Encode("path", VMGroupID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}", pathParameters),
		autorest.WithJSON(workloadNetworkVMGroup),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateVMGroupSender sends the CreateVMGroup request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) CreateVMGroupSender(req *http.Request) (future WorkloadNetworksCreateVMGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateVMGroupResponder handles the response to the CreateVMGroup request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) CreateVMGroupResponder(resp *http.Response) (result WorkloadNetworkVMGroup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDhcp sends the delete dhcp request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// dhcpID - NSX DHCP identifier. Generally the same as the DHCP display name
func (client WorkloadNetworksClient) DeleteDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string) (result WorkloadNetworksDeleteDhcpFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeleteDhcp")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeleteDhcp", err.Error())
	}

	req, err := client.DeleteDhcpPreparer(ctx, resourceGroupName, privateCloudName, dhcpID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDhcp", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteDhcpSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDhcp", nil, "Failure sending request")
		return
	}

	return
}

// DeleteDhcpPreparer prepares the DeleteDhcp request.
func (client WorkloadNetworksClient) DeleteDhcpPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dhcpId":            autorest.Encode("path", dhcpID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDhcpSender sends the DeleteDhcp request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeleteDhcpSender(req *http.Request) (future WorkloadNetworksDeleteDhcpFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteDhcpResponder handles the response to the DeleteDhcp request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeleteDhcpResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDNSService sends the delete dns service request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// DNSServiceID - NSX DNS Service identifier. Generally the same as the DNS Service's display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) DeleteDNSService(ctx context.Context, resourceGroupName string, DNSServiceID string, privateCloudName string) (result WorkloadNetworksDeleteDNSServiceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeleteDNSService")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeleteDNSService", err.Error())
	}

	req, err := client.DeleteDNSServicePreparer(ctx, resourceGroupName, DNSServiceID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDNSService", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteDNSServiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDNSService", nil, "Failure sending request")
		return
	}

	return
}

// DeleteDNSServicePreparer prepares the DeleteDNSService request.
func (client WorkloadNetworksClient) DeleteDNSServicePreparer(ctx context.Context, resourceGroupName string, DNSServiceID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsServiceId":      autorest.Encode("path", DNSServiceID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDNSServiceSender sends the DeleteDNSService request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeleteDNSServiceSender(req *http.Request) (future WorkloadNetworksDeleteDNSServiceFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteDNSServiceResponder handles the response to the DeleteDNSService request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeleteDNSServiceResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDNSZone sends the delete dns zone request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// DNSZoneID - NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) DeleteDNSZone(ctx context.Context, resourceGroupName string, DNSZoneID string, privateCloudName string) (result WorkloadNetworksDeleteDNSZoneFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeleteDNSZone")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeleteDNSZone", err.Error())
	}

	req, err := client.DeleteDNSZonePreparer(ctx, resourceGroupName, DNSZoneID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDNSZone", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteDNSZoneSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteDNSZone", nil, "Failure sending request")
		return
	}

	return
}

// DeleteDNSZonePreparer prepares the DeleteDNSZone request.
func (client WorkloadNetworksClient) DeleteDNSZonePreparer(ctx context.Context, resourceGroupName string, DNSZoneID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsZoneId":         autorest.Encode("path", DNSZoneID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDNSZoneSender sends the DeleteDNSZone request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeleteDNSZoneSender(req *http.Request) (future WorkloadNetworksDeleteDNSZoneFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteDNSZoneResponder handles the response to the DeleteDNSZone request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeleteDNSZoneResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePortMirroring sends the delete port mirroring request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// portMirroringID - NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) DeletePortMirroring(ctx context.Context, resourceGroupName string, portMirroringID string, privateCloudName string) (result WorkloadNetworksDeletePortMirroringFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeletePortMirroring")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeletePortMirroring", err.Error())
	}

	req, err := client.DeletePortMirroringPreparer(ctx, resourceGroupName, portMirroringID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeletePortMirroring", nil, "Failure preparing request")
		return
	}

	result, err = client.DeletePortMirroringSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeletePortMirroring", nil, "Failure sending request")
		return
	}

	return
}

// DeletePortMirroringPreparer prepares the DeletePortMirroring request.
func (client WorkloadNetworksClient) DeletePortMirroringPreparer(ctx context.Context, resourceGroupName string, portMirroringID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"portMirroringId":   autorest.Encode("path", portMirroringID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePortMirroringSender sends the DeletePortMirroring request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeletePortMirroringSender(req *http.Request) (future WorkloadNetworksDeletePortMirroringFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeletePortMirroringResponder handles the response to the DeletePortMirroring request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeletePortMirroringResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePublicIP sends the delete public ip request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// publicIPID - NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) DeletePublicIP(ctx context.Context, resourceGroupName string, publicIPID string, privateCloudName string) (result WorkloadNetworksDeletePublicIPFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeletePublicIP")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeletePublicIP", err.Error())
	}

	req, err := client.DeletePublicIPPreparer(ctx, resourceGroupName, publicIPID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeletePublicIP", nil, "Failure preparing request")
		return
	}

	result, err = client.DeletePublicIPSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeletePublicIP", nil, "Failure sending request")
		return
	}

	return
}

// DeletePublicIPPreparer prepares the DeletePublicIP request.
func (client WorkloadNetworksClient) DeletePublicIPPreparer(ctx context.Context, resourceGroupName string, publicIPID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"publicIPId":        autorest.Encode("path", publicIPID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs/{publicIPId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePublicIPSender sends the DeletePublicIP request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeletePublicIPSender(req *http.Request) (future WorkloadNetworksDeletePublicIPFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeletePublicIPResponder handles the response to the DeletePublicIP request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeletePublicIPResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSegment sends the delete segment request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// segmentID - NSX Segment identifier. Generally the same as the Segment's display name
func (client WorkloadNetworksClient) DeleteSegment(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (result WorkloadNetworksDeleteSegmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeleteSegment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeleteSegment", err.Error())
	}

	req, err := client.DeleteSegmentPreparer(ctx, resourceGroupName, privateCloudName, segmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteSegment", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSegmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteSegment", nil, "Failure sending request")
		return
	}

	return
}

// DeleteSegmentPreparer prepares the DeleteSegment request.
func (client WorkloadNetworksClient) DeleteSegmentPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"segmentId":         autorest.Encode("path", segmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSegmentSender sends the DeleteSegment request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeleteSegmentSender(req *http.Request) (future WorkloadNetworksDeleteSegmentFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteSegmentResponder handles the response to the DeleteSegment request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeleteSegmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVMGroup sends the delete vm group request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// VMGroupID - NSX VM Group identifier. Generally the same as the VM Group's display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) DeleteVMGroup(ctx context.Context, resourceGroupName string, VMGroupID string, privateCloudName string) (result WorkloadNetworksDeleteVMGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.DeleteVMGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "DeleteVMGroup", err.Error())
	}

	req, err := client.DeleteVMGroupPreparer(ctx, resourceGroupName, VMGroupID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteVMGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteVMGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "DeleteVMGroup", nil, "Failure sending request")
		return
	}

	return
}

// DeleteVMGroupPreparer prepares the DeleteVMGroup request.
func (client WorkloadNetworksClient) DeleteVMGroupPreparer(ctx context.Context, resourceGroupName string, VMGroupID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vmGroupId":         autorest.Encode("path", VMGroupID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteVMGroupSender sends the DeleteVMGroup request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) DeleteVMGroupSender(req *http.Request) (future WorkloadNetworksDeleteVMGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteVMGroupResponder handles the response to the DeleteVMGroup request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) DeleteVMGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetDhcp sends the get dhcp request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// dhcpID - NSX DHCP identifier. Generally the same as the DHCP display name
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) GetDhcp(ctx context.Context, resourceGroupName string, dhcpID string, privateCloudName string) (result WorkloadNetworkDhcp, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetDhcp")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetDhcp", err.Error())
	}

	req, err := client.GetDhcpPreparer(ctx, resourceGroupName, dhcpID, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDhcp", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDhcpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDhcp", resp, "Failure sending request")
		return
	}

	result, err = client.GetDhcpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDhcp", resp, "Failure responding to request")
		return
	}

	return
}

// GetDhcpPreparer prepares the GetDhcp request.
func (client WorkloadNetworksClient) GetDhcpPreparer(ctx context.Context, resourceGroupName string, dhcpID string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dhcpId":            autorest.Encode("path", dhcpID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDhcpSender sends the GetDhcp request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetDhcpSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDhcpResponder handles the response to the GetDhcp request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetDhcpResponder(resp *http.Response) (result WorkloadNetworkDhcp, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDNSService sends the get dns service request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSServiceID - NSX DNS Service identifier. Generally the same as the DNS Service's display name
func (client WorkloadNetworksClient) GetDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string) (result WorkloadNetworkDNSService, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetDNSService")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetDNSService", err.Error())
	}

	req, err := client.GetDNSServicePreparer(ctx, resourceGroupName, privateCloudName, DNSServiceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSService", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDNSServiceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSService", resp, "Failure sending request")
		return
	}

	result, err = client.GetDNSServiceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSService", resp, "Failure responding to request")
		return
	}

	return
}

// GetDNSServicePreparer prepares the GetDNSService request.
func (client WorkloadNetworksClient) GetDNSServicePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsServiceId":      autorest.Encode("path", DNSServiceID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDNSServiceSender sends the GetDNSService request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetDNSServiceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDNSServiceResponder handles the response to the GetDNSService request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetDNSServiceResponder(resp *http.Response) (result WorkloadNetworkDNSService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDNSZone sends the get dns zone request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSZoneID - NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
func (client WorkloadNetworksClient) GetDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string) (result WorkloadNetworkDNSZone, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetDNSZone")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetDNSZone", err.Error())
	}

	req, err := client.GetDNSZonePreparer(ctx, resourceGroupName, privateCloudName, DNSZoneID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSZone", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDNSZoneSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSZone", resp, "Failure sending request")
		return
	}

	result, err = client.GetDNSZoneResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetDNSZone", resp, "Failure responding to request")
		return
	}

	return
}

// GetDNSZonePreparer prepares the GetDNSZone request.
func (client WorkloadNetworksClient) GetDNSZonePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsZoneId":         autorest.Encode("path", DNSZoneID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDNSZoneSender sends the GetDNSZone request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetDNSZoneSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDNSZoneResponder handles the response to the GetDNSZone request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetDNSZoneResponder(resp *http.Response) (result WorkloadNetworkDNSZone, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetGateway sends the get gateway request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// gatewayID - NSX Gateway identifier. Generally the same as the Gateway's display name
func (client WorkloadNetworksClient) GetGateway(ctx context.Context, resourceGroupName string, privateCloudName string, gatewayID string) (result WorkloadNetworkGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetGateway", err.Error())
	}

	req, err := client.GetGatewayPreparer(ctx, resourceGroupName, privateCloudName, gatewayID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetGateway", resp, "Failure responding to request")
		return
	}

	return
}

// GetGatewayPreparer prepares the GetGateway request.
func (client WorkloadNetworksClient) GetGatewayPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, gatewayID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayId":         autorest.Encode("path", gatewayID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/gateways/{gatewayId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetGatewaySender sends the GetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetGatewayResponder handles the response to the GetGateway request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetGatewayResponder(resp *http.Response) (result WorkloadNetworkGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPortMirroring sends the get port mirroring request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// portMirroringID - NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
func (client WorkloadNetworksClient) GetPortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string) (result WorkloadNetworkPortMirroring, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetPortMirroring")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetPortMirroring", err.Error())
	}

	req, err := client.GetPortMirroringPreparer(ctx, resourceGroupName, privateCloudName, portMirroringID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPortMirroring", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPortMirroringSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPortMirroring", resp, "Failure sending request")
		return
	}

	result, err = client.GetPortMirroringResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPortMirroring", resp, "Failure responding to request")
		return
	}

	return
}

// GetPortMirroringPreparer prepares the GetPortMirroring request.
func (client WorkloadNetworksClient) GetPortMirroringPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"portMirroringId":   autorest.Encode("path", portMirroringID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPortMirroringSender sends the GetPortMirroring request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetPortMirroringSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPortMirroringResponder handles the response to the GetPortMirroring request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetPortMirroringResponder(resp *http.Response) (result WorkloadNetworkPortMirroring, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicIP sends the get public ip request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// publicIPID - NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
func (client WorkloadNetworksClient) GetPublicIP(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string) (result WorkloadNetworkPublicIP, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetPublicIP")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetPublicIP", err.Error())
	}

	req, err := client.GetPublicIPPreparer(ctx, resourceGroupName, privateCloudName, publicIPID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPublicIP", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicIPSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPublicIP", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicIPResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetPublicIP", resp, "Failure responding to request")
		return
	}

	return
}

// GetPublicIPPreparer prepares the GetPublicIP request.
func (client WorkloadNetworksClient) GetPublicIPPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"publicIPId":        autorest.Encode("path", publicIPID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs/{publicIPId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPublicIPSender sends the GetPublicIP request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetPublicIPSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPublicIPResponder handles the response to the GetPublicIP request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetPublicIPResponder(resp *http.Response) (result WorkloadNetworkPublicIP, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSegment sends the get segment request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// segmentID - NSX Segment identifier. Generally the same as the Segment's display name
func (client WorkloadNetworksClient) GetSegment(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (result WorkloadNetworkSegment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetSegment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetSegment", err.Error())
	}

	req, err := client.GetSegmentPreparer(ctx, resourceGroupName, privateCloudName, segmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetSegment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSegmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetSegment", resp, "Failure sending request")
		return
	}

	result, err = client.GetSegmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetSegment", resp, "Failure responding to request")
		return
	}

	return
}

// GetSegmentPreparer prepares the GetSegment request.
func (client WorkloadNetworksClient) GetSegmentPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"segmentId":         autorest.Encode("path", segmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSegmentSender sends the GetSegment request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetSegmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSegmentResponder handles the response to the GetSegment request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetSegmentResponder(resp *http.Response) (result WorkloadNetworkSegment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVirtualMachine sends the get virtual machine request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// virtualMachineID - virtual Machine identifier
func (client WorkloadNetworksClient) GetVirtualMachine(ctx context.Context, resourceGroupName string, privateCloudName string, virtualMachineID string) (result WorkloadNetworkVirtualMachine, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetVirtualMachine")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetVirtualMachine", err.Error())
	}

	req, err := client.GetVirtualMachinePreparer(ctx, resourceGroupName, privateCloudName, virtualMachineID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVirtualMachine", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVirtualMachineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVirtualMachine", resp, "Failure sending request")
		return
	}

	result, err = client.GetVirtualMachineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVirtualMachine", resp, "Failure responding to request")
		return
	}

	return
}

// GetVirtualMachinePreparer prepares the GetVirtualMachine request.
func (client WorkloadNetworksClient) GetVirtualMachinePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, virtualMachineID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"virtualMachineId":  autorest.Encode("path", virtualMachineID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/virtualMachines/{virtualMachineId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVirtualMachineSender sends the GetVirtualMachine request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetVirtualMachineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVirtualMachineResponder handles the response to the GetVirtualMachine request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetVirtualMachineResponder(resp *http.Response) (result WorkloadNetworkVirtualMachine, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVMGroup sends the get vm group request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// VMGroupID - NSX VM Group identifier. Generally the same as the VM Group's display name
func (client WorkloadNetworksClient) GetVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string) (result WorkloadNetworkVMGroup, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.GetVMGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "GetVMGroup", err.Error())
	}

	req, err := client.GetVMGroupPreparer(ctx, resourceGroupName, privateCloudName, VMGroupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVMGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVMGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVMGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetVMGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "GetVMGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetVMGroupPreparer prepares the GetVMGroup request.
func (client WorkloadNetworksClient) GetVMGroupPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vmGroupId":         autorest.Encode("path", VMGroupID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVMGroupSender sends the GetVMGroup request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) GetVMGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVMGroupResponder handles the response to the GetVMGroup request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) GetVMGroupResponder(resp *http.Response) (result WorkloadNetworkVMGroup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDhcp sends the list dhcp request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListDhcp(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDhcpListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDhcp")
		defer func() {
			sc := -1
			if result.wndl.Response.Response != nil {
				sc = result.wndl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListDhcp", err.Error())
	}

	result.fn = client.listDhcpNextResults
	req, err := client.ListDhcpPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDhcp", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDhcpSender(req)
	if err != nil {
		result.wndl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDhcp", resp, "Failure sending request")
		return
	}

	result.wndl, err = client.ListDhcpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDhcp", resp, "Failure responding to request")
		return
	}
	if result.wndl.hasNextLink() && result.wndl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDhcpPreparer prepares the ListDhcp request.
func (client WorkloadNetworksClient) ListDhcpPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDhcpSender sends the ListDhcp request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListDhcpSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDhcpResponder handles the response to the ListDhcp request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListDhcpResponder(resp *http.Response) (result WorkloadNetworkDhcpList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDhcpNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listDhcpNextResults(ctx context.Context, lastResults WorkloadNetworkDhcpList) (result WorkloadNetworkDhcpList, err error) {
	req, err := lastResults.workloadNetworkDhcpListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDhcpNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDhcpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDhcpNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDhcpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDhcpNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDhcpComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListDhcpComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDhcpListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDhcp")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDhcp(ctx, resourceGroupName, privateCloudName)
	return
}

// ListDNSServices sends the list dns services request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListDNSServices(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDNSServicesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDNSServices")
		defer func() {
			sc := -1
			if result.wndsl.Response.Response != nil {
				sc = result.wndsl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListDNSServices", err.Error())
	}

	result.fn = client.listDNSServicesNextResults
	req, err := client.ListDNSServicesPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSServices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDNSServicesSender(req)
	if err != nil {
		result.wndsl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSServices", resp, "Failure sending request")
		return
	}

	result.wndsl, err = client.ListDNSServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSServices", resp, "Failure responding to request")
		return
	}
	if result.wndsl.hasNextLink() && result.wndsl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDNSServicesPreparer prepares the ListDNSServices request.
func (client WorkloadNetworksClient) ListDNSServicesPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDNSServicesSender sends the ListDNSServices request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListDNSServicesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDNSServicesResponder handles the response to the ListDNSServices request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListDNSServicesResponder(resp *http.Response) (result WorkloadNetworkDNSServicesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDNSServicesNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listDNSServicesNextResults(ctx context.Context, lastResults WorkloadNetworkDNSServicesList) (result WorkloadNetworkDNSServicesList, err error) {
	req, err := lastResults.workloadNetworkDNSServicesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSServicesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDNSServicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSServicesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDNSServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSServicesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDNSServicesComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListDNSServicesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDNSServicesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDNSServices")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDNSServices(ctx, resourceGroupName, privateCloudName)
	return
}

// ListDNSZones sends the list dns zones request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListDNSZones(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDNSZonesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDNSZones")
		defer func() {
			sc := -1
			if result.wndzl.Response.Response != nil {
				sc = result.wndzl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListDNSZones", err.Error())
	}

	result.fn = client.listDNSZonesNextResults
	req, err := client.ListDNSZonesPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSZones", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDNSZonesSender(req)
	if err != nil {
		result.wndzl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSZones", resp, "Failure sending request")
		return
	}

	result.wndzl, err = client.ListDNSZonesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListDNSZones", resp, "Failure responding to request")
		return
	}
	if result.wndzl.hasNextLink() && result.wndzl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDNSZonesPreparer prepares the ListDNSZones request.
func (client WorkloadNetworksClient) ListDNSZonesPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDNSZonesSender sends the ListDNSZones request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListDNSZonesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDNSZonesResponder handles the response to the ListDNSZones request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListDNSZonesResponder(resp *http.Response) (result WorkloadNetworkDNSZonesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDNSZonesNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listDNSZonesNextResults(ctx context.Context, lastResults WorkloadNetworkDNSZonesList) (result WorkloadNetworkDNSZonesList, err error) {
	req, err := lastResults.workloadNetworkDNSZonesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSZonesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDNSZonesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSZonesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDNSZonesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listDNSZonesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDNSZonesComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListDNSZonesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkDNSZonesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListDNSZones")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDNSZones(ctx, resourceGroupName, privateCloudName)
	return
}

// ListGateways sends the list gateways request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListGateways(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkGatewayListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListGateways")
		defer func() {
			sc := -1
			if result.wngl.Response.Response != nil {
				sc = result.wngl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListGateways", err.Error())
	}

	result.fn = client.listGatewaysNextResults
	req, err := client.ListGatewaysPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListGateways", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGatewaysSender(req)
	if err != nil {
		result.wngl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListGateways", resp, "Failure sending request")
		return
	}

	result.wngl, err = client.ListGatewaysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListGateways", resp, "Failure responding to request")
		return
	}
	if result.wngl.hasNextLink() && result.wngl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListGatewaysPreparer prepares the ListGateways request.
func (client WorkloadNetworksClient) ListGatewaysPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/gateways", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListGatewaysSender sends the ListGateways request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListGatewaysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListGatewaysResponder handles the response to the ListGateways request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListGatewaysResponder(resp *http.Response) (result WorkloadNetworkGatewayList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listGatewaysNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listGatewaysNextResults(ctx context.Context, lastResults WorkloadNetworkGatewayList) (result WorkloadNetworkGatewayList, err error) {
	req, err := lastResults.workloadNetworkGatewayListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listGatewaysNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListGatewaysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listGatewaysNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListGatewaysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listGatewaysNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListGatewaysComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListGatewaysComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkGatewayListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListGateways")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListGateways(ctx, resourceGroupName, privateCloudName)
	return
}

// ListPortMirroring sends the list port mirroring request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListPortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkPortMirroringListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListPortMirroring")
		defer func() {
			sc := -1
			if result.wnpml.Response.Response != nil {
				sc = result.wnpml.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListPortMirroring", err.Error())
	}

	result.fn = client.listPortMirroringNextResults
	req, err := client.ListPortMirroringPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPortMirroring", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPortMirroringSender(req)
	if err != nil {
		result.wnpml.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPortMirroring", resp, "Failure sending request")
		return
	}

	result.wnpml, err = client.ListPortMirroringResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPortMirroring", resp, "Failure responding to request")
		return
	}
	if result.wnpml.hasNextLink() && result.wnpml.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPortMirroringPreparer prepares the ListPortMirroring request.
func (client WorkloadNetworksClient) ListPortMirroringPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPortMirroringSender sends the ListPortMirroring request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListPortMirroringSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPortMirroringResponder handles the response to the ListPortMirroring request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListPortMirroringResponder(resp *http.Response) (result WorkloadNetworkPortMirroringList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPortMirroringNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listPortMirroringNextResults(ctx context.Context, lastResults WorkloadNetworkPortMirroringList) (result WorkloadNetworkPortMirroringList, err error) {
	req, err := lastResults.workloadNetworkPortMirroringListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPortMirroringNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPortMirroringSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPortMirroringNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPortMirroringResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPortMirroringNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPortMirroringComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListPortMirroringComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkPortMirroringListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListPortMirroring")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPortMirroring(ctx, resourceGroupName, privateCloudName)
	return
}

// ListPublicIPs sends the list public i ps request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListPublicIPs(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkPublicIPsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListPublicIPs")
		defer func() {
			sc := -1
			if result.wnpipl.Response.Response != nil {
				sc = result.wnpipl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListPublicIPs", err.Error())
	}

	result.fn = client.listPublicIPsNextResults
	req, err := client.ListPublicIPsPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPublicIPs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublicIPsSender(req)
	if err != nil {
		result.wnpipl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPublicIPs", resp, "Failure sending request")
		return
	}

	result.wnpipl, err = client.ListPublicIPsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListPublicIPs", resp, "Failure responding to request")
		return
	}
	if result.wnpipl.hasNextLink() && result.wnpipl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPublicIPsPreparer prepares the ListPublicIPs request.
func (client WorkloadNetworksClient) ListPublicIPsPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPublicIPsSender sends the ListPublicIPs request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListPublicIPsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPublicIPsResponder handles the response to the ListPublicIPs request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListPublicIPsResponder(resp *http.Response) (result WorkloadNetworkPublicIPsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPublicIPsNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listPublicIPsNextResults(ctx context.Context, lastResults WorkloadNetworkPublicIPsList) (result WorkloadNetworkPublicIPsList, err error) {
	req, err := lastResults.workloadNetworkPublicIPsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPublicIPsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPublicIPsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPublicIPsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPublicIPsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listPublicIPsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPublicIPsComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListPublicIPsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkPublicIPsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListPublicIPs")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPublicIPs(ctx, resourceGroupName, privateCloudName)
	return
}

// ListSegments sends the list segments request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListSegments(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkSegmentsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListSegments")
		defer func() {
			sc := -1
			if result.wnsl.Response.Response != nil {
				sc = result.wnsl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListSegments", err.Error())
	}

	result.fn = client.listSegmentsNextResults
	req, err := client.ListSegmentsPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListSegments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSegmentsSender(req)
	if err != nil {
		result.wnsl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListSegments", resp, "Failure sending request")
		return
	}

	result.wnsl, err = client.ListSegmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListSegments", resp, "Failure responding to request")
		return
	}
	if result.wnsl.hasNextLink() && result.wnsl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSegmentsPreparer prepares the ListSegments request.
func (client WorkloadNetworksClient) ListSegmentsPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSegmentsSender sends the ListSegments request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListSegmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSegmentsResponder handles the response to the ListSegments request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListSegmentsResponder(resp *http.Response) (result WorkloadNetworkSegmentsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSegmentsNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listSegmentsNextResults(ctx context.Context, lastResults WorkloadNetworkSegmentsList) (result WorkloadNetworkSegmentsList, err error) {
	req, err := lastResults.workloadNetworkSegmentsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listSegmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSegmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listSegmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSegmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listSegmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSegmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListSegmentsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkSegmentsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListSegments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSegments(ctx, resourceGroupName, privateCloudName)
	return
}

// ListVirtualMachines sends the list virtual machines request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListVirtualMachines(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkVirtualMachinesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListVirtualMachines")
		defer func() {
			sc := -1
			if result.wnvml.Response.Response != nil {
				sc = result.wnvml.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListVirtualMachines", err.Error())
	}

	result.fn = client.listVirtualMachinesNextResults
	req, err := client.ListVirtualMachinesPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVirtualMachines", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVirtualMachinesSender(req)
	if err != nil {
		result.wnvml.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVirtualMachines", resp, "Failure sending request")
		return
	}

	result.wnvml, err = client.ListVirtualMachinesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVirtualMachines", resp, "Failure responding to request")
		return
	}
	if result.wnvml.hasNextLink() && result.wnvml.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVirtualMachinesPreparer prepares the ListVirtualMachines request.
func (client WorkloadNetworksClient) ListVirtualMachinesPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/virtualMachines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVirtualMachinesSender sends the ListVirtualMachines request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListVirtualMachinesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVirtualMachinesResponder handles the response to the ListVirtualMachines request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListVirtualMachinesResponder(resp *http.Response) (result WorkloadNetworkVirtualMachinesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVirtualMachinesNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listVirtualMachinesNextResults(ctx context.Context, lastResults WorkloadNetworkVirtualMachinesList) (result WorkloadNetworkVirtualMachinesList, err error) {
	req, err := lastResults.workloadNetworkVirtualMachinesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVirtualMachinesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVirtualMachinesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVirtualMachinesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVirtualMachinesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVirtualMachinesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVirtualMachinesComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListVirtualMachinesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkVirtualMachinesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListVirtualMachines")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVirtualMachines(ctx, resourceGroupName, privateCloudName)
	return
}

// ListVMGroups sends the list vm groups request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
func (client WorkloadNetworksClient) ListVMGroups(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkVMGroupsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListVMGroups")
		defer func() {
			sc := -1
			if result.wnvgl.Response.Response != nil {
				sc = result.wnvgl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "ListVMGroups", err.Error())
	}

	result.fn = client.listVMGroupsNextResults
	req, err := client.ListVMGroupsPreparer(ctx, resourceGroupName, privateCloudName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVMGroups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVMGroupsSender(req)
	if err != nil {
		result.wnvgl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVMGroups", resp, "Failure sending request")
		return
	}

	result.wnvgl, err = client.ListVMGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "ListVMGroups", resp, "Failure responding to request")
		return
	}
	if result.wnvgl.hasNextLink() && result.wnvgl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVMGroupsPreparer prepares the ListVMGroups request.
func (client WorkloadNetworksClient) ListVMGroupsPreparer(ctx context.Context, resourceGroupName string, privateCloudName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVMGroupsSender sends the ListVMGroups request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) ListVMGroupsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVMGroupsResponder handles the response to the ListVMGroups request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) ListVMGroupsResponder(resp *http.Response) (result WorkloadNetworkVMGroupsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVMGroupsNextResults retrieves the next set of results, if any.
func (client WorkloadNetworksClient) listVMGroupsNextResults(ctx context.Context, lastResults WorkloadNetworkVMGroupsList) (result WorkloadNetworkVMGroupsList, err error) {
	req, err := lastResults.workloadNetworkVMGroupsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVMGroupsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVMGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVMGroupsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVMGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "listVMGroupsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVMGroupsComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkloadNetworksClient) ListVMGroupsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result WorkloadNetworkVMGroupsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.ListVMGroups")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVMGroups(ctx, resourceGroupName, privateCloudName)
	return
}

// UpdateDhcp sends the update dhcp request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// dhcpID - NSX DHCP identifier. Generally the same as the DHCP display name
// workloadNetworkDhcp - NSX DHCP
func (client WorkloadNetworksClient) UpdateDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp WorkloadNetworkDhcp) (result WorkloadNetworksUpdateDhcpFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdateDhcp")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdateDhcp", err.Error())
	}

	req, err := client.UpdateDhcpPreparer(ctx, resourceGroupName, privateCloudName, dhcpID, workloadNetworkDhcp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDhcp", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateDhcpSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDhcp", nil, "Failure sending request")
		return
	}

	return
}

// UpdateDhcpPreparer prepares the UpdateDhcp request.
func (client WorkloadNetworksClient) UpdateDhcpPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp WorkloadNetworkDhcp) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dhcpId":            autorest.Encode("path", dhcpID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}", pathParameters),
		autorest.WithJSON(workloadNetworkDhcp),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateDhcpSender sends the UpdateDhcp request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdateDhcpSender(req *http.Request) (future WorkloadNetworksUpdateDhcpFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateDhcpResponder handles the response to the UpdateDhcp request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdateDhcpResponder(resp *http.Response) (result WorkloadNetworkDhcp, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDNSService sends the update dns service request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSServiceID - NSX DNS Service identifier. Generally the same as the DNS Service's display name
// workloadNetworkDNSService - NSX DNS Service
func (client WorkloadNetworksClient) UpdateDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService WorkloadNetworkDNSService) (result WorkloadNetworksUpdateDNSServiceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdateDNSService")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdateDNSService", err.Error())
	}

	req, err := client.UpdateDNSServicePreparer(ctx, resourceGroupName, privateCloudName, DNSServiceID, workloadNetworkDNSService)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDNSService", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateDNSServiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDNSService", nil, "Failure sending request")
		return
	}

	return
}

// UpdateDNSServicePreparer prepares the UpdateDNSService request.
func (client WorkloadNetworksClient) UpdateDNSServicePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService WorkloadNetworkDNSService) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsServiceId":      autorest.Encode("path", DNSServiceID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsServices/{dnsServiceId}", pathParameters),
		autorest.WithJSON(workloadNetworkDNSService),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateDNSServiceSender sends the UpdateDNSService request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdateDNSServiceSender(req *http.Request) (future WorkloadNetworksUpdateDNSServiceFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateDNSServiceResponder handles the response to the UpdateDNSService request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdateDNSServiceResponder(resp *http.Response) (result WorkloadNetworkDNSService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDNSZone sends the update dns zone request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// DNSZoneID - NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
// workloadNetworkDNSZone - NSX DNS Zone
func (client WorkloadNetworksClient) UpdateDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone WorkloadNetworkDNSZone) (result WorkloadNetworksUpdateDNSZoneFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdateDNSZone")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdateDNSZone", err.Error())
	}

	req, err := client.UpdateDNSZonePreparer(ctx, resourceGroupName, privateCloudName, DNSZoneID, workloadNetworkDNSZone)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDNSZone", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateDNSZoneSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateDNSZone", nil, "Failure sending request")
		return
	}

	return
}

// UpdateDNSZonePreparer prepares the UpdateDNSZone request.
func (client WorkloadNetworksClient) UpdateDNSZonePreparer(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone WorkloadNetworkDNSZone) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dnsZoneId":         autorest.Encode("path", DNSZoneID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}", pathParameters),
		autorest.WithJSON(workloadNetworkDNSZone),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateDNSZoneSender sends the UpdateDNSZone request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdateDNSZoneSender(req *http.Request) (future WorkloadNetworksUpdateDNSZoneFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateDNSZoneResponder handles the response to the UpdateDNSZone request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdateDNSZoneResponder(resp *http.Response) (result WorkloadNetworkDNSZone, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePortMirroring sends the update port mirroring request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// portMirroringID - NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
// workloadNetworkPortMirroring - NSX port mirroring
func (client WorkloadNetworksClient) UpdatePortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring WorkloadNetworkPortMirroring) (result WorkloadNetworksUpdatePortMirroringFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdatePortMirroring")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdatePortMirroring", err.Error())
	}

	req, err := client.UpdatePortMirroringPreparer(ctx, resourceGroupName, privateCloudName, portMirroringID, workloadNetworkPortMirroring)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdatePortMirroring", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdatePortMirroringSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdatePortMirroring", nil, "Failure sending request")
		return
	}

	return
}

// UpdatePortMirroringPreparer prepares the UpdatePortMirroring request.
func (client WorkloadNetworksClient) UpdatePortMirroringPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring WorkloadNetworkPortMirroring) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"portMirroringId":   autorest.Encode("path", portMirroringID),
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/portMirroringProfiles/{portMirroringId}", pathParameters),
		autorest.WithJSON(workloadNetworkPortMirroring),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePortMirroringSender sends the UpdatePortMirroring request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdatePortMirroringSender(req *http.Request) (future WorkloadNetworksUpdatePortMirroringFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdatePortMirroringResponder handles the response to the UpdatePortMirroring request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdatePortMirroringResponder(resp *http.Response) (result WorkloadNetworkPortMirroring, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSegments sends the update segments request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// segmentID - NSX Segment identifier. Generally the same as the Segment's display name
// workloadNetworkSegment - NSX Segment
func (client WorkloadNetworksClient) UpdateSegments(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment WorkloadNetworkSegment) (result WorkloadNetworksUpdateSegmentsFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdateSegments")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdateSegments", err.Error())
	}

	req, err := client.UpdateSegmentsPreparer(ctx, resourceGroupName, privateCloudName, segmentID, workloadNetworkSegment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateSegments", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSegmentsSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateSegments", nil, "Failure sending request")
		return
	}

	return
}

// UpdateSegmentsPreparer prepares the UpdateSegments request.
func (client WorkloadNetworksClient) UpdateSegmentsPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment WorkloadNetworkSegment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"segmentId":         autorest.Encode("path", segmentID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}", pathParameters),
		autorest.WithJSON(workloadNetworkSegment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSegmentsSender sends the UpdateSegments request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdateSegmentsSender(req *http.Request) (future WorkloadNetworksUpdateSegmentsFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateSegmentsResponder handles the response to the UpdateSegments request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdateSegmentsResponder(resp *http.Response) (result WorkloadNetworkSegment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVMGroup sends the update vm group request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// privateCloudName - name of the private cloud
// VMGroupID - NSX VM Group identifier. Generally the same as the VM Group's display name
// workloadNetworkVMGroup - NSX VM Group
func (client WorkloadNetworksClient) UpdateVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup WorkloadNetworkVMGroup) (result WorkloadNetworksUpdateVMGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworksClient.UpdateVMGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("avs.WorkloadNetworksClient", "UpdateVMGroup", err.Error())
	}

	req, err := client.UpdateVMGroupPreparer(ctx, resourceGroupName, privateCloudName, VMGroupID, workloadNetworkVMGroup)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateVMGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateVMGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksClient", "UpdateVMGroup", nil, "Failure sending request")
		return
	}

	return
}

// UpdateVMGroupPreparer prepares the UpdateVMGroup request.
func (client WorkloadNetworksClient) UpdateVMGroupPreparer(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup WorkloadNetworkVMGroup) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"privateCloudName":  autorest.Encode("path", privateCloudName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vmGroupId":         autorest.Encode("path", VMGroupID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/vmGroups/{vmGroupId}", pathParameters),
		autorest.WithJSON(workloadNetworkVMGroup),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateVMGroupSender sends the UpdateVMGroup request. The method will close the
// http.Response Body if it receives an error.
func (client WorkloadNetworksClient) UpdateVMGroupSender(req *http.Request) (future WorkloadNetworksUpdateVMGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateVMGroupResponder handles the response to the UpdateVMGroup request. The method always
// closes the http.Response Body.
func (client WorkloadNetworksClient) UpdateVMGroupResponder(resp *http.Response) (result WorkloadNetworkVMGroup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
