// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package quantum

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/quantum/mgmt/2019-11-04-preview/quantum"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	Application     CreatedByType = original.Application
	Key             CreatedByType = original.Key
	ManagedIdentity CreatedByType = original.ManagedIdentity
	User            CreatedByType = original.User
)

type ProvisioningStatus = original.ProvisioningStatus

const (
	Failed               ProvisioningStatus = original.Failed
	ProviderDeleting     ProvisioningStatus = original.ProviderDeleting
	ProviderLaunching    ProvisioningStatus = original.ProviderLaunching
	ProviderProvisioning ProvisioningStatus = original.ProviderProvisioning
	ProviderUpdating     ProvisioningStatus = original.ProviderUpdating
	Succeeded            ProvisioningStatus = original.Succeeded
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	None           ResourceIdentityType = original.None
	SystemAssigned ResourceIdentityType = original.SystemAssigned
)

type Status = original.Status

const (
	StatusDeleted   Status = original.StatusDeleted
	StatusDeleting  Status = original.StatusDeleting
	StatusFailed    Status = original.StatusFailed
	StatusLaunching Status = original.StatusLaunching
	StatusSucceeded Status = original.StatusSucceeded
	StatusUpdating  Status = original.StatusUpdating
)

type UsableStatus = original.UsableStatus

const (
	No      UsableStatus = original.No
	Partial UsableStatus = original.Partial
	Yes     UsableStatus = original.Yes
)

type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type CheckNameAvailabilityParameters = original.CheckNameAvailabilityParameters
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type OfferingsClient = original.OfferingsClient
type OfferingsListResult = original.OfferingsListResult
type OfferingsListResultIterator = original.OfferingsListResultIterator
type OfferingsListResultPage = original.OfferingsListResultPage
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationsClient = original.OperationsClient
type OperationsList = original.OperationsList
type OperationsListIterator = original.OperationsListIterator
type OperationsListPage = original.OperationsListPage
type PricingDetail = original.PricingDetail
type PricingDimension = original.PricingDimension
type Provider = original.Provider
type ProviderDescription = original.ProviderDescription
type ProviderProperties = original.ProviderProperties
type ProviderPropertiesAad = original.ProviderPropertiesAad
type ProviderPropertiesManagedApplication = original.ProviderPropertiesManagedApplication
type ProxyResource = original.ProxyResource
type QuotaDimension = original.QuotaDimension
type Resource = original.Resource
type SkuDescription = original.SkuDescription
type SystemData = original.SystemData
type TagsObject = original.TagsObject
type TargetDescription = original.TargetDescription
type TrackedResource = original.TrackedResource
type Workspace = original.Workspace
type WorkspaceClient = original.WorkspaceClient
type WorkspaceIdentity = original.WorkspaceIdentity
type WorkspaceListResult = original.WorkspaceListResult
type WorkspaceListResultIterator = original.WorkspaceListResultIterator
type WorkspaceListResultPage = original.WorkspaceListResultPage
type WorkspaceResourceProperties = original.WorkspaceResourceProperties
type WorkspacesClient = original.WorkspacesClient
type WorkspacesCreateOrUpdateFuture = original.WorkspacesCreateOrUpdateFuture
type WorkspacesDeleteFuture = original.WorkspacesDeleteFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOfferingsClient(subscriptionID string) OfferingsClient {
	return original.NewOfferingsClient(subscriptionID)
}
func NewOfferingsClientWithBaseURI(baseURI string, subscriptionID string) OfferingsClient {
	return original.NewOfferingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOfferingsListResultIterator(page OfferingsListResultPage) OfferingsListResultIterator {
	return original.NewOfferingsListResultIterator(page)
}
func NewOfferingsListResultPage(cur OfferingsListResult, getNextPage func(context.Context, OfferingsListResult) (OfferingsListResult, error)) OfferingsListResultPage {
	return original.NewOfferingsListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return original.NewOperationsListIterator(page)
}
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return original.NewOperationsListPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceClient(subscriptionID string) WorkspaceClient {
	return original.NewWorkspaceClient(subscriptionID)
}
func NewWorkspaceClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceClient {
	return original.NewWorkspaceClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return original.NewWorkspaceListResultIterator(page)
}
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return original.NewWorkspaceListResultPage(cur, getNextPage)
}
func NewWorkspacesClient(subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClient(subscriptionID)
}
func NewWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleProvisioningStatusValues() []ProvisioningStatus {
	return original.PossibleProvisioningStatusValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleUsableStatusValues() []UsableStatus {
	return original.PossibleUsableStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
