// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package siterecovery

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2018-07-10/siterecovery"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type A2ARecoveryAvailabilityType = original.A2ARecoveryAvailabilityType

const (
	AvailabilitySet  A2ARecoveryAvailabilityType = original.AvailabilitySet
	AvailabilityZone A2ARecoveryAvailabilityType = original.AvailabilityZone
	Single           A2ARecoveryAvailabilityType = original.Single
)

type A2ARpRecoveryPointType = original.A2ARpRecoveryPointType

const (
	Latest                      A2ARpRecoveryPointType = original.Latest
	LatestApplicationConsistent A2ARpRecoveryPointType = original.LatestApplicationConsistent
	LatestCrashConsistent       A2ARpRecoveryPointType = original.LatestCrashConsistent
	LatestProcessed             A2ARpRecoveryPointType = original.LatestProcessed
)

type AgentAutoUpdateStatus = original.AgentAutoUpdateStatus

const (
	Disabled AgentAutoUpdateStatus = original.Disabled
	Enabled  AgentAutoUpdateStatus = original.Enabled
)

type AgentUpgradeBlockedReason = original.AgentUpgradeBlockedReason

const (
	AgentNoHeartbeat              AgentUpgradeBlockedReason = original.AgentNoHeartbeat
	AlreadyOnLatestVersion        AgentUpgradeBlockedReason = original.AlreadyOnLatestVersion
	DistroIsNotReported           AgentUpgradeBlockedReason = original.DistroIsNotReported
	DistroNotSupportedForUpgrade  AgentUpgradeBlockedReason = original.DistroNotSupportedForUpgrade
	IncompatibleApplianceVersion  AgentUpgradeBlockedReason = original.IncompatibleApplianceVersion
	InvalidAgentVersion           AgentUpgradeBlockedReason = original.InvalidAgentVersion
	InvalidDriverVersion          AgentUpgradeBlockedReason = original.InvalidDriverVersion
	MissingUpgradePath            AgentUpgradeBlockedReason = original.MissingUpgradePath
	NotProtected                  AgentUpgradeBlockedReason = original.NotProtected
	ProcessServerNoHeartbeat      AgentUpgradeBlockedReason = original.ProcessServerNoHeartbeat
	RcmProxyNoHeartbeat           AgentUpgradeBlockedReason = original.RcmProxyNoHeartbeat
	RebootRequired                AgentUpgradeBlockedReason = original.RebootRequired
	Unknown                       AgentUpgradeBlockedReason = original.Unknown
	UnsupportedProtectionScenario AgentUpgradeBlockedReason = original.UnsupportedProtectionScenario
)

type AgentVersionStatus = original.AgentVersionStatus

const (
	Deprecated             AgentVersionStatus = original.Deprecated
	NotSupported           AgentVersionStatus = original.NotSupported
	SecurityUpdateRequired AgentVersionStatus = original.SecurityUpdateRequired
	Supported              AgentVersionStatus = original.Supported
	UpdateRequired         AgentVersionStatus = original.UpdateRequired
)

type AlternateLocationRecoveryOption = original.AlternateLocationRecoveryOption

const (
	CreateVMIfNotFound AlternateLocationRecoveryOption = original.CreateVMIfNotFound
	NoAction           AlternateLocationRecoveryOption = original.NoAction
)

type AutoProtectionOfDataDisk = original.AutoProtectionOfDataDisk

const (
	AutoProtectionOfDataDiskDisabled AutoProtectionOfDataDisk = original.AutoProtectionOfDataDiskDisabled
	AutoProtectionOfDataDiskEnabled  AutoProtectionOfDataDisk = original.AutoProtectionOfDataDiskEnabled
)

type AutoProtectionOfDataDiskStatus = original.AutoProtectionOfDataDiskStatus

const (
	AutoProtectionOfDataDiskStatusDisabled AutoProtectionOfDataDiskStatus = original.AutoProtectionOfDataDiskStatusDisabled
	AutoProtectionOfDataDiskStatusEnabled  AutoProtectionOfDataDiskStatus = original.AutoProtectionOfDataDiskStatusEnabled
)

type DataSyncStatus = original.DataSyncStatus

const (
	ForDownTime        DataSyncStatus = original.ForDownTime
	ForSynchronization DataSyncStatus = original.ForSynchronization
)

type DisableProtectionReason = original.DisableProtectionReason

const (
	MigrationComplete DisableProtectionReason = original.MigrationComplete
	NotSpecified      DisableProtectionReason = original.NotSpecified
)

type DiskAccountType = original.DiskAccountType

const (
	PremiumLRS     DiskAccountType = original.PremiumLRS
	StandardLRS    DiskAccountType = original.StandardLRS
	StandardSSDLRS DiskAccountType = original.StandardSSDLRS
)

type DiskType = original.DiskType

const (
	DiskTypePremiumLRS     DiskType = original.DiskTypePremiumLRS
	DiskTypeStandardLRS    DiskType = original.DiskTypeStandardLRS
	DiskTypeStandardSSDLRS DiskType = original.DiskTypeStandardSSDLRS
)

type EthernetAddressType = original.EthernetAddressType

const (
	Dynamic EthernetAddressType = original.Dynamic
	Static  EthernetAddressType = original.Static
)

type FailoverDeploymentModel = original.FailoverDeploymentModel

const (
	Classic         FailoverDeploymentModel = original.Classic
	NotApplicable   FailoverDeploymentModel = original.NotApplicable
	ResourceManager FailoverDeploymentModel = original.ResourceManager
)

type HealthErrorCategory = original.HealthErrorCategory

const (
	AgentAutoUpdate      HealthErrorCategory = original.AgentAutoUpdate
	Configuration        HealthErrorCategory = original.Configuration
	FabricInfrastructure HealthErrorCategory = original.FabricInfrastructure
	None                 HealthErrorCategory = original.None
	Replication          HealthErrorCategory = original.Replication
	TestFailover         HealthErrorCategory = original.TestFailover
	VersionExpiry        HealthErrorCategory = original.VersionExpiry
)

type HealthErrorCustomerResolvability = original.HealthErrorCustomerResolvability

const (
	Allowed    HealthErrorCustomerResolvability = original.Allowed
	NotAllowed HealthErrorCustomerResolvability = original.NotAllowed
)

type HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointType

const (
	HyperVReplicaAzureRpRecoveryPointTypeLatest                      HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatest
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed             HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed
)

type InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointType

const (
	InMageV2RpRecoveryPointTypeLatest                      InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatest
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestApplicationConsistent
	InMageV2RpRecoveryPointTypeLatestCrashConsistent       InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestCrashConsistent
	InMageV2RpRecoveryPointTypeLatestProcessed             InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestProcessed
)

type InstanceType = original.InstanceType

const (
	InstanceTypeA2A                           InstanceType = original.InstanceTypeA2A
	InstanceTypeAddDisksProviderSpecificInput InstanceType = original.InstanceTypeAddDisksProviderSpecificInput
)

type InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInput

const (
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A                                     InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure                      InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2                           InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm                               InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = original.InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm
)

type InstanceTypeBasicConfigurationSettings = original.InstanceTypeBasicConfigurationSettings

const (
	InstanceTypeConfigurationSettings   InstanceTypeBasicConfigurationSettings = original.InstanceTypeConfigurationSettings
	InstanceTypeHyperVVirtualMachine    InstanceTypeBasicConfigurationSettings = original.InstanceTypeHyperVVirtualMachine
	InstanceTypeReplicationGroupDetails InstanceTypeBasicConfigurationSettings = original.InstanceTypeReplicationGroupDetails
	InstanceTypeVmmVirtualMachine       InstanceTypeBasicConfigurationSettings = original.InstanceTypeVmmVirtualMachine
	InstanceTypeVMwareVirtualMachine    InstanceTypeBasicConfigurationSettings = original.InstanceTypeVMwareVirtualMachine
)

type InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails = original.InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails

const (
	InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A                                           InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails = original.InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeCreateProtectionIntentProviderSpecificDetails InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails = original.InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeCreateProtectionIntentProviderSpecificDetails
)

type InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeBasicDisableProtectionProviderSpecificInput

const (
	InstanceTypeDisableProtectionProviderSpecificInput InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeDisableProtectionProviderSpecificInput
	InstanceTypeInMage                                 InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeInMage
)

type InstanceTypeBasicEnableMigrationProviderSpecificInput = original.InstanceTypeBasicEnableMigrationProviderSpecificInput

const (
	InstanceTypeEnableMigrationProviderSpecificInput InstanceTypeBasicEnableMigrationProviderSpecificInput = original.InstanceTypeEnableMigrationProviderSpecificInput
	InstanceTypeVMwareCbt                            InstanceTypeBasicEnableMigrationProviderSpecificInput = original.InstanceTypeVMwareCbt
)

type InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInput

const (
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A                                   InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure                    InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage                                InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2                         InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm                             InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan                                   InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan
)

type InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetails

const (
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A                           InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails  InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012             InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2           InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure            InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2                 InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm                     InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm
)

type InstanceTypeBasicEventSpecificDetails = original.InstanceTypeBasicEventSpecificDetails

const (
	InstanceTypeEventSpecificDetails InstanceTypeBasicEventSpecificDetails = original.InstanceTypeEventSpecificDetails
	InstanceTypeJobStatus            InstanceTypeBasicEventSpecificDetails = original.InstanceTypeJobStatus
)

type InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificCreateNetworkMappingInput

const (
	InstanceTypeAzureToAzure                            InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeAzureToAzure
	InstanceTypeFabricSpecificCreateNetworkMappingInput InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeFabricSpecificCreateNetworkMappingInput
	InstanceTypeVmmToAzure                              InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeVmmToAzure
	InstanceTypeVmmToVmm                                InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeVmmToVmm
)

type InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeBasicFabricSpecificCreationInput

const (
	InstanceTypeAzure                       InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeAzure
	InstanceTypeFabricSpecificCreationInput InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeFabricSpecificCreationInput
	InstanceTypeInMageRcm                   InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeInMageRcm
	InstanceTypeVMwareV2                    InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeVMwareV2
)

type InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetails

const (
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure                 InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite            InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm             InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM                   InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware                InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2              InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2
)

type InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput

const (
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure                            InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure                              InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm                                InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm
)

type InstanceTypeBasicGroupTaskDetails = original.InstanceTypeBasicGroupTaskDetails

const (
	InstanceTypeGroupTaskDetails                     InstanceTypeBasicGroupTaskDetails = original.InstanceTypeGroupTaskDetails
	InstanceTypeInlineWorkflowTaskDetails            InstanceTypeBasicGroupTaskDetails = original.InstanceTypeInlineWorkflowTaskDetails
	InstanceTypeRecoveryPlanGroupTaskDetails         InstanceTypeBasicGroupTaskDetails = original.InstanceTypeRecoveryPlanGroupTaskDetails
	InstanceTypeRecoveryPlanShutdownGroupTaskDetails InstanceTypeBasicGroupTaskDetails = original.InstanceTypeRecoveryPlanShutdownGroupTaskDetails
)

type InstanceTypeBasicJobDetails = original.InstanceTypeBasicJobDetails

const (
	InstanceTypeAsrJobDetails              InstanceTypeBasicJobDetails = original.InstanceTypeAsrJobDetails
	InstanceTypeExportJobDetails           InstanceTypeBasicJobDetails = original.InstanceTypeExportJobDetails
	InstanceTypeFailoverJobDetails         InstanceTypeBasicJobDetails = original.InstanceTypeFailoverJobDetails
	InstanceTypeJobDetails                 InstanceTypeBasicJobDetails = original.InstanceTypeJobDetails
	InstanceTypeSwitchProtectionJobDetails InstanceTypeBasicJobDetails = original.InstanceTypeSwitchProtectionJobDetails
	InstanceTypeTestFailoverJobDetails     InstanceTypeBasicJobDetails = original.InstanceTypeTestFailoverJobDetails
)

type InstanceTypeBasicMigrateProviderSpecificInput = original.InstanceTypeBasicMigrateProviderSpecificInput

const (
	InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeMigrateProviderSpecificInput InstanceTypeBasicMigrateProviderSpecificInput = original.InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeMigrateProviderSpecificInput
	InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeVMwareCbt                    InstanceTypeBasicMigrateProviderSpecificInput = original.InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicMigrationProviderSpecificSettings = original.InstanceTypeBasicMigrationProviderSpecificSettings

const (
	InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeMigrationProviderSpecificSettings InstanceTypeBasicMigrationProviderSpecificSettings = original.InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeMigrationProviderSpecificSettings
	InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeVMwareCbt                         InstanceTypeBasicMigrationProviderSpecificSettings = original.InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeVMwareCbt
)

type InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettings

const (
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure                         InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure                           InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm                             InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm
)

type InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetails

const (
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A                            InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012              InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2            InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure             InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage                         InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2                  InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails        InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm                      InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails  InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration              InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt                      InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt
)

type InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInput

const (
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A                         InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012           InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2         InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure          InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage                      InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2               InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm                   InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt                   InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails

const (
	InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A                                               InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails
	InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeVMwareCbt                                         InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeVMwareCbt
)

type InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInput

const (
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A                           InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure            InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback    InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage                        InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2                 InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput
)

type InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetails

const (
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A                                  InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2                        InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm                            InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails
)

type InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeBasicRecoveryPlanActionDetails

const (
	InstanceTypeAutomationRunbookActionDetails InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeAutomationRunbookActionDetails
	InstanceTypeManualActionDetails            InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeManualActionDetails
	InstanceTypeRecoveryPlanActionDetails      InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeRecoveryPlanActionDetails
	InstanceTypeScriptActionDetails            InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeScriptActionDetails
)

type InstanceTypeBasicRecoveryPlanProviderSpecificDetails = original.InstanceTypeBasicRecoveryPlanProviderSpecificDetails

const (
	InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A                                 InstanceTypeBasicRecoveryPlanProviderSpecificDetails = original.InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeRecoveryPlanProviderSpecificDetails InstanceTypeBasicRecoveryPlanProviderSpecificDetails = original.InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeRecoveryPlanProviderSpecificDetails
)

type InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput

const (
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A                                       InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure                        InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback                InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage                                    InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2                             InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm                                 InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput
)

type InstanceTypeBasicRecoveryPlanProviderSpecificInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificInput

const (
	InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A                               InstanceTypeBasicRecoveryPlanProviderSpecificInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeRecoveryPlanProviderSpecificInput InstanceTypeBasicRecoveryPlanProviderSpecificInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeRecoveryPlanProviderSpecificInput
)

type InstanceTypeBasicRemoveDisksProviderSpecificInput = original.InstanceTypeBasicRemoveDisksProviderSpecificInput

const (
	InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A                              InstanceTypeBasicRemoveDisksProviderSpecificInput = original.InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeRemoveDisksProviderSpecificInput InstanceTypeBasicRemoveDisksProviderSpecificInput = original.InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeRemoveDisksProviderSpecificInput
)

type InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings = original.InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings

const (
	InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeA2A                                                 InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings = original.InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeA2A
	InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeReplicationProtectionIntentProviderSpecificSettings InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings = original.InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeReplicationProtectionIntentProviderSpecificSettings
)

type InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInput

const (
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A                                                                                  InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput                                    InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeSixcSevendaFourFiveFiveFiveZeroSixfFourThreeffAOneSixaEightebOneZeroOneaebbSevenZero InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeSixcSevendaFourFiveFiveFiveZeroSixfFourThreeffAOneSixaEightebOneZeroOneaebbSevenZero
)

type InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInput

const (
	InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A                                              InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeReplicationProviderSpecificContainerMappingInput InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeReplicationProviderSpecificContainerMappingInput
	InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeVMwareCbt                                        InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettings

const (
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A                                 InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012                   InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2                 InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure                  InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage                              InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2                       InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm                           InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings
)

type InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput

const (
	InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A                                                    InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeReplicationProviderSpecificUpdateContainerMappingInput InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeReplicationProviderSpecificUpdateContainerMappingInput
)

type InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInput

const (
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A                                     InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure                      InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage                                  InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2                           InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput
)

type InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInput

const (
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A                                   InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput
)

type InstanceTypeBasicTaskTypeDetails = original.InstanceTypeBasicTaskTypeDetails

const (
	InstanceTypeAutomationRunbookTaskDetails      InstanceTypeBasicTaskTypeDetails = original.InstanceTypeAutomationRunbookTaskDetails
	InstanceTypeConsistencyCheckTaskDetails       InstanceTypeBasicTaskTypeDetails = original.InstanceTypeConsistencyCheckTaskDetails
	InstanceTypeFabricReplicationGroupTaskDetails InstanceTypeBasicTaskTypeDetails = original.InstanceTypeFabricReplicationGroupTaskDetails
	InstanceTypeJobTaskDetails                    InstanceTypeBasicTaskTypeDetails = original.InstanceTypeJobTaskDetails
	InstanceTypeManualActionTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeManualActionTaskDetails
	InstanceTypeScriptActionTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeScriptActionTaskDetails
	InstanceTypeTaskTypeDetails                   InstanceTypeBasicTaskTypeDetails = original.InstanceTypeTaskTypeDetails
	InstanceTypeVirtualMachineTaskDetails         InstanceTypeBasicTaskTypeDetails = original.InstanceTypeVirtualMachineTaskDetails
	InstanceTypeVMNicUpdatesTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeVMNicUpdatesTaskDetails
)

type InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInput

const (
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A                               InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure                InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage                            InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2                     InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm                         InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm
	InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput InstanceTypeBasicTestFailoverProviderSpecificInput = original.InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput
)

type InstanceTypeBasicTestMigrateProviderSpecificInput = original.InstanceTypeBasicTestMigrateProviderSpecificInput

const (
	InstanceTypeBasicTestMigrateProviderSpecificInputInstanceTypeTestMigrateProviderSpecificInput InstanceTypeBasicTestMigrateProviderSpecificInput = original.InstanceTypeBasicTestMigrateProviderSpecificInputInstanceTypeTestMigrateProviderSpecificInput
	InstanceTypeBasicTestMigrateProviderSpecificInputInstanceTypeVMwareCbt                        InstanceTypeBasicTestMigrateProviderSpecificInput = original.InstanceTypeBasicTestMigrateProviderSpecificInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInput

const (
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A                                    InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure                     InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage                                 InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2                          InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm                              InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm
	InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput InstanceTypeBasicUnplannedFailoverProviderSpecificInput = original.InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput
)

type InstanceTypeBasicUpdateMigrationItemProviderSpecificInput = original.InstanceTypeBasicUpdateMigrationItemProviderSpecificInput

const (
	InstanceTypeBasicUpdateMigrationItemProviderSpecificInputInstanceTypeUpdateMigrationItemProviderSpecificInput InstanceTypeBasicUpdateMigrationItemProviderSpecificInput = original.InstanceTypeBasicUpdateMigrationItemProviderSpecificInputInstanceTypeUpdateMigrationItemProviderSpecificInput
	InstanceTypeBasicUpdateMigrationItemProviderSpecificInputInstanceTypeVMwareCbt                                InstanceTypeBasicUpdateMigrationItemProviderSpecificInput = original.InstanceTypeBasicUpdateMigrationItemProviderSpecificInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInput

const (
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A                                         InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure                          InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2                               InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm                                   InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput
)

type LicenseType = original.LicenseType

const (
	LicenseTypeNoLicenseType LicenseType = original.LicenseTypeNoLicenseType
	LicenseTypeNotSpecified  LicenseType = original.LicenseTypeNotSpecified
	LicenseTypeWindowsServer LicenseType = original.LicenseTypeWindowsServer
)

type MigrationItemOperation = original.MigrationItemOperation

const (
	DisableMigration   MigrationItemOperation = original.DisableMigration
	Migrate            MigrationItemOperation = original.Migrate
	TestMigrate        MigrationItemOperation = original.TestMigrate
	TestMigrateCleanup MigrationItemOperation = original.TestMigrateCleanup
)

type MigrationRecoveryPointType = original.MigrationRecoveryPointType

const (
	MigrationRecoveryPointTypeApplicationConsistent MigrationRecoveryPointType = original.MigrationRecoveryPointTypeApplicationConsistent
	MigrationRecoveryPointTypeCrashConsistent       MigrationRecoveryPointType = original.MigrationRecoveryPointTypeCrashConsistent
	MigrationRecoveryPointTypeNotSpecified          MigrationRecoveryPointType = original.MigrationRecoveryPointTypeNotSpecified
)

type MigrationState = original.MigrationState

const (
	MigrationStateDisableMigrationFailed     MigrationState = original.MigrationStateDisableMigrationFailed
	MigrationStateDisableMigrationInProgress MigrationState = original.MigrationStateDisableMigrationInProgress
	MigrationStateEnableMigrationFailed      MigrationState = original.MigrationStateEnableMigrationFailed
	MigrationStateEnableMigrationInProgress  MigrationState = original.MigrationStateEnableMigrationInProgress
	MigrationStateInitialSeedingFailed       MigrationState = original.MigrationStateInitialSeedingFailed
	MigrationStateInitialSeedingInProgress   MigrationState = original.MigrationStateInitialSeedingInProgress
	MigrationStateMigrationFailed            MigrationState = original.MigrationStateMigrationFailed
	MigrationStateMigrationInProgress        MigrationState = original.MigrationStateMigrationInProgress
	MigrationStateMigrationSucceeded         MigrationState = original.MigrationStateMigrationSucceeded
	MigrationStateNone                       MigrationState = original.MigrationStateNone
	MigrationStateReplicating                MigrationState = original.MigrationStateReplicating
)

type MobilityAgentUpgradeState = original.MobilityAgentUpgradeState

const (
	MobilityAgentUpgradeStateCommit    MobilityAgentUpgradeState = original.MobilityAgentUpgradeStateCommit
	MobilityAgentUpgradeStateCompleted MobilityAgentUpgradeState = original.MobilityAgentUpgradeStateCompleted
	MobilityAgentUpgradeStateNone      MobilityAgentUpgradeState = original.MobilityAgentUpgradeStateNone
	MobilityAgentUpgradeStateStarted   MobilityAgentUpgradeState = original.MobilityAgentUpgradeStateStarted
)

type MultiVMGroupCreateOption = original.MultiVMGroupCreateOption

const (
	AutoCreated   MultiVMGroupCreateOption = original.AutoCreated
	UserSpecified MultiVMGroupCreateOption = original.UserSpecified
)

type MultiVMSyncPointOption = original.MultiVMSyncPointOption

const (
	UseMultiVMSyncRecoveryPoint MultiVMSyncPointOption = original.UseMultiVMSyncRecoveryPoint
	UsePerVMRecoveryPoint       MultiVMSyncPointOption = original.UsePerVMRecoveryPoint
)

type MultiVMSyncStatus = original.MultiVMSyncStatus

const (
	MultiVMSyncStatusDisabled MultiVMSyncStatus = original.MultiVMSyncStatusDisabled
	MultiVMSyncStatusEnabled  MultiVMSyncStatus = original.MultiVMSyncStatusEnabled
)

type PossibleOperationsDirections = original.PossibleOperationsDirections

const (
	PrimaryToRecovery PossibleOperationsDirections = original.PrimaryToRecovery
	RecoveryToPrimary PossibleOperationsDirections = original.RecoveryToPrimary
)

type PresenceStatus = original.PresenceStatus

const (
	PresenceStatusNotPresent PresenceStatus = original.PresenceStatusNotPresent
	PresenceStatusPresent    PresenceStatus = original.PresenceStatusPresent
	PresenceStatusUnknown    PresenceStatus = original.PresenceStatusUnknown
)

type ProtectionHealth = original.ProtectionHealth

const (
	ProtectionHealthCritical ProtectionHealth = original.ProtectionHealthCritical
	ProtectionHealthNone     ProtectionHealth = original.ProtectionHealthNone
	ProtectionHealthNormal   ProtectionHealth = original.ProtectionHealthNormal
	ProtectionHealthWarning  ProtectionHealth = original.ProtectionHealthWarning
)

type RecoveryPlanActionLocation = original.RecoveryPlanActionLocation

const (
	Primary  RecoveryPlanActionLocation = original.Primary
	Recovery RecoveryPlanActionLocation = original.Recovery
)

type RecoveryPlanGroupType = original.RecoveryPlanGroupType

const (
	Boot     RecoveryPlanGroupType = original.Boot
	Failover RecoveryPlanGroupType = original.Failover
	Shutdown RecoveryPlanGroupType = original.Shutdown
)

type RecoveryPlanPointType = original.RecoveryPlanPointType

const (
	RecoveryPlanPointTypeLatest                      RecoveryPlanPointType = original.RecoveryPlanPointTypeLatest
	RecoveryPlanPointTypeLatestApplicationConsistent RecoveryPlanPointType = original.RecoveryPlanPointTypeLatestApplicationConsistent
	RecoveryPlanPointTypeLatestCrashConsistent       RecoveryPlanPointType = original.RecoveryPlanPointTypeLatestCrashConsistent
	RecoveryPlanPointTypeLatestProcessed             RecoveryPlanPointType = original.RecoveryPlanPointTypeLatestProcessed
)

type RecoveryPointSyncType = original.RecoveryPointSyncType

const (
	MultiVMSyncRecoveryPoint RecoveryPointSyncType = original.MultiVMSyncRecoveryPoint
	PerVMRecoveryPoint       RecoveryPointSyncType = original.PerVMRecoveryPoint
)

type RecoveryPointType = original.RecoveryPointType

const (
	Custom     RecoveryPointType = original.Custom
	LatestTag  RecoveryPointType = original.LatestTag
	LatestTime RecoveryPointType = original.LatestTime
)

type ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperation

const (
	ReplicationProtectedItemOperationChangePit           ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationChangePit
	ReplicationProtectedItemOperationCommit              ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationCommit
	ReplicationProtectedItemOperationCompleteMigration   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationCompleteMigration
	ReplicationProtectedItemOperationDisableProtection   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationDisableProtection
	ReplicationProtectedItemOperationFailback            ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationFailback
	ReplicationProtectedItemOperationFinalizeFailback    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationFinalizeFailback
	ReplicationProtectedItemOperationPlannedFailover     ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationPlannedFailover
	ReplicationProtectedItemOperationRepairReplication   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationRepairReplication
	ReplicationProtectedItemOperationReverseReplicate    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationReverseReplicate
	ReplicationProtectedItemOperationSwitchProtection    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationSwitchProtection
	ReplicationProtectedItemOperationTestFailover        ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationTestFailover
	ReplicationProtectedItemOperationTestFailoverCleanup ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationTestFailoverCleanup
	ReplicationProtectedItemOperationUnplannedFailover   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationUnplannedFailover
)

type ResourceType = original.ResourceType

const (
	ResourceTypeExisting                       ResourceType = original.ResourceTypeExisting
	ResourceTypeNew                            ResourceType = original.ResourceTypeNew
	ResourceTypeProtectionProfileCustomDetails ResourceType = original.ResourceTypeProtectionProfileCustomDetails
)

type ResourceTypeBasicRecoveryAvailabilitySetCustomDetails = original.ResourceTypeBasicRecoveryAvailabilitySetCustomDetails

const (
	ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting                             ResourceTypeBasicRecoveryAvailabilitySetCustomDetails = original.ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting
	ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeRecoveryAvailabilitySetCustomDetails ResourceTypeBasicRecoveryAvailabilitySetCustomDetails = original.ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeRecoveryAvailabilitySetCustomDetails
)

type ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails = original.ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails

const (
	ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting                                     ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails = original.ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting
	ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeRecoveryProximityPlacementGroupCustomDetails ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails = original.ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeRecoveryProximityPlacementGroupCustomDetails
)

type ResourceTypeBasicRecoveryResourceGroupCustomDetails = original.ResourceTypeBasicRecoveryResourceGroupCustomDetails

const (
	ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting                           ResourceTypeBasicRecoveryResourceGroupCustomDetails = original.ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting
	ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeRecoveryResourceGroupCustomDetails ResourceTypeBasicRecoveryResourceGroupCustomDetails = original.ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeRecoveryResourceGroupCustomDetails
)

type ResourceTypeBasicRecoveryVirtualNetworkCustomDetails = original.ResourceTypeBasicRecoveryVirtualNetworkCustomDetails

const (
	ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting                            ResourceTypeBasicRecoveryVirtualNetworkCustomDetails = original.ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting
	ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeRecoveryVirtualNetworkCustomDetails ResourceTypeBasicRecoveryVirtualNetworkCustomDetails = original.ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeRecoveryVirtualNetworkCustomDetails
)

type ResourceTypeBasicStorageAccountCustomDetails = original.ResourceTypeBasicStorageAccountCustomDetails

const (
	ResourceTypeBasicStorageAccountCustomDetailsResourceTypeExisting                    ResourceTypeBasicStorageAccountCustomDetails = original.ResourceTypeBasicStorageAccountCustomDetailsResourceTypeExisting
	ResourceTypeBasicStorageAccountCustomDetailsResourceTypeStorageAccountCustomDetails ResourceTypeBasicStorageAccountCustomDetails = original.ResourceTypeBasicStorageAccountCustomDetailsResourceTypeStorageAccountCustomDetails
)

type ResyncState = original.ResyncState

const (
	ResyncStateNone                         ResyncState = original.ResyncStateNone
	ResyncStatePreparedForResynchronization ResyncState = original.ResyncStatePreparedForResynchronization
	ResyncStateStartedResynchronization     ResyncState = original.ResyncStateStartedResynchronization
)

type RpInMageRecoveryPointType = original.RpInMageRecoveryPointType

const (
	RpInMageRecoveryPointTypeCustom     RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeCustom
	RpInMageRecoveryPointTypeLatestTag  RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeLatestTag
	RpInMageRecoveryPointTypeLatestTime RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeLatestTime
)

type SetMultiVMSyncStatus = original.SetMultiVMSyncStatus

const (
	Disable SetMultiVMSyncStatus = original.Disable
	Enable  SetMultiVMSyncStatus = original.Enable
)

type Severity = original.Severity

const (
	Error   Severity = original.Error
	Info    Severity = original.Info
	NONE    Severity = original.NONE
	Warning Severity = original.Warning
)

type SourceSiteOperations = original.SourceSiteOperations

const (
	NotRequired SourceSiteOperations = original.NotRequired
	Required    SourceSiteOperations = original.Required
)

type TestMigrationState = original.TestMigrationState

const (
	TestMigrationStateNone                           TestMigrationState = original.TestMigrationStateNone
	TestMigrationStateTestMigrationCleanupInProgress TestMigrationState = original.TestMigrationStateTestMigrationCleanupInProgress
	TestMigrationStateTestMigrationFailed            TestMigrationState = original.TestMigrationStateTestMigrationFailed
	TestMigrationStateTestMigrationInProgress        TestMigrationState = original.TestMigrationStateTestMigrationInProgress
	TestMigrationStateTestMigrationSucceeded         TestMigrationState = original.TestMigrationStateTestMigrationSucceeded
)

type VMEncryptionType = original.VMEncryptionType

const (
	NotEncrypted     VMEncryptionType = original.NotEncrypted
	OnePassEncrypted VMEncryptionType = original.OnePassEncrypted
	TwoPassEncrypted VMEncryptionType = original.TwoPassEncrypted
)

type A2AAddDisksInput = original.A2AAddDisksInput
type A2AApplyRecoveryPointInput = original.A2AApplyRecoveryPointInput
type A2AContainerCreationInput = original.A2AContainerCreationInput
type A2AContainerMappingInput = original.A2AContainerMappingInput
type A2ACreateProtectionIntentInput = original.A2ACreateProtectionIntentInput
type A2AEnableProtectionInput = original.A2AEnableProtectionInput
type A2AEventDetails = original.A2AEventDetails
type A2AFailoverProviderInput = original.A2AFailoverProviderInput
type A2APolicyCreationInput = original.A2APolicyCreationInput
type A2APolicyDetails = original.A2APolicyDetails
type A2AProtectedDiskDetails = original.A2AProtectedDiskDetails
type A2AProtectedManagedDiskDetails = original.A2AProtectedManagedDiskDetails
type A2AProtectionContainerMappingDetails = original.A2AProtectionContainerMappingDetails
type A2AProtectionIntentDiskInputDetails = original.A2AProtectionIntentDiskInputDetails
type A2AProtectionIntentManagedDiskInputDetails = original.A2AProtectionIntentManagedDiskInputDetails
type A2ARecoveryPointDetails = original.A2ARecoveryPointDetails
type A2ARemoveDisksInput = original.A2ARemoveDisksInput
type A2AReplicationDetails = original.A2AReplicationDetails
type A2AReplicationIntentDetails = original.A2AReplicationIntentDetails
type A2AReprotectInput = original.A2AReprotectInput
type A2ASwitchProtectionInput = original.A2ASwitchProtectionInput
type A2ATestFailoverInput = original.A2ATestFailoverInput
type A2AUnplannedFailoverInput = original.A2AUnplannedFailoverInput
type A2AUnprotectedDiskDetails = original.A2AUnprotectedDiskDetails
type A2AUpdateContainerMappingInput = original.A2AUpdateContainerMappingInput
type A2AUpdateReplicationProtectedItemInput = original.A2AUpdateReplicationProtectedItemInput
type A2AVMDiskDetails = original.A2AVMDiskDetails
type A2AVMDiskInputDetails = original.A2AVMDiskInputDetails
type A2AVMManagedDiskDetails = original.A2AVMManagedDiskDetails
type A2AVMManagedDiskInputDetails = original.A2AVMManagedDiskInputDetails
type A2AVMManagedDiskUpdateDetails = original.A2AVMManagedDiskUpdateDetails
type ASRTask = original.ASRTask
type AddDisksInput = original.AddDisksInput
type AddDisksInputProperties = original.AddDisksInputProperties
type AddDisksProviderSpecificInput = original.AddDisksProviderSpecificInput
type AddRecoveryServicesProviderInput = original.AddRecoveryServicesProviderInput
type AddRecoveryServicesProviderInputProperties = original.AddRecoveryServicesProviderInputProperties
type AddVCenterRequest = original.AddVCenterRequest
type AddVCenterRequestProperties = original.AddVCenterRequestProperties
type AgentDetails = original.AgentDetails
type AgentDiskDetails = original.AgentDiskDetails
type Alert = original.Alert
type AlertCollection = original.AlertCollection
type AlertCollectionIterator = original.AlertCollectionIterator
type AlertCollectionPage = original.AlertCollectionPage
type AlertProperties = original.AlertProperties
type ApplyRecoveryPointInput = original.ApplyRecoveryPointInput
type ApplyRecoveryPointInputProperties = original.ApplyRecoveryPointInputProperties
type ApplyRecoveryPointProviderSpecificInput = original.ApplyRecoveryPointProviderSpecificInput
type AsrJobDetails = original.AsrJobDetails
type AutomationRunbookTaskDetails = original.AutomationRunbookTaskDetails
type AzureFabricCreationInput = original.AzureFabricCreationInput
type AzureFabricSpecificDetails = original.AzureFabricSpecificDetails
type AzureToAzureCreateNetworkMappingInput = original.AzureToAzureCreateNetworkMappingInput
type AzureToAzureNetworkMappingSettings = original.AzureToAzureNetworkMappingSettings
type AzureToAzureUpdateNetworkMappingInput = original.AzureToAzureUpdateNetworkMappingInput
type AzureToAzureVMSyncedConfigDetails = original.AzureToAzureVMSyncedConfigDetails
type AzureVMDiskDetails = original.AzureVMDiskDetails
type BaseClient = original.BaseClient
type BasicAddDisksProviderSpecificInput = original.BasicAddDisksProviderSpecificInput
type BasicApplyRecoveryPointProviderSpecificInput = original.BasicApplyRecoveryPointProviderSpecificInput
type BasicConfigurationSettings = original.BasicConfigurationSettings
type BasicCreateProtectionIntentProviderSpecificDetails = original.BasicCreateProtectionIntentProviderSpecificDetails
type BasicDisableProtectionProviderSpecificInput = original.BasicDisableProtectionProviderSpecificInput
type BasicEnableMigrationProviderSpecificInput = original.BasicEnableMigrationProviderSpecificInput
type BasicEnableProtectionProviderSpecificInput = original.BasicEnableProtectionProviderSpecificInput
type BasicEventProviderSpecificDetails = original.BasicEventProviderSpecificDetails
type BasicEventSpecificDetails = original.BasicEventSpecificDetails
type BasicFabricSpecificCreateNetworkMappingInput = original.BasicFabricSpecificCreateNetworkMappingInput
type BasicFabricSpecificCreationInput = original.BasicFabricSpecificCreationInput
type BasicFabricSpecificDetails = original.BasicFabricSpecificDetails
type BasicFabricSpecificUpdateNetworkMappingInput = original.BasicFabricSpecificUpdateNetworkMappingInput
type BasicGroupTaskDetails = original.BasicGroupTaskDetails
type BasicJobDetails = original.BasicJobDetails
type BasicMigrateProviderSpecificInput = original.BasicMigrateProviderSpecificInput
type BasicMigrationProviderSpecificSettings = original.BasicMigrationProviderSpecificSettings
type BasicNetworkMappingFabricSpecificSettings = original.BasicNetworkMappingFabricSpecificSettings
type BasicPolicyProviderSpecificDetails = original.BasicPolicyProviderSpecificDetails
type BasicPolicyProviderSpecificInput = original.BasicPolicyProviderSpecificInput
type BasicProtectionContainerMappingProviderSpecificDetails = original.BasicProtectionContainerMappingProviderSpecificDetails
type BasicProtectionProfileCustomDetails = original.BasicProtectionProfileCustomDetails
type BasicProviderSpecificFailoverInput = original.BasicProviderSpecificFailoverInput
type BasicProviderSpecificRecoveryPointDetails = original.BasicProviderSpecificRecoveryPointDetails
type BasicRecoveryAvailabilitySetCustomDetails = original.BasicRecoveryAvailabilitySetCustomDetails
type BasicRecoveryPlanActionDetails = original.BasicRecoveryPlanActionDetails
type BasicRecoveryPlanProviderSpecificDetails = original.BasicRecoveryPlanProviderSpecificDetails
type BasicRecoveryPlanProviderSpecificFailoverInput = original.BasicRecoveryPlanProviderSpecificFailoverInput
type BasicRecoveryPlanProviderSpecificInput = original.BasicRecoveryPlanProviderSpecificInput
type BasicRecoveryProximityPlacementGroupCustomDetails = original.BasicRecoveryProximityPlacementGroupCustomDetails
type BasicRecoveryResourceGroupCustomDetails = original.BasicRecoveryResourceGroupCustomDetails
type BasicRecoveryVirtualNetworkCustomDetails = original.BasicRecoveryVirtualNetworkCustomDetails
type BasicRemoveDisksProviderSpecificInput = original.BasicRemoveDisksProviderSpecificInput
type BasicReplicationProtectionIntentProviderSpecificSettings = original.BasicReplicationProtectionIntentProviderSpecificSettings
type BasicReplicationProviderSpecificContainerCreationInput = original.BasicReplicationProviderSpecificContainerCreationInput
type BasicReplicationProviderSpecificContainerMappingInput = original.BasicReplicationProviderSpecificContainerMappingInput
type BasicReplicationProviderSpecificSettings = original.BasicReplicationProviderSpecificSettings
type BasicReplicationProviderSpecificUpdateContainerMappingInput = original.BasicReplicationProviderSpecificUpdateContainerMappingInput
type BasicReverseReplicationProviderSpecificInput = original.BasicReverseReplicationProviderSpecificInput
type BasicStorageAccountCustomDetails = original.BasicStorageAccountCustomDetails
type BasicSwitchProtectionProviderSpecificInput = original.BasicSwitchProtectionProviderSpecificInput
type BasicTaskTypeDetails = original.BasicTaskTypeDetails
type BasicTestFailoverProviderSpecificInput = original.BasicTestFailoverProviderSpecificInput
type BasicTestMigrateProviderSpecificInput = original.BasicTestMigrateProviderSpecificInput
type BasicUnplannedFailoverProviderSpecificInput = original.BasicUnplannedFailoverProviderSpecificInput
type BasicUpdateMigrationItemProviderSpecificInput = original.BasicUpdateMigrationItemProviderSpecificInput
type BasicUpdateReplicationProtectedItemProviderInput = original.BasicUpdateReplicationProtectedItemProviderInput
type ComputeSizeErrorDetails = original.ComputeSizeErrorDetails
type ConfigurationSettings = original.ConfigurationSettings
type ConfigureAlertRequest = original.ConfigureAlertRequest
type ConfigureAlertRequestProperties = original.ConfigureAlertRequestProperties
type ConsistencyCheckTaskDetails = original.ConsistencyCheckTaskDetails
type CreateNetworkMappingInput = original.CreateNetworkMappingInput
type CreateNetworkMappingInputProperties = original.CreateNetworkMappingInputProperties
type CreatePolicyInput = original.CreatePolicyInput
type CreatePolicyInputProperties = original.CreatePolicyInputProperties
type CreateProtectionContainerInput = original.CreateProtectionContainerInput
type CreateProtectionContainerInputProperties = original.CreateProtectionContainerInputProperties
type CreateProtectionContainerMappingInput = original.CreateProtectionContainerMappingInput
type CreateProtectionContainerMappingInputProperties = original.CreateProtectionContainerMappingInputProperties
type CreateProtectionIntentInput = original.CreateProtectionIntentInput
type CreateProtectionIntentProperties = original.CreateProtectionIntentProperties
type CreateProtectionIntentProviderSpecificDetails = original.CreateProtectionIntentProviderSpecificDetails
type CreateRecoveryPlanInput = original.CreateRecoveryPlanInput
type CreateRecoveryPlanInputProperties = original.CreateRecoveryPlanInputProperties
type CurrentJobDetails = original.CurrentJobDetails
type CurrentScenarioDetails = original.CurrentScenarioDetails
type DataStore = original.DataStore
type DisableProtectionInput = original.DisableProtectionInput
type DisableProtectionInputProperties = original.DisableProtectionInputProperties
type DisableProtectionProviderSpecificInput = original.DisableProtectionProviderSpecificInput
type DiscoverProtectableItemRequest = original.DiscoverProtectableItemRequest
type DiscoverProtectableItemRequestProperties = original.DiscoverProtectableItemRequestProperties
type DiskDetails = original.DiskDetails
type DiskEncryptionInfo = original.DiskEncryptionInfo
type DiskEncryptionKeyInfo = original.DiskEncryptionKeyInfo
type DiskVolumeDetails = original.DiskVolumeDetails
type Display = original.Display
type DraDetails = original.DraDetails
type EnableMigrationInput = original.EnableMigrationInput
type EnableMigrationInputProperties = original.EnableMigrationInputProperties
type EnableMigrationProviderSpecificInput = original.EnableMigrationProviderSpecificInput
type EnableProtectionInput = original.EnableProtectionInput
type EnableProtectionInputProperties = original.EnableProtectionInputProperties
type EnableProtectionProviderSpecificInput = original.EnableProtectionProviderSpecificInput
type EncryptionDetails = original.EncryptionDetails
type Event = original.Event
type EventCollection = original.EventCollection
type EventCollectionIterator = original.EventCollectionIterator
type EventCollectionPage = original.EventCollectionPage
type EventProperties = original.EventProperties
type EventProviderSpecificDetails = original.EventProviderSpecificDetails
type EventQueryParameter = original.EventQueryParameter
type EventSpecificDetails = original.EventSpecificDetails
type ExistingProtectionProfile = original.ExistingProtectionProfile
type ExistingRecoveryAvailabilitySet = original.ExistingRecoveryAvailabilitySet
type ExistingRecoveryProximityPlacementGroup = original.ExistingRecoveryProximityPlacementGroup
type ExistingRecoveryRecoveryResourceGroup = original.ExistingRecoveryRecoveryResourceGroup
type ExistingRecoveryVirtualNetwork = original.ExistingRecoveryVirtualNetwork
type ExistingStorageAccount = original.ExistingStorageAccount
type ExportJobDetails = original.ExportJobDetails
type Fabric = original.Fabric
type FabricCollection = original.FabricCollection
type FabricCollectionIterator = original.FabricCollectionIterator
type FabricCollectionPage = original.FabricCollectionPage
type FabricCreationInput = original.FabricCreationInput
type FabricCreationInputProperties = original.FabricCreationInputProperties
type FabricProperties = original.FabricProperties
type FabricReplicationGroupTaskDetails = original.FabricReplicationGroupTaskDetails
type FabricSpecificCreateNetworkMappingInput = original.FabricSpecificCreateNetworkMappingInput
type FabricSpecificCreationInput = original.FabricSpecificCreationInput
type FabricSpecificDetails = original.FabricSpecificDetails
type FabricSpecificUpdateNetworkMappingInput = original.FabricSpecificUpdateNetworkMappingInput
type FailoverJobDetails = original.FailoverJobDetails
type FailoverProcessServerRequest = original.FailoverProcessServerRequest
type FailoverProcessServerRequestProperties = original.FailoverProcessServerRequestProperties
type FailoverReplicationProtectedItemDetails = original.FailoverReplicationProtectedItemDetails
type GroupTaskDetails = original.GroupTaskDetails
type HealthError = original.HealthError
type HealthErrorSummary = original.HealthErrorSummary
type HyperVReplica2012EventDetails = original.HyperVReplica2012EventDetails
type HyperVReplica2012R2EventDetails = original.HyperVReplica2012R2EventDetails
type HyperVReplicaAzureApplyRecoveryPointInput = original.HyperVReplicaAzureApplyRecoveryPointInput
type HyperVReplicaAzureEnableProtectionInput = original.HyperVReplicaAzureEnableProtectionInput
type HyperVReplicaAzureEventDetails = original.HyperVReplicaAzureEventDetails
type HyperVReplicaAzureFailbackProviderInput = original.HyperVReplicaAzureFailbackProviderInput
type HyperVReplicaAzureFailoverProviderInput = original.HyperVReplicaAzureFailoverProviderInput
type HyperVReplicaAzurePolicyDetails = original.HyperVReplicaAzurePolicyDetails
type HyperVReplicaAzurePolicyInput = original.HyperVReplicaAzurePolicyInput
type HyperVReplicaAzureReplicationDetails = original.HyperVReplicaAzureReplicationDetails
type HyperVReplicaAzureReprotectInput = original.HyperVReplicaAzureReprotectInput
type HyperVReplicaAzureTestFailoverInput = original.HyperVReplicaAzureTestFailoverInput
type HyperVReplicaAzureUnplannedFailoverInput = original.HyperVReplicaAzureUnplannedFailoverInput
type HyperVReplicaAzureUpdateReplicationProtectedItemInput = original.HyperVReplicaAzureUpdateReplicationProtectedItemInput
type HyperVReplicaBaseEventDetails = original.HyperVReplicaBaseEventDetails
type HyperVReplicaBasePolicyDetails = original.HyperVReplicaBasePolicyDetails
type HyperVReplicaBaseReplicationDetails = original.HyperVReplicaBaseReplicationDetails
type HyperVReplicaBluePolicyDetails = original.HyperVReplicaBluePolicyDetails
type HyperVReplicaBluePolicyInput = original.HyperVReplicaBluePolicyInput
type HyperVReplicaBlueReplicationDetails = original.HyperVReplicaBlueReplicationDetails
type HyperVReplicaPolicyDetails = original.HyperVReplicaPolicyDetails
type HyperVReplicaPolicyInput = original.HyperVReplicaPolicyInput
type HyperVReplicaReplicationDetails = original.HyperVReplicaReplicationDetails
type HyperVSiteDetails = original.HyperVSiteDetails
type HyperVVirtualMachineDetails = original.HyperVVirtualMachineDetails
type IPConfig = original.IPConfig
type IdentityProviderDetails = original.IdentityProviderDetails
type IdentityProviderInput = original.IdentityProviderInput
type InMageAgentDetails = original.InMageAgentDetails
type InMageAgentVersionDetails = original.InMageAgentVersionDetails
type InMageAzureV2ApplyRecoveryPointInput = original.InMageAzureV2ApplyRecoveryPointInput
type InMageAzureV2DiskInputDetails = original.InMageAzureV2DiskInputDetails
type InMageAzureV2EnableProtectionInput = original.InMageAzureV2EnableProtectionInput
type InMageAzureV2EventDetails = original.InMageAzureV2EventDetails
type InMageAzureV2FailoverProviderInput = original.InMageAzureV2FailoverProviderInput
type InMageAzureV2ManagedDiskDetails = original.InMageAzureV2ManagedDiskDetails
type InMageAzureV2PolicyDetails = original.InMageAzureV2PolicyDetails
type InMageAzureV2PolicyInput = original.InMageAzureV2PolicyInput
type InMageAzureV2ProtectedDiskDetails = original.InMageAzureV2ProtectedDiskDetails
type InMageAzureV2RecoveryPointDetails = original.InMageAzureV2RecoveryPointDetails
type InMageAzureV2ReplicationDetails = original.InMageAzureV2ReplicationDetails
type InMageAzureV2ReprotectInput = original.InMageAzureV2ReprotectInput
type InMageAzureV2TestFailoverInput = original.InMageAzureV2TestFailoverInput
type InMageAzureV2UnplannedFailoverInput = original.InMageAzureV2UnplannedFailoverInput
type InMageAzureV2UpdateReplicationProtectedItemInput = original.InMageAzureV2UpdateReplicationProtectedItemInput
type InMageBasePolicyDetails = original.InMageBasePolicyDetails
type InMageDisableProtectionProviderSpecificInput = original.InMageDisableProtectionProviderSpecificInput
type InMageDiskDetails = original.InMageDiskDetails
type InMageDiskExclusionInput = original.InMageDiskExclusionInput
type InMageDiskSignatureExclusionOptions = original.InMageDiskSignatureExclusionOptions
type InMageEnableProtectionInput = original.InMageEnableProtectionInput
type InMageFailoverProviderInput = original.InMageFailoverProviderInput
type InMagePolicyDetails = original.InMagePolicyDetails
type InMagePolicyInput = original.InMagePolicyInput
type InMageProtectedDiskDetails = original.InMageProtectedDiskDetails
type InMageRcmAgentUpgradeBlockingErrorDetails = original.InMageRcmAgentUpgradeBlockingErrorDetails
type InMageRcmApplyRecoveryPointInput = original.InMageRcmApplyRecoveryPointInput
type InMageRcmDiskInput = original.InMageRcmDiskInput
type InMageRcmDisksDefaultInput = original.InMageRcmDisksDefaultInput
type InMageRcmEnableProtectionInput = original.InMageRcmEnableProtectionInput
type InMageRcmEventDetails = original.InMageRcmEventDetails
type InMageRcmFabricCreationInput = original.InMageRcmFabricCreationInput
type InMageRcmFabricSpecificDetails = original.InMageRcmFabricSpecificDetails
type InMageRcmLastAgentUpgradeErrorDetails = original.InMageRcmLastAgentUpgradeErrorDetails
type InMageRcmMobilityAgentDetails = original.InMageRcmMobilityAgentDetails
type InMageRcmNicDetails = original.InMageRcmNicDetails
type InMageRcmNicInput = original.InMageRcmNicInput
type InMageRcmPolicyCreationInput = original.InMageRcmPolicyCreationInput
type InMageRcmPolicyDetails = original.InMageRcmPolicyDetails
type InMageRcmProtectedDiskDetails = original.InMageRcmProtectedDiskDetails
type InMageRcmRecoveryPointDetails = original.InMageRcmRecoveryPointDetails
type InMageRcmReplicationDetails = original.InMageRcmReplicationDetails
type InMageRcmTestFailoverInput = original.InMageRcmTestFailoverInput
type InMageRcmUnplannedFailoverInput = original.InMageRcmUnplannedFailoverInput
type InMageRcmUpdateReplicationProtectedItemInput = original.InMageRcmUpdateReplicationProtectedItemInput
type InMageReplicationDetails = original.InMageReplicationDetails
type InMageReprotectInput = original.InMageReprotectInput
type InMageTestFailoverInput = original.InMageTestFailoverInput
type InMageUnplannedFailoverInput = original.InMageUnplannedFailoverInput
type InMageVolumeExclusionOptions = original.InMageVolumeExclusionOptions
type InconsistentVMDetails = original.InconsistentVMDetails
type InitialReplicationDetails = original.InitialReplicationDetails
type InlineWorkflowTaskDetails = original.InlineWorkflowTaskDetails
type InnerHealthError = original.InnerHealthError
type InputEndpoint = original.InputEndpoint
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobDetails = original.JobDetails
type JobEntity = original.JobEntity
type JobErrorDetails = original.JobErrorDetails
type JobProperties = original.JobProperties
type JobQueryParameter = original.JobQueryParameter
type JobStatusEventDetails = original.JobStatusEventDetails
type JobTaskDetails = original.JobTaskDetails
type KeyEncryptionKeyInfo = original.KeyEncryptionKeyInfo
type LogicalNetwork = original.LogicalNetwork
type LogicalNetworkCollection = original.LogicalNetworkCollection
type LogicalNetworkCollectionIterator = original.LogicalNetworkCollectionIterator
type LogicalNetworkCollectionPage = original.LogicalNetworkCollectionPage
type LogicalNetworkProperties = original.LogicalNetworkProperties
type ManualActionTaskDetails = original.ManualActionTaskDetails
type MasterTargetServer = original.MasterTargetServer
type MigrateInput = original.MigrateInput
type MigrateInputProperties = original.MigrateInputProperties
type MigrateProviderSpecificInput = original.MigrateProviderSpecificInput
type MigrationItem = original.MigrationItem
type MigrationItemCollection = original.MigrationItemCollection
type MigrationItemCollectionIterator = original.MigrationItemCollectionIterator
type MigrationItemCollectionPage = original.MigrationItemCollectionPage
type MigrationItemProperties = original.MigrationItemProperties
type MigrationItemsQueryParameter = original.MigrationItemsQueryParameter
type MigrationProviderSpecificSettings = original.MigrationProviderSpecificSettings
type MigrationRecoveryPoint = original.MigrationRecoveryPoint
type MigrationRecoveryPointCollection = original.MigrationRecoveryPointCollection
type MigrationRecoveryPointCollectionIterator = original.MigrationRecoveryPointCollectionIterator
type MigrationRecoveryPointCollectionPage = original.MigrationRecoveryPointCollectionPage
type MigrationRecoveryPointProperties = original.MigrationRecoveryPointProperties
type MigrationRecoveryPointsClient = original.MigrationRecoveryPointsClient
type MobilityServiceUpdate = original.MobilityServiceUpdate
type Network = original.Network
type NetworkCollection = original.NetworkCollection
type NetworkCollectionIterator = original.NetworkCollectionIterator
type NetworkCollectionPage = original.NetworkCollectionPage
type NetworkMapping = original.NetworkMapping
type NetworkMappingCollection = original.NetworkMappingCollection
type NetworkMappingCollectionIterator = original.NetworkMappingCollectionIterator
type NetworkMappingCollectionPage = original.NetworkMappingCollectionPage
type NetworkMappingFabricSpecificSettings = original.NetworkMappingFabricSpecificSettings
type NetworkMappingProperties = original.NetworkMappingProperties
type NetworkProperties = original.NetworkProperties
type NewProtectionProfile = original.NewProtectionProfile
type OSDetails = original.OSDetails
type OSDiskDetails = original.OSDiskDetails
type OSVersionWrapper = original.OSVersionWrapper
type OperationsClient = original.OperationsClient
type OperationsDiscovery = original.OperationsDiscovery
type OperationsDiscoveryCollection = original.OperationsDiscoveryCollection
type OperationsDiscoveryCollectionIterator = original.OperationsDiscoveryCollectionIterator
type OperationsDiscoveryCollectionPage = original.OperationsDiscoveryCollectionPage
type PlannedFailoverInput = original.PlannedFailoverInput
type PlannedFailoverInputProperties = original.PlannedFailoverInputProperties
type Policy = original.Policy
type PolicyCollection = original.PolicyCollection
type PolicyCollectionIterator = original.PolicyCollectionIterator
type PolicyCollectionPage = original.PolicyCollectionPage
type PolicyProperties = original.PolicyProperties
type PolicyProviderSpecificDetails = original.PolicyProviderSpecificDetails
type PolicyProviderSpecificInput = original.PolicyProviderSpecificInput
type ProcessServer = original.ProcessServer
type ProcessServerDetails = original.ProcessServerDetails
type ProtectableItem = original.ProtectableItem
type ProtectableItemCollection = original.ProtectableItemCollection
type ProtectableItemCollectionIterator = original.ProtectableItemCollectionIterator
type ProtectableItemCollectionPage = original.ProtectableItemCollectionPage
type ProtectableItemProperties = original.ProtectableItemProperties
type ProtectableItemQueryParameter = original.ProtectableItemQueryParameter
type ProtectedItemsQueryParameter = original.ProtectedItemsQueryParameter
type ProtectionContainer = original.ProtectionContainer
type ProtectionContainerCollection = original.ProtectionContainerCollection
type ProtectionContainerCollectionIterator = original.ProtectionContainerCollectionIterator
type ProtectionContainerCollectionPage = original.ProtectionContainerCollectionPage
type ProtectionContainerFabricSpecificDetails = original.ProtectionContainerFabricSpecificDetails
type ProtectionContainerMapping = original.ProtectionContainerMapping
type ProtectionContainerMappingCollection = original.ProtectionContainerMappingCollection
type ProtectionContainerMappingCollectionIterator = original.ProtectionContainerMappingCollectionIterator
type ProtectionContainerMappingCollectionPage = original.ProtectionContainerMappingCollectionPage
type ProtectionContainerMappingProperties = original.ProtectionContainerMappingProperties
type ProtectionContainerMappingProviderSpecificDetails = original.ProtectionContainerMappingProviderSpecificDetails
type ProtectionContainerProperties = original.ProtectionContainerProperties
type ProtectionProfileCustomDetails = original.ProtectionProfileCustomDetails
type ProviderError = original.ProviderError
type ProviderSpecificFailoverInput = original.ProviderSpecificFailoverInput
type ProviderSpecificRecoveryPointDetails = original.ProviderSpecificRecoveryPointDetails
type PushInstallerDetails = original.PushInstallerDetails
type RcmAzureMigrationPolicyDetails = original.RcmAzureMigrationPolicyDetails
type RcmProxyDetails = original.RcmProxyDetails
type RecoveryAvailabilitySetCustomDetails = original.RecoveryAvailabilitySetCustomDetails
type RecoveryPlan = original.RecoveryPlan
type RecoveryPlanA2ADetails = original.RecoveryPlanA2ADetails
type RecoveryPlanA2AFailoverInput = original.RecoveryPlanA2AFailoverInput
type RecoveryPlanA2AInput = original.RecoveryPlanA2AInput
type RecoveryPlanAction = original.RecoveryPlanAction
type RecoveryPlanActionDetails = original.RecoveryPlanActionDetails
type RecoveryPlanAutomationRunbookActionDetails = original.RecoveryPlanAutomationRunbookActionDetails
type RecoveryPlanCollection = original.RecoveryPlanCollection
type RecoveryPlanCollectionIterator = original.RecoveryPlanCollectionIterator
type RecoveryPlanCollectionPage = original.RecoveryPlanCollectionPage
type RecoveryPlanGroup = original.RecoveryPlanGroup
type RecoveryPlanGroupTaskDetails = original.RecoveryPlanGroupTaskDetails
type RecoveryPlanHyperVReplicaAzureFailbackInput = original.RecoveryPlanHyperVReplicaAzureFailbackInput
type RecoveryPlanHyperVReplicaAzureFailoverInput = original.RecoveryPlanHyperVReplicaAzureFailoverInput
type RecoveryPlanInMageAzureV2FailoverInput = original.RecoveryPlanInMageAzureV2FailoverInput
type RecoveryPlanInMageFailoverInput = original.RecoveryPlanInMageFailoverInput
type RecoveryPlanInMageRcmFailoverInput = original.RecoveryPlanInMageRcmFailoverInput
type RecoveryPlanManualActionDetails = original.RecoveryPlanManualActionDetails
type RecoveryPlanPlannedFailoverInput = original.RecoveryPlanPlannedFailoverInput
type RecoveryPlanPlannedFailoverInputProperties = original.RecoveryPlanPlannedFailoverInputProperties
type RecoveryPlanProperties = original.RecoveryPlanProperties
type RecoveryPlanProtectedItem = original.RecoveryPlanProtectedItem
type RecoveryPlanProviderSpecificDetails = original.RecoveryPlanProviderSpecificDetails
type RecoveryPlanProviderSpecificFailoverInput = original.RecoveryPlanProviderSpecificFailoverInput
type RecoveryPlanProviderSpecificInput = original.RecoveryPlanProviderSpecificInput
type RecoveryPlanScriptActionDetails = original.RecoveryPlanScriptActionDetails
type RecoveryPlanShutdownGroupTaskDetails = original.RecoveryPlanShutdownGroupTaskDetails
type RecoveryPlanTestFailoverCleanupInput = original.RecoveryPlanTestFailoverCleanupInput
type RecoveryPlanTestFailoverCleanupInputProperties = original.RecoveryPlanTestFailoverCleanupInputProperties
type RecoveryPlanTestFailoverInput = original.RecoveryPlanTestFailoverInput
type RecoveryPlanTestFailoverInputProperties = original.RecoveryPlanTestFailoverInputProperties
type RecoveryPlanUnplannedFailoverInput = original.RecoveryPlanUnplannedFailoverInput
type RecoveryPlanUnplannedFailoverInputProperties = original.RecoveryPlanUnplannedFailoverInputProperties
type RecoveryPoint = original.RecoveryPoint
type RecoveryPointCollection = original.RecoveryPointCollection
type RecoveryPointCollectionIterator = original.RecoveryPointCollectionIterator
type RecoveryPointCollectionPage = original.RecoveryPointCollectionPage
type RecoveryPointProperties = original.RecoveryPointProperties
type RecoveryPointsClient = original.RecoveryPointsClient
type RecoveryProximityPlacementGroupCustomDetails = original.RecoveryProximityPlacementGroupCustomDetails
type RecoveryResourceGroupCustomDetails = original.RecoveryResourceGroupCustomDetails
type RecoveryServicesProvider = original.RecoveryServicesProvider
type RecoveryServicesProviderCollection = original.RecoveryServicesProviderCollection
type RecoveryServicesProviderCollectionIterator = original.RecoveryServicesProviderCollectionIterator
type RecoveryServicesProviderCollectionPage = original.RecoveryServicesProviderCollectionPage
type RecoveryServicesProviderProperties = original.RecoveryServicesProviderProperties
type RecoveryVirtualNetworkCustomDetails = original.RecoveryVirtualNetworkCustomDetails
type RemoveDisksInput = original.RemoveDisksInput
type RemoveDisksInputProperties = original.RemoveDisksInputProperties
type RemoveDisksProviderSpecificInput = original.RemoveDisksProviderSpecificInput
type RemoveProtectionContainerMappingInput = original.RemoveProtectionContainerMappingInput
type RemoveProtectionContainerMappingInputProperties = original.RemoveProtectionContainerMappingInputProperties
type RenewCertificateInput = original.RenewCertificateInput
type RenewCertificateInputProperties = original.RenewCertificateInputProperties
type ReplicationAgentDetails = original.ReplicationAgentDetails
type ReplicationAlertSettingsClient = original.ReplicationAlertSettingsClient
type ReplicationEligibilityResults = original.ReplicationEligibilityResults
type ReplicationEligibilityResultsClient = original.ReplicationEligibilityResultsClient
type ReplicationEligibilityResultsCollection = original.ReplicationEligibilityResultsCollection
type ReplicationEligibilityResultsErrorInfo = original.ReplicationEligibilityResultsErrorInfo
type ReplicationEligibilityResultsProperties = original.ReplicationEligibilityResultsProperties
type ReplicationEventsClient = original.ReplicationEventsClient
type ReplicationFabricsCheckConsistencyFuture = original.ReplicationFabricsCheckConsistencyFuture
type ReplicationFabricsClient = original.ReplicationFabricsClient
type ReplicationFabricsCreateFuture = original.ReplicationFabricsCreateFuture
type ReplicationFabricsDeleteFuture = original.ReplicationFabricsDeleteFuture
type ReplicationFabricsMigrateToAadFuture = original.ReplicationFabricsMigrateToAadFuture
type ReplicationFabricsPurgeFuture = original.ReplicationFabricsPurgeFuture
type ReplicationFabricsReassociateGatewayFuture = original.ReplicationFabricsReassociateGatewayFuture
type ReplicationFabricsRenewCertificateFuture = original.ReplicationFabricsRenewCertificateFuture
type ReplicationGroupDetails = original.ReplicationGroupDetails
type ReplicationJobsCancelFuture = original.ReplicationJobsCancelFuture
type ReplicationJobsClient = original.ReplicationJobsClient
type ReplicationJobsExportFuture = original.ReplicationJobsExportFuture
type ReplicationJobsRestartFuture = original.ReplicationJobsRestartFuture
type ReplicationJobsResumeFuture = original.ReplicationJobsResumeFuture
type ReplicationLogicalNetworksClient = original.ReplicationLogicalNetworksClient
type ReplicationMigrationItemsClient = original.ReplicationMigrationItemsClient
type ReplicationMigrationItemsCreateFuture = original.ReplicationMigrationItemsCreateFuture
type ReplicationMigrationItemsDeleteFuture = original.ReplicationMigrationItemsDeleteFuture
type ReplicationMigrationItemsMigrateFuture = original.ReplicationMigrationItemsMigrateFuture
type ReplicationMigrationItemsTestMigrateCleanupFuture = original.ReplicationMigrationItemsTestMigrateCleanupFuture
type ReplicationMigrationItemsTestMigrateFuture = original.ReplicationMigrationItemsTestMigrateFuture
type ReplicationMigrationItemsUpdateFuture = original.ReplicationMigrationItemsUpdateFuture
type ReplicationNetworkMappingsClient = original.ReplicationNetworkMappingsClient
type ReplicationNetworkMappingsCreateFuture = original.ReplicationNetworkMappingsCreateFuture
type ReplicationNetworkMappingsDeleteFuture = original.ReplicationNetworkMappingsDeleteFuture
type ReplicationNetworkMappingsUpdateFuture = original.ReplicationNetworkMappingsUpdateFuture
type ReplicationNetworksClient = original.ReplicationNetworksClient
type ReplicationPoliciesClient = original.ReplicationPoliciesClient
type ReplicationPoliciesCreateFuture = original.ReplicationPoliciesCreateFuture
type ReplicationPoliciesDeleteFuture = original.ReplicationPoliciesDeleteFuture
type ReplicationPoliciesUpdateFuture = original.ReplicationPoliciesUpdateFuture
type ReplicationProtectableItemsClient = original.ReplicationProtectableItemsClient
type ReplicationProtectedItem = original.ReplicationProtectedItem
type ReplicationProtectedItemCollection = original.ReplicationProtectedItemCollection
type ReplicationProtectedItemCollectionIterator = original.ReplicationProtectedItemCollectionIterator
type ReplicationProtectedItemCollectionPage = original.ReplicationProtectedItemCollectionPage
type ReplicationProtectedItemProperties = original.ReplicationProtectedItemProperties
type ReplicationProtectedItemsAddDisksFuture = original.ReplicationProtectedItemsAddDisksFuture
type ReplicationProtectedItemsApplyRecoveryPointFuture = original.ReplicationProtectedItemsApplyRecoveryPointFuture
type ReplicationProtectedItemsClient = original.ReplicationProtectedItemsClient
type ReplicationProtectedItemsCreateFuture = original.ReplicationProtectedItemsCreateFuture
type ReplicationProtectedItemsDeleteFuture = original.ReplicationProtectedItemsDeleteFuture
type ReplicationProtectedItemsFailoverCommitFuture = original.ReplicationProtectedItemsFailoverCommitFuture
type ReplicationProtectedItemsPlannedFailoverFuture = original.ReplicationProtectedItemsPlannedFailoverFuture
type ReplicationProtectedItemsPurgeFuture = original.ReplicationProtectedItemsPurgeFuture
type ReplicationProtectedItemsRemoveDisksFuture = original.ReplicationProtectedItemsRemoveDisksFuture
type ReplicationProtectedItemsRepairReplicationFuture = original.ReplicationProtectedItemsRepairReplicationFuture
type ReplicationProtectedItemsReprotectFuture = original.ReplicationProtectedItemsReprotectFuture
type ReplicationProtectedItemsResolveHealthErrorsFuture = original.ReplicationProtectedItemsResolveHealthErrorsFuture
type ReplicationProtectedItemsTestFailoverCleanupFuture = original.ReplicationProtectedItemsTestFailoverCleanupFuture
type ReplicationProtectedItemsTestFailoverFuture = original.ReplicationProtectedItemsTestFailoverFuture
type ReplicationProtectedItemsUnplannedFailoverFuture = original.ReplicationProtectedItemsUnplannedFailoverFuture
type ReplicationProtectedItemsUpdateFuture = original.ReplicationProtectedItemsUpdateFuture
type ReplicationProtectedItemsUpdateMobilityServiceFuture = original.ReplicationProtectedItemsUpdateMobilityServiceFuture
type ReplicationProtectionContainerMappingsClient = original.ReplicationProtectionContainerMappingsClient
type ReplicationProtectionContainerMappingsCreateFuture = original.ReplicationProtectionContainerMappingsCreateFuture
type ReplicationProtectionContainerMappingsDeleteFuture = original.ReplicationProtectionContainerMappingsDeleteFuture
type ReplicationProtectionContainerMappingsPurgeFuture = original.ReplicationProtectionContainerMappingsPurgeFuture
type ReplicationProtectionContainerMappingsUpdateFuture = original.ReplicationProtectionContainerMappingsUpdateFuture
type ReplicationProtectionContainersClient = original.ReplicationProtectionContainersClient
type ReplicationProtectionContainersCreateFuture = original.ReplicationProtectionContainersCreateFuture
type ReplicationProtectionContainersDeleteFuture = original.ReplicationProtectionContainersDeleteFuture
type ReplicationProtectionContainersDiscoverProtectableItemFuture = original.ReplicationProtectionContainersDiscoverProtectableItemFuture
type ReplicationProtectionContainersSwitchProtectionFuture = original.ReplicationProtectionContainersSwitchProtectionFuture
type ReplicationProtectionIntent = original.ReplicationProtectionIntent
type ReplicationProtectionIntentCollection = original.ReplicationProtectionIntentCollection
type ReplicationProtectionIntentCollectionIterator = original.ReplicationProtectionIntentCollectionIterator
type ReplicationProtectionIntentCollectionPage = original.ReplicationProtectionIntentCollectionPage
type ReplicationProtectionIntentProperties = original.ReplicationProtectionIntentProperties
type ReplicationProtectionIntentProviderSpecificSettings = original.ReplicationProtectionIntentProviderSpecificSettings
type ReplicationProtectionIntentsClient = original.ReplicationProtectionIntentsClient
type ReplicationProviderContainerUnmappingInput = original.ReplicationProviderContainerUnmappingInput
type ReplicationProviderSpecificContainerCreationInput = original.ReplicationProviderSpecificContainerCreationInput
type ReplicationProviderSpecificContainerMappingInput = original.ReplicationProviderSpecificContainerMappingInput
type ReplicationProviderSpecificSettings = original.ReplicationProviderSpecificSettings
type ReplicationProviderSpecificUpdateContainerMappingInput = original.ReplicationProviderSpecificUpdateContainerMappingInput
type ReplicationRecoveryPlansClient = original.ReplicationRecoveryPlansClient
type ReplicationRecoveryPlansCreateFuture = original.ReplicationRecoveryPlansCreateFuture
type ReplicationRecoveryPlansDeleteFuture = original.ReplicationRecoveryPlansDeleteFuture
type ReplicationRecoveryPlansFailoverCommitFuture = original.ReplicationRecoveryPlansFailoverCommitFuture
type ReplicationRecoveryPlansPlannedFailoverFuture = original.ReplicationRecoveryPlansPlannedFailoverFuture
type ReplicationRecoveryPlansReprotectFuture = original.ReplicationRecoveryPlansReprotectFuture
type ReplicationRecoveryPlansTestFailoverCleanupFuture = original.ReplicationRecoveryPlansTestFailoverCleanupFuture
type ReplicationRecoveryPlansTestFailoverFuture = original.ReplicationRecoveryPlansTestFailoverFuture
type ReplicationRecoveryPlansUnplannedFailoverFuture = original.ReplicationRecoveryPlansUnplannedFailoverFuture
type ReplicationRecoveryPlansUpdateFuture = original.ReplicationRecoveryPlansUpdateFuture
type ReplicationRecoveryServicesProvidersClient = original.ReplicationRecoveryServicesProvidersClient
type ReplicationRecoveryServicesProvidersCreateFuture = original.ReplicationRecoveryServicesProvidersCreateFuture
type ReplicationRecoveryServicesProvidersDeleteFuture = original.ReplicationRecoveryServicesProvidersDeleteFuture
type ReplicationRecoveryServicesProvidersPurgeFuture = original.ReplicationRecoveryServicesProvidersPurgeFuture
type ReplicationRecoveryServicesProvidersRefreshProviderFuture = original.ReplicationRecoveryServicesProvidersRefreshProviderFuture
type ReplicationStorageClassificationMappingsClient = original.ReplicationStorageClassificationMappingsClient
type ReplicationStorageClassificationMappingsCreateFuture = original.ReplicationStorageClassificationMappingsCreateFuture
type ReplicationStorageClassificationMappingsDeleteFuture = original.ReplicationStorageClassificationMappingsDeleteFuture
type ReplicationStorageClassificationsClient = original.ReplicationStorageClassificationsClient
type ReplicationVaultHealthClient = original.ReplicationVaultHealthClient
type ReplicationVaultHealthRefreshFuture = original.ReplicationVaultHealthRefreshFuture
type ReplicationVaultSettingClient = original.ReplicationVaultSettingClient
type ReplicationvCentersClient = original.ReplicationvCentersClient
type ReplicationvCentersCreateFuture = original.ReplicationvCentersCreateFuture
type ReplicationvCentersDeleteFuture = original.ReplicationvCentersDeleteFuture
type ReplicationvCentersUpdateFuture = original.ReplicationvCentersUpdateFuture
type ReprotectAgentDetails = original.ReprotectAgentDetails
type ResolveHealthError = original.ResolveHealthError
type ResolveHealthInput = original.ResolveHealthInput
type ResolveHealthInputProperties = original.ResolveHealthInputProperties
type Resource = original.Resource
type ResourceHealthSummary = original.ResourceHealthSummary
type ResumeJobParams = original.ResumeJobParams
type ResumeJobParamsProperties = original.ResumeJobParamsProperties
type RetentionVolume = original.RetentionVolume
type ReverseReplicationInput = original.ReverseReplicationInput
type ReverseReplicationInputProperties = original.ReverseReplicationInputProperties
type ReverseReplicationProviderSpecificInput = original.ReverseReplicationProviderSpecificInput
type RoleAssignment = original.RoleAssignment
type RunAsAccount = original.RunAsAccount
type SanEnableProtectionInput = original.SanEnableProtectionInput
type ScriptActionTaskDetails = original.ScriptActionTaskDetails
type ServiceError = original.ServiceError
type StorageAccountCustomDetails = original.StorageAccountCustomDetails
type StorageClassification = original.StorageClassification
type StorageClassificationCollection = original.StorageClassificationCollection
type StorageClassificationCollectionIterator = original.StorageClassificationCollectionIterator
type StorageClassificationCollectionPage = original.StorageClassificationCollectionPage
type StorageClassificationMapping = original.StorageClassificationMapping
type StorageClassificationMappingCollection = original.StorageClassificationMappingCollection
type StorageClassificationMappingCollectionIterator = original.StorageClassificationMappingCollectionIterator
type StorageClassificationMappingCollectionPage = original.StorageClassificationMappingCollectionPage
type StorageClassificationMappingInput = original.StorageClassificationMappingInput
type StorageClassificationMappingProperties = original.StorageClassificationMappingProperties
type StorageClassificationProperties = original.StorageClassificationProperties
type StorageMappingInputProperties = original.StorageMappingInputProperties
type Subnet = original.Subnet
type SupportedOSDetails = original.SupportedOSDetails
type SupportedOSProperties = original.SupportedOSProperties
type SupportedOSProperty = original.SupportedOSProperty
type SupportedOperatingSystems = original.SupportedOperatingSystems
type SupportedOperatingSystemsClient = original.SupportedOperatingSystemsClient
type SwitchProtectionInput = original.SwitchProtectionInput
type SwitchProtectionInputProperties = original.SwitchProtectionInputProperties
type SwitchProtectionJobDetails = original.SwitchProtectionJobDetails
type SwitchProtectionProviderSpecificInput = original.SwitchProtectionProviderSpecificInput
type TargetComputeSize = original.TargetComputeSize
type TargetComputeSizeCollection = original.TargetComputeSizeCollection
type TargetComputeSizeCollectionIterator = original.TargetComputeSizeCollectionIterator
type TargetComputeSizeCollectionPage = original.TargetComputeSizeCollectionPage
type TargetComputeSizeProperties = original.TargetComputeSizeProperties
type TargetComputeSizesClient = original.TargetComputeSizesClient
type TaskTypeDetails = original.TaskTypeDetails
type TestFailoverCleanupInput = original.TestFailoverCleanupInput
type TestFailoverCleanupInputProperties = original.TestFailoverCleanupInputProperties
type TestFailoverInput = original.TestFailoverInput
type TestFailoverInputProperties = original.TestFailoverInputProperties
type TestFailoverJobDetails = original.TestFailoverJobDetails
type TestFailoverProviderSpecificInput = original.TestFailoverProviderSpecificInput
type TestMigrateCleanupInput = original.TestMigrateCleanupInput
type TestMigrateCleanupInputProperties = original.TestMigrateCleanupInputProperties
type TestMigrateInput = original.TestMigrateInput
type TestMigrateInputProperties = original.TestMigrateInputProperties
type TestMigrateProviderSpecificInput = original.TestMigrateProviderSpecificInput
type UnplannedFailoverInput = original.UnplannedFailoverInput
type UnplannedFailoverInputProperties = original.UnplannedFailoverInputProperties
type UnplannedFailoverProviderSpecificInput = original.UnplannedFailoverProviderSpecificInput
type UpdateMigrationItemInput = original.UpdateMigrationItemInput
type UpdateMigrationItemInputProperties = original.UpdateMigrationItemInputProperties
type UpdateMigrationItemProviderSpecificInput = original.UpdateMigrationItemProviderSpecificInput
type UpdateMobilityServiceRequest = original.UpdateMobilityServiceRequest
type UpdateMobilityServiceRequestProperties = original.UpdateMobilityServiceRequestProperties
type UpdateNetworkMappingInput = original.UpdateNetworkMappingInput
type UpdateNetworkMappingInputProperties = original.UpdateNetworkMappingInputProperties
type UpdatePolicyInput = original.UpdatePolicyInput
type UpdatePolicyInputProperties = original.UpdatePolicyInputProperties
type UpdateProtectionContainerMappingInput = original.UpdateProtectionContainerMappingInput
type UpdateProtectionContainerMappingInputProperties = original.UpdateProtectionContainerMappingInputProperties
type UpdateRecoveryPlanInput = original.UpdateRecoveryPlanInput
type UpdateRecoveryPlanInputProperties = original.UpdateRecoveryPlanInputProperties
type UpdateReplicationProtectedItemInput = original.UpdateReplicationProtectedItemInput
type UpdateReplicationProtectedItemInputProperties = original.UpdateReplicationProtectedItemInputProperties
type UpdateReplicationProtectedItemProviderInput = original.UpdateReplicationProtectedItemProviderInput
type UpdateVCenterRequest = original.UpdateVCenterRequest
type UpdateVCenterRequestProperties = original.UpdateVCenterRequestProperties
type VCenter = original.VCenter
type VCenterCollection = original.VCenterCollection
type VCenterCollectionIterator = original.VCenterCollectionIterator
type VCenterCollectionPage = original.VCenterCollectionPage
type VCenterProperties = original.VCenterProperties
type VMNicDetails = original.VMNicDetails
type VMNicInputDetails = original.VMNicInputDetails
type VMNicUpdatesTaskDetails = original.VMNicUpdatesTaskDetails
type VMwareCbtContainerCreationInput = original.VMwareCbtContainerCreationInput
type VMwareCbtContainerMappingInput = original.VMwareCbtContainerMappingInput
type VMwareCbtDiskInput = original.VMwareCbtDiskInput
type VMwareCbtEnableMigrationInput = original.VMwareCbtEnableMigrationInput
type VMwareCbtMigrateInput = original.VMwareCbtMigrateInput
type VMwareCbtMigrationDetails = original.VMwareCbtMigrationDetails
type VMwareCbtNicDetails = original.VMwareCbtNicDetails
type VMwareCbtNicInput = original.VMwareCbtNicInput
type VMwareCbtPolicyCreationInput = original.VMwareCbtPolicyCreationInput
type VMwareCbtProtectedDiskDetails = original.VMwareCbtProtectedDiskDetails
type VMwareCbtProtectionContainerMappingDetails = original.VMwareCbtProtectionContainerMappingDetails
type VMwareCbtTestMigrateInput = original.VMwareCbtTestMigrateInput
type VMwareCbtUpdateMigrationItemInput = original.VMwareCbtUpdateMigrationItemInput
type VMwareDetails = original.VMwareDetails
type VMwareV2FabricCreationInput = original.VMwareV2FabricCreationInput
type VMwareV2FabricSpecificDetails = original.VMwareV2FabricSpecificDetails
type VMwareVirtualMachineDetails = original.VMwareVirtualMachineDetails
type VaultHealthDetails = original.VaultHealthDetails
type VaultHealthProperties = original.VaultHealthProperties
type VaultSetting = original.VaultSetting
type VaultSettingCollection = original.VaultSettingCollection
type VaultSettingCollectionIterator = original.VaultSettingCollectionIterator
type VaultSettingCollectionPage = original.VaultSettingCollectionPage
type VaultSettingCreationInput = original.VaultSettingCreationInput
type VaultSettingCreationInputProperties = original.VaultSettingCreationInputProperties
type VaultSettingProperties = original.VaultSettingProperties
type VersionDetails = original.VersionDetails
type VirtualMachineTaskDetails = original.VirtualMachineTaskDetails
type VmmDetails = original.VmmDetails
type VmmToAzureCreateNetworkMappingInput = original.VmmToAzureCreateNetworkMappingInput
type VmmToAzureNetworkMappingSettings = original.VmmToAzureNetworkMappingSettings
type VmmToAzureUpdateNetworkMappingInput = original.VmmToAzureUpdateNetworkMappingInput
type VmmToVmmCreateNetworkMappingInput = original.VmmToVmmCreateNetworkMappingInput
type VmmToVmmNetworkMappingSettings = original.VmmToVmmNetworkMappingSettings
type VmmToVmmUpdateNetworkMappingInput = original.VmmToVmmUpdateNetworkMappingInput
type VmmVirtualMachineDetails = original.VmmVirtualMachineDetails
type VmwareCbtPolicyDetails = original.VmwareCbtPolicyDetails

func New(subscriptionID string, resourceGroupName string, resourceName string) BaseClient {
	return original.New(subscriptionID, resourceGroupName, resourceName)
}
func NewAlertCollectionIterator(page AlertCollectionPage) AlertCollectionIterator {
	return original.NewAlertCollectionIterator(page)
}
func NewAlertCollectionPage(cur AlertCollection, getNextPage func(context.Context, AlertCollection) (AlertCollection, error)) AlertCollectionPage {
	return original.NewAlertCollectionPage(cur, getNextPage)
}
func NewEventCollectionIterator(page EventCollectionPage) EventCollectionIterator {
	return original.NewEventCollectionIterator(page)
}
func NewEventCollectionPage(cur EventCollection, getNextPage func(context.Context, EventCollection) (EventCollection, error)) EventCollectionPage {
	return original.NewEventCollectionPage(cur, getNextPage)
}
func NewFabricCollectionIterator(page FabricCollectionPage) FabricCollectionIterator {
	return original.NewFabricCollectionIterator(page)
}
func NewFabricCollectionPage(cur FabricCollection, getNextPage func(context.Context, FabricCollection) (FabricCollection, error)) FabricCollectionPage {
	return original.NewFabricCollectionPage(cur, getNextPage)
}
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return original.NewJobCollectionIterator(page)
}
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return original.NewJobCollectionPage(cur, getNextPage)
}
func NewLogicalNetworkCollectionIterator(page LogicalNetworkCollectionPage) LogicalNetworkCollectionIterator {
	return original.NewLogicalNetworkCollectionIterator(page)
}
func NewLogicalNetworkCollectionPage(cur LogicalNetworkCollection, getNextPage func(context.Context, LogicalNetworkCollection) (LogicalNetworkCollection, error)) LogicalNetworkCollectionPage {
	return original.NewLogicalNetworkCollectionPage(cur, getNextPage)
}
func NewMigrationItemCollectionIterator(page MigrationItemCollectionPage) MigrationItemCollectionIterator {
	return original.NewMigrationItemCollectionIterator(page)
}
func NewMigrationItemCollectionPage(cur MigrationItemCollection, getNextPage func(context.Context, MigrationItemCollection) (MigrationItemCollection, error)) MigrationItemCollectionPage {
	return original.NewMigrationItemCollectionPage(cur, getNextPage)
}
func NewMigrationRecoveryPointCollectionIterator(page MigrationRecoveryPointCollectionPage) MigrationRecoveryPointCollectionIterator {
	return original.NewMigrationRecoveryPointCollectionIterator(page)
}
func NewMigrationRecoveryPointCollectionPage(cur MigrationRecoveryPointCollection, getNextPage func(context.Context, MigrationRecoveryPointCollection) (MigrationRecoveryPointCollection, error)) MigrationRecoveryPointCollectionPage {
	return original.NewMigrationRecoveryPointCollectionPage(cur, getNextPage)
}
func NewMigrationRecoveryPointsClient(subscriptionID string, resourceGroupName string, resourceName string) MigrationRecoveryPointsClient {
	return original.NewMigrationRecoveryPointsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewMigrationRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) MigrationRecoveryPointsClient {
	return original.NewMigrationRecoveryPointsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewNetworkCollectionIterator(page NetworkCollectionPage) NetworkCollectionIterator {
	return original.NewNetworkCollectionIterator(page)
}
func NewNetworkCollectionPage(cur NetworkCollection, getNextPage func(context.Context, NetworkCollection) (NetworkCollection, error)) NetworkCollectionPage {
	return original.NewNetworkCollectionPage(cur, getNextPage)
}
func NewNetworkMappingCollectionIterator(page NetworkMappingCollectionPage) NetworkMappingCollectionIterator {
	return original.NewNetworkMappingCollectionIterator(page)
}
func NewNetworkMappingCollectionPage(cur NetworkMappingCollection, getNextPage func(context.Context, NetworkMappingCollection) (NetworkMappingCollection, error)) NetworkMappingCollectionPage {
	return original.NewNetworkMappingCollectionPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string, resourceGroupName string, resourceName string) OperationsClient {
	return original.NewOperationsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewOperationsDiscoveryCollectionIterator(page OperationsDiscoveryCollectionPage) OperationsDiscoveryCollectionIterator {
	return original.NewOperationsDiscoveryCollectionIterator(page)
}
func NewOperationsDiscoveryCollectionPage(cur OperationsDiscoveryCollection, getNextPage func(context.Context, OperationsDiscoveryCollection) (OperationsDiscoveryCollection, error)) OperationsDiscoveryCollectionPage {
	return original.NewOperationsDiscoveryCollectionPage(cur, getNextPage)
}
func NewPolicyCollectionIterator(page PolicyCollectionPage) PolicyCollectionIterator {
	return original.NewPolicyCollectionIterator(page)
}
func NewPolicyCollectionPage(cur PolicyCollection, getNextPage func(context.Context, PolicyCollection) (PolicyCollection, error)) PolicyCollectionPage {
	return original.NewPolicyCollectionPage(cur, getNextPage)
}
func NewProtectableItemCollectionIterator(page ProtectableItemCollectionPage) ProtectableItemCollectionIterator {
	return original.NewProtectableItemCollectionIterator(page)
}
func NewProtectableItemCollectionPage(cur ProtectableItemCollection, getNextPage func(context.Context, ProtectableItemCollection) (ProtectableItemCollection, error)) ProtectableItemCollectionPage {
	return original.NewProtectableItemCollectionPage(cur, getNextPage)
}
func NewProtectionContainerCollectionIterator(page ProtectionContainerCollectionPage) ProtectionContainerCollectionIterator {
	return original.NewProtectionContainerCollectionIterator(page)
}
func NewProtectionContainerCollectionPage(cur ProtectionContainerCollection, getNextPage func(context.Context, ProtectionContainerCollection) (ProtectionContainerCollection, error)) ProtectionContainerCollectionPage {
	return original.NewProtectionContainerCollectionPage(cur, getNextPage)
}
func NewProtectionContainerMappingCollectionIterator(page ProtectionContainerMappingCollectionPage) ProtectionContainerMappingCollectionIterator {
	return original.NewProtectionContainerMappingCollectionIterator(page)
}
func NewProtectionContainerMappingCollectionPage(cur ProtectionContainerMappingCollection, getNextPage func(context.Context, ProtectionContainerMappingCollection) (ProtectionContainerMappingCollection, error)) ProtectionContainerMappingCollectionPage {
	return original.NewProtectionContainerMappingCollectionPage(cur, getNextPage)
}
func NewRecoveryPlanCollectionIterator(page RecoveryPlanCollectionPage) RecoveryPlanCollectionIterator {
	return original.NewRecoveryPlanCollectionIterator(page)
}
func NewRecoveryPlanCollectionPage(cur RecoveryPlanCollection, getNextPage func(context.Context, RecoveryPlanCollection) (RecoveryPlanCollection, error)) RecoveryPlanCollectionPage {
	return original.NewRecoveryPlanCollectionPage(cur, getNextPage)
}
func NewRecoveryPointCollectionIterator(page RecoveryPointCollectionPage) RecoveryPointCollectionIterator {
	return original.NewRecoveryPointCollectionIterator(page)
}
func NewRecoveryPointCollectionPage(cur RecoveryPointCollection, getNextPage func(context.Context, RecoveryPointCollection) (RecoveryPointCollection, error)) RecoveryPointCollectionPage {
	return original.NewRecoveryPointCollectionPage(cur, getNextPage)
}
func NewRecoveryPointsClient(subscriptionID string, resourceGroupName string, resourceName string) RecoveryPointsClient {
	return original.NewRecoveryPointsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) RecoveryPointsClient {
	return original.NewRecoveryPointsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewRecoveryServicesProviderCollectionIterator(page RecoveryServicesProviderCollectionPage) RecoveryServicesProviderCollectionIterator {
	return original.NewRecoveryServicesProviderCollectionIterator(page)
}
func NewRecoveryServicesProviderCollectionPage(cur RecoveryServicesProviderCollection, getNextPage func(context.Context, RecoveryServicesProviderCollection) (RecoveryServicesProviderCollection, error)) RecoveryServicesProviderCollectionPage {
	return original.NewRecoveryServicesProviderCollectionPage(cur, getNextPage)
}
func NewReplicationAlertSettingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationAlertSettingsClient {
	return original.NewReplicationAlertSettingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationAlertSettingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationAlertSettingsClient {
	return original.NewReplicationAlertSettingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEligibilityResultsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationEligibilityResultsClient {
	return original.NewReplicationEligibilityResultsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEligibilityResultsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationEligibilityResultsClient {
	return original.NewReplicationEligibilityResultsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEventsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationEventsClient {
	return original.NewReplicationEventsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEventsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationEventsClient {
	return original.NewReplicationEventsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationFabricsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationFabricsClient {
	return original.NewReplicationFabricsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationFabricsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationFabricsClient {
	return original.NewReplicationFabricsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationJobsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationJobsClient {
	return original.NewReplicationJobsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationJobsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationJobsClient {
	return original.NewReplicationJobsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationLogicalNetworksClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationLogicalNetworksClient {
	return original.NewReplicationLogicalNetworksClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationLogicalNetworksClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationLogicalNetworksClient {
	return original.NewReplicationLogicalNetworksClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationMigrationItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationMigrationItemsClient {
	return original.NewReplicationMigrationItemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationMigrationItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationMigrationItemsClient {
	return original.NewReplicationMigrationItemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworkMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworkMappingsClient {
	return original.NewReplicationNetworkMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworkMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworkMappingsClient {
	return original.NewReplicationNetworkMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworksClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworksClient {
	return original.NewReplicationNetworksClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworksClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworksClient {
	return original.NewReplicationNetworksClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationPoliciesClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationPoliciesClient {
	return original.NewReplicationPoliciesClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationPoliciesClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationPoliciesClient {
	return original.NewReplicationPoliciesClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectableItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectableItemsClient {
	return original.NewReplicationProtectableItemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectableItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectableItemsClient {
	return original.NewReplicationProtectableItemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectedItemCollectionIterator(page ReplicationProtectedItemCollectionPage) ReplicationProtectedItemCollectionIterator {
	return original.NewReplicationProtectedItemCollectionIterator(page)
}
func NewReplicationProtectedItemCollectionPage(cur ReplicationProtectedItemCollection, getNextPage func(context.Context, ReplicationProtectedItemCollection) (ReplicationProtectedItemCollection, error)) ReplicationProtectedItemCollectionPage {
	return original.NewReplicationProtectedItemCollectionPage(cur, getNextPage)
}
func NewReplicationProtectedItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return original.NewReplicationProtectedItemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectedItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return original.NewReplicationProtectedItemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainerMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainerMappingsClient {
	return original.NewReplicationProtectionContainerMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainerMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainerMappingsClient {
	return original.NewReplicationProtectionContainerMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainersClient {
	return original.NewReplicationProtectionContainersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainersClient {
	return original.NewReplicationProtectionContainersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionIntentCollectionIterator(page ReplicationProtectionIntentCollectionPage) ReplicationProtectionIntentCollectionIterator {
	return original.NewReplicationProtectionIntentCollectionIterator(page)
}
func NewReplicationProtectionIntentCollectionPage(cur ReplicationProtectionIntentCollection, getNextPage func(context.Context, ReplicationProtectionIntentCollection) (ReplicationProtectionIntentCollection, error)) ReplicationProtectionIntentCollectionPage {
	return original.NewReplicationProtectionIntentCollectionPage(cur, getNextPage)
}
func NewReplicationProtectionIntentsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionIntentsClient {
	return original.NewReplicationProtectionIntentsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionIntentsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionIntentsClient {
	return original.NewReplicationProtectionIntentsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryPlansClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return original.NewReplicationRecoveryPlansClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryPlansClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return original.NewReplicationRecoveryPlansClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryServicesProvidersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryServicesProvidersClient {
	return original.NewReplicationRecoveryServicesProvidersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryServicesProvidersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryServicesProvidersClient {
	return original.NewReplicationRecoveryServicesProvidersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationMappingsClient {
	return original.NewReplicationStorageClassificationMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationMappingsClient {
	return original.NewReplicationStorageClassificationMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationsClient {
	return original.NewReplicationStorageClassificationsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationsClient {
	return original.NewReplicationStorageClassificationsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultHealthClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultHealthClient {
	return original.NewReplicationVaultHealthClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultHealthClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultHealthClient {
	return original.NewReplicationVaultHealthClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultSettingClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultSettingClient {
	return original.NewReplicationVaultSettingClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultSettingClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultSettingClient {
	return original.NewReplicationVaultSettingClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationvCentersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationvCentersClient {
	return original.NewReplicationvCentersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationvCentersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationvCentersClient {
	return original.NewReplicationvCentersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewStorageClassificationCollectionIterator(page StorageClassificationCollectionPage) StorageClassificationCollectionIterator {
	return original.NewStorageClassificationCollectionIterator(page)
}
func NewStorageClassificationCollectionPage(cur StorageClassificationCollection, getNextPage func(context.Context, StorageClassificationCollection) (StorageClassificationCollection, error)) StorageClassificationCollectionPage {
	return original.NewStorageClassificationCollectionPage(cur, getNextPage)
}
func NewStorageClassificationMappingCollectionIterator(page StorageClassificationMappingCollectionPage) StorageClassificationMappingCollectionIterator {
	return original.NewStorageClassificationMappingCollectionIterator(page)
}
func NewStorageClassificationMappingCollectionPage(cur StorageClassificationMappingCollection, getNextPage func(context.Context, StorageClassificationMappingCollection) (StorageClassificationMappingCollection, error)) StorageClassificationMappingCollectionPage {
	return original.NewStorageClassificationMappingCollectionPage(cur, getNextPage)
}
func NewSupportedOperatingSystemsClient(subscriptionID string, resourceGroupName string, resourceName string) SupportedOperatingSystemsClient {
	return original.NewSupportedOperatingSystemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewSupportedOperatingSystemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) SupportedOperatingSystemsClient {
	return original.NewSupportedOperatingSystemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewTargetComputeSizeCollectionIterator(page TargetComputeSizeCollectionPage) TargetComputeSizeCollectionIterator {
	return original.NewTargetComputeSizeCollectionIterator(page)
}
func NewTargetComputeSizeCollectionPage(cur TargetComputeSizeCollection, getNextPage func(context.Context, TargetComputeSizeCollection) (TargetComputeSizeCollection, error)) TargetComputeSizeCollectionPage {
	return original.NewTargetComputeSizeCollectionPage(cur, getNextPage)
}
func NewTargetComputeSizesClient(subscriptionID string, resourceGroupName string, resourceName string) TargetComputeSizesClient {
	return original.NewTargetComputeSizesClient(subscriptionID, resourceGroupName, resourceName)
}
func NewTargetComputeSizesClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) TargetComputeSizesClient {
	return original.NewTargetComputeSizesClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewVCenterCollectionIterator(page VCenterCollectionPage) VCenterCollectionIterator {
	return original.NewVCenterCollectionIterator(page)
}
func NewVCenterCollectionPage(cur VCenterCollection, getNextPage func(context.Context, VCenterCollection) (VCenterCollection, error)) VCenterCollectionPage {
	return original.NewVCenterCollectionPage(cur, getNextPage)
}
func NewVaultSettingCollectionIterator(page VaultSettingCollectionPage) VaultSettingCollectionIterator {
	return original.NewVaultSettingCollectionIterator(page)
}
func NewVaultSettingCollectionPage(cur VaultSettingCollection, getNextPage func(context.Context, VaultSettingCollection) (VaultSettingCollection, error)) VaultSettingCollectionPage {
	return original.NewVaultSettingCollectionPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func PossibleA2ARecoveryAvailabilityTypeValues() []A2ARecoveryAvailabilityType {
	return original.PossibleA2ARecoveryAvailabilityTypeValues()
}
func PossibleA2ARpRecoveryPointTypeValues() []A2ARpRecoveryPointType {
	return original.PossibleA2ARpRecoveryPointTypeValues()
}
func PossibleAgentAutoUpdateStatusValues() []AgentAutoUpdateStatus {
	return original.PossibleAgentAutoUpdateStatusValues()
}
func PossibleAgentUpgradeBlockedReasonValues() []AgentUpgradeBlockedReason {
	return original.PossibleAgentUpgradeBlockedReasonValues()
}
func PossibleAgentVersionStatusValues() []AgentVersionStatus {
	return original.PossibleAgentVersionStatusValues()
}
func PossibleAlternateLocationRecoveryOptionValues() []AlternateLocationRecoveryOption {
	return original.PossibleAlternateLocationRecoveryOptionValues()
}
func PossibleAutoProtectionOfDataDiskStatusValues() []AutoProtectionOfDataDiskStatus {
	return original.PossibleAutoProtectionOfDataDiskStatusValues()
}
func PossibleAutoProtectionOfDataDiskValues() []AutoProtectionOfDataDisk {
	return original.PossibleAutoProtectionOfDataDiskValues()
}
func PossibleDataSyncStatusValues() []DataSyncStatus {
	return original.PossibleDataSyncStatusValues()
}
func PossibleDisableProtectionReasonValues() []DisableProtectionReason {
	return original.PossibleDisableProtectionReasonValues()
}
func PossibleDiskAccountTypeValues() []DiskAccountType {
	return original.PossibleDiskAccountTypeValues()
}
func PossibleDiskTypeValues() []DiskType {
	return original.PossibleDiskTypeValues()
}
func PossibleEthernetAddressTypeValues() []EthernetAddressType {
	return original.PossibleEthernetAddressTypeValues()
}
func PossibleFailoverDeploymentModelValues() []FailoverDeploymentModel {
	return original.PossibleFailoverDeploymentModelValues()
}
func PossibleHealthErrorCategoryValues() []HealthErrorCategory {
	return original.PossibleHealthErrorCategoryValues()
}
func PossibleHealthErrorCustomerResolvabilityValues() []HealthErrorCustomerResolvability {
	return original.PossibleHealthErrorCustomerResolvabilityValues()
}
func PossibleHyperVReplicaAzureRpRecoveryPointTypeValues() []HyperVReplicaAzureRpRecoveryPointType {
	return original.PossibleHyperVReplicaAzureRpRecoveryPointTypeValues()
}
func PossibleInMageV2RpRecoveryPointTypeValues() []InMageV2RpRecoveryPointType {
	return original.PossibleInMageV2RpRecoveryPointTypeValues()
}
func PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues() []InstanceTypeBasicApplyRecoveryPointProviderSpecificInput {
	return original.PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicConfigurationSettingsValues() []InstanceTypeBasicConfigurationSettings {
	return original.PossibleInstanceTypeBasicConfigurationSettingsValues()
}
func PossibleInstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsValues() []InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues() []InstanceTypeBasicDisableProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicEnableMigrationProviderSpecificInputValues() []InstanceTypeBasicEnableMigrationProviderSpecificInput {
	return original.PossibleInstanceTypeBasicEnableMigrationProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues() []InstanceTypeBasicEnableProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicEventProviderSpecificDetailsValues() []InstanceTypeBasicEventProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicEventProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicEventSpecificDetailsValues() []InstanceTypeBasicEventSpecificDetails {
	return original.PossibleInstanceTypeBasicEventSpecificDetailsValues()
}
func PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput {
	return original.PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues()
}
func PossibleInstanceTypeBasicFabricSpecificCreationInputValues() []InstanceTypeBasicFabricSpecificCreationInput {
	return original.PossibleInstanceTypeBasicFabricSpecificCreationInputValues()
}
func PossibleInstanceTypeBasicFabricSpecificDetailsValues() []InstanceTypeBasicFabricSpecificDetails {
	return original.PossibleInstanceTypeBasicFabricSpecificDetailsValues()
}
func PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput {
	return original.PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues()
}
func PossibleInstanceTypeBasicGroupTaskDetailsValues() []InstanceTypeBasicGroupTaskDetails {
	return original.PossibleInstanceTypeBasicGroupTaskDetailsValues()
}
func PossibleInstanceTypeBasicJobDetailsValues() []InstanceTypeBasicJobDetails {
	return original.PossibleInstanceTypeBasicJobDetailsValues()
}
func PossibleInstanceTypeBasicMigrateProviderSpecificInputValues() []InstanceTypeBasicMigrateProviderSpecificInput {
	return original.PossibleInstanceTypeBasicMigrateProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicMigrationProviderSpecificSettingsValues() []InstanceTypeBasicMigrationProviderSpecificSettings {
	return original.PossibleInstanceTypeBasicMigrationProviderSpecificSettingsValues()
}
func PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues() []InstanceTypeBasicNetworkMappingFabricSpecificSettings {
	return original.PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues()
}
func PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues() []InstanceTypeBasicPolicyProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicPolicyProviderSpecificInputValues() []InstanceTypeBasicPolicyProviderSpecificInput {
	return original.PossibleInstanceTypeBasicPolicyProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsValues() []InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicProviderSpecificFailoverInputValues() []InstanceTypeBasicProviderSpecificFailoverInput {
	return original.PossibleInstanceTypeBasicProviderSpecificFailoverInputValues()
}
func PossibleInstanceTypeBasicProviderSpecificRecoveryPointDetailsValues() []InstanceTypeBasicProviderSpecificRecoveryPointDetails {
	return original.PossibleInstanceTypeBasicProviderSpecificRecoveryPointDetailsValues()
}
func PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues() []InstanceTypeBasicRecoveryPlanActionDetails {
	return original.PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues()
}
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificDetailsValues() []InstanceTypeBasicRecoveryPlanProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicRecoveryPlanProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues() []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput {
	return original.PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues()
}
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificInputValues() []InstanceTypeBasicRecoveryPlanProviderSpecificInput {
	return original.PossibleInstanceTypeBasicRecoveryPlanProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicRemoveDisksProviderSpecificInputValues() []InstanceTypeBasicRemoveDisksProviderSpecificInput {
	return original.PossibleInstanceTypeBasicRemoveDisksProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsValues() []InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings {
	return original.PossibleInstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerMappingInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerMappingInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificContainerMappingInputValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues() []InstanceTypeBasicReplicationProviderSpecificSettings {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputValues() []InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputValues()
}
func PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues() []InstanceTypeBasicReverseReplicationProviderSpecificInput {
	return original.PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues() []InstanceTypeBasicSwitchProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicTaskTypeDetailsValues() []InstanceTypeBasicTaskTypeDetails {
	return original.PossibleInstanceTypeBasicTaskTypeDetailsValues()
}
func PossibleInstanceTypeBasicTestFailoverProviderSpecificInputValues() []InstanceTypeBasicTestFailoverProviderSpecificInput {
	return original.PossibleInstanceTypeBasicTestFailoverProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicTestMigrateProviderSpecificInputValues() []InstanceTypeBasicTestMigrateProviderSpecificInput {
	return original.PossibleInstanceTypeBasicTestMigrateProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicUnplannedFailoverProviderSpecificInputValues() []InstanceTypeBasicUnplannedFailoverProviderSpecificInput {
	return original.PossibleInstanceTypeBasicUnplannedFailoverProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicUpdateMigrationItemProviderSpecificInputValues() []InstanceTypeBasicUpdateMigrationItemProviderSpecificInput {
	return original.PossibleInstanceTypeBasicUpdateMigrationItemProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues() []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput {
	return original.PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues()
}
func PossibleInstanceTypeValues() []InstanceType {
	return original.PossibleInstanceTypeValues()
}
func PossibleLicenseTypeValues() []LicenseType {
	return original.PossibleLicenseTypeValues()
}
func PossibleMigrationItemOperationValues() []MigrationItemOperation {
	return original.PossibleMigrationItemOperationValues()
}
func PossibleMigrationRecoveryPointTypeValues() []MigrationRecoveryPointType {
	return original.PossibleMigrationRecoveryPointTypeValues()
}
func PossibleMigrationStateValues() []MigrationState {
	return original.PossibleMigrationStateValues()
}
func PossibleMobilityAgentUpgradeStateValues() []MobilityAgentUpgradeState {
	return original.PossibleMobilityAgentUpgradeStateValues()
}
func PossibleMultiVMGroupCreateOptionValues() []MultiVMGroupCreateOption {
	return original.PossibleMultiVMGroupCreateOptionValues()
}
func PossibleMultiVMSyncPointOptionValues() []MultiVMSyncPointOption {
	return original.PossibleMultiVMSyncPointOptionValues()
}
func PossibleMultiVMSyncStatusValues() []MultiVMSyncStatus {
	return original.PossibleMultiVMSyncStatusValues()
}
func PossiblePossibleOperationsDirectionsValues() []PossibleOperationsDirections {
	return original.PossiblePossibleOperationsDirectionsValues()
}
func PossiblePresenceStatusValues() []PresenceStatus {
	return original.PossiblePresenceStatusValues()
}
func PossibleProtectionHealthValues() []ProtectionHealth {
	return original.PossibleProtectionHealthValues()
}
func PossibleRecoveryPlanActionLocationValues() []RecoveryPlanActionLocation {
	return original.PossibleRecoveryPlanActionLocationValues()
}
func PossibleRecoveryPlanGroupTypeValues() []RecoveryPlanGroupType {
	return original.PossibleRecoveryPlanGroupTypeValues()
}
func PossibleRecoveryPlanPointTypeValues() []RecoveryPlanPointType {
	return original.PossibleRecoveryPlanPointTypeValues()
}
func PossibleRecoveryPointSyncTypeValues() []RecoveryPointSyncType {
	return original.PossibleRecoveryPointSyncTypeValues()
}
func PossibleRecoveryPointTypeValues() []RecoveryPointType {
	return original.PossibleRecoveryPointTypeValues()
}
func PossibleReplicationProtectedItemOperationValues() []ReplicationProtectedItemOperation {
	return original.PossibleReplicationProtectedItemOperationValues()
}
func PossibleResourceTypeBasicRecoveryAvailabilitySetCustomDetailsValues() []ResourceTypeBasicRecoveryAvailabilitySetCustomDetails {
	return original.PossibleResourceTypeBasicRecoveryAvailabilitySetCustomDetailsValues()
}
func PossibleResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsValues() []ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails {
	return original.PossibleResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsValues()
}
func PossibleResourceTypeBasicRecoveryResourceGroupCustomDetailsValues() []ResourceTypeBasicRecoveryResourceGroupCustomDetails {
	return original.PossibleResourceTypeBasicRecoveryResourceGroupCustomDetailsValues()
}
func PossibleResourceTypeBasicRecoveryVirtualNetworkCustomDetailsValues() []ResourceTypeBasicRecoveryVirtualNetworkCustomDetails {
	return original.PossibleResourceTypeBasicRecoveryVirtualNetworkCustomDetailsValues()
}
func PossibleResourceTypeBasicStorageAccountCustomDetailsValues() []ResourceTypeBasicStorageAccountCustomDetails {
	return original.PossibleResourceTypeBasicStorageAccountCustomDetailsValues()
}
func PossibleResourceTypeValues() []ResourceType {
	return original.PossibleResourceTypeValues()
}
func PossibleResyncStateValues() []ResyncState {
	return original.PossibleResyncStateValues()
}
func PossibleRpInMageRecoveryPointTypeValues() []RpInMageRecoveryPointType {
	return original.PossibleRpInMageRecoveryPointTypeValues()
}
func PossibleSetMultiVMSyncStatusValues() []SetMultiVMSyncStatus {
	return original.PossibleSetMultiVMSyncStatusValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSourceSiteOperationsValues() []SourceSiteOperations {
	return original.PossibleSourceSiteOperationsValues()
}
func PossibleTestMigrationStateValues() []TestMigrationState {
	return original.PossibleTestMigrationStateValues()
}
func PossibleVMEncryptionTypeValues() []VMEncryptionType {
	return original.PossibleVMEncryptionTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
