---
title: "v1.23.0"
linkTitle: "v1.23.0"
date: 2021-12-16
description: >
  Cloud Provider Azure v1.23.0
---

# Changelog since v1.1.0

## Changes by Kind

### Feature

- Adds support for the Cloud Node Manager to run as a Windows Service. This can be enabled using the --windows-service flag. ([#823](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/823), [@JoelSpeed](https://github.com/JoelSpeed))
- Chore: rename tag key for CSI drivers ([#799](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/799), [@andyzhangx](https://github.com/andyzhangx))
- Feat: Adds windows server 2022 build ([#821](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/821), [@nick5616](https://github.com/nick5616))
- Feat: add AccessTier in file share creation interface ([#781](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/781), [@andyzhangx](https://github.com/andyzhangx))
- Feat: add AllowBlobPublicAccess setting in storage account creation ([#784](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/784), [@andyzhangx](https://github.com/andyzhangx))
- Feat: add disk online resize support ([#889](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/889), [@andyzhangx](https://github.com/andyzhangx))
- Feat: only restart all controllers after stopping if needed ([#832](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/832), [@nilo19](https://github.com/nilo19))
- Feat: reduce vmss cache refresh in parallel disk attach/detach ([#803](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/803), [@andyzhangx](https://github.com/andyzhangx))
- Feat: support creating account if not exists when account name is provided ([#786](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/786), [@andyzhangx](https://github.com/andyzhangx))
- Feat: support json style tags ([#892](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/892), [@nilo19](https://github.com/nilo19))
- Feat: support reloading the cloud controller manager based on the changes of the config file ([#769](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/769), [@nilo19](https://github.com/nilo19))
- Introduce a new config `loadBalancerBackendPoolConfigurationType` and it can be set to `nodeIPConfiguration` (default) or `nodeIP`. If set to `nodeIPConfiguration`, everything will keep unchanged. If set to `nodeIP`, the cloud provider will call the LB API to attach the node private IPs to the LB instead of linking the NICs to the LB. ([#918](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/918), [@nilo19](https://github.com/nilo19))
- Prefix 'k8s-azure-' has been added to the following tags:
  
  Legacy Tag | New Tag | Comment
  -- | -- | --
  service | k8s-azure-service | Applied on public IP
  kubernetes-cluster-name | k8s-azure-cluster-name | Applied on public IP
  kubernetes-dns-label-service | k8s-azure-dns-label-service | Applied on public IP
  
  To keep backward compability, the legacy tags on existing public IP would not be removed, but newly created public IPs would only get the new tags. ([#815](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/815), [@feiskyer](https://github.com/feiskyer))

### Documentation

- Chore: add release notes for v0.7.9, v1.0.6 and v1.1.2 ([#867](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/867), [@nilo19](https://github.com/nilo19))

### Failing Test

- Chore: fix implictly required vendor ([#775](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/775), [@nilo19](https://github.com/nilo19))

### Bug or Regression

- **Release note**: ([#780](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/780), [@andyzhangx](https://github.com/andyzhangx))
- 1 controllerserver.go:378] delete azure disk(/subscriptions/xxx/resourceGroups/aks55h93-nodegroup/providers/Microsoft.Compute/disks/pvc-ecfefbb9-102c-4f40-944f-d5d4b6183568) returned with Retriable: true, RetryAfter: 0s, HTTPStatusCode: 0, RawError: azure cloud provider rate limited(read) for operation "GetDisk"
   1 utils.go:100] GRPC error: Retriable: true, RetryAfter: 0s, HTTPStatusCode: 0, RawError: azure cloud provider rate limited(read) for operation "GetDisk" ([#757](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/757), [@andyzhangx](https://github.com/andyzhangx))
- Fix detach disk issue on deleting vmss node ([#774](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/774), [@andyzhangx](https://github.com/andyzhangx))
- Fix: consolidate logs for instance not found error ([#794](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/794), [@feiskyer](https://github.com/feiskyer))
- Fix: detach disk should return error when throttled ([#929](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/929), [@andyzhangx](https://github.com/andyzhangx))
- Fix: do not crash if the region does not support zones ([#850](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/850), [@nilo19](https://github.com/nilo19))
- Fix: do not delete the lb that does not exist ([#860](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/860), [@nilo19](https://github.com/nilo19))
- Fix: fix a potential data race issue in unit test ([#848](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/848), [@nilo19](https://github.com/nilo19))
- Fix: ignore the case when comparing azure tags in service annotation ([#791](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/791), [@nilo19](https://github.com/nilo19))
- Fix: multi accounts creation issue when private endpoint creation failed ([#880](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/880), [@andyzhangx](https://github.com/andyzhangx))
- Fix: panic due to nil pointer ([#899](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/899), [@andyzhangx](https://github.com/andyzhangx))
- Fix: remove VMSS instances from SLB backend pool only when they are explicitly labeled
  fix: remove VMSS from SLB backend pool only when necessary ([#856](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/856), [@feiskyer](https://github.com/feiskyer))
- Fix: remove outdated ipv4 route when the corresponding node is deleted ([#876](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/876), [@nilo19](https://github.com/nilo19))
- Fix: use correct gitVersion in userAgent ([#764](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/764), [@feiskyer](https://github.com/feiskyer))
- Version.Info{Major:"1", Minor:"0+", GitVersion:"v1.0.1-116-g93dee8c35", GitCommit:"93dee8c35bddbff6beabb764725c74d252130c3c", GitTreeState:"", BuildDate:"2021-08-11T08:21:10Z", GoVersion:"go1.16.6", Compiler:"gc", Platform:"darwin/amd64"} ([#749](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/749), [@feiskyer](https://github.com/feiskyer))

### Other (Cleanup or Flake)

- Chore: add mixed protocol service e2e test ([#897](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/897), [@nilo19](https://github.com/nilo19))
- Chore: bump k8s.io/cloud-provider to v0.23.0 ([#934](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/934), [@nilo19](https://github.com/nilo19))
- Chore: detect data race in unit tests ([#849](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/849), [@nilo19](https://github.com/nilo19))
- Chore: expose some public functions ([#754](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/754), [@andyzhangx](https://github.com/andyzhangx))
- Chore: logging the service body when service controller invokes the cloud provider ([#778](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/778), [@nilo19](https://github.com/nilo19))
- Cleanup: remove blob disk controller
  blob disk  is not supported any more ([#909](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/909), [@andyzhangx](https://github.com/andyzhangx))
- Fix: report an error when route table name is not configured ([#819](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/819), [@feiskyer](https://github.com/feiskyer))

### Uncategorized

- Fix: skip instance not found when decoupling vmss from lb ([#842](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/842), [@nilo19](https://github.com/nilo19))
- Fix: switch to sync detach disk ([#790](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/790), [@andyzhangx](https://github.com/andyzhangx))
- Use docker buildx for multi-arch node image ([#855](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/855), [@mainred](https://github.com/mainred))

## Dependencies

### Added
- github.com/cncf/xds/go: [fbca930](https://github.com/cncf/xds/go/tree/fbca930)
- github.com/getkin/kin-openapi: [v0.76.0](https://github.com/getkin/kin-openapi/tree/v0.76.0)
- github.com/go-logr/zapr: [v1.2.0](https://github.com/go-logr/zapr/tree/v1.2.0)
- github.com/golang-jwt/jwt/v4: [v4.0.0](https://github.com/golang-jwt/jwt/v4/tree/v4.0.0)
- github.com/gorilla/mux: [v1.8.0](https://github.com/gorilla/mux/tree/v1.8.0)
- k8s.io/component-helpers: v0.23.0
- k8s.io/kubelet: v0.23.0
- sigs.k8s.io/json: c049b76

### Changed
- github.com/Azure/azure-sdk-for-go: [v55.0.0+incompatible → v55.8.0+incompatible](https://github.com/Azure/azure-sdk-for-go/compare/v55.0.0...v55.8.0)
- github.com/Azure/go-autorest/autorest/adal: [v0.9.14 → v0.9.17](https://github.com/Azure/go-autorest/autorest/adal/compare/v0.9.14...v0.9.17)
- github.com/Azure/go-autorest/autorest/validation: [v0.1.0 → v0.3.1](https://github.com/Azure/go-autorest/autorest/validation/compare/v0.1.0...v0.3.1)
- github.com/Azure/go-autorest/autorest: [v0.11.19 → v0.11.22](https://github.com/Azure/go-autorest/autorest/compare/v0.11.19...v0.11.22)
- github.com/benbjohnson/clock: [v1.0.3 → v1.1.0](https://github.com/benbjohnson/clock/compare/v1.0.3...v1.1.0)
- github.com/envoyproxy/go-control-plane: [668b12f → 63b5d3c](https://github.com/envoyproxy/go-control-plane/compare/668b12f...63b5d3c)
- github.com/evanphx/json-patch: [v4.11.0+incompatible → v4.12.0+incompatible](https://github.com/evanphx/json-patch/compare/v4.11.0...v4.12.0)
- github.com/fsnotify/fsnotify: [v1.4.9 → v1.5.1](https://github.com/fsnotify/fsnotify/compare/v1.4.9...v1.5.1)
- github.com/go-logr/logr: [v0.4.0 → v1.2.0](https://github.com/go-logr/logr/compare/v0.4.0...v1.2.0)
- github.com/json-iterator/go: [v1.1.11 → v1.1.12](https://github.com/json-iterator/go/compare/v1.1.11...v1.1.12)
- github.com/mitchellh/go-homedir: [v1.1.0 → v1.0.0](https://github.com/mitchellh/go-homedir/compare/v1.1.0...v1.0.0)
- github.com/modern-go/reflect2: [v1.0.1 → v1.0.2](https://github.com/modern-go/reflect2/compare/v1.0.1...v1.0.2)
- github.com/onsi/ginkgo: [v1.16.4 → v1.16.5](https://github.com/onsi/ginkgo/compare/v1.16.4...v1.16.5)
- github.com/onsi/gomega: [v1.15.0 → v1.16.0](https://github.com/onsi/gomega/compare/v1.15.0...v1.16.0)
- github.com/prometheus/common: [v0.26.0 → v0.28.0](https://github.com/prometheus/common/compare/v0.26.0...v0.28.0)
- github.com/stretchr/objx: [v0.2.0 → v0.1.1](https://github.com/stretchr/objx/compare/v0.2.0...v0.1.1)
- github.com/yuin/goldmark: [v1.3.5 → v1.4.0](https://github.com/yuin/goldmark/compare/v1.3.5...v1.4.0)
- go.uber.org/zap: v1.17.0 → v1.19.0
- golang.org/x/crypto: 5ea612d → 089bfa5
- golang.org/x/net: 37e1c6a → e898025
- golang.org/x/oauth2: 2e8d934 → 2bc19b1
- golang.org/x/sys: 59db8d7 → f4d4317
- golang.org/x/term: 6a3ed07 → 6886f2d
- golang.org/x/text: v0.3.6 → v0.3.7
- golang.org/x/tools: v0.1.2 → d4cc65f
- google.golang.org/genproto: f16073e → fe13028
- google.golang.org/grpc: v1.38.0 → v1.40.0
- google.golang.org/protobuf: v1.26.0 → v1.27.1
- k8s.io/api: v0.22.0 → v0.23.0
- k8s.io/apimachinery: v0.22.0 → v0.23.0
- k8s.io/apiserver: v0.22.0 → v0.23.0
- k8s.io/client-go: v0.22.0 → v0.23.0
- k8s.io/cloud-provider: v0.22.0 → v0.23.0
- k8s.io/component-base: v0.22.0 → v0.23.0
- k8s.io/controller-manager: v0.22.0 → v0.23.0
- k8s.io/gengo: 3a45101 → 485abfe
- k8s.io/klog/v2: v2.10.0 → v2.30.0
- k8s.io/kube-openapi: 9528897 → e816edb
- k8s.io/utils: 4b05e18 → cb0fa31
- sigs.k8s.io/apiserver-network-proxy/konnectivity-client: v0.0.22 → v0.0.25
- sigs.k8s.io/yaml: v1.2.0 → v1.3.0

### Removed
- cloud.google.com/go/datastore: v1.1.0
- cloud.google.com/go/pubsub: v1.3.1
- github.com/alecthomas/template: [fb15b89](https://github.com/alecthomas/template/tree/fb15b89)
- github.com/alecthomas/units: [f65c72e](https://github.com/alecthomas/units/tree/f65c72e)
- github.com/client9/misspell: [v0.3.4](https://github.com/client9/misspell/tree/v0.3.4)
- github.com/coreos/bbolt: [v1.3.2](https://github.com/coreos/bbolt/tree/v1.3.2)
- github.com/coreos/etcd: [v3.3.13+incompatible](https://github.com/coreos/etcd/tree/v3.3.13)
- github.com/coreos/go-systemd: [95778df](https://github.com/coreos/go-systemd/tree/95778df)
- github.com/coreos/pkg: [399ea9e](https://github.com/coreos/pkg/tree/399ea9e)
- github.com/dgrijalva/jwt-go: [v3.2.0+incompatible](https://github.com/dgrijalva/jwt-go/tree/v3.2.0)
- github.com/dgryski/go-sip13: [e10d5fe](https://github.com/dgryski/go-sip13/tree/e10d5fe)
- github.com/dnaeon/go-vcr: [v1.1.0](https://github.com/dnaeon/go-vcr/tree/v1.1.0)
- github.com/go-gl/glfw: [e6da0ac](https://github.com/go-gl/glfw/tree/e6da0ac)
- github.com/gofrs/uuid: [v4.0.0+incompatible](https://github.com/gofrs/uuid/tree/v4.0.0)
- github.com/google/martian: [v2.1.0+incompatible](https://github.com/google/martian/tree/v2.1.0)
- github.com/hpcloud/tail: [v1.0.0](https://github.com/hpcloud/tail/tree/v1.0.0)
- github.com/jpillora/backoff: [v1.0.0](https://github.com/jpillora/backoff/tree/v1.0.0)
- github.com/konsorten/go-windows-terminal-sequences: [v1.0.3](https://github.com/konsorten/go-windows-terminal-sequences/tree/v1.0.3)
- github.com/kr/logfmt: [b84e30a](https://github.com/kr/logfmt/tree/b84e30a)
- github.com/kr/pty: [v1.1.1](https://github.com/kr/pty/tree/v1.1.1)
- github.com/modocache/gover: [b58185e](https://github.com/modocache/gover/tree/b58185e)
- github.com/oklog/ulid: [v1.3.1](https://github.com/oklog/ulid/tree/v1.3.1)
- github.com/prometheus/tsdb: [v0.7.1](https://github.com/prometheus/tsdb/tree/v0.7.1)
- github.com/rubiojr/go-vhd: [02e2102](https://github.com/rubiojr/go-vhd/tree/02e2102)
- gopkg.in/fsnotify.v1: v1.4.7
- gopkg.in/resty.v1: v1.12.0
- rsc.io/binaryregexp: v0.2.0
- rsc.io/quote/v3: v3.1.0
- rsc.io/sampler: v1.3.0
ree/02e2102)
- gopkg.in/fsnotify.v1: v1.4.7
- gopkg.in/resty.v1: v1.12.0
- rsc.io/binaryregexp: v0.2.0
- rsc.io/quote/v3: v3.1.0
- rsc.io/sampler: v1.3.0
