// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gapic-generator. DO NOT EDIT.

package apiv1

import (
	"context"
	"flag"
	"fmt"
	"io"
	"log"
	"net"
	"os"
	"strings"
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes"
	emptypb "github.com/golang/protobuf/ptypes/empty"
	"google.golang.org/api/option"
	adminpb "google.golang.org/genproto/googleapis/firestore/admin/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"

	status "google.golang.org/genproto/googleapis/rpc/status"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"

	gstatus "google.golang.org/grpc/status"
)

var _ = io.EOF
var _ = ptypes.MarshalAny
var _ status.Status

type mockFirestoreAdminServer struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	adminpb.FirestoreAdminServer

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockFirestoreAdminServer) CreateIndex(ctx context.Context, req *adminpb.CreateIndexRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockFirestoreAdminServer) ListIndexes(ctx context.Context, req *adminpb.ListIndexesRequest) (*adminpb.ListIndexesResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*adminpb.ListIndexesResponse), nil
}

func (s *mockFirestoreAdminServer) GetIndex(ctx context.Context, req *adminpb.GetIndexRequest) (*adminpb.Index, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*adminpb.Index), nil
}

func (s *mockFirestoreAdminServer) DeleteIndex(ctx context.Context, req *adminpb.DeleteIndexRequest) (*emptypb.Empty, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*emptypb.Empty), nil
}

func (s *mockFirestoreAdminServer) GetField(ctx context.Context, req *adminpb.GetFieldRequest) (*adminpb.Field, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*adminpb.Field), nil
}

func (s *mockFirestoreAdminServer) UpdateField(ctx context.Context, req *adminpb.UpdateFieldRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockFirestoreAdminServer) ListFields(ctx context.Context, req *adminpb.ListFieldsRequest) (*adminpb.ListFieldsResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*adminpb.ListFieldsResponse), nil
}

func (s *mockFirestoreAdminServer) ExportDocuments(ctx context.Context, req *adminpb.ExportDocumentsRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockFirestoreAdminServer) ImportDocuments(ctx context.Context, req *adminpb.ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

// clientOpt is the option tests should use to connect to the test server.
// It is initialized by TestMain.
var clientOpt option.ClientOption

var (
	mockFirestoreAdmin mockFirestoreAdminServer
)

func TestMain(m *testing.M) {
	flag.Parse()

	serv := grpc.NewServer()
	adminpb.RegisterFirestoreAdminServer(serv, &mockFirestoreAdmin)

	lis, err := net.Listen("tcp", "localhost:0")
	if err != nil {
		log.Fatal(err)
	}
	go serv.Serve(lis)

	conn, err := grpc.Dial(lis.Addr().String(), grpc.WithInsecure())
	if err != nil {
		log.Fatal(err)
	}
	clientOpt = option.WithGRPCConn(conn)

	os.Exit(m.Run())
}

func TestFirestoreAdminCreateIndex(t *testing.T) {
	var name string = "name3373707"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name,
		Done: done,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var index *adminpb.Index = &adminpb.Index{}
	var request = &adminpb.CreateIndexRequest{
		Parent: formattedParent,
		Index:  index,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateIndex(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminCreateIndexError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var index *adminpb.Index = &adminpb.Index{}
	var request = &adminpb.CreateIndexRequest{
		Parent: formattedParent,
		Index:  index,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateIndex(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminListIndexes(t *testing.T) {
	var nextPageToken string = ""
	var indexesElement *adminpb.Index = &adminpb.Index{}
	var indexes = []*adminpb.Index{indexesElement}
	var expectedResponse = &adminpb.ListIndexesResponse{
		NextPageToken: nextPageToken,
		Indexes:       indexes,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var request = &adminpb.ListIndexesRequest{
		Parent: formattedParent,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListIndexes(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Indexes[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminListIndexesError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var request = &adminpb.ListIndexesRequest{
		Parent: formattedParent,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListIndexes(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminGetIndex(t *testing.T) {
	var name2 string = "name2-1052831874"
	var expectedResponse = &adminpb.Index{
		Name: name2,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/indexes/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[INDEX_ID]")
	var request = &adminpb.GetIndexRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetIndex(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminGetIndexError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/indexes/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[INDEX_ID]")
	var request = &adminpb.GetIndexRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetIndex(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminDeleteIndex(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/indexes/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[INDEX_ID]")
	var request = &adminpb.DeleteIndexRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteIndex(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestFirestoreAdminDeleteIndexError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/indexes/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[INDEX_ID]")
	var request = &adminpb.DeleteIndexRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteIndex(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestFirestoreAdminImportDocuments(t *testing.T) {
	var name2 string = "name2-1052831874"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name2,
		Done: done,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s", "[PROJECT]", "[DATABASE]")
	var request = &adminpb.ImportDocumentsRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ImportDocuments(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminImportDocumentsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s", "[PROJECT]", "[DATABASE]")
	var request = &adminpb.ImportDocumentsRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ImportDocuments(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminExportDocuments(t *testing.T) {
	var name2 string = "name2-1052831874"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name2,
		Done: done,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s", "[PROJECT]", "[DATABASE]")
	var request = &adminpb.ExportDocumentsRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ExportDocuments(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminExportDocumentsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s", "[PROJECT]", "[DATABASE]")
	var request = &adminpb.ExportDocumentsRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ExportDocuments(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminGetField(t *testing.T) {
	var name2 string = "name2-1052831874"
	var expectedResponse = &adminpb.Field{
		Name: name2,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/fields/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[FIELD_ID]")
	var request = &adminpb.GetFieldRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetField(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminGetFieldError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s/fields/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]", "[FIELD_ID]")
	var request = &adminpb.GetFieldRequest{
		Name: formattedName,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetField(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminListFields(t *testing.T) {
	var nextPageToken string = ""
	var fieldsElement *adminpb.Field = &adminpb.Field{}
	var fields = []*adminpb.Field{fieldsElement}
	var expectedResponse = &adminpb.ListFieldsResponse{
		NextPageToken: nextPageToken,
		Fields:        fields,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var request = &adminpb.ListFieldsRequest{
		Parent: formattedParent,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListFields(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Fields[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminListFieldsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/databases/%s/collectionGroups/%s", "[PROJECT]", "[DATABASE]", "[COLLECTION_ID]")
	var request = &adminpb.ListFieldsRequest{
		Parent: formattedParent,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListFields(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestFirestoreAdminUpdateField(t *testing.T) {
	var name string = "name3373707"
	var done bool = true
	var expectedResponse = &longrunningpb.Operation{
		Name: name,
		Done: done,
	}

	mockFirestoreAdmin.err = nil
	mockFirestoreAdmin.reqs = nil

	mockFirestoreAdmin.resps = append(mockFirestoreAdmin.resps[:0], expectedResponse)

	var field *adminpb.Field = &adminpb.Field{}
	var request = &adminpb.UpdateFieldRequest{
		Field: field,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateField(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockFirestoreAdmin.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestFirestoreAdminUpdateFieldError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockFirestoreAdmin.err = gstatus.Error(errCode, "test error")

	var field *adminpb.Field = &adminpb.Field{}
	var request = &adminpb.UpdateFieldRequest{
		Field: field,
	}

	c, err := NewFirestoreAdminClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateField(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
