package sqlapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/2017-03-01-preview/sql"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/gofrs/uuid"
)

// RecoverableDatabasesClientAPI contains the set of methods on the RecoverableDatabasesClient type.
type RecoverableDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RecoverableDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RecoverableDatabaseListResult, err error)
}

var _ RecoverableDatabasesClientAPI = (*sql.RecoverableDatabasesClient)(nil)

// RestorableDroppedDatabasesClientAPI contains the set of methods on the RestorableDroppedDatabasesClient type.
type RestorableDroppedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, restorableDroppededDatabaseID string) (result sql.RestorableDroppedDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RestorableDroppedDatabaseListResult, err error)
}

var _ RestorableDroppedDatabasesClientAPI = (*sql.RestorableDroppedDatabasesClient)(nil)

// CapabilitiesClientAPI contains the set of methods on the CapabilitiesClient type.
type CapabilitiesClientAPI interface {
	ListByLocation(ctx context.Context, locationID string) (result sql.LocationCapabilities, err error)
}

var _ CapabilitiesClientAPI = (*sql.CapabilitiesClient)(nil)

// ServersClientAPI contains the set of methods on the ServersClient type.
type ServersClientAPI interface {
	CheckNameAvailability(ctx context.Context, parameters sql.CheckNameAvailabilityRequest) (result sql.CheckNameAvailabilityResponse, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.Server) (result sql.ServersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.Server, err error)
	List(ctx context.Context) (result sql.ServerListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.ServerListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.ServerListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.ServerListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerUpdate) (result sql.ServersUpdateFuture, err error)
}

var _ ServersClientAPI = (*sql.ServersClient)(nil)

// ServerConnectionPoliciesClientAPI contains the set of methods on the ServerConnectionPoliciesClient type.
type ServerConnectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerConnectionPolicy) (result sql.ServerConnectionPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerConnectionPolicy, err error)
}

var _ ServerConnectionPoliciesClientAPI = (*sql.ServerConnectionPoliciesClient)(nil)

// DatabasesClientAPI contains the set of methods on the DatabasesClient type.
type DatabasesClientAPI interface {
	CreateImportOperation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ImportExtensionRequest) (result sql.DatabasesCreateImportOperationFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.Database) (result sql.DatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error)
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExportRequest) (result sql.DatabasesExportFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, expand string) (result sql.Database, err error)
	GetByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, databaseName string) (result sql.Database, err error)
	GetByRecommendedElasticPool(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string, databaseName string) (result sql.Database, err error)
	Import(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ImportRequest) (result sql.DatabasesImportFuture, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResult, err error)
	ListByRecommendedElasticPool(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.DatabaseListResult, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, expand string, filter string) (result sql.DatabaseListResult, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.MetricListResult, err error)
	Pause(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesPauseFuture, err error)
	Rename(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ResourceMoveDefinition) (result autorest.Response, err error)
	Resume(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesResumeFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseUpdate) (result sql.DatabasesUpdateFuture, err error)
}

var _ DatabasesClientAPI = (*sql.DatabasesClient)(nil)

// DatabaseThreatDetectionPoliciesClientAPI contains the set of methods on the DatabaseThreatDetectionPoliciesClient type.
type DatabaseThreatDetectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseSecurityAlertPolicy) (result sql.DatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertPolicy, err error)
}

var _ DatabaseThreatDetectionPoliciesClientAPI = (*sql.DatabaseThreatDetectionPoliciesClient)(nil)

// DataMaskingPoliciesClientAPI contains the set of methods on the DataMaskingPoliciesClient type.
type DataMaskingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DataMaskingPolicy) (result sql.DataMaskingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingPolicy, err error)
}

var _ DataMaskingPoliciesClientAPI = (*sql.DataMaskingPoliciesClient)(nil)

// DataMaskingRulesClientAPI contains the set of methods on the DataMaskingRulesClient type.
type DataMaskingRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, dataMaskingRuleName string, parameters sql.DataMaskingRule) (result sql.DataMaskingRule, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingRuleListResult, err error)
}

var _ DataMaskingRulesClientAPI = (*sql.DataMaskingRulesClient)(nil)

// ElasticPoolsClientAPI contains the set of methods on the ElasticPoolsClient type.
type ElasticPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPool) (result sql.ElasticPoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ElasticPoolListResult, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, filter string) (result sql.MetricListResult, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPoolUpdate) (result sql.ElasticPoolsUpdateFuture, err error)
}

var _ ElasticPoolsClientAPI = (*sql.ElasticPoolsClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters sql.FirewallRule) (result sql.FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result sql.FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FirewallRuleListResult, err error)
}

var _ FirewallRulesClientAPI = (*sql.FirewallRulesClient)(nil)

// GeoBackupPoliciesClientAPI contains the set of methods on the GeoBackupPoliciesClient type.
type GeoBackupPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.GeoBackupPolicy) (result sql.GeoBackupPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicyListResult, err error)
}

var _ GeoBackupPoliciesClientAPI = (*sql.GeoBackupPoliciesClient)(nil)

// ReplicationLinksClientAPI contains the set of methods on the ReplicationLinksClient type.
type ReplicationLinksClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result autorest.Response, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverFuture, err error)
	FailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLink, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ReplicationLinkListResult, err error)
	Unlink(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string, parameters sql.UnlinkParameters) (result sql.ReplicationLinksUnlinkFuture, err error)
}

var _ ReplicationLinksClientAPI = (*sql.ReplicationLinksClient)(nil)

// ServerAzureADAdministratorsClientAPI contains the set of methods on the ServerAzureADAdministratorsClient type.
type ServerAzureADAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, properties sql.ServerAzureADAdministrator) (result sql.ServerAzureADAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministrator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAdministratorListResult, err error)
}

var _ ServerAzureADAdministratorsClientAPI = (*sql.ServerAzureADAdministratorsClient)(nil)

// ServerCommunicationLinksClientAPI contains the set of methods on the ServerCommunicationLinksClient type.
type ServerCommunicationLinksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string, parameters sql.ServerCommunicationLink) (result sql.ServerCommunicationLinksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result sql.ServerCommunicationLink, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerCommunicationLinkListResult, err error)
}

var _ ServerCommunicationLinksClientAPI = (*sql.ServerCommunicationLinksClient)(nil)

// ServiceObjectivesClientAPI contains the set of methods on the ServiceObjectivesClient type.
type ServiceObjectivesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, serviceObjectiveName string) (result sql.ServiceObjective, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServiceObjectiveListResult, err error)
}

var _ ServiceObjectivesClientAPI = (*sql.ServiceObjectivesClient)(nil)

// ElasticPoolActivitiesClientAPI contains the set of methods on the ElasticPoolActivitiesClient type.
type ElasticPoolActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolActivityListResult, err error)
}

var _ ElasticPoolActivitiesClientAPI = (*sql.ElasticPoolActivitiesClient)(nil)

// ElasticPoolDatabaseActivitiesClientAPI contains the set of methods on the ElasticPoolDatabaseActivitiesClient type.
type ElasticPoolDatabaseActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolDatabaseActivityListResult, err error)
}

var _ ElasticPoolDatabaseActivitiesClientAPI = (*sql.ElasticPoolDatabaseActivitiesClient)(nil)

// ServiceTierAdvisorsClientAPI contains the set of methods on the ServiceTierAdvisorsClient type.
type ServiceTierAdvisorsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, serviceTierAdvisorName string) (result sql.ServiceTierAdvisor, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ServiceTierAdvisorListResult, err error)
}

var _ ServiceTierAdvisorsClientAPI = (*sql.ServiceTierAdvisorsClient)(nil)

// TransparentDataEncryptionsClientAPI contains the set of methods on the TransparentDataEncryptionsClient type.
type TransparentDataEncryptionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.TransparentDataEncryption) (result sql.TransparentDataEncryption, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryption, err error)
}

var _ TransparentDataEncryptionsClientAPI = (*sql.TransparentDataEncryptionsClient)(nil)

// TransparentDataEncryptionActivitiesClientAPI contains the set of methods on the TransparentDataEncryptionActivitiesClient type.
type TransparentDataEncryptionActivitiesClientAPI interface {
	ListByConfiguration(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryptionActivityListResult, err error)
}

var _ TransparentDataEncryptionActivitiesClientAPI = (*sql.TransparentDataEncryptionActivitiesClient)(nil)

// ServerUsagesClientAPI contains the set of methods on the ServerUsagesClient type.
type ServerUsagesClientAPI interface {
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerUsageListResult, err error)
}

var _ ServerUsagesClientAPI = (*sql.ServerUsagesClient)(nil)

// DatabaseUsagesClientAPI contains the set of methods on the DatabaseUsagesClient type.
type DatabaseUsagesClientAPI interface {
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseUsageListResult, err error)
}

var _ DatabaseUsagesClientAPI = (*sql.DatabaseUsagesClient)(nil)

// DatabaseAutomaticTuningClientAPI contains the set of methods on the DatabaseAutomaticTuningClient type.
type DatabaseAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseAutomaticTuning) (result sql.DatabaseAutomaticTuning, err error)
}

var _ DatabaseAutomaticTuningClientAPI = (*sql.DatabaseAutomaticTuningClient)(nil)

// EncryptionProtectorsClientAPI contains the set of methods on the EncryptionProtectorsClient type.
type EncryptionProtectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.EncryptionProtector) (result sql.EncryptionProtectorsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtector, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultIterator, err error)
	Revalidate(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorsRevalidateFuture, err error)
}

var _ EncryptionProtectorsClientAPI = (*sql.EncryptionProtectorsClient)(nil)

// FailoverGroupsClientAPI contains the set of methods on the FailoverGroupsClient type.
type FailoverGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroup) (result sql.FailoverGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsFailoverFuture, err error)
	ForceFailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsForceFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroup, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroupUpdate) (result sql.FailoverGroupsUpdateFuture, err error)
}

var _ FailoverGroupsClientAPI = (*sql.FailoverGroupsClient)(nil)

// ManagedInstancesClientAPI contains the set of methods on the ManagedInstancesClient type.
type ManagedInstancesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstance) (result sql.ManagedInstancesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstance, err error)
	List(ctx context.Context) (result sql.ManagedInstanceListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.ManagedInstanceListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.ManagedInstanceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.ManagedInstanceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceUpdate) (result sql.ManagedInstancesUpdateFuture, err error)
}

var _ ManagedInstancesClientAPI = (*sql.ManagedInstancesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result sql.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*sql.OperationsClient)(nil)

// ServerKeysClientAPI contains the set of methods on the ServerKeysClient type.
type ServerKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, keyName string, parameters sql.ServerKey) (result sql.ServerKeysCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKeysDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKey, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultIterator, err error)
}

var _ ServerKeysClientAPI = (*sql.ServerKeysClient)(nil)

// SyncAgentsClientAPI contains the set of methods on the SyncAgentsClient type.
type SyncAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string, parameters sql.SyncAgent) (result sql.SyncAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentsDeleteFuture, err error)
	GenerateKey(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentKeyProperties, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultIterator, err error)
	ListLinkedDatabases(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultPage, err error)
	ListLinkedDatabasesComplete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultIterator, err error)
}

var _ SyncAgentsClientAPI = (*sql.SyncAgentsClient)(nil)

// SyncGroupsClientAPI contains the set of methods on the SyncGroupsClient type.
type SyncGroupsClientAPI interface {
	CancelSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroup, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultIterator, err error)
	ListHubSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListHubSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	ListLogs(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter string, continuationToken string) (result sql.SyncGroupLogListResultPage, err error)
	ListLogsComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter string, continuationToken string) (result sql.SyncGroupLogListResultIterator, err error)
	ListSyncDatabaseIds(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultPage, err error)
	ListSyncDatabaseIdsComplete(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultIterator, err error)
	RefreshHubSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsRefreshHubSchemaFuture, err error)
	TriggerSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsUpdateFuture, err error)
}

var _ SyncGroupsClientAPI = (*sql.SyncGroupsClient)(nil)

// SyncMembersClientAPI contains the set of methods on the SyncMembersClient type.
type SyncMembersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMember, err error)
	ListBySyncGroup(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultPage, err error)
	ListBySyncGroupComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultIterator, err error)
	ListMemberSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListMemberSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	RefreshMemberSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersRefreshMemberSchemaFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersUpdateFuture, err error)
}

var _ SyncMembersClientAPI = (*sql.SyncMembersClient)(nil)

// SubscriptionUsagesClientAPI contains the set of methods on the SubscriptionUsagesClient type.
type SubscriptionUsagesClientAPI interface {
	Get(ctx context.Context, locationName string, usageName string) (result sql.SubscriptionUsage, err error)
	ListByLocation(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultIterator, err error)
}

var _ SubscriptionUsagesClientAPI = (*sql.SubscriptionUsagesClient)(nil)

// VirtualClustersClientAPI contains the set of methods on the VirtualClustersClient type.
type VirtualClustersClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualCluster, err error)
	List(ctx context.Context) (result sql.VirtualClusterListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.VirtualClusterListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, virtualClusterName string, parameters sql.VirtualClusterUpdate) (result sql.VirtualClustersUpdateFuture, err error)
}

var _ VirtualClustersClientAPI = (*sql.VirtualClustersClient)(nil)

// ExtendedDatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedDatabaseBlobAuditingPoliciesClient type.
type ExtendedDatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExtendedDatabaseBlobAuditingPolicy) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedDatabaseBlobAuditingPoliciesClientAPI = (*sql.ExtendedDatabaseBlobAuditingPoliciesClient)(nil)

// ExtendedServerBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedServerBlobAuditingPoliciesClient type.
type ExtendedServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ExtendedServerBlobAuditingPolicy) (result sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedServerBlobAuditingPoliciesClientAPI = (*sql.ExtendedServerBlobAuditingPoliciesClient)(nil)

// ServerBlobAuditingPoliciesClientAPI contains the set of methods on the ServerBlobAuditingPoliciesClient type.
type ServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerBlobAuditingPolicy) (result sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ServerBlobAuditingPoliciesClientAPI = (*sql.ServerBlobAuditingPoliciesClient)(nil)

// DatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the DatabaseBlobAuditingPoliciesClient type.
type DatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseBlobAuditingPolicy) (result sql.DatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ DatabaseBlobAuditingPoliciesClientAPI = (*sql.DatabaseBlobAuditingPoliciesClient)(nil)

// DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentRuleBaselinesClient type.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName, parameters sql.DatabaseVulnerabilityAssessmentRuleBaseline) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
}

var _ DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.DatabaseVulnerabilityAssessmentRuleBaselinesClient)(nil)

// DatabaseVulnerabilityAssessmentsClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentsClient type.
type DatabaseVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseVulnerabilityAssessment) (result sql.DatabaseVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultIterator, err error)
}

var _ DatabaseVulnerabilityAssessmentsClientAPI = (*sql.DatabaseVulnerabilityAssessmentsClient)(nil)

// VirtualNetworkRulesClientAPI contains the set of methods on the VirtualNetworkRulesClient type.
type VirtualNetworkRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string, parameters sql.VirtualNetworkRule) (result sql.VirtualNetworkRulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultIterator, err error)
}

var _ VirtualNetworkRulesClientAPI = (*sql.VirtualNetworkRulesClient)(nil)

// DatabaseOperationsClientAPI contains the set of methods on the DatabaseOperationsClient type.
type DatabaseOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, databaseName string, operationID uuid.UUID) (result autorest.Response, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultIterator, err error)
}

var _ DatabaseOperationsClientAPI = (*sql.DatabaseOperationsClient)(nil)

// DataWarehouseUserActivitiesClientAPI contains the set of methods on the DataWarehouseUserActivitiesClient type.
type DataWarehouseUserActivitiesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataWarehouseUserActivities, err error)
}

var _ DataWarehouseUserActivitiesClientAPI = (*sql.DataWarehouseUserActivitiesClient)(nil)

// JobAgentsClientAPI contains the set of methods on the JobAgentsClient type.
type JobAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgent) (result sql.JobAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgentUpdate) (result sql.JobAgentsUpdateFuture, err error)
}

var _ JobAgentsClientAPI = (*sql.JobAgentsClient)(nil)

// JobCredentialsClientAPI contains the set of methods on the JobCredentialsClient type.
type JobCredentialsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string, parameters sql.JobCredential) (result sql.JobCredential, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result sql.JobCredential, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultIterator, err error)
}

var _ JobCredentialsClientAPI = (*sql.JobCredentialsClient)(nil)

// JobExecutionsClientAPI contains the set of methods on the JobExecutionsClient type.
type JobExecutionsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result autorest.Response, err error)
	Create(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobExecutionsCreateFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecutionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecution, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobExecutionsClientAPI = (*sql.JobExecutionsClient)(nil)

// JobsClientAPI contains the set of methods on the JobsClient type.
type JobsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, parameters sql.Job) (result sql.Job, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.Job, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultIterator, err error)
}

var _ JobsClientAPI = (*sql.JobsClient)(nil)

// JobStepExecutionsClientAPI contains the set of methods on the JobStepExecutionsClient type.
type JobStepExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobStepExecutionsClientAPI = (*sql.JobStepExecutionsClient)(nil)

// JobStepsClientAPI contains the set of methods on the JobStepsClient type.
type JobStepsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, parameters sql.JobStep) (result sql.JobStep, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result sql.JobStep, err error)
	GetByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32, stepName string) (result sql.JobStep, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultIterator, err error)
	ListByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultPage, err error)
	ListByVersionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultIterator, err error)
}

var _ JobStepsClientAPI = (*sql.JobStepsClient)(nil)

// JobTargetExecutionsClientAPI contains the set of methods on the JobTargetExecutionsClient type.
type JobTargetExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, targetID uuid.UUID) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByStep(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByStepComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobTargetExecutionsClientAPI = (*sql.JobTargetExecutionsClient)(nil)

// JobTargetGroupsClientAPI contains the set of methods on the JobTargetGroupsClient type.
type JobTargetGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string, parameters sql.JobTargetGroup) (result sql.JobTargetGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result sql.JobTargetGroup, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultIterator, err error)
}

var _ JobTargetGroupsClientAPI = (*sql.JobTargetGroupsClient)(nil)

// JobVersionsClientAPI contains the set of methods on the JobVersionsClient type.
type JobVersionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobVersion, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultIterator, err error)
}

var _ JobVersionsClientAPI = (*sql.JobVersionsClient)(nil)

// ManagedBackupShortTermRetentionPoliciesClientAPI contains the set of methods on the ManagedBackupShortTermRetentionPoliciesClient type.
type ManagedBackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ ManagedBackupShortTermRetentionPoliciesClientAPI = (*sql.ManagedBackupShortTermRetentionPoliciesClient)(nil)

// ManagedDatabasesClientAPI contains the set of methods on the ManagedDatabasesClient type.
type ManagedDatabasesClientAPI interface {
	CompleteRestore(ctx context.Context, locationName string, operationID uuid.UUID, parameters sql.CompleteDatabaseRestoreDefinition) (result sql.ManagedDatabasesCompleteRestoreFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabase) (result sql.ManagedDatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseUpdate) (result sql.ManagedDatabasesUpdateFuture, err error)
}

var _ ManagedDatabasesClientAPI = (*sql.ManagedDatabasesClient)(nil)

// SensitivityLabelsClientAPI contains the set of methods on the SensitivityLabelsClient type.
type SensitivityLabelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, parameters sql.SensitivityLabel) (result sql.SensitivityLabel, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	DisableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	EnableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, sensitivityLabelSource sql.SensitivityLabelSource) (result sql.SensitivityLabel, err error)
	ListCurrentByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListCurrentByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	ListRecommendedByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListRecommendedByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
}

var _ SensitivityLabelsClientAPI = (*sql.SensitivityLabelsClient)(nil)

// ManagedInstanceAdministratorsClientAPI contains the set of methods on the ManagedInstanceAdministratorsClient type.
type ManagedInstanceAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceAdministrator) (result sql.ManagedInstanceAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministrator, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultIterator, err error)
}

var _ ManagedInstanceAdministratorsClientAPI = (*sql.ManagedInstanceAdministratorsClient)(nil)

// ServerAutomaticTuningClientAPI contains the set of methods on the ServerAutomaticTuningClient type.
type ServerAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAutomaticTuning) (result sql.ServerAutomaticTuning, err error)
}

var _ ServerAutomaticTuningClientAPI = (*sql.ServerAutomaticTuningClient)(nil)

// ServerDNSAliasesClientAPI contains the set of methods on the ServerDNSAliasesClient type.
type ServerDNSAliasesClientAPI interface {
	Acquire(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string, parameters sql.ServerDNSAliasAcquisition) (result sql.ServerDNSAliasesAcquireFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAlias, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultIterator, err error)
}

var _ ServerDNSAliasesClientAPI = (*sql.ServerDNSAliasesClient)(nil)

// ServerSecurityAlertPoliciesClientAPI contains the set of methods on the ServerSecurityAlertPoliciesClient type.
type ServerSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerSecurityAlertPolicy) (result sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerSecurityAlertPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultIterator, err error)
}

var _ ServerSecurityAlertPoliciesClientAPI = (*sql.ServerSecurityAlertPoliciesClient)(nil)

// RestorableDroppedManagedDatabasesClientAPI contains the set of methods on the RestorableDroppedManagedDatabasesClient type.
type RestorableDroppedManagedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.RestorableDroppedManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultIterator, err error)
}

var _ RestorableDroppedManagedDatabasesClientAPI = (*sql.RestorableDroppedManagedDatabasesClient)(nil)

// RestorePointsClientAPI contains the set of methods on the RestorePointsClient type.
type RestorePointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.CreateDatabaseRestorePointDefinition) (result sql.RestorePointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result sql.RestorePoint, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RestorePointListResult, err error)
}

var _ RestorePointsClientAPI = (*sql.RestorePointsClient)(nil)
