// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/api/sharedresource/v1alpha1"
	scheme "github.com/openshift/client-go/sharedresource/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SharedSecretsGetter has a method to return a SharedSecretInterface.
// A group's client should implement this interface.
type SharedSecretsGetter interface {
	SharedSecrets() SharedSecretInterface
}

// SharedSecretInterface has methods to work with SharedSecret resources.
type SharedSecretInterface interface {
	Create(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.CreateOptions) (*v1alpha1.SharedSecret, error)
	Update(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.UpdateOptions) (*v1alpha1.SharedSecret, error)
	UpdateStatus(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.UpdateOptions) (*v1alpha1.SharedSecret, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.SharedSecret, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.SharedSecretList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.SharedSecret, err error)
	SharedSecretExpansion
}

// sharedSecrets implements SharedSecretInterface
type sharedSecrets struct {
	client rest.Interface
}

// newSharedSecrets returns a SharedSecrets
func newSharedSecrets(c *SharedresourceV1alpha1Client) *sharedSecrets {
	return &sharedSecrets{
		client: c.RESTClient(),
	}
}

// Get takes name of the sharedSecret, and returns the corresponding sharedSecret object, and an error if there is any.
func (c *sharedSecrets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.SharedSecret, err error) {
	result = &v1alpha1.SharedSecret{}
	err = c.client.Get().
		Resource("sharedsecrets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SharedSecrets that match those selectors.
func (c *sharedSecrets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.SharedSecretList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.SharedSecretList{}
	err = c.client.Get().
		Resource("sharedsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sharedSecrets.
func (c *sharedSecrets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("sharedsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a sharedSecret and creates it.  Returns the server's representation of the sharedSecret, and an error, if there is any.
func (c *sharedSecrets) Create(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.CreateOptions) (result *v1alpha1.SharedSecret, err error) {
	result = &v1alpha1.SharedSecret{}
	err = c.client.Post().
		Resource("sharedsecrets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedSecret).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a sharedSecret and updates it. Returns the server's representation of the sharedSecret, and an error, if there is any.
func (c *sharedSecrets) Update(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.UpdateOptions) (result *v1alpha1.SharedSecret, err error) {
	result = &v1alpha1.SharedSecret{}
	err = c.client.Put().
		Resource("sharedsecrets").
		Name(sharedSecret.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedSecret).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *sharedSecrets) UpdateStatus(ctx context.Context, sharedSecret *v1alpha1.SharedSecret, opts v1.UpdateOptions) (result *v1alpha1.SharedSecret, err error) {
	result = &v1alpha1.SharedSecret{}
	err = c.client.Put().
		Resource("sharedsecrets").
		Name(sharedSecret.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedSecret).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the sharedSecret and deletes it. Returns an error if one occurs.
func (c *sharedSecrets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("sharedsecrets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sharedSecrets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("sharedsecrets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched sharedSecret.
func (c *sharedSecrets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.SharedSecret, err error) {
	result = &v1alpha1.SharedSecret{}
	err = c.client.Patch(pt).
		Resource("sharedsecrets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
