// Code generated by aws/endpoints/v3model_codegen.go. DO NOT EDIT.

package endpoints

import (
	"regexp"
)

// Partition identifiers
const (
	AwsPartitionID      = "aws"        // AWS Standard partition.
	AwsCnPartitionID    = "aws-cn"     // AWS China partition.
	AwsUsGovPartitionID = "aws-us-gov" // AWS GovCloud (US) partition.
	AwsIsoPartitionID   = "aws-iso"    // AWS ISO (US) partition.
	AwsIsoBPartitionID  = "aws-iso-b"  // AWS ISOB (US) partition.
)

// AWS Standard partition's regions.
const (
	AfSouth1RegionID     = "af-south-1"     // Africa (Cape Town).
	ApEast1RegionID      = "ap-east-1"      // Asia Pacific (Hong Kong).
	ApNortheast1RegionID = "ap-northeast-1" // Asia Pacific (Tokyo).
	ApNortheast2RegionID = "ap-northeast-2" // Asia Pacific (Seoul).
	ApNortheast3RegionID = "ap-northeast-3" // Asia Pacific (Osaka).
	ApSouth1RegionID     = "ap-south-1"     // Asia Pacific (Mumbai).
	ApSoutheast1RegionID = "ap-southeast-1" // Asia Pacific (Singapore).
	ApSoutheast2RegionID = "ap-southeast-2" // Asia Pacific (Sydney).
	CaCentral1RegionID   = "ca-central-1"   // Canada (Central).
	EuCentral1RegionID   = "eu-central-1"   // Europe (Frankfurt).
	EuNorth1RegionID     = "eu-north-1"     // Europe (Stockholm).
	EuSouth1RegionID     = "eu-south-1"     // Europe (Milan).
	EuWest1RegionID      = "eu-west-1"      // Europe (Ireland).
	EuWest2RegionID      = "eu-west-2"      // Europe (London).
	EuWest3RegionID      = "eu-west-3"      // Europe (Paris).
	MeSouth1RegionID     = "me-south-1"     // Middle East (Bahrain).
	SaEast1RegionID      = "sa-east-1"      // South America (Sao Paulo).
	UsEast1RegionID      = "us-east-1"      // US East (N. Virginia).
	UsEast2RegionID      = "us-east-2"      // US East (Ohio).
	UsWest1RegionID      = "us-west-1"      // US West (N. California).
	UsWest2RegionID      = "us-west-2"      // US West (Oregon).
)

// AWS China partition's regions.
const (
	CnNorth1RegionID     = "cn-north-1"     // China (Beijing).
	CnNorthwest1RegionID = "cn-northwest-1" // China (Ningxia).
)

// AWS GovCloud (US) partition's regions.
const (
	UsGovEast1RegionID = "us-gov-east-1" // AWS GovCloud (US-East).
	UsGovWest1RegionID = "us-gov-west-1" // AWS GovCloud (US-West).
)

// AWS ISO (US) partition's regions.
const (
	UsIsoEast1RegionID = "us-iso-east-1" // US ISO East.
)

// AWS ISOB (US) partition's regions.
const (
	UsIsobEast1RegionID = "us-isob-east-1" // US ISOB East (Ohio).
)

// DefaultResolver returns an Endpoint resolver that will be able
// to resolve endpoints for: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), and AWS ISOB (US).
//
// Use DefaultPartitions() to get the list of the default partitions.
func DefaultResolver() Resolver {
	return defaultPartitions
}

// DefaultPartitions returns a list of the partitions the SDK is bundled
// with. The available partitions are: AWS Standard, AWS China, AWS GovCloud (US), AWS ISO (US), and AWS ISOB (US).
//
//    partitions := endpoints.DefaultPartitions
//    for _, p := range partitions {
//        // ... inspect partitions
//    }
func DefaultPartitions() []Partition {
	return defaultPartitions.Partitions()
}

var defaultPartitions = partitions{
	awsPartition,
	awscnPartition,
	awsusgovPartition,
	awsisoPartition,
	awsisobPartition,
}

// AwsPartition returns the Resolver for AWS Standard.
func AwsPartition() Partition {
	return awsPartition.Partition()
}

var awsPartition = partition{
	ID:        "aws",
	Name:      "AWS Standard",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"af-south-1": region{
			Description: "Africa (Cape Town)",
		},
		"ap-east-1": region{
			Description: "Asia Pacific (Hong Kong)",
		},
		"ap-northeast-1": region{
			Description: "Asia Pacific (Tokyo)",
		},
		"ap-northeast-2": region{
			Description: "Asia Pacific (Seoul)",
		},
		"ap-northeast-3": region{
			Description: "Asia Pacific (Osaka)",
		},
		"ap-south-1": region{
			Description: "Asia Pacific (Mumbai)",
		},
		"ap-southeast-1": region{
			Description: "Asia Pacific (Singapore)",
		},
		"ap-southeast-2": region{
			Description: "Asia Pacific (Sydney)",
		},
		"ca-central-1": region{
			Description: "Canada (Central)",
		},
		"eu-central-1": region{
			Description: "Europe (Frankfurt)",
		},
		"eu-north-1": region{
			Description: "Europe (Stockholm)",
		},
		"eu-south-1": region{
			Description: "Europe (Milan)",
		},
		"eu-west-1": region{
			Description: "Europe (Ireland)",
		},
		"eu-west-2": region{
			Description: "Europe (London)",
		},
		"eu-west-3": region{
			Description: "Europe (Paris)",
		},
		"me-south-1": region{
			Description: "Middle East (Bahrain)",
		},
		"sa-east-1": region{
			Description: "South America (Sao Paulo)",
		},
		"us-east-1": region{
			Description: "US East (N. Virginia)",
		},
		"us-east-2": region{
			Description: "US East (Ohio)",
		},
		"us-west-1": region{
			Description: "US West (N. California)",
		},
		"us-west-2": region{
			Description: "US West (Oregon)",
		},
	},
	Services: services{
		"a4b": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"access-analyzer": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "access-analyzer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "access-analyzer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "access-analyzer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "access-analyzer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "access-analyzer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"acm": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"ca-central-1-fips": endpoint{
					Hostname: "acm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-south-1":   endpoint{},
				"eu-west-1":    endpoint{},
				"eu-west-2":    endpoint{},
				"eu-west-3":    endpoint{},
				"me-south-1":   endpoint{},
				"sa-east-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "acm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "acm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "acm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "acm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"acm-pca": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "acm-pca-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "acm-pca-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "acm-pca-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "acm-pca-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "acm-pca-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"airflow": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"amplifybackend": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"api.detective": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "api.detective-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "api.detective-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "api.detective-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "api.detective-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.ecr": service{

			Endpoints: endpoints{
				"af-south-1": endpoint{
					Hostname: "api.ecr.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				"ap-east-1": endpoint{
					Hostname: "api.ecr.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"ap-northeast-1": endpoint{
					Hostname: "api.ecr.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "api.ecr.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-northeast-3": endpoint{
					Hostname: "api.ecr.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"ap-south-1": endpoint{
					Hostname: "api.ecr.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "api.ecr.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "api.ecr.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "api.ecr.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "api.ecr.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-north-1": endpoint{
					Hostname: "api.ecr.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"eu-south-1": endpoint{
					Hostname: "api.ecr.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "api.ecr.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "api.ecr.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname: "api.ecr.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-dkr-us-east-1": endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-dkr-us-east-2": endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-dkr-us-west-1": endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-dkr-us-west-2": endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ecr-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ecr-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ecr-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ecr-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{
					Hostname: "api.ecr.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"sa-east-1": endpoint{
					Hostname: "api.ecr.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"us-east-1": endpoint{
					Hostname: "api.ecr.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "api.ecr.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{
					Hostname: "api.ecr.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{
					Hostname: "api.ecr.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"api.elastic-inference": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname: "api.elastic-inference.ap-northeast-1.amazonaws.com",
				},
				"ap-northeast-2": endpoint{
					Hostname: "api.elastic-inference.ap-northeast-2.amazonaws.com",
				},
				"eu-west-1": endpoint{
					Hostname: "api.elastic-inference.eu-west-1.amazonaws.com",
				},
				"us-east-1": endpoint{
					Hostname: "api.elastic-inference.us-east-1.amazonaws.com",
				},
				"us-east-2": endpoint{
					Hostname: "api.elastic-inference.us-east-2.amazonaws.com",
				},
				"us-west-2": endpoint{
					Hostname: "api.elastic-inference.us-west-2.amazonaws.com",
				},
			},
		},
		"api.fleethub.iot": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "api.fleethub.iot-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "api.fleethub.iot-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "api.fleethub.iot-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"api.mediatailor": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"api.pricing": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "pricing",
				},
			},
			Endpoints: endpoints{
				"ap-south-1": endpoint{},
				"us-east-1":  endpoint{},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "api-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "api-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "api-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "api-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"app-integrations": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"appflow": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"appmesh": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"apprunner": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"appstream2": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
				CredentialScope: credentialScope{
					Service: "appstream",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips": endpoint{
					Hostname: "appstream2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"appsync": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"athena": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "athena-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "athena-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "athena-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "athena-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"backup": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"batch": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "fips.batch.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "fips.batch.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "fips.batch.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "fips.batch.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "budgets.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "ce.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"chime": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "chime.us-east-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloud9": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"clouddirectory": service{

			Endpoints: endpoints{
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "cloudformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "cloudformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "cloudformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "cloudformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "cloudfront.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloudhsm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "cloudhsm",
				},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudsearch": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "cloudtrail-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "cloudtrail-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "cloudtrail-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "cloudtrail-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"codeartifact": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"codebuild": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"codecommit": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"codeguru-reviewer": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"codepipeline": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "codepipeline-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "codepipeline-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "codepipeline-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "codepipeline-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "codepipeline-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"codestar": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"codestar-connections": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cognito-identity": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "cognito-identity-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "cognito-identity-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "cognito-identity-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"cognito-idp": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "cognito-idp-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "cognito-idp-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "cognito-idp-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "cognito-idp-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"cognito-sync": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "comprehend-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "comprehend-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "comprehend-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"comprehendmedical": service{

			Endpoints: endpoints{
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "comprehendmedical-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "comprehendmedical-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "comprehendmedical-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "config-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "config-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "config-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "config-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"connect": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"contact-lens": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cur": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"data.mediastore": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"dataexchange": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"datapipeline": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"datasync": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "datasync-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "datasync-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "datasync-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "datasync-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "datasync-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"dax": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"devicefarm": service{

			Endpoints: endpoints{
				"us-west-2": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "directconnect-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "directconnect-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "directconnect-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "directconnect-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"discovery": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"dms-fips": endpoint{
					Hostname: "dms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-south-1":   endpoint{},
				"eu-west-1":    endpoint{},
				"eu-west-2":    endpoint{},
				"eu-west-3":    endpoint{},
				"me-south-1":   endpoint{},
				"sa-east-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-east-2":    endpoint{},
				"us-west-1":    endpoint{},
				"us-west-2":    endpoint{},
			},
		},
		"docdb": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-south-1": endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"sa-east-1": endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"us-east-1": endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "ds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"ca-central-1-fips": endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-south-1":   endpoint{},
				"eu-west-1":    endpoint{},
				"eu-west-2":    endpoint{},
				"eu-west-3":    endpoint{},
				"local": endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"ebs": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "ebs-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ebs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ebs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ebs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ebs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "ec2-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ec2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ec2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ec2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ec2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "ecs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ecs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ecs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ecs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"eks": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "fips.eks.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "fips.eks.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "fips.eks.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "fips.eks.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "elasticbeanstalk-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "elasticbeanstalk-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"elasticfilesystem": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-af-south-1": endpoint{
					Hostname: "elasticfilesystem-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				"fips-ap-east-1": endpoint{
					Hostname: "elasticfilesystem-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"fips-ap-northeast-1": endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"fips-ap-northeast-2": endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"fips-ap-northeast-3": endpoint{
					Hostname: "elasticfilesystem-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"fips-ap-south-1": endpoint{
					Hostname: "elasticfilesystem-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"fips-ap-southeast-1": endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"fips-ap-southeast-2": endpoint{
					Hostname: "elasticfilesystem-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"fips-ca-central-1": endpoint{
					Hostname: "elasticfilesystem-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-eu-central-1": endpoint{
					Hostname: "elasticfilesystem-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"fips-eu-north-1": endpoint{
					Hostname: "elasticfilesystem-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"fips-eu-south-1": endpoint{
					Hostname: "elasticfilesystem-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				"fips-eu-west-1": endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"fips-eu-west-2": endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"fips-eu-west-3": endpoint{
					Hostname: "elasticfilesystem-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-me-south-1": endpoint{
					Hostname: "elasticfilesystem-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"fips-sa-east-1": endpoint{
					Hostname: "elasticfilesystem-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "elasticfilesystem-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "elasticfilesystem-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "elasticfilesystem-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "elasticfilesystem-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "elasticloadbalancing-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "elasticloadbalancing-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.{service}.{dnsSuffix}",
				Protocols:     []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1": endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				"eu-north-1": endpoint{},
				"eu-south-1": endpoint{},
				"eu-west-1":  endpoint{},
				"eu-west-2":  endpoint{},
				"eu-west-3":  endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "elasticmapreduce-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "elasticmapreduce-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "elasticmapreduce-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "elasticmapreduce-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "elasticmapreduce-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"elastictranscoder": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"email": service{

			Endpoints: endpoints{
				"ap-south-1":     endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"emr-containers": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"entitlement.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "es-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "events-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "events-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "events-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "events-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"finspace": service{

			Endpoints: endpoints{
				"ca-central-1": endpoint{},
				"eu-west-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-east-2":    endpoint{},
				"us-west-2":    endpoint{},
			},
		},
		"finspace-api": service{

			Endpoints: endpoints{
				"ca-central-1": endpoint{},
				"eu-west-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-east-2":    endpoint{},
				"us-west-2":    endpoint{},
			},
		},
		"firehose": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "firehose-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "firehose-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "firehose-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "firehose-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"fms": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-af-south-1": endpoint{
					Hostname: "fms-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				"fips-ap-east-1": endpoint{
					Hostname: "fms-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"fips-ap-northeast-1": endpoint{
					Hostname: "fms-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"fips-ap-northeast-2": endpoint{
					Hostname: "fms-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"fips-ap-south-1": endpoint{
					Hostname: "fms-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"fips-ap-southeast-1": endpoint{
					Hostname: "fms-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"fips-ap-southeast-2": endpoint{
					Hostname: "fms-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"fips-ca-central-1": endpoint{
					Hostname: "fms-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-eu-central-1": endpoint{
					Hostname: "fms-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"fips-eu-south-1": endpoint{
					Hostname: "fms-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				"fips-eu-west-1": endpoint{
					Hostname: "fms-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"fips-eu-west-2": endpoint{
					Hostname: "fms-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"fips-eu-west-3": endpoint{
					Hostname: "fms-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-me-south-1": endpoint{
					Hostname: "fms-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"fips-sa-east-1": endpoint{
					Hostname: "fms-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "fms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "fms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "fms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "fms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"forecast": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "forecast-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "forecast-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "forecast-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"forecastquery": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "forecastquery-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "forecastquery-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "forecastquery-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"fsx": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-prod-ca-central-1": endpoint{
					Hostname: "fsx-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-prod-us-east-1": endpoint{
					Hostname: "fsx-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-prod-us-east-2": endpoint{
					Hostname: "fsx-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-prod-us-west-1": endpoint{
					Hostname: "fsx-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-prod-us-west-2": endpoint{
					Hostname: "fsx-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"gamelift": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "glacier-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "glacier-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "glacier-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "glacier-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "glacier-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"glue": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "glue-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "glue-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "glue-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "glue-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"groundstation": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "groundstation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "groundstation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "groundstation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "guardduty-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "guardduty-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "guardduty-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "guardduty-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"fips-us-east-2": endpoint{
					Hostname: "health-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
			},
		},
		"healthlake": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"honeycode": service{

			Endpoints: endpoints{
				"us-west-2": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "iam.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"iam-fips": endpoint{
					Hostname: "iam-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"identitystore": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"importexport": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:          "importexport.amazonaws.com",
					SignatureVersions: []string{"v2", "v4"},
					CredentialScope: credentialScope{
						Region:  "us-east-1",
						Service: "IngestionService",
					},
				},
			},
		},
		"inspector": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "inspector-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "inspector-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "inspector-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "inspector-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iotanalytics": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iotevents": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"ioteventsdata": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname: "data.iotevents.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "data.iotevents.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "data.iotevents.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "data.iotevents.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "data.iotevents.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "data.iotevents.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "data.iotevents.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"us-east-1": endpoint{
					Hostname: "data.iotevents.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "data.iotevents.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{
					Hostname: "data.iotevents.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"iotsecuredtunneling": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iotthingsgraph": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "iotthingsgraph",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iotwireless": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname: "api.iotwireless.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "api.iotwireless.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "api.iotwireless.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"us-east-1": endpoint{
					Hostname: "api.iotwireless.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-west-2": endpoint{
					Hostname: "api.iotwireless.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"kafka": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "kinesis-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "kinesis-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "kinesis-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "kinesis-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"kinesisanalytics": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kinesisvideo": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"lakeformation": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "lakeformation-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "lakeformation-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "lakeformation-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "lakeformation-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "lambda-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "lambda-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "lambda-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "lambda-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"license-manager": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "license-manager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "license-manager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "license-manager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "license-manager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"lightsail": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "logs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "logs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "logs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "logs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"lookoutequipment": service{

			Endpoints: endpoints{
				"ap-northeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
			},
		},
		"lookoutvision": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"machinelearning": service{

			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
			},
		},
		"macie": service{

			Endpoints: endpoints{
				"fips-us-east-1": endpoint{
					Hostname: "macie-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "macie-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"macie2": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "macie2-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "macie2-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "macie2-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "macie2-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"managedblockchain": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
			},
		},
		"marketplacecommerceanalytics": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"mediaconnect": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mediaconvert": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "mediaconvert-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "mediaconvert-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "mediaconvert-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "mediaconvert-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "mediaconvert-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"medialive": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "medialive-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "medialive-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "medialive-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"mediapackage": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mediastore": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"metering.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mgh": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mobileanalytics": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "models-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "models-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"monitoring": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "monitoring-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "monitoring-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "monitoring-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "monitoring-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"mq": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "mq-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "mq-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "mq-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "mq-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"mturk-requester": service{
			IsRegionalized: boxedFalse,

			Endpoints: endpoints{
				"sandbox": endpoint{
					Hostname: "mturk-requester-sandbox.us-east-1.amazonaws.com",
				},
				"us-east-1": endpoint{},
			},
		},
		"neptune": service{

			Endpoints: endpoints{
				"ap-east-1": endpoint{
					Hostname: "rds.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"ap-northeast-1": endpoint{
					Hostname: "rds.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "rds.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-south-1": endpoint{
					Hostname: "rds.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "rds.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "rds.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "rds.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-north-1": endpoint{
					Hostname: "rds.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname: "rds.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"me-south-1": endpoint{
					Hostname: "rds.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"sa-east-1": endpoint{
					Hostname: "rds.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"us-east-1": endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{
					Hostname: "rds.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"oidc": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname: "oidc.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "oidc.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-south-1": endpoint{
					Hostname: "oidc.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "oidc.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "oidc.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "oidc.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "oidc.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-north-1": endpoint{
					Hostname: "oidc.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "oidc.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "oidc.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname: "oidc.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"us-east-1": endpoint{
					Hostname: "oidc.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "oidc.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{
					Hostname: "oidc.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"opsworks": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"opsworks-cm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "organizations.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-aws-global": endpoint{
					Hostname: "organizations-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"outposts": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "outposts-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "outposts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "outposts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "outposts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "outposts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"personalize": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"pinpoint": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "mobiletargeting",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "pinpoint-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "pinpoint-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{
					Hostname: "pinpoint.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-west-2": endpoint{
					Hostname: "pinpoint.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"polly": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "polly-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "polly-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "polly-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "polly-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"portal.sso": service{

			Endpoints: endpoints{
				"ap-southeast-1": endpoint{
					Hostname: "portal.sso.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "portal.sso.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "portal.sso.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "portal.sso.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "portal.sso.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "portal.sso.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"us-east-1": endpoint{
					Hostname: "portal.sso.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "portal.sso.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{
					Hostname: "portal.sso.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"profile": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"projects.iot1click": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"qldb": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"ram": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "ram-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ram-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ram-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ram-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ram-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"rds-fips.ca-central-1": endpoint{
					Hostname: "rds-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"rds-fips.us-east-1": endpoint{
					Hostname: "rds-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"rds-fips.us-east-2": endpoint{
					Hostname: "rds-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"rds-fips.us-west-1": endpoint{
					Hostname: "rds-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"rds-fips.us-west-2": endpoint{
					Hostname: "rds-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "redshift-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "redshift-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "redshift-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "redshift-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "redshift-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"rekognition": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"rekognition-fips.ca-central-1": endpoint{
					Hostname: "rekognition-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"rekognition-fips.us-east-1": endpoint{
					Hostname: "rekognition-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"rekognition-fips.us-east-2": endpoint{
					Hostname: "rekognition-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"rekognition-fips.us-west-1": endpoint{
					Hostname: "rekognition-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"rekognition-fips.us-west-2": endpoint{
					Hostname: "rekognition-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"resource-groups": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "resource-groups-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "resource-groups-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "resource-groups-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "resource-groups-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"robomaker": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "route53.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-aws-global": endpoint{
					Hostname: "route53-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"route53domains": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"route53resolver": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "runtime-fips.lex.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "runtime-fips.lex.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "runtime-fips.sagemaker.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "runtime-fips.sagemaker.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"s3": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedTrue,
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"accesspoint-af-south-1": endpoint{
					Hostname:          "s3-accesspoint.af-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-east-1": endpoint{
					Hostname:          "s3-accesspoint.ap-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-northeast-1": endpoint{
					Hostname:          "s3-accesspoint.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-northeast-2": endpoint{
					Hostname:          "s3-accesspoint.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-northeast-3": endpoint{
					Hostname:          "s3-accesspoint.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-south-1": endpoint{
					Hostname:          "s3-accesspoint.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-southeast-1": endpoint{
					Hostname:          "s3-accesspoint.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ap-southeast-2": endpoint{
					Hostname:          "s3-accesspoint.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-ca-central-1": endpoint{
					Hostname:          "s3-accesspoint.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-central-1": endpoint{
					Hostname:          "s3-accesspoint.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-north-1": endpoint{
					Hostname:          "s3-accesspoint.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-south-1": endpoint{
					Hostname:          "s3-accesspoint.eu-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-west-1": endpoint{
					Hostname:          "s3-accesspoint.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-west-2": endpoint{
					Hostname:          "s3-accesspoint.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-eu-west-3": endpoint{
					Hostname:          "s3-accesspoint.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-me-south-1": endpoint{
					Hostname:          "s3-accesspoint.me-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-sa-east-1": endpoint{
					Hostname:          "s3-accesspoint.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-us-east-1": endpoint{
					Hostname:          "s3-accesspoint.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-us-east-2": endpoint{
					Hostname:          "s3-accesspoint.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-us-west-1": endpoint{
					Hostname:          "s3-accesspoint.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-us-west-2": endpoint{
					Hostname:          "s3-accesspoint.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"af-south-1": endpoint{},
				"ap-east-1":  endpoint{},
				"ap-northeast-1": endpoint{
					Hostname:          "s3.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{
					Hostname:          "s3.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"ap-southeast-2": endpoint{
					Hostname:          "s3.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"aws-global": endpoint{
					Hostname:          "s3.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"ca-central-1": endpoint{},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-south-1":   endpoint{},
				"eu-west-1": endpoint{
					Hostname:          "s3.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"eu-west-2": endpoint{},
				"eu-west-3": endpoint{},
				"fips-accesspoint-ca-central-1": endpoint{
					Hostname:          "s3-accesspoint-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-east-1": endpoint{
					Hostname:          "s3-accesspoint-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-east-2": endpoint{
					Hostname:          "s3-accesspoint-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-west-1": endpoint{
					Hostname:          "s3-accesspoint-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-west-2": endpoint{
					Hostname:          "s3-accesspoint-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"me-south-1": endpoint{},
				"s3-external-1": endpoint{
					Hostname:          "s3-external-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"sa-east-1": endpoint{
					Hostname:          "s3.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-east-1": endpoint{
					Hostname:          "s3.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{
					Hostname:          "s3.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-west-2": endpoint{
					Hostname:          "s3.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpoint{
				Protocols:         []string{"https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname:          "s3-control.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname:          "s3-control.ap-northeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-northeast-3": endpoint{
					Hostname:          "s3-control.ap-northeast-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"ap-south-1": endpoint{
					Hostname:          "s3-control.ap-south-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname:          "s3-control.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname:          "s3-control.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname:          "s3-control.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"ca-central-1-fips": endpoint{
					Hostname:          "s3-control-fips.ca-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname:          "s3-control.eu-central-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-north-1": endpoint{
					Hostname:          "s3-control.eu-north-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname:          "s3-control.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname:          "s3-control.eu-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname:          "s3-control.eu-west-3.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"sa-east-1": endpoint{
					Hostname:          "s3-control.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"us-east-1": endpoint{
					Hostname:          "s3-control.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-1-fips": endpoint{
					Hostname:          "s3-control-fips.us-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname:          "s3-control.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-east-2-fips": endpoint{
					Hostname:          "s3-control-fips.us-east-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{
					Hostname:          "s3-control.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-1-fips": endpoint{
					Hostname:          "s3-control-fips.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{
					Hostname:          "s3-control.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-west-2-fips": endpoint{
					Hostname:          "s3-control-fips.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"savingsplans": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "savingsplans.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"schemas": service{

			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"sdb": service{
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"v2"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1": endpoint{
					Hostname: "sdb.amazonaws.com",
				},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"secretsmanager": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "secretsmanager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "secretsmanager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"securityhub": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "securityhub-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "securityhub-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "securityhub-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "securityhub-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"serverlessrepo": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-east-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-northeast-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-northeast-2": endpoint{
					Protocols: []string{"https"},
				},
				"ap-south-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-southeast-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-southeast-2": endpoint{
					Protocols: []string{"https"},
				},
				"ca-central-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-central-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-north-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-west-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-west-2": endpoint{
					Protocols: []string{"https"},
				},
				"eu-west-3": endpoint{
					Protocols: []string{"https"},
				},
				"me-south-1": endpoint{
					Protocols: []string{"https"},
				},
				"sa-east-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-east-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-east-2": endpoint{
					Protocols: []string{"https"},
				},
				"us-west-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-west-2": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"servicecatalog-appregistry": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "servicecatalog-appregistry-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "servicecatalog-appregistry-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"servicediscovery": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"servicediscovery-fips": endpoint{
					Hostname: "servicediscovery-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"servicequotas": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"session.qldb": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "session.qldb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "session.qldb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "session.qldb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"shield": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpoint{
				SSLCommonName: "shield.us-east-1.amazonaws.com",
				Protocols:     []string{"https"},
			},
			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "shield.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-aws-global": endpoint{
					Hostname: "shield-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "sms-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "sms-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "sms-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "sms-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ap-northeast-1": endpoint{
					Hostname: "snowball-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"fips-ap-northeast-2": endpoint{
					Hostname: "snowball-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"fips-ap-northeast-3": endpoint{
					Hostname: "snowball-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"fips-ap-south-1": endpoint{
					Hostname: "snowball-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"fips-ap-southeast-1": endpoint{
					Hostname: "snowball-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"fips-ap-southeast-2": endpoint{
					Hostname: "snowball-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"fips-ca-central-1": endpoint{
					Hostname: "snowball-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-eu-central-1": endpoint{
					Hostname: "snowball-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"fips-eu-west-1": endpoint{
					Hostname: "snowball-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"fips-eu-west-2": endpoint{
					Hostname: "snowball-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"fips-eu-west-3": endpoint{
					Hostname: "snowball-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-sa-east-1": endpoint{
					Hostname: "snowball-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "snowball-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "snowball-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "snowball-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "snowball-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"sns": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "sns-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "sns-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "sns-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "sns-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.queue.{dnsSuffix}",
				Protocols:     []string{"http", "https"},
			},
			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "sqs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "queue.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "ssm-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "ssm-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "ssm-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "ssm-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "ssm-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "states-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "states-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "states-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "states-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "storagegateway-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"ca-central-1-fips": endpoint{
					Hostname: "dynamodb-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-west-1":    endpoint{},
				"eu-west-2":    endpoint{},
				"eu-west-3":    endpoint{},
				"local": endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "dynamodb-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "dynamodb-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "dynamodb-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "dynamodb-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"sts": service{
			PartitionEndpoint: "aws-global",

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"aws-global": endpoint{
					Hostname: "sts.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"ca-central-1": endpoint{},
				"eu-central-1": endpoint{},
				"eu-north-1":   endpoint{},
				"eu-south-1":   endpoint{},
				"eu-west-1":    endpoint{},
				"eu-west-2":    endpoint{},
				"eu-west-3":    endpoint{},
				"me-south-1":   endpoint{},
				"sa-east-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-global",

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "support.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "swf-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "swf-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "swf-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "swf-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"me-south-1":     endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "fips.transcribe.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "fips.transcribe.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "fips.transcribe.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "fips.transcribe.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"transcribestreaming": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"transfer": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-ca-central-1": endpoint{
					Hostname: "transfer-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "transfer-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "transfer-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "transfer-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "transfer-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
		"translate": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"waf": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-fips": endpoint{
					Hostname: "waf-fips.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"aws-global": endpoint{
					Hostname: "waf.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"waf-regional": service{

			Endpoints: endpoints{
				"af-south-1": endpoint{
					Hostname: "waf-regional.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				"ap-east-1": endpoint{
					Hostname: "waf-regional.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"ap-northeast-1": endpoint{
					Hostname: "waf-regional.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"ap-northeast-2": endpoint{
					Hostname: "waf-regional.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-northeast-3": endpoint{
					Hostname: "waf-regional.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"ap-south-1": endpoint{
					Hostname: "waf-regional.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"ap-southeast-1": endpoint{
					Hostname: "waf-regional.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"ap-southeast-2": endpoint{
					Hostname: "waf-regional.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"ca-central-1": endpoint{
					Hostname: "waf-regional.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"eu-central-1": endpoint{
					Hostname: "waf-regional.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-north-1": endpoint{
					Hostname: "waf-regional.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"eu-south-1": endpoint{
					Hostname: "waf-regional.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "waf-regional.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "waf-regional.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"eu-west-3": endpoint{
					Hostname: "waf-regional.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-af-south-1": endpoint{
					Hostname: "waf-regional-fips.af-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "af-south-1",
					},
				},
				"fips-ap-east-1": endpoint{
					Hostname: "waf-regional-fips.ap-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-east-1",
					},
				},
				"fips-ap-northeast-1": endpoint{
					Hostname: "waf-regional-fips.ap-northeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-1",
					},
				},
				"fips-ap-northeast-2": endpoint{
					Hostname: "waf-regional-fips.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"fips-ap-northeast-3": endpoint{
					Hostname: "waf-regional-fips.ap-northeast-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-3",
					},
				},
				"fips-ap-south-1": endpoint{
					Hostname: "waf-regional-fips.ap-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-south-1",
					},
				},
				"fips-ap-southeast-1": endpoint{
					Hostname: "waf-regional-fips.ap-southeast-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-1",
					},
				},
				"fips-ap-southeast-2": endpoint{
					Hostname: "waf-regional-fips.ap-southeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-southeast-2",
					},
				},
				"fips-ca-central-1": endpoint{
					Hostname: "waf-regional-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"fips-eu-central-1": endpoint{
					Hostname: "waf-regional-fips.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"fips-eu-north-1": endpoint{
					Hostname: "waf-regional-fips.eu-north-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-north-1",
					},
				},
				"fips-eu-south-1": endpoint{
					Hostname: "waf-regional-fips.eu-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-south-1",
					},
				},
				"fips-eu-west-1": endpoint{
					Hostname: "waf-regional-fips.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"fips-eu-west-2": endpoint{
					Hostname: "waf-regional-fips.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"fips-eu-west-3": endpoint{
					Hostname: "waf-regional-fips.eu-west-3.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-3",
					},
				},
				"fips-me-south-1": endpoint{
					Hostname: "waf-regional-fips.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"fips-sa-east-1": endpoint{
					Hostname: "waf-regional-fips.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"fips-us-east-1": endpoint{
					Hostname: "waf-regional-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "waf-regional-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "waf-regional-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "waf-regional-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{
					Hostname: "waf-regional.me-south-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "me-south-1",
					},
				},
				"sa-east-1": endpoint{
					Hostname: "waf-regional.sa-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "sa-east-1",
					},
				},
				"us-east-1": endpoint{
					Hostname: "waf-regional.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "waf-regional.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{
					Hostname: "waf-regional.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{
					Hostname: "waf-regional.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"workdocs": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "workdocs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "workdocs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"workmail": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"workspaces": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "workspaces-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "workspaces-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"xray": service{

			Endpoints: endpoints{
				"af-south-1":     endpoint{},
				"ap-east-1":      endpoint{},
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-northeast-3": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-north-1":     endpoint{},
				"eu-south-1":     endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "xray-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "xray-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "xray-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "xray-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"me-south-1": endpoint{},
				"sa-east-1":  endpoint{},
				"us-east-1":  endpoint{},
				"us-east-2":  endpoint{},
				"us-west-1":  endpoint{},
				"us-west-2":  endpoint{},
			},
		},
	},
}

// AwsCnPartition returns the Resolver for AWS China.
func AwsCnPartition() Partition {
	return awscnPartition.Partition()
}

var awscnPartition = partition{
	ID:        "aws-cn",
	Name:      "AWS China",
	DNSSuffix: "amazonaws.com.cn",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^cn\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"cn-north-1": region{
			Description: "China (Beijing)",
		},
		"cn-northwest-1": region{
			Description: "China (Ningxia)",
		},
	},
	Services: services{
		"access-analyzer": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"acm": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"api.ecr": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Hostname: "api.ecr.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"cn-northwest-1": endpoint{
					Hostname: "api.ecr.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"appsync": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"athena": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"backup": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"batch": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "budgets.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "ce.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname:  "cloudfront.cn-northwest-1.amazonaws.com.cn",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"codebuild": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"codecommit": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cognito-identity": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cur": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{},
			},
		},
		"dax": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"docdb": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ebs": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"eks": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticfilesystem": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
				"fips-cn-north-1": endpoint{
					Hostname: "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"fips-cn-northwest-1": endpoint{
					Hostname: "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"firehose": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"fsx": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"gamelift": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"glue": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "iam.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"iotanalytics": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"iotevents": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"ioteventsdata": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Hostname: "data.iotevents.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iotsecuredtunneling": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"kafka": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"kinesisanalytics": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"lakeformation": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"license-manager": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"mediaconvert": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{
					Hostname: "subscribe.mediaconvert.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"monitoring": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"mq": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"neptune": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{
					Hostname: "rds.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "organizations.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"personalize": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"polly": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{},
			},
		},
		"ram": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"resource-groups": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "route53.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"route53resolver": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"s3": service{
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"accesspoint-cn-north-1": endpoint{
					Hostname:          "s3-accesspoint.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-cn-northwest-1": endpoint{
					Hostname:          "s3-accesspoint.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
				},
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"s3-control": service{
			Defaults: endpoint{
				Protocols:         []string{"https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Hostname:          "s3-control.cn-north-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"cn-northwest-1": endpoint{
					Hostname:          "s3-control.cn-northwest-1.amazonaws.com.cn",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"secretsmanager": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"securityhub": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"serverlessrepo": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Protocols: []string{"https"},
				},
				"cn-northwest-1": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"servicediscovery": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
				"fips-cn-north-1": endpoint{
					Hostname: "snowball-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"fips-cn-northwest-1": endpoint{
					Hostname: "snowball-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"sns": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.queue.{dnsSuffix}",
				Protocols:     []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-cn-global",

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "support.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Hostname: "cn.transcribe.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"cn-northwest-1": endpoint{
					Hostname: "cn.transcribe.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"transcribestreaming": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"transfer": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"waf-regional": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{
					Hostname: "waf-regional.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"cn-northwest-1": endpoint{
					Hostname: "waf-regional.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
				"fips-cn-north-1": endpoint{
					Hostname: "waf-regional-fips.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
				"fips-cn-northwest-1": endpoint{
					Hostname: "waf-regional-fips.cn-northwest-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-northwest-1",
					},
				},
			},
		},
		"workspaces": service{

			Endpoints: endpoints{
				"cn-northwest-1": endpoint{},
			},
		},
		"xray": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
	},
}

// AwsUsGovPartition returns the Resolver for AWS GovCloud (US).
func AwsUsGovPartition() Partition {
	return awsusgovPartition.Partition()
}

var awsusgovPartition = partition{
	ID:        "aws-us-gov",
	Name:      "AWS GovCloud (US)",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-gov\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"us-gov-east-1": region{
			Description: "AWS GovCloud (US-East)",
		},
		"us-gov-west-1": region{
			Description: "AWS GovCloud (US-West)",
		},
	},
	Services: services{
		"access-analyzer": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "access-analyzer.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "access-analyzer.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"acm": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "acm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "acm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"acm-pca": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "acm-pca.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "acm-pca.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"api.detective": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "api.detective-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "api.detective-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"api.ecr": service{

			Endpoints: endpoints{
				"fips-dkr-us-gov-east-1": endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-dkr-us-gov-west-1": endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"fips-us-gov-east-1": endpoint{
					Hostname: "ecr-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "ecr-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{
					Hostname: "api.ecr.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "api.ecr.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "api-fips.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1-fips-secondary": endpoint{
					Hostname: "api.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Hostname:  "autoscaling.{region}.amazonaws.com",
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "application-autoscaling",
				},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"appstream2": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
				CredentialScope: credentialScope{
					Service: "appstream",
				},
			},
			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "appstream2-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"athena": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "athena-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "athena-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"autoscaling": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"backup": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"batch": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "batch.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "batch.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"clouddirectory": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "cloudformation.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "cloudformation.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"cloudhsm": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "cloudhsm",
				},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "cloudtrail.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "cloudtrail.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"codebuild": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "codebuild-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "codebuild-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"codecommit": service{

			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "codecommit-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"codepipeline": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "codepipeline-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"cognito-identity": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "cognito-identity-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"cognito-idp": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "cognito-idp-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "comprehend-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"comprehendmedical": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "comprehendmedical-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "config.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "config.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"connect": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"datasync": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "datasync-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "datasync-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "directconnect.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "directconnect.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"dms-fips": endpoint{
					Hostname: "dms.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"docdb": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "ds-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "ds-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"dynamodb": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ebs": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"ec2": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "ec2.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "ec2.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "ecs-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "ecs-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"eks": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "eks.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "eks.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "elasticache.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "elasticbeanstalk.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "elasticbeanstalk.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"elasticfilesystem": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "elasticfilesystem-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticloadbalancing": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "elasticloadbalancing.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "elasticloadbalancing.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"elasticmapreduce": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "elasticmapreduce.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "elasticmapreduce.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"email": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "email-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "es-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "events.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "events.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"firehose": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "firehose-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "firehose-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"fms": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "fms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "fms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"fsx": service{

			Endpoints: endpoints{
				"fips-prod-us-gov-east-1": endpoint{
					Hostname: "fsx-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-prod-us-gov-west-1": endpoint{
					Hostname: "fsx-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"glacier": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "glacier.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:  "glacier.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"glue": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "glue-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "glue-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"dataplane-us-gov-east-1": endpoint{
					Hostname: "greengrass-ats.iot.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"dataplane-us-gov-west-1": endpoint{
					Hostname: "greengrass-ats.iot.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"fips-us-gov-east-1": endpoint{
					Hostname: "greengrass-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-east-1": endpoint{
					Hostname: "greengrass.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "greengrass.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "guardduty.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "guardduty.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "health-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-us-gov-global": endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"iam-govcloud-fips": endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"inspector": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "inspector-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "inspector-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"iotsecuredtunneling": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"kafka": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "kinesis.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "kinesis.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"kinesisanalytics": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"ProdFips": endpoint{
					Hostname: "kms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"lakeformation": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "lakeformation-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "lambda-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "lambda-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"license-manager": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "license-manager-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "license-manager-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "logs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "logs.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"mediaconvert": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Hostname: "mediaconvert.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"metering.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "models-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"monitoring": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "monitoring.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "monitoring.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"mq": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "mq-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "mq-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"neptune": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-us-gov-global": endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"fips-aws-us-gov-global": endpoint{
					Hostname: "organizations.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"outposts": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "outposts.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "outposts.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"pinpoint": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "mobiletargeting",
				},
			},
			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "pinpoint-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "pinpoint.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"polly": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "polly-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"ram": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "ram.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "ram.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"rds.us-gov-east-1": endpoint{
					Hostname: "rds.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"rds.us-gov-west-1": endpoint{
					Hostname: "rds.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "redshift.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "redshift.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"rekognition": service{

			Endpoints: endpoints{
				"rekognition-fips.us-gov-west-1": endpoint{
					Hostname: "rekognition-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"resource-groups": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "resource-groups.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "resource-groups.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-us-gov-global": endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"fips-aws-us-gov-global": endpoint{
					Hostname: "route53.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"route53resolver": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "runtime-fips.lex.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "runtime.sagemaker.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"s3": service{
			Defaults: endpoint{
				SignatureVersions: []string{"s3", "s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"accesspoint-us-gov-east-1": endpoint{
					Hostname:          "s3-accesspoint.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"accesspoint-us-gov-west-1": endpoint{
					Hostname:          "s3-accesspoint.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-gov-east-1": endpoint{
					Hostname:          "s3-accesspoint-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-accesspoint-us-gov-west-1": endpoint{
					Hostname:          "s3-accesspoint-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "s3-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{
					Hostname:  "s3.us-gov-east-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
				"us-gov-west-1": endpoint{
					Hostname:  "s3.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"s3-control": service{
			Defaults: endpoint{
				Protocols:         []string{"https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname:          "s3-control.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-east-1-fips": endpoint{
					Hostname:          "s3-control-fips.us-gov-east-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:          "s3-control.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1-fips": endpoint{
					Hostname:          "s3-control-fips.us-gov-west-1.amazonaws.com",
					SignatureVersions: []string{"s3v4"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"secretsmanager": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"securityhub": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "securityhub-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "securityhub-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"serverlessrepo": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname:  "serverlessrepo.us-gov-east-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:  "serverlessrepo.us-gov-west-1.amazonaws.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"servicecatalog": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"servicecatalog-appregistry": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "servicecatalog-appregistry.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"servicequotas": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "servicequotas.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "servicequotas.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "sms-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "sms-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "snowball-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "snowball-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"sns": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "sns.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:  "sns.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"sqs": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "sqs.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:      "sqs.us-gov-west-1.amazonaws.com",
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "ssm.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "ssm.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "states-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "states.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "storagegateway-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-east-1-fips": endpoint{
					Hostname: "sts.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "sts.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-us-gov-global",

			Endpoints: endpoints{
				"aws-us-gov-global": endpoint{
					Hostname: "support.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "support.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{
					Hostname: "swf.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "swf.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "fips.transcribe.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "fips.transcribe.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"transfer": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "transfer-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "transfer-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
		"translate": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "translate-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"waf-regional": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "waf-regional-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "waf-regional-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{
					Hostname: "waf-regional.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname: "waf-regional.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"workspaces": service{

			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "workspaces-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"xray": service{

			Endpoints: endpoints{
				"fips-us-gov-east-1": endpoint{
					Hostname: "xray-fips.us-gov-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-east-1",
					},
				},
				"fips-us-gov-west-1": endpoint{
					Hostname: "xray-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-east-1": endpoint{},
				"us-gov-west-1": endpoint{},
			},
		},
	},
}

// AwsIsoPartition returns the Resolver for AWS ISO (US).
func AwsIsoPartition() Partition {
	return awsisoPartition.Partition()
}

var awsisoPartition = partition{
	ID:        "aws-iso",
	Name:      "AWS ISO (US)",
	DNSSuffix: "c2s.ic.gov",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-iso\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"us-iso-east-1": region{
			Description: "US ISO East",
		},
	},
	Services: services{
		"api.ecr": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Hostname: "api.ecr.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"autoscaling": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"datapipeline": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"dms-fips": endpoint{
					Hostname: "dms.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
				"us-iso-east-1": endpoint{},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"dynamodb": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"ec2": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"elasticfilesystem": service{

			Endpoints: endpoints{
				"fips-us-iso-east-1": endpoint{
					Hostname: "elasticfilesystem-fips.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
				"us-iso-east-1": endpoint{},
			},
		},
		"elasticloadbalancing": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"elasticmapreduce": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"firehose": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"glacier": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-iso-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-iso-global": endpoint{
					Hostname: "iam.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"ProdFips": endpoint{
					Hostname: "kms-fips.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
				"us-iso-east-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"medialive": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"mediapackage": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"monitoring": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"outposts": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"ram": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-iso-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-iso-global": endpoint{
					Hostname: "route53.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"s3": service{
			Defaults: endpoint{
				SignatureVersions: []string{"s3v4"},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols:         []string{"http", "https"},
					SignatureVersions: []string{"s3v4"},
				},
			},
		},
		"secretsmanager": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"sns": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"sqs": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-iso-global",

			Endpoints: endpoints{
				"aws-iso-global": endpoint{
					Hostname: "support.us-iso-east-1.c2s.ic.gov",
					CredentialScope: credentialScope{
						Region: "us-iso-east-1",
					},
				},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"transcribe": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"transcribestreaming": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"translate": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
		"workspaces": service{

			Endpoints: endpoints{
				"us-iso-east-1": endpoint{},
			},
		},
	},
}

// AwsIsoBPartition returns the Resolver for AWS ISOB (US).
func AwsIsoBPartition() Partition {
	return awsisobPartition.Partition()
}

var awsisobPartition = partition{
	ID:        "aws-iso-b",
	Name:      "AWS ISOB (US)",
	DNSSuffix: "sc2s.sgov.gov",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-isob\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"us-isob-east-1": region{
			Description: "US ISOB East (Ohio)",
		},
	},
	Services: services{
		"api.ecr": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{
					Hostname: "api.ecr.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"dms-fips": endpoint{
					Hostname: "dms.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
				"us-isob-east-1": endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"elasticloadbalancing": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"elasticmapreduce": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"glacier": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-iso-b-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-iso-b-global": endpoint{
					Hostname: "iam.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"ProdFips": endpoint{
					Hostname: "kms-fips.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
				"us-isob-east-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"license-manager": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"monitoring": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-iso-b-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-iso-b-global": endpoint{
					Hostname: "route53.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"s3": service{
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"sns": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.queue.{dnsSuffix}",
				Protocols:     []string{"http", "https"},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
		"support": service{
			PartitionEndpoint: "aws-iso-b-global",

			Endpoints: endpoints{
				"aws-iso-b-global": endpoint{
					Hostname: "support.us-isob-east-1.sc2s.sgov.gov",
					CredentialScope: credentialScope{
						Region: "us-isob-east-1",
					},
				},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"us-isob-east-1": endpoint{},
			},
		},
	},
}
