# The Service Controller

The service controller is responsible for watch for service and node object changes, so that it can create, update, or delete cloud load balancers corresponding to load balanced services.  Like the other controllers, we import the cloud-provider provided utility functions for managing the controller itself, which calls into cloud provider defined methods `GetLoadBalancer`, `GetLoadBalancerName`, `EnsureLoadBalancer`, `UpdateLoadBalancer`, and `EnsureLoadBalancerDeleted`.


| Annotation | Valid Values | Default | Description |
| --- | --- | --- | --- |
| service.beta.kubernetes.io/aws-load-balancer-access-log-emit-interval          | [5\|60]                             | -   | How frequently the load balancer emits [access logs](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html), in minutes.  |
| service.beta.kubernetes.io/aws-load-balancer-access-log-enabled                | [true\|false]                       | -   | If true, access logs is enabled.  |
| service.beta.kubernetes.io/aws-load-balancer-access-log-s3-bucket-name         | -                                   | -   | Access log S3 bucket name.  |
| service.beta.kubernetes.io/aws-load-balancer-access-log-s3-bucket-prefix       | -                                   | -   | Access log S3 bucket prefix.  |
| service.beta.kubernetes.io/aws-load-balancer-additional-resource-tags          | Comma-separated list of key=value | -   | A comma-separated list of key-value pairs which will be recorded as additional tags in the ELB. For example: "Key1=Val1,Key2=Val2,KeyNoVal1=,KeyNoVal2" |
| service.beta.kubernetes.io/aws-load-balancer-backend-protocol                  | [http\|https\|ssl\|tcp]             | -   | Specifies the protocol spoken by the backend (pod) behind a listener. If `http` (default) or `https`, an HTTPS listener that terminates the connection and parses headers is created. If set to `ssl` or `tcp`, a "raw" SSL listener is used. If set to `http` and `aws-load-balancer-ssl-cert` is not used then a HTTP listener is used. |
| service.beta.kubernetes.io/aws-load-balancer-connection-draining-enabled       | [true\|false]                       | -   | Enable [connection draining](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html). |
| service.beta.kubernetes.io/aws-load-balancer-connection-draining-timeout       | [1-3600]                            | 300 | The maximum time (in seconds) for the load balancer to keep connections alive before reporting the instance as de-registered. The maximum timeout value can be set between 1 and 3,600 seconds (the default is 300 seconds). When the maximum time limit is reached, the load balancer forcibly closes connections to the de-registering instance. |
| service.beta.kubernetes.io/aws-load-balancer-connection-idle-timeout           | [1-4000]                            | 60  | The load balancer has a configured idle timeout period (in seconds) that applies to its connections. If no data has been sent or received by the time that the idle timeout period elapses, the load balancer closes the connection. |
| service.beta.kubernetes.io/aws-load-balancer-cross-zone-load-balancing-enabled | [true\|false]                       | -   | With cross-zone load balancing, each load balancer node for your Classic Load Balancer distributes requests evenly across the registered instances in all enabled Availability Zones. If cross-zone load balancing is disabled, each load balancer node distributes requests evenly across the registered instances in its Availability Zone only. |
| service.beta.kubernetes.io/aws-load-balancer-extra-security-groups             | Comma-separated list]              | -   | Specifies additional security groups to be added to ELB.    |
| service.beta.kubernetes.io/aws-load-balancer-healthcheck-healthy-threshold     | [2-10]                              | -   | Specifies the number of successive successful health checks required for a backend to be considered healthy for traffic. For NLB, healthy-threshold and unhealthy-threshold must be equal. |
| service.beta.kubernetes.io/aws-load-balancer-healthcheck-interval              | [5-300]                             | 30  | Specifies, in seconds, the interval between health checks. |
| service.beta.kubernetes.io/aws-load-balancer-healthcheck-timeout               | [2-60]                              | 5   | The amount of time to wait when receiving a response from the health check, in seconds. |
| service.beta.kubernetes.io/aws-load-balancer-healthcheck-unhealthy-threshold   | [2-10]                              | 2   | The number of consecutive failed health checks that must occur before declaring an EC2 instance unhealthy. |
| service.beta.kubernetes.io/aws-load-balancer-internal                          | [true\|false]                       | -   | Indicates that the load balancer should be internal. |
| service.beta.kubernetes.io/aws-load-balancer-proxy-protocol                    | [*]                                 | -   | Enables the proxy protocol on an ELB. Right now we only accept the value "*" which means enable the proxy protocol on all ELB backends. In the future we could adjust this to allow setting the proxy protocol only on certain backends. |
| service.beta.kubernetes.io/aws-load-balancer-ssl-cert                          | IAM or ACM ARN                    | -   | Requests a secure listener. Value is a valid certificate ARN. For more, see the [elb listener config guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html).  CertARN is an IAM or CM certificate ARN. |
| service.beta.kubernetes.io/aws-load-balancer-ssl-negotiation-policy            | -                                   | ELBSecurityPolicy-2016-08 | Specifies SSL negotiation settings for the HTTPS/SSL listeners of your load balancer. Defaults to the default ELB policy. |
| service.beta.kubernetes.io/aws-load-balancer-ssl-ports                         | Comma-separated list                                   | *   | Specifies a comma-separated list of ports that will use SSL/HTTPS listeners. Defaults to all. |
| service.beta.kubernetes.io/aws-load-balancer-type                              | [nlb]                                   | -   | Indicates the type of Load Balancer. The only valid value is nlb.  Leaving this field blank is equivalent to selecting ELB. |

