#!/bin/bash
LOG=$1
CONF=/etc/cpfs/cpfs-options.conf

now=`date`
echo "=== $now ===" >> ${LOG}

#
# do nothing if config doesn't exist
#
if [ -f ${CONF} ]; then
    . ${CONF}
else
    echo "Skip cpfs post start config because $CONF not exists" >> ${LOG}
    exit
fi

. /etc/cpfs/utils.sh

CGROUP_RETVAL=0
OPENCACHE_RETVAL=0
LUSTRE_RETVAL=0
[ "$CONFIG_CGROUP" == true ] && { echo "Running config cgroup"; run_config /etc/cpfs/config-cgroup.sh start ${LOG}; CGROUP_RETVAL=$?; }
[ "$CONFIG_OPENCACHE" == true ] && { echo "Running config opencache"; run_config /etc/cpfs/config-opencache.sh start ${LOG}; OPENCACHE_RETVAL=$?; }
[ "$CONFIG_LUSTRE" == true ] && { echo "Running config lustre"; run_config /etc/cpfs/config-lustre.sh start ${LOG}; LUSTRE_RETVAL=$?; }

[ $CGROUP_RETVAL -ne 0 ] || [ $OPENCACHE_RETVAL -ne 0 ] || [ $LUSTRE_RETVAL -ne 0 ] && exit 1

exit 0
