#!/bin/bash
LOG=$1
CONF=/etc/cpfs/cpfs-options.conf

now=`date`
echo "=== $now ===" >> ${LOG}

#
# do nothing if config doesn't exist
#
if [ -f ${CONF} ]; then
    . ${CONF}
else
    echo "skip cpfs post stop config because $CONF not exists" >> ${LOG}
    exit
fi

. /etc/cpfs/utils.sh

RETVAL=0
[ "$CONFIG_CGROUP" == true ] && { echo "Running config cgroup"; run_config /etc/cpfs/config-cgroup.sh stop ${LOG}; RETVAL=$?; }
[ $RETVAL -ne 0 ] && exit $RETVAL
[ "$CONFIG_LUSTRE" == true ] && { echo "Running config lustre"; run_config /etc/cpfs/config-lustre.sh stop ${LOG}; RETVAL=$?; }
[ $RETVAL -ne 0 ] && exit $RETVAL

exit 0
