package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDiskReplicaPair invokes the ecs.CreateDiskReplicaPair API synchronously
func (client *Client) CreateDiskReplicaPair(request *CreateDiskReplicaPairRequest) (response *CreateDiskReplicaPairResponse, err error) {
	response = CreateCreateDiskReplicaPairResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDiskReplicaPairWithChan invokes the ecs.CreateDiskReplicaPair API asynchronously
func (client *Client) CreateDiskReplicaPairWithChan(request *CreateDiskReplicaPairRequest) (<-chan *CreateDiskReplicaPairResponse, <-chan error) {
	responseChan := make(chan *CreateDiskReplicaPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDiskReplicaPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDiskReplicaPairWithCallback invokes the ecs.CreateDiskReplicaPair API asynchronously
func (client *Client) CreateDiskReplicaPairWithCallback(request *CreateDiskReplicaPairRequest, callback func(response *CreateDiskReplicaPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDiskReplicaPairResponse
		var err error
		defer close(result)
		response, err = client.CreateDiskReplicaPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDiskReplicaPairRequest is the request struct for api CreateDiskReplicaPair
type CreateDiskReplicaPairRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PairName             string           `position:"Query" name:"PairName"`
	DestinationRegionId  string           `position:"Query" name:"DestinationRegionId"`
	Description          string           `position:"Query" name:"Description"`
	DiskId               string           `position:"Query" name:"DiskId"`
	AsyncCycle           requests.Integer `position:"Query" name:"AsyncCycle"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DestinationDiskId    string           `position:"Query" name:"DestinationDiskId"`
}

// CreateDiskReplicaPairResponse is the response struct for api CreateDiskReplicaPair
type CreateDiskReplicaPairResponse struct {
	*responses.BaseResponse
	PairId    string `json:"PairId" xml:"PairId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDiskReplicaPairRequest creates a request to invoke CreateDiskReplicaPair API
func CreateCreateDiskReplicaPairRequest() (request *CreateDiskReplicaPairRequest) {
	request = &CreateDiskReplicaPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateDiskReplicaPair", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDiskReplicaPairResponse creates a response to parse from CreateDiskReplicaPair response
func CreateCreateDiskReplicaPairResponse() (response *CreateDiskReplicaPairResponse) {
	response = &CreateDiskReplicaPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
