package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetAlertActionPolicy invokes the sls.SetAlertActionPolicy API synchronously
func (client *Client) SetAlertActionPolicy(request *SetAlertActionPolicyRequest) (response *SetAlertActionPolicyResponse, err error) {
	response = CreateSetAlertActionPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// SetAlertActionPolicyWithChan invokes the sls.SetAlertActionPolicy API asynchronously
func (client *Client) SetAlertActionPolicyWithChan(request *SetAlertActionPolicyRequest) (<-chan *SetAlertActionPolicyResponse, <-chan error) {
	responseChan := make(chan *SetAlertActionPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetAlertActionPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetAlertActionPolicyWithCallback invokes the sls.SetAlertActionPolicy API asynchronously
func (client *Client) SetAlertActionPolicyWithCallback(request *SetAlertActionPolicyRequest, callback func(response *SetAlertActionPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetAlertActionPolicyResponse
		var err error
		defer close(result)
		response, err = client.SetAlertActionPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetAlertActionPolicyRequest is the request struct for api SetAlertActionPolicy
type SetAlertActionPolicyRequest struct {
	*requests.RpcRequest
	App      string `position:"Body" name:"App"`
	PolicyId string `position:"Body" name:"PolicyId"`
	Policy   string `position:"Body" name:"Policy"`
}

// SetAlertActionPolicyResponse is the response struct for api SetAlertActionPolicy
type SetAlertActionPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateSetAlertActionPolicyRequest creates a request to invoke SetAlertActionPolicy API
func CreateSetAlertActionPolicyRequest() (request *SetAlertActionPolicyRequest) {
	request = &SetAlertActionPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "SetAlertActionPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateSetAlertActionPolicyResponse creates a response to parse from SetAlertActionPolicy response
func CreateSetAlertActionPolicyResponse() (response *SetAlertActionPolicyResponse) {
	response = &SetAlertActionPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
