package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRuleAttribute invokes the alb.UpdateRuleAttribute API synchronously
func (client *Client) UpdateRuleAttribute(request *UpdateRuleAttributeRequest) (response *UpdateRuleAttributeResponse, err error) {
	response = CreateUpdateRuleAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRuleAttributeWithChan invokes the alb.UpdateRuleAttribute API asynchronously
func (client *Client) UpdateRuleAttributeWithChan(request *UpdateRuleAttributeRequest) (<-chan *UpdateRuleAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateRuleAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRuleAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRuleAttributeWithCallback invokes the alb.UpdateRuleAttribute API asynchronously
func (client *Client) UpdateRuleAttributeWithCallback(request *UpdateRuleAttributeRequest, callback func(response *UpdateRuleAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRuleAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateRuleAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRuleAttributeRequest is the request struct for api UpdateRuleAttribute
type UpdateRuleAttributeRequest struct {
	*requests.RpcRequest
	ClientToken    string                               `position:"Query" name:"ClientToken"`
	RuleName       string                               `position:"Query" name:"RuleName"`
	RuleActions    *[]UpdateRuleAttributeRuleActions    `position:"Query" name:"RuleActions"  type:"Repeated"`
	RuleConditions *[]UpdateRuleAttributeRuleConditions `position:"Query" name:"RuleConditions"  type:"Repeated"`
	DryRun         requests.Boolean                     `position:"Query" name:"DryRun"`
	Priority       requests.Integer                     `position:"Query" name:"Priority"`
	RuleId         string                               `position:"Query" name:"RuleId"`
}

// UpdateRuleAttributeRuleActions is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActions struct {
	FixedResponseConfig UpdateRuleAttributeRuleActionsFixedResponseConfig `name:"FixedResponseConfig" type:"Struct"`
	TrafficMirrorConfig UpdateRuleAttributeRuleActionsTrafficMirrorConfig `name:"TrafficMirrorConfig" type:"Struct"`
	ForwardGroupConfig  UpdateRuleAttributeRuleActionsForwardGroupConfig  `name:"ForwardGroupConfig" type:"Struct"`
	RemoveHeaderConfig  UpdateRuleAttributeRuleActionsRemoveHeaderConfig  `name:"RemoveHeaderConfig" type:"Struct"`
	InsertHeaderConfig  UpdateRuleAttributeRuleActionsInsertHeaderConfig  `name:"InsertHeaderConfig" type:"Struct"`
	TrafficLimitConfig  UpdateRuleAttributeRuleActionsTrafficLimitConfig  `name:"TrafficLimitConfig" type:"Struct"`
	RedirectConfig      UpdateRuleAttributeRuleActionsRedirectConfig      `name:"RedirectConfig" type:"Struct"`
	Type                string                                            `name:"Type"`
	Order               string                                            `name:"Order"`
	RewriteConfig       UpdateRuleAttributeRuleActionsRewriteConfig       `name:"RewriteConfig" type:"Struct"`
}

// UpdateRuleAttributeRuleConditions is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditions struct {
	MethodConfig             UpdateRuleAttributeRuleConditionsMethodConfig             `name:"MethodConfig" type:"Struct"`
	SourceIpConfig           UpdateRuleAttributeRuleConditionsSourceIpConfig           `name:"SourceIpConfig" type:"Struct"`
	HostConfig               UpdateRuleAttributeRuleConditionsHostConfig               `name:"HostConfig" type:"Struct"`
	QueryStringConfig        UpdateRuleAttributeRuleConditionsQueryStringConfig        `name:"QueryStringConfig" type:"Struct"`
	ResponseStatusCodeConfig UpdateRuleAttributeRuleConditionsResponseStatusCodeConfig `name:"ResponseStatusCodeConfig" type:"Struct"`
	PathConfig               UpdateRuleAttributeRuleConditionsPathConfig               `name:"PathConfig" type:"Struct"`
	CookieConfig             UpdateRuleAttributeRuleConditionsCookieConfig             `name:"CookieConfig" type:"Struct"`
	Type                     string                                                    `name:"Type"`
	HeaderConfig             UpdateRuleAttributeRuleConditionsHeaderConfig             `name:"HeaderConfig" type:"Struct"`
	ResponseHeaderConfig     UpdateRuleAttributeRuleConditionsResponseHeaderConfig     `name:"ResponseHeaderConfig" type:"Struct"`
}

// UpdateRuleAttributeRuleActionsFixedResponseConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsFixedResponseConfig struct {
	HttpCode    string `name:"HttpCode"`
	Content     string `name:"Content"`
	ContentType string `name:"ContentType"`
}

// UpdateRuleAttributeRuleActionsTrafficMirrorConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsTrafficMirrorConfig struct {
	MirrorGroupConfig UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfig `name:"MirrorGroupConfig" type:"Struct"`
	TargetType        string                                                             `name:"TargetType"`
}

// UpdateRuleAttributeRuleActionsForwardGroupConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsForwardGroupConfig struct {
	ServerGroupStickySession UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupStickySession `name:"ServerGroupStickySession" type:"Struct"`
	ServerGroupTuples        *[]UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// UpdateRuleAttributeRuleActionsRemoveHeaderConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsRemoveHeaderConfig struct {
	Key string `name:"Key"`
}

// UpdateRuleAttributeRuleActionsInsertHeaderConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsInsertHeaderConfig struct {
	ValueType    string `name:"ValueType"`
	CoverEnabled string `name:"CoverEnabled"`
	Value        string `name:"Value"`
	Key          string `name:"Key"`
}

// UpdateRuleAttributeRuleActionsTrafficLimitConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsTrafficLimitConfig struct {
	QPS string `name:"QPS"`
}

// UpdateRuleAttributeRuleActionsRedirectConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsRedirectConfig struct {
	Path     string `name:"Path"`
	Protocol string `name:"Protocol"`
	Port     string `name:"Port"`
	Query    string `name:"Query"`
	Host     string `name:"Host"`
	HttpCode string `name:"HttpCode"`
}

// UpdateRuleAttributeRuleActionsRewriteConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsRewriteConfig struct {
	Path  string `name:"Path"`
	Query string `name:"Query"`
	Host  string `name:"Host"`
}

// UpdateRuleAttributeRuleConditionsMethodConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsMethodConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsSourceIpConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsSourceIpConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsHostConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsHostConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsQueryStringConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsQueryStringConfig struct {
	Values *[]UpdateRuleAttributeRuleConditionsQueryStringConfigValuesItem `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsResponseStatusCodeConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsResponseStatusCodeConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsPathConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsPathConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsCookieConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsCookieConfig struct {
	Values *[]UpdateRuleAttributeRuleConditionsCookieConfigValuesItem `name:"Values" type:"Repeated"`
}

// UpdateRuleAttributeRuleConditionsHeaderConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsHeaderConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
	Key    string    `name:"Key"`
}

// UpdateRuleAttributeRuleConditionsResponseHeaderConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsResponseHeaderConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
	Key    string    `name:"Key"`
}

// UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfig is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfig struct {
	ServerGroupTuples *[]UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupStickySession is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupStickySession struct {
	Enabled string `name:"Enabled"`
	Timeout string `name:"Timeout"`
}

// UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupTuplesItem is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsForwardGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
	Weight        string `name:"Weight"`
}

// UpdateRuleAttributeRuleConditionsQueryStringConfigValuesItem is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsQueryStringConfigValuesItem struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// UpdateRuleAttributeRuleConditionsCookieConfigValuesItem is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleConditionsCookieConfigValuesItem struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem is a repeated param struct in UpdateRuleAttributeRequest
type UpdateRuleAttributeRuleActionsTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
}

// UpdateRuleAttributeResponse is the response struct for api UpdateRuleAttribute
type UpdateRuleAttributeResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRuleAttributeRequest creates a request to invoke UpdateRuleAttribute API
func CreateUpdateRuleAttributeRequest() (request *UpdateRuleAttributeRequest) {
	request = &UpdateRuleAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateRuleAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRuleAttributeResponse creates a response to parse from UpdateRuleAttribute response
func CreateUpdateRuleAttributeResponse() (response *UpdateRuleAttributeResponse) {
	response = &UpdateRuleAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
