package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLoadBalancers invokes the alb.ListLoadBalancers API synchronously
func (client *Client) ListLoadBalancers(request *ListLoadBalancersRequest) (response *ListLoadBalancersResponse, err error) {
	response = CreateListLoadBalancersResponse()
	err = client.DoAction(request, response)
	return
}

// ListLoadBalancersWithChan invokes the alb.ListLoadBalancers API asynchronously
func (client *Client) ListLoadBalancersWithChan(request *ListLoadBalancersRequest) (<-chan *ListLoadBalancersResponse, <-chan error) {
	responseChan := make(chan *ListLoadBalancersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLoadBalancers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLoadBalancersWithCallback invokes the alb.ListLoadBalancers API asynchronously
func (client *Client) ListLoadBalancersWithCallback(request *ListLoadBalancersRequest, callback func(response *ListLoadBalancersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLoadBalancersResponse
		var err error
		defer close(result)
		response, err = client.ListLoadBalancers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLoadBalancersRequest is the request struct for api ListLoadBalancers
type ListLoadBalancersRequest struct {
	*requests.RpcRequest
	LoadBalancerNames           *[]string               `position:"Query" name:"LoadBalancerNames"  type:"Repeated"`
	LoadBalancerIds             *[]string               `position:"Query" name:"LoadBalancerIds"  type:"Repeated"`
	ResourceGroupId             string                  `position:"Query" name:"ResourceGroupId"`
	NextToken                   string                  `position:"Query" name:"NextToken"`
	LoadBalancerBussinessStatus string                  `position:"Query" name:"LoadBalancerBussinessStatus"`
	AddressType                 string                  `position:"Query" name:"AddressType"`
	VpcIds                      *[]string               `position:"Query" name:"VpcIds"  type:"Repeated"`
	Tag                         *[]ListLoadBalancersTag `position:"Query" name:"Tag"  type:"Repeated"`
	Address                     string                  `position:"Query" name:"Address"`
	LoadBalancerStatus          string                  `position:"Query" name:"LoadBalancerStatus"`
	InternetChargeType          string                  `position:"Query" name:"InternetChargeType"`
	MaxResults                  requests.Integer        `position:"Query" name:"MaxResults"`
	ZoneId                      string                  `position:"Query" name:"ZoneId"`
	PayType                     string                  `position:"Query" name:"PayType"`
}

// ListLoadBalancersTag is a repeated param struct in ListLoadBalancersRequest
type ListLoadBalancersTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListLoadBalancersResponse is the response struct for api ListLoadBalancers
type ListLoadBalancersResponse struct {
	*responses.BaseResponse
	MaxResults    int            `json:"MaxResults" xml:"MaxResults"`
	NextToken     string         `json:"NextToken" xml:"NextToken"`
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	TotalCount    int            `json:"TotalCount" xml:"TotalCount"`
	LoadBalancers []LoadBalancer `json:"LoadBalancers" xml:"LoadBalancers"`
}

// CreateListLoadBalancersRequest creates a request to invoke ListLoadBalancers API
func CreateListLoadBalancersRequest() (request *ListLoadBalancersRequest) {
	request = &ListLoadBalancersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListLoadBalancers", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLoadBalancersResponse creates a response to parse from ListLoadBalancers response
func CreateListLoadBalancersResponse() (response *ListLoadBalancersResponse) {
	response = &ListLoadBalancersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
