// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mqiface provides an interface to enable mocking the AmazonMQ service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mqiface

import (
	"github.com/aws/aws-sdk-go-v2/service/mq"
)

// ClientAPI provides an interface to enable mocking the
// mq.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AmazonMQ.
//    func myFunc(svc mqiface.ClientAPI) bool {
//        // Make svc.CreateBroker request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := mq.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        mqiface.ClientPI
//    }
//    func (m *mockClientClient) CreateBroker(input *mq.CreateBrokerInput) (*mq.CreateBrokerOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateBrokerRequest(*mq.CreateBrokerInput) mq.CreateBrokerRequest

	CreateConfigurationRequest(*mq.CreateConfigurationInput) mq.CreateConfigurationRequest

	CreateTagsRequest(*mq.CreateTagsInput) mq.CreateTagsRequest

	CreateUserRequest(*mq.CreateUserInput) mq.CreateUserRequest

	DeleteBrokerRequest(*mq.DeleteBrokerInput) mq.DeleteBrokerRequest

	DeleteTagsRequest(*mq.DeleteTagsInput) mq.DeleteTagsRequest

	DeleteUserRequest(*mq.DeleteUserInput) mq.DeleteUserRequest

	DescribeBrokerRequest(*mq.DescribeBrokerInput) mq.DescribeBrokerRequest

	DescribeBrokerEngineTypesRequest(*mq.DescribeBrokerEngineTypesInput) mq.DescribeBrokerEngineTypesRequest

	DescribeBrokerInstanceOptionsRequest(*mq.DescribeBrokerInstanceOptionsInput) mq.DescribeBrokerInstanceOptionsRequest

	DescribeConfigurationRequest(*mq.DescribeConfigurationInput) mq.DescribeConfigurationRequest

	DescribeConfigurationRevisionRequest(*mq.DescribeConfigurationRevisionInput) mq.DescribeConfigurationRevisionRequest

	DescribeUserRequest(*mq.DescribeUserInput) mq.DescribeUserRequest

	ListBrokersRequest(*mq.ListBrokersInput) mq.ListBrokersRequest

	ListConfigurationRevisionsRequest(*mq.ListConfigurationRevisionsInput) mq.ListConfigurationRevisionsRequest

	ListConfigurationsRequest(*mq.ListConfigurationsInput) mq.ListConfigurationsRequest

	ListTagsRequest(*mq.ListTagsInput) mq.ListTagsRequest

	ListUsersRequest(*mq.ListUsersInput) mq.ListUsersRequest

	RebootBrokerRequest(*mq.RebootBrokerInput) mq.RebootBrokerRequest

	UpdateBrokerRequest(*mq.UpdateBrokerInput) mq.UpdateBrokerRequest

	UpdateConfigurationRequest(*mq.UpdateConfigurationInput) mq.UpdateConfigurationRequest

	UpdateUserRequest(*mq.UpdateUserInput) mq.UpdateUserRequest
}

var _ ClientAPI = (*mq.Client)(nil)
